package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevokeInstanceFromTransitRouter invokes the cbn.RevokeInstanceFromTransitRouter API synchronously
func (client *Client) RevokeInstanceFromTransitRouter(request *RevokeInstanceFromTransitRouterRequest) (response *RevokeInstanceFromTransitRouterResponse, err error) {
	response = CreateRevokeInstanceFromTransitRouterResponse()
	err = client.DoAction(request, response)
	return
}

// RevokeInstanceFromTransitRouterWithChan invokes the cbn.RevokeInstanceFromTransitRouter API asynchronously
func (client *Client) RevokeInstanceFromTransitRouterWithChan(request *RevokeInstanceFromTransitRouterRequest) (<-chan *RevokeInstanceFromTransitRouterResponse, <-chan error) {
	responseChan := make(chan *RevokeInstanceFromTransitRouterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevokeInstanceFromTransitRouter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevokeInstanceFromTransitRouterWithCallback invokes the cbn.RevokeInstanceFromTransitRouter API asynchronously
func (client *Client) RevokeInstanceFromTransitRouterWithCallback(request *RevokeInstanceFromTransitRouterRequest, callback func(response *RevokeInstanceFromTransitRouterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevokeInstanceFromTransitRouterResponse
		var err error
		defer close(result)
		response, err = client.RevokeInstanceFromTransitRouter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevokeInstanceFromTransitRouterRequest is the request struct for api RevokeInstanceFromTransitRouter
type RevokeInstanceFromTransitRouterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CenId                string           `position:"Query" name:"CenId"`
	CenOwnerId           requests.Integer `position:"Query" name:"CenOwnerId"`
	InstanceType         string           `position:"Query" name:"InstanceType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// RevokeInstanceFromTransitRouterResponse is the response struct for api RevokeInstanceFromTransitRouter
type RevokeInstanceFromTransitRouterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRevokeInstanceFromTransitRouterRequest creates a request to invoke RevokeInstanceFromTransitRouter API
func CreateRevokeInstanceFromTransitRouterRequest() (request *RevokeInstanceFromTransitRouterRequest) {
	request = &RevokeInstanceFromTransitRouterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "RevokeInstanceFromTransitRouter", "", "")
	request.Method = requests.POST
	return
}

// CreateRevokeInstanceFromTransitRouterResponse creates a response to parse from RevokeInstanceFromTransitRouter response
func CreateRevokeInstanceFromTransitRouterResponse() (response *RevokeInstanceFromTransitRouterResponse) {
	response = &RevokeInstanceFromTransitRouterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
