/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * rotate about vec3

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_rotate_about_vec3.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfRotateAboutVec3Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL useAngle = fractal->transformCommon.angle0;

	if (fractal->transformCommon.functionEnabledEFalse)
	{
		if (aux->i > fractal->transformCommon.startIterationsRV)
		{
			useAngle *= (1.0f
										- 1.0f
												/ (1.0f
													 + (aux->i - fractal->transformCommon.startIterationsRV)
															 / fractal->transformCommon.offset0))
									* fractal->transformCommon.scale1;
		}
	}

	useAngle *= M_PI_180_F;
	if (!fractal->transformCommon.functionEnabledFFalse)
	{
		REAL4 v = fractal->transformCommon.vec111;
		v = v / length(v); // normalise
		REAL c = native_cos(useAngle);
		REAL temp = 1.0f - c;
		REAL s = native_sin(useAngle);
		REAL4 rotVec = (REAL4){0.0f, 0.0f, 0.0f, z.w};

		rotVec.x = z.x * (c + temp * v.x * v.x) + z.y * (temp * v.x * v.y + s * v.z)
							 + z.z * (temp * v.x * v.z - s * v.y);
		rotVec.y = z.x * (temp * v.x * v.y - s * v.z) + z.y * (c + temp * v.y * v.y)
							 + z.z * (temp * v.y * v.z + s * v.x);
		rotVec.z = z.x * (temp * v.x * v.z + s * v.y) + z.y * (temp * v.y * v.z - s * v.x)
							 + z.z * (c + temp * v.z * v.z);
		z = rotVec;
	}
	else
	{
		z = RotateAroundVectorByAngle4(z, fractal->transformCommon.vec111.xyz, -useAngle);
	}
	// DE tweak
	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	return z;
}