/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2021 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * @reference trans-qIFS
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_quadratic_fold4d.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfQuadraticFold4dIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 a = fractal->transformCommon.offset1111;
	if (fractal->transformCommon.functionEnabledAx)
	{
		z.x = 1.0f - fabs(z.x);
		a.x = a.x - 1.0f;
		REAL bx = 1.0f - a.x;
		if (z.x > 0.0f) z.x = a.x * z.x * z.x + bx * z.x;
	} // x = 0 -> newx = 0 and x = 1 -> newx = 1

	if (fractal->transformCommon.functionEnabledAyFalse)
	{
		z.y = 1.0f - fabs(z.y);
		a.y = a.y - 1.0f;
		REAL by = 1.0f - a.y;
		if (z.y > 0.0f) z.y = a.y * z.y * z.y + by * z.y;
	}

	if (fractal->transformCommon.functionEnabledAzFalse)
	{
		z.z = 1.0f - fabs(z.z);
		a.z = a.z - 1.0f;
		REAL bz = 1.0f - a.z;
		if (z.z > 0.0f) z.z = a.z * z.z * z.z + bz * z.z;
	}

	if (fractal->transformCommon.functionEnabledAwFalse)
	{
		z.w = 1.0f - fabs(z.w);
		a.w = a.w - 1.0f;
		REAL bw = 1.0f - a.w;
		if (z.w > 0.0f) z.w = a.w * z.w * z.w + bw * z.w;
	}

	z += fractal->transformCommon.offset0000;

	// DE tweak
	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	return z;
}