/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Mandelbulb fractal.
 * @reference http://www.fractalforums.com/3d-fractal-generation/true-3d-mandlebrot-type-fractal/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_mandelbulb_sin_cos_v4.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MandelbulbSinCosV4Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL temp;

	if (fractal->transformCommon.functionEnabledTFalse
			&& aux->i >= fractal->transformCommon.startIterationsT
			&& aux->i < fractal->transformCommon.stopIterationsT1)
	{
		REAL4 t = z;
		temp = 1.0f / dot(t, t);

		temp = temp + (1.0f / aux->r - temp) * fractal->transformCommon.scaleC1;

		REAL4 g = fractal->transformCommon.scale3D111;
		t *= g * temp;
		aux->DE += 1.0f / aux->DE;
		z = (z - t) * fractal->transformCommon.scaleD1;
		aux->DE *= fractal->transformCommon.scaleD1;
	}

	if (fractal->transformCommon.functionEnabledPFalse
			&& aux->i >= fractal->transformCommon.startIterationsP
			&& aux->i < fractal->transformCommon.stopIterationsP1)
	{
		if (fractal->transformCommon.functionEnabledxFalse)
		{
			z.x = sign(z.x) * (fractal->transformCommon.offset000.x - fabs(z.x));
		}
		if (fractal->transformCommon.functionEnabledyFalse)
		{
			z.y = sign(z.y) * (fractal->transformCommon.offset000.y - fabs(z.y));
		}
		if (fractal->transformCommon.functionEnabledzFalse)
		{
			z.z = sign(z.z) * (fractal->transformCommon.offset000.z - fabs(z.z));
		}
	}

	// cartesian to polar
	REAL th;
	if (!fractal->transformCommon.functionEnabledMFalse)
		th = z.z / aux->r;
	else
		th = z.y / aux->r;

	REAL ph;
	if (!fractal->transformCommon.functionEnabledNFalse)
		ph = atan2(z.y, z.x);
	else
		ph = atan2(z.z, z.x);

	if (!fractal->transformCommon.functionEnabledBFalse)
	{
		if (!fractal->transformCommon.functionEnabledAFalse)
			th = asin(th);
		else
			th = acos(th);
	}
	else
	{
		temp = acos(th);
		th = temp + (asin(th) - temp) * fractal->transformCommon.scale1;
	}

	th =
		(th + fractal->bulb.betaAngleOffset) * (fractal->bulb.power + fractal->transformCommon.offset0);
	ph = (ph + fractal->bulb.alphaAngleOffset)
			 * (fractal->bulb.power + fractal->transformCommon.offsetA0);

	REAL rp = pow(aux->r, (fractal->bulb.power - 1.0f) * fractal->transformCommon.scaleA1);
	aux->DE = aux->DE * rp * fabs(fractal->bulb.power) + 1.0f;
	rp *= aux->r * fractal->transformCommon.scaleB1;

	// polar to cartesian
	if (!fractal->transformCommon.functionEnabledSwFalse)
	{
		temp = native_cos(th);
		z.x = temp * native_cos(ph);
		z.y = temp * native_sin(ph);
		z.z = native_sin(th);
	}
	else
	{
		temp = native_sin(th);
		z.x = temp * native_cos(ph);
		z.y = temp * native_sin(ph);
		z.z = native_cos(th);
	}
	z *= rp;

	if (fractal->transformCommon.functionEnabledFFalse
			&& aux->i >= fractal->transformCommon.startIterationsF
			&& aux->i < fractal->transformCommon.stopIterationsF)
	{
		switch (fractal->mandelbulbMulti.orderOfXYZ)
		{
			case multi_OrderOfXYZCl_xyz:
			default: z = (REAL4){z.x, z.y, z.z, z.w}; break;
			case multi_OrderOfXYZCl_xzy: z = (REAL4){z.x, z.z, z.y, z.w}; break;
			case multi_OrderOfXYZCl_yxz: z = (REAL4){z.y, z.x, z.z, z.w}; break;
			case multi_OrderOfXYZCl_yzx: z = (REAL4){z.y, z.z, z.x, z.w}; break;
			case multi_OrderOfXYZCl_zxy: z = (REAL4){z.z, z.x, z.y, z.w}; break;
			case multi_OrderOfXYZCl_zyx: z = (REAL4){z.z, z.y, z.x, z.w}; break;
		}
	}

	if (fractal->transformCommon.functionEnabledGFalse
			&& aux->i >= fractal->transformCommon.startIterationsG
			&& aux->i < fractal->transformCommon.stopIterationsG)
	{
		z.z *= fractal->transformCommon.scaleG1;
	}

	z += fractal->transformCommon.offsetA000;
	z += aux->const_c * fractal->transformCommon.constantMultiplier111;

	if (fractal->transformCommon.functionEnabledIFalse
			&& aux->i >= fractal->transformCommon.startIterationsI
			&& aux->i < fractal->transformCommon.stopIterationsI)
	{
		z.y = fabs(z.y) + fractal->transformCommon.offset1;
		temp = fmod(z.y, fractal->transformCommon.scale2 * fractal->transformCommon.offset1);
		z.y = temp - fractal->transformCommon.offset1;
	}

	if (fractal->analyticDE.enabledFalse)
	{
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	}

	if (fractal->transformCommon.functionEnabledCFalse)
	{
		aux->DE0 = length(z);
		if (aux->DE0 > 1.0f)
			aux->DE0 = 0.5f * log(aux->DE0) * aux->DE0 / (aux->DE);
		else
			aux->DE0 = 0.0f; // 0.01f artifacts in openCL

		if (aux->i >= fractal->transformCommon.startIterationsO
				&& aux->i < fractal->transformCommon.stopIterationsO)
			aux->dist = min(aux->dist, aux->DE0);
		else
			aux->dist = aux->DE0;
	}
	return z;
}