/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.         ______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,      / ____/ __    __
 *                                        \><||i|=>>%)     / /   __/ /___/ /_
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    / /__ /_  __/_  __/
 * The project is licensed under GPLv3,   -<>>=|><|||`    \____/ /_/   /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *

 */

#include "all_fractal_definitions.h"

cFractalTransfSinTan::cFractalTransfSinTan() : cAbstractFractal()
{
	nameInComboBox = "T>Sin Tan";
	internalName = "transf_sin_tan";
	internalID = fractal::transfSinTan;
	DEType = analyticDEType;
	DEFunctionType = withoutDEFunction;
	cpixelAddition = cpixelDisabledByDefault;
	defaultBailout = 100.0;
	DEAnalyticFunction = analyticFunctionNone;
	coloringFunction = coloringFunctionDefault;
}

void cFractalTransfSinTan::FormulaCode(CVector4 &z, const sFractal *fractal, sExtendedAux &aux)
{
	if (fractal->transformCommon.functionEnabledAx)
		z.x = tan(sin((z.x - fractal->transformCommon.offset000.x) * fractal->transformCommon.constantMultiplierA111.x))
				* fractal->transformCommon.constantMultiplierB111.x + fractal->transformCommon.offsetA000.x;
	if (fractal->transformCommon.functionEnabledAyFalse)
		z.y = tan(sin((z.y - fractal->transformCommon.offset000.y) * fractal->transformCommon.constantMultiplierA111.y))
				* fractal->transformCommon.constantMultiplierB111.y + fractal->transformCommon.offsetA000.y;
	if (fractal->transformCommon.functionEnabledAzFalse)
		z.z = tan(sin((z.z - fractal->transformCommon.offset000.z) * fractal->transformCommon.constantMultiplierA111.z))
				* fractal->transformCommon.constantMultiplierB111.z + fractal->transformCommon.offsetA000.z;

	// DE tweak
	if (fractal->analyticDE.enabledFalse)
		aux.DE = aux.DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
}
