#include <SDL/SDL.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <netinet/in.h>
#include "gwiz-pawn.h"

MonsterPawn pawn;

void errhandle(void)
{
	/* note teh spelling of "abnormally" */
	printf ("an error occurred, read monmake.c for usage information.\n");
	printf ("this tool is completely unsupported, exiting abnormarlly.\n");
	exit (1);
}

int main (int argc, char **argv)
{
    FILE *out;
    
    if ((argc < 12) && (argc != 2))
	errhandle();
    if (argc == 2)
	{
	    out = fopen (argv[1], "rb");
	    if (out == NULL)
		errhandle();
	    
	    fread (&pawn, sizeof(MonsterPawn), 1, out);
	    
	    printf("name:    %s\n", pawn.name);
	    printf("pix:     %s\n", pawn.pixpath);
	    printf("minphys: %d\n", htonl(pawn.minphys));
	    printf("maxphys: %d\n", htonl(pawn.maxphys));
	    printf("mspells: 0x%08x\n", htonl(pawn.mspells));
	    printf("cspells: 0x%08x\n", htonl(pawn.cspells));
	    printf("hp:      %d\n", htonl(pawn.hp));
	    printf("expval:  %d\n", htonl(pawn.epval));
	    printf("gpval:   %d\n", htonl(pawn.gpval));
	    printf("suscept: 0x%08x ", htonl(pawn.susceptibility));
	    if ((htonl(pawn.susceptibility)&STATUS_POISON)==STATUS_POISON)
		printf ("poison ");
	    if ((htonl(pawn.susceptibility)&STATUS_PETRIF)==STATUS_PETRIF)
		printf ("petrify ");
	    if ((htonl(pawn.susceptibility)&STATUS_AFRAID)==STATUS_AFRAID)
		printf ("afraid");
	    printf ("\n");
	    printf("inflict: 0x%08x ", htonl(pawn.specialphys));
	    if ((htonl(pawn.specialphys)&STATUS_POISON) == STATUS_POISON)
		printf("poison ");
	    if ((htonl(pawn.specialphys) & STATUS_PETRIF) == STATUS_PETRIF)
		printf("petrify ");
	    if ((htonl(pawn.specialphys) & STATUS_AFRAID) == STATUS_AFRAID)
		printf("afraid");
	    printf ("\n");
	    
	    fclose (out);
	    exit (0);
	}
    
    strncpy (pawn.name, argv[1], 16);
    strncpy (pawn.pixpath, argv[2], 13); /* max: 9 bytes (8.3 or just 9) */
    pawn.minphys = htonl(atoi (argv[3]));
    pawn.maxphys = htonl(atoi (argv[4]));
    pawn.mspells = htonl(strtol (argv[5], NULL, 0));
    pawn.cspells = htonl(strtol (argv[6], NULL, 0));
    pawn.hp = htonl(atoi (argv[7]));
    pawn.epval = htonl(atoi (argv[8]));
    pawn.gpval = htonl(atoi (argv[9]));
    pawn.susceptibility = 0;
    if (strstr(argv[10], "PSN") != NULL)
	pawn.susceptibility = (pawn.susceptibility|STATUS_POISON);
    if (strstr(argv[10], "PTR") != NULL)
	pawn.susceptibility = (pawn.susceptibility|STATUS_PETRIF);
    if (strstr(argv[10], "AFR") != NULL)
	pawn.susceptibility = (pawn.susceptibility|STATUS_AFRAID);
    pawn.susceptibility = htonl(pawn.susceptibility);
    if (strstr(argv[11], "PSN") != NULL)
	pawn.specialphys = (pawn.specialphys|STATUS_POISON);
    if (strstr(argv[11], "PTR") != NULL)
	pawn.specialphys = (pawn.specialphys|STATUS_PETRIF);
    if (strstr(argv[11], "AFR") != NULL)
	pawn.specialphys = (pawn.specialphys|STATUS_AFRAID);
    pawn.specialphys = htonl(pawn.specialphys);
    
    if ((out = fopen (argv[12], "wb")) == NULL)
	errhandle();
    fwrite (&pawn, sizeof(MonsterPawn), 1, out);
    
    fclose (out);
    
    return 0;
}
