module PkgMisc
using ..Pkg
using Test

@testset "inference" begin
    f1() = Pkg.Types.STDLIBS_BY_VERSION
    @inferred f1()
    f2() = Pkg.Types.UNREGISTERED_STDLIBS
    @inferred f2()
end

@testset "hashing" begin
    @test hash(Pkg.Types.Project()) == hash(Pkg.Types.Project())
    @test hash(Pkg.Types.VersionBound()) == hash(Pkg.Types.VersionBound())
    @test hash(Pkg.Resolve.Fixed(VersionNumber(0,1,0))) == hash(Pkg.Resolve.Fixed(VersionNumber(0,1,0)))

    hash(Pkg.Types.VersionSpec()) # hash isn't stable
    hash(Pkg.Types.PackageEntry()) # hash isn't stable because the internal `repo` field is a mutable struct
end

@testset "safe_realpath" begin
    # issue #3085
    for p in ("", "some-non-existing-path")
        @test p == Pkg.safe_realpath(p)
    end
end

@test eltype([PackageSpec(a) for a in []]) == PackageSpec

end # module
