/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.stream;

import java.io.IOException;
import java.io.InputStream;
import uk.org.webcompere.systemstubs.resource.SingularTestResource;
import uk.org.webcompere.systemstubs.stream.input.AltInputStream;
import uk.org.webcompere.systemstubs.stream.input.DecoratingAltStream;
import uk.org.webcompere.systemstubs.stream.input.LinesAltStream;
import uk.org.webcompere.systemstubs.stream.input.ThrowAtEndStream;

public class SystemIn
extends SingularTestResource {
    private InputStream originalIn;
    private AltInputStream altInputStream;

    public SystemIn() {
        this(new String[0]);
    }

    public SystemIn(String ... lines) {
        this(new LinesAltStream(lines));
    }

    public SystemIn(InputStream inputStream) {
        this(new DecoratingAltStream(inputStream));
    }

    public SystemIn(AltInputStream altInputStream) {
        this.altInputStream = altInputStream;
    }

    public SystemIn setInputStream(InputStream inputStream) {
        return this.setInputStream(new DecoratingAltStream(inputStream));
    }

    public SystemIn setInputStream(AltInputStream altInputStream) {
        if (this.isActive()) {
            System.setIn(altInputStream);
        }
        this.altInputStream = altInputStream;
        return this;
    }

    public SystemIn andExceptionThrownOnInputEnd(IOException exception) {
        if (this.altInputStream.contains(ThrowAtEndStream.class)) {
            throw new IllegalStateException("You cannot call andExceptionThrownOnInputEnd(IOException) because andExceptionThrownOnInputEnd has already been called.");
        }
        this.setInputStream(new ThrowAtEndStream(this.altInputStream, exception));
        return this;
    }

    public SystemIn andExceptionThrownOnInputEnd(RuntimeException exception) {
        if (this.altInputStream.contains(ThrowAtEndStream.class)) {
            throw new IllegalStateException("You cannot call andExceptionThrownOnInputEnd(RuntimeException) because andExceptionThrownOnInputEnd has already been called.");
        }
        this.setInputStream(new ThrowAtEndStream(this.altInputStream, exception));
        return this;
    }

    @Override
    protected void doSetup() throws Exception {
        this.originalIn = System.in;
        System.setIn(this.altInputStream);
    }

    @Override
    protected void doTeardown() throws Exception {
        System.setIn(this.originalIn);
        this.altInputStream.close();
    }
}

