/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.ForLink;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.attribute.SimpleLabel;
import java.util.Objects;
import javax.annotation.Nullable;

public final class EndLabel
extends SimpleLabel
implements Attributes<ForLink> {
    private final String key;
    @Nullable
    private final Double angle;
    @Nullable
    private final Double distance;

    private EndLabel(String key2, String value, boolean html, @Nullable Double angle, @Nullable Double distance) {
        super(value, html);
        this.key = key2;
        this.angle = angle;
        this.distance = distance;
    }

    public static EndLabel head(SimpleLabel label, @Nullable Double angle, @Nullable Double distance) {
        return new EndLabel("headlabel", label.value, label.html, angle, distance);
    }

    public static EndLabel tail(SimpleLabel label, @Nullable Double angle, @Nullable Double distance) {
        return new EndLabel("taillabel", label.value, label.html, angle, distance);
    }

    @Override
    public Attributes<? super ForLink> applyTo(MapAttributes<? super ForLink> attributes) {
        attributes.add(this.key, this);
        if (this.angle != null) {
            attributes.add("labelangle", this.angle);
        }
        if (this.distance != null) {
            attributes.add("labeldistance", this.distance);
        }
        return attributes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndLabel endLabel = (EndLabel)o;
        return Objects.equals(this.key, endLabel.key) && Objects.equals(this.angle, endLabel.angle) && Objects.equals(this.distance, endLabel.distance);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key, this.angle, this.distance);
    }
}

