/*******************************************************************************
* File:   		misc.c
* Date:   		2002-09-24
* Author: 		Alain Girardet/Dominik Blunk/Fernando Tarín
* Last Modified:	2002-10-24
*
* Description: Misc functions
*
*
* This program is free software; you can redistribute it and/or modify it under
* the terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version. See http://www.fsf.org/copyleft/gpl.txt.
*
* This program is distributed in the hope that it will be useful, but WITHOUT ANY
* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
* PARTICULAR PURPOSE. See the GNU General Public License for more details.
*
********************************************************************************/

#include <sys/time.h>
#include <stdio.h>
#include "wepdecrypt.h"
#include "config.h"
#include "log.h"
#include "misc.h"

double difftime_us(struct timeval *time_start, struct timeval *time_end) {

	double ret_time;
	ret_time = ((double)(time_end->tv_usec) / 1000000);
	ret_time += ((double)time_end->tv_sec);
	ret_time -= ((double)(time_start->tv_usec) / 1000000);
	ret_time -= (double)(time_start->tv_sec);

	return ret_time;
}

void show_help() {
	
	fprintf(stdout,"WEPDECRYPT by Fernando Tarin ");
	fprintf(stdout,"based on Wepattack - Version %s\n", VERSION);
#ifndef __CYGWIN__
	fprintf(stdout,"\nusage: wepdecrypt -f dumpfile [-s] [-w wordfile]");
#else
	fprintf(stdout,"\nusage: wepdecrypt -f dumpfile [-w wordfile]");
#endif
	fprintf(stdout, " [-m mode] [-b mac_address] [-i key] [-e key] [-n network] [-c server:port] [-g] [-l num_blocks] [-d mode]\n\n");
	fprintf(stdout,"-f dumpfile \tnetwork dumpfile to read\n");
	fprintf(stdout,"\t\t(in PCAP format as TCPDUMP or ETHEREAL uses)\n");
	fprintf(stdout,"-w wordlist \twordlist to use (default: stdin not valid with 64 or 128 mode)\n");
	fprintf(stdout,"-b mac_address \tfilters the mac address from the dump file\n");
	fprintf(stdout,"-m mode \truns wepdecrypt in diffente modes (default: all)\n");
	fprintf(stdout,"\t\tvalues: 64, 128, n64, n128, nall\n");
	fprintf(stdout,"-i Key \t\tspecifies the first key (only with 64 or 128 mode can be also used in server mode)\n");
	fprintf(stdout,"-e Key \t\tspecifies the last key (only with 64 or 128 mode)\n");
	fprintf(stdout,"-d mode \tsets the mode for the key generator\n");
	fprintf(stdout,"\t\tvalues: all, alpha, alphanumeric, numeric, random, printable\n");
	fprintf(stdout,"-s 	\tServer mode needs a decrypt mode and a dumpfile\n");
	fprintf(stdout,"-c server:port \tClient mode, host and port where server is running\n");	
	fprintf(stdout,"-n network \tnetwork number to attack\n");
	fprintf(stdout,"-v \t\tShows current version\n");
	fprintf(stdout,"-?|-h \t\tShows this help\n\n");	
}

void show_version() {
	
	fprintf(stdout,"WepDecrypt Version %s - Fernando Tarin\n", VERSION);
	fprintf(stdout,"Copyright (C) %s\n\n", YEAR);
	fprintf(stdout,"This is free software; see the source for copying conditions.\n");
	fprintf(stdout,"There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\n");
	fprintf(stdout,"PARTICULAR PURPOSE.\n\n");
	
}

void wlan_key_cracked() {

	// write result to logfile
	log_bssid(current_packet);

	// display information on screen
	printf("\n++++++++++ Packet decrypted! ++++++++++\n");

	// display bssid and key
	printf("BSSID: ");
	print_hex_array(stdout, current_packet->frame.bssid,6);
	printf("/ Key %d", current_packet->frame.key);

	// display wepkey
	printf("\tWepKey: ");
	print_hex_array(stdout, current_packet->secret,
		current_packet->encryption&0x0F);
	
	if ((current_packet->encryption&0x60) == MODE_WEP)
		printf("(%s)", current_packet->secret);
	else if ((current_packet->encryption&0x60) == MODE_KEYGEN)
		printf("(%s)", current_packet->nwep_secret);

	// display encryption
	printf("\nEncryption: %d Bit", ((current_packet->encryption&0x0F)+3)*8);
	if ((current_packet->encryption&0x60) == MODE_KEYGEN)
		printf(" (KEYGEN)");
	printf("\n");
}

int 
d_fprintf (FILE *__restrict __stream, 
	__const char *__restrict __format,...) {

	if (DEBUG) {
		fprintf(__stream, __format);
	}
	
	return 0;
}

void print_hex_array(FILE* out, unsigned char* data, int length) {

	int start = 0;

	while(start < length) {
		fprintf(out,"%.2X ",data[start]);
		start++;
   	}
}
