/********************************************************************************
* File:   		log.c
* Date:   		2002-09-24
* Author: 		Alain Girardet/Dominik Blunk/Fernando Tarín
* Last Modified:	2002-10-24
*
* Description: Write attack & server results to logfile
*
*
* This program is free software; you can redistribute it and/or modify it under
* the terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version. See http://www.fsf.org/copyleft/gpl.txt.
*
* This program is distributed in the hope that it will be useful, but WITHOUT ANY
* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
* PARTICULAR PURPOSE. See the GNU General Public License for more details.
*
********************************************************************************/

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include "log.h"
#include "wepdecrypt.h"
#include "misc.h"
#include "config.h"

static time_t start_time;
char logfile[40];

//
// generate logfile name, logfiles wouldn't be overwritten
//
void get_logfile(char *name) {

	FILE* fp;
	time_t now;
	struct tm* date;
	int file_count = 1;

	now = time(&now);
	date = localtime(&now);

	// generate first logfile name
	sprintf(name,"%s-%d-%.2d-%.2d-%d%s", LOGFILE_PREFIX, date->tm_year+1900,
		date->tm_mon+1, date->tm_mday, file_count, LOGFILE_POSTFIX);

	// try to open file, file does exist, if open is successful
	fp = fopen(name,"r");

	// loop until file open fail (file does not exist)
	while (fp != NULL) {
		file_count++;
		fclose(fp);
		sprintf(name,"%s-%d-%.2d-%.2d-%d%s", LOGFILE_PREFIX, 
			date->tm_year+1900, date->tm_mon+1, date->tm_mday,
			file_count, LOGFILE_POSTFIX);
		fp = fopen(name,"r");
	}
}

void open_log(char *word, char *in) {

	FILE *fp;

	get_logfile(logfile);

	fp = fopen(logfile,"w");

	start_time = time(&start_time);
	fprintf(fp, "Logfile of WepDecrypt by Fernando Tarin\n\n");
	fprintf(fp, "Cracking started: %s", ctime(&start_time));
	fprintf(fp, "Cracking method: %s\tDumpFile: %s\n", word, in);

	fprintf(fp, "\nBssid\t\t\tKeyNo\tWepKey\t\tASCII\tEncryption\tElapsed Time");
	fclose(fp);
}

void log_bssid(wlan_packet_list* bssid) {

	FILE *fp;
	time_t now;
	//int encryption;

	fp = fopen(logfile,"a");
	now = time(&now);

	fprintf(fp, "\n");
	print_hex_array(fp, bssid->frame.bssid,6);
	fprintf(fp, "\t%d", bssid->frame.key);

	fprintf(fp, "\t");

	print_hex_array(fp, bssid->secret, bssid->encryption&0x0F);
	if ((bssid->encryption&0x60) == MODE_WEP)
		fprintf(fp, "\t%s", bssid->secret);
	else if ((bssid->encryption&0x60) == MODE_KEYGEN)
		fprintf(fp, "\t%s", bssid->nwep_secret);

	fprintf(fp, "\t%d Bit", ((bssid->encryption&0x0F)+3)*8);
	if ((bssid->encryption&0x60) == MODE_KEYGEN)
		fprintf(fp, " (KEYGEN)");

	fprintf(fp, "\t\t%d sec", (int)difftime(now, start_time));

	fclose(fp);
}

void log_uncracked(wlan_packet_list* list, unsigned char* key, unsigned char use_modes) {

	FILE *fp;
	time_t now;

	fp = fopen(logfile,"a");
	now = time(&now);

	while (list->next != NULL) {
		if (!list->cracked) {
			fprintf(fp, "\n");
			print_hex_array(fp, list->frame.bssid, 6);
			fprintf(fp, "\t%d", list->frame.key);
			fprintf(fp, "\tnot cracked\t\t\t\t%d sec",
				(int)difftime(now, start_time));
		}
		list = list->next;
	}
	if ((use_modes & 0x07) == 0)
		fprintf(fp,"\n\nLast key: %.2X:%.2X:%.2X:%.2X:%.2X\n", key[0], key[1], key[2],key[3], key[4]);
	else if ((use_modes & 0x07) == 2)
		fprintf(fp,"\n\nLast key: %.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X\n", key[0], key[1], key[2],key[3], key[4]\
					,key[5], key[6], key[7],key[8], key[9], key[10], key[11], key[12]);
	else
		if (key != NULL) fprintf(fp,"\n\nLast key: %s", key);

	fprintf(fp,"\n");
		
	fclose(fp);
}

void server_log_init(char * log_file, int mode, char * path, char * file_name, int port, char * block_size, int network_count){
	FILE *fp;
	time_t now;
	
	now = time(&now);
	
	if ((fp = fopen(log_file, "r")) == NULL){
		if ((fp = fopen(log_file,"a+")) == NULL ){
		return;			
		}
		fprintf(fp, "Logfile of WepDecrypt by Fernando Tarin\n\n");		
	}
	
	else{
		if ((fp = fopen(log_file,"a+")) == NULL ){
			return;
		}
	}	
	fprintf(fp, "Starting server - %s", ctime(&now));

#ifndef __CYGWIN__
	fprintf(fp, "Cracking method: %i Bits  DumpFile: %s%s\n", mode, path, file_name);
#else
	fprintf(fp, "Cracking method: %i Bits  DumpFile: %s\n", mode, file_name);
#endif
	
	fprintf(fp, "Port: %i Blocksize: %s\n", port, block_size);
	fprintf(fp, "%i key to decrypt\n", network_count);
	fclose(fp);	
}

void server_log_message(char * log_file, const unsigned char * message){
	FILE *fp;
	
	if ((fp = fopen(log_file,"a+")) == NULL ){
			return;
		}
		
	fprintf(fp,"%s\n", message);
	fclose(fp);
}

void server_log_key(char * log_file, const unsigned char * decrypted_key, const unsigned char * decrypted_bssid, int mode){
	int i;
	FILE * fp;
	
	if ((fp = fopen(log_file,"a+")) == NULL ){
		return;
	}
	
	fprintf(fp, "\n==================== DECRYPTED KEY ====================\n");
	fprintf(fp, "BSSID: ");
	for (i=0; i<6; i++){
		fprintf(fp, "%.2X", decrypted_bssid[i]);
		if (i != 5) fprintf(fp, ":");
	}
	fprintf(fp, "\nDecrypted key: ");
	if (mode == 64){		
		for (i=0; i<5; i++){
			fprintf(fp, "%.2X", decrypted_key[i]);
			if (i != 4) fprintf(fp, ":");
		}
	}
	else{
		for (i=0; i<13; i++){
			fprintf(fp, "%.2X", decrypted_key[i]);
			if (i != 12) fprintf(fp, ":");
		}
	}
	fprintf(fp,"\n=======================================================\n\n");
	fclose(fp);
}

void server_log_stop(char * log_file){
	FILE * fp;
	time_t now;
	
	now = time(&now);
	
	if ((fp = fopen(log_file,"a")) == NULL ){
		return;
	}
	
	fprintf(fp , "Stoping server - %s\n", ctime(&now));
	
	fclose(fp);
}
