/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.BonusCalc;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Delta;
import pcgen.util.Logging;

public class ArmorToken
extends Token {
    public static final String TOKENNAME = "ARMOR";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        if (tokenSource.startsWith(TOKENNAME) && (tokenSource.charAt(5) == '.' || Character.isDigit(tokenSource.charAt(5)))) {
            return ArmorToken.getArmorToken(tokenSource, pc, eh);
        }
        return "";
    }

    public static String getArmorToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        return ArmorToken.replaceTokenArmor(tokenSource, pc, eh);
    }

    private static String replaceTokenArmor(String aString, PlayerCharacter aPC, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        String[] tokens = new String[aTok.countTokens()];
        int i = 0;
        while (aTok.hasMoreTokens()) {
            tokens[i] = aTok.nextToken();
            ++i;
        }
        String property = "";
        if (tokens.length > 0) {
            property = tokens[tokens.length - 1];
        }
        int equipped = 3;
        int index = 0;
        String type = "";
        String subtype = "";
        int merge = 0;
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            if (TOKENNAME.equals(tokens[i2])) continue;
            if (tokens[i2].startsWith(TOKENNAME)) {
                try {
                    index = Integer.parseInt(tokens[i2].substring(5));
                }
                catch (NumberFormatException nfe) {
                    index = 0;
                }
                Logging.errorPrint((String)"Old syntax ARMORx will be replaced for ARMOR.x");
                continue;
            }
            if ("ALL".equals(tokens[i2])) {
                equipped = 3;
                continue;
            }
            if (tokens[i2].startsWith("ALL")) {
                Logging.errorPrint((String)"Old syntax ALLx will be replaced for ALL.x");
                index = Integer.parseInt(tokens[i2].substring(3));
                equipped = 3;
                continue;
            }
            if ("EQUIPPED".equals(tokens[i2])) {
                equipped = 1;
                continue;
            }
            if (tokens[i2].startsWith("EQUIPPED")) {
                Logging.errorPrint((String)"Old syntax EQUIPPEDx will be replaced for EQUIPPED.x");
                index = Integer.parseInt(tokens[i2].substring(8));
                equipped = 1;
                continue;
            }
            if ("NOT_EQUIPPED".equals(tokens[i2])) {
                equipped = 2;
                continue;
            }
            if (tokens[i2].startsWith("NOT_EQUIPPED")) {
                Logging.errorPrint((String)"Old syntax NOT_EQUIPPEDx will be replaced for NOT_EQUIPPED.x");
                index = Integer.parseInt(tokens[i2].substring(12));
                equipped = 2;
                continue;
            }
            if (tokens[i2].equals("MERGENONE")) {
                merge = 1;
                continue;
            }
            if (tokens[i2].equals("MERGELOC")) {
                merge = 2;
                continue;
            }
            if (tokens[i2].equals("MERGEALL")) {
                merge = 0;
                continue;
            }
            if (tokens[i2].equals("ISTYPE")) {
                property = tokens[i2] + "." + tokens[i2 + 1];
                break;
            }
            if (tokens[i2].equals("NAME")) {
                property = tokens[i2];
                if (i2 >= tokens.length - 1) break;
                property = property + "." + tokens[i2 + 1];
                break;
            }
            if (i2 < tokens.length - 1) {
                try {
                    index = Integer.parseInt(tokens[i2]);
                }
                catch (NumberFormatException exc) {
                    if ("".equals(type)) {
                        type = tokens[i2];
                        continue;
                    }
                    subtype = tokens[i2];
                }
                continue;
            }
            property = tokens[i2];
        }
        if ("".equals(type)) {
            return ArmorToken._replaceTokenArmor(index, property, equipped, merge, aPC, eh);
        }
        if ("SUIT".equals(type)) {
            return ArmorToken._replaceTokenArmorSuit(index, subtype, property, equipped, merge, aPC, eh);
        }
        if ("SHIRT".equals(type)) {
            return ArmorToken._replaceTokenArmorShirt(index, subtype, property, equipped, merge, aPC, eh);
        }
        if ("SHIELD".equals(type)) {
            return ArmorToken._replaceTokenArmorShield(index, subtype, property, equipped, merge, aPC, eh);
        }
        if ("ITEM".equals(type) || "ACITEM".equals(type)) {
            return ArmorToken._replaceTokenArmorItem(index, subtype, property, equipped, merge, aPC, eh);
        }
        return ArmorToken._replaceTokenArmorVarious(index, type, subtype, property, equipped, merge, aPC, eh);
    }

    private static String _replaceTokenArmor(int armor, String property, int equipped, int merge, PlayerCharacter aPC, ExportHandler eh) {
        List aArrayList = aPC.getEquipmentOfTypeInOutputOrder("Armor", equipped, merge);
        List bArrayList = aPC.getEquipmentOfTypeInOutputOrder("Shield", equipped, merge);
        for (Equipment eq : bArrayList) {
            aArrayList.remove(eq);
        }
        if (armor < aArrayList.size()) {
            Equipment eq = (Equipment)aArrayList.get(armor);
            return ArmorToken._writeArmorProperty(eq, property, aPC);
        }
        eh.setNoMoreItems(true);
        return "";
    }

    private static String _replaceTokenArmorItem(int item, String subtype, String property, int equipped, int merge, PlayerCharacter aPC, ExportHandler eh) {
        ArrayList<Equipment> aArrayList = new ArrayList<Equipment>();
        for (Equipment eq : aPC.getEquipmentListInOutputOrder(merge)) {
            if (!"".equals(subtype) && !eq.isType(subtype) || equipped != 3 && (equipped != 2 || eq.isEquipped()) && (equipped != 1 || !eq.isEquipped()) || !eq.hasBonusWithInfo(aPC, "AC") || eq.isArmor() || eq.isShield()) continue;
            aArrayList.add(eq);
        }
        if (item < aArrayList.size()) {
            Equipment eq = (Equipment)aArrayList.get(item);
            return ArmorToken._writeArmorProperty(eq, property, aPC);
        }
        eh.setNoMoreItems(true);
        return "";
    }

    private static String _replaceTokenArmorShield(int shield, String subtype, String property, int equipped, int merge, PlayerCharacter aPC, ExportHandler eh) {
        List aArrayList = aPC.getEquipmentOfTypeInOutputOrder("Shield", subtype, equipped, merge);
        if (shield < aArrayList.size()) {
            Equipment eq = (Equipment)aArrayList.get(shield);
            return ArmorToken._writeArmorProperty(eq, property, aPC);
        }
        eh.setNoMoreItems(true);
        return "";
    }

    private static String _replaceTokenArmorShirt(int shirt, String subtype, String property, int equipped, int merge, PlayerCharacter aPC, ExportHandler eh) {
        List aArrayList = aPC.getEquipmentOfTypeInOutputOrder("Shirt", subtype, equipped, merge);
        if (shirt < aArrayList.size()) {
            Equipment eq = (Equipment)aArrayList.get(shirt);
            return ArmorToken._writeArmorProperty(eq, property, aPC);
        }
        eh.setNoMoreItems(true);
        return "";
    }

    private static String _replaceTokenArmorSuit(int suit, String subtype, String property, int equipped, int merge, PlayerCharacter aPC, ExportHandler eh) {
        List aArrayList = aPC.getEquipmentOfTypeInOutputOrder("Suit", subtype, equipped, merge);
        if (suit < aArrayList.size()) {
            Equipment eq = (Equipment)aArrayList.get(suit);
            return ArmorToken._writeArmorProperty(eq, property, aPC);
        }
        eh.setNoMoreItems(true);
        return "";
    }

    private static String _replaceTokenArmorVarious(int index, String type, String subtype, String property, int equipped, int merge, PlayerCharacter aPC, ExportHandler eh) {
        ArrayList<Equipment> aArrayList = new ArrayList<Equipment>();
        for (Equipment eq : aPC.getEquipmentOfTypeInOutputOrder(type, subtype, equipped, merge)) {
            if (eq.getACMod(aPC) > 0) {
                aArrayList.add(eq);
                continue;
            }
            if (!eq.hasBonusWithInfo(aPC, "AC")) continue;
            aArrayList.add(eq);
        }
        if (index < aArrayList.size()) {
            Equipment eq = (Equipment)aArrayList.get(index);
            return ArmorToken._writeArmorProperty(eq, property, aPC);
        }
        eh.setNoMoreItems(true);
        return "";
    }

    private static String _writeArmorProperty(Equipment eq, String property, PlayerCharacter aPC) {
        CharacterDisplay display = aPC.getDisplay();
        StringBuilder ret = new StringBuilder();
        if (property.startsWith("NAME")) {
            if (eq.isEquipped() && !property.equals("NAMENOSTAR")) {
                ret.append("*");
            }
            ret.append(OutputNameFormatting.parseOutputName((CDOMObject)eq, (PlayerCharacter)aPC));
            ret.append(eq.getAppliedName());
        } else if (property.startsWith("OUTPUTNAME")) {
            if (eq.isEquipped()) {
                ret.append("*");
            }
            ret.append(OutputNameFormatting.parseOutputName((CDOMObject)eq, (PlayerCharacter)aPC));
            ret.append(eq.getAppliedName());
        } else if (property.startsWith("TOTALAC")) {
            ret.append(Delta.toString((int)((int)eq.bonusTo(aPC, "COMBAT", "AC", true))));
        } else if (property.startsWith("BASEAC")) {
            ret.append(Delta.toString((int)((int)BonusCalc.charBonusTo((PObject)eq, (String)"COMBAT", (String)"AC", (PlayerCharacter)aPC))));
        } else if (property.startsWith("ACBONUS")) {
            ret.append(Delta.toString((int)((int)eq.bonusTo(aPC, "COMBAT", "AC", true))));
        } else if (property.startsWith("MAXDEX")) {
            int iMax = eq.getMaxDex(aPC);
            if (iMax != 100) {
                ret.append(Delta.toString((int)iMax));
            }
        } else if (property.startsWith("ACCHECK")) {
            ret.append(Delta.toString((Integer)eq.acCheck(aPC)));
        } else if (property.startsWith("EDR")) {
            ret.append(Delta.toString((Integer)eq.eDR(aPC)));
        } else if (property.startsWith("ISTYPE")) {
            if (eq.isType(property.substring(property.indexOf(".") + 1))) {
                ret.append("TRUE");
            } else {
                ret.append("FALSE");
            }
        } else if (property.startsWith("SPELLFAIL")) {
            ret.append(eq.spellFailure(aPC).toString());
        } else if (property.startsWith("MOVE")) {
            StringTokenizer aTok = new StringTokenizer(eq.moveString(), ",", false);
            String tempString = "";
            if (("M".equals(display.getSize()) || "S".equals(display.getSize())) && aTok.countTokens() > 0) {
                tempString = aTok.nextToken();
                if ("S".equals(display.getSize()) && aTok.countTokens() > 1) {
                    tempString = aTok.nextToken();
                }
            }
            ret.append(tempString);
        } else if (property.startsWith("SPROP")) {
            ret.append(eq.getSpecialProperties(aPC));
        } else if (property.startsWith("TYPE")) {
            String typeString = "";
            if (eq.isLight()) {
                typeString = "Light";
            } else if (eq.isMedium()) {
                typeString = "Medium";
            } else if (eq.isHeavy()) {
                typeString = "Heavy";
            } else if (eq.isShield()) {
                typeString = "Shield";
            } else if (eq.isExtra()) {
                typeString = "Extra";
            }
            ret.append(typeString);
        } else if (property.startsWith("WT")) {
            ret.append(BigDecimalHelper.trimZeros((String)eq.getWeight(aPC).toString()));
        }
        return ret.toString();
    }
}

