/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import pcgen.base.formula.AddingFormula;
import pcgen.base.formula.DividingFormula;
import pcgen.base.formula.MultiplyingFormula;
import pcgen.base.formula.SubtractingFormula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.Processor;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.processor.ContextProcessor;
import pcgen.cdom.processor.HitDieFormula;
import pcgen.cdom.processor.HitDieLock;
import pcgen.cdom.processor.HitDieStep;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class HitdieToken
extends AbstractNonEmptyToken<PCTemplate>
implements CDOMPrimaryToken<PCTemplate> {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;

    @Override
    public String getTokenName() {
        return "HITDIE";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, PCTemplate template, String value) {
        try {
            int steps;
            Processor<HitDie> hdm;
            String lock = value;
            int pipeLoc = lock.indexOf("|");
            if (pipeLoc != lock.lastIndexOf("|")) {
                return new ParseResult.Fail(this.getTokenName() + " has more than one pipe, " + "is not of format: <int>[|<prereq>]", context);
            }
            CDOMReference owner = null;
            if (pipeLoc != -1) {
                String substring;
                String lockPre = lock.substring(pipeLoc + 1);
                if (lockPre.startsWith("CLASS.TYPE=")) {
                    substring = lock.substring(pipeLoc + 12);
                    if (substring.length() == 0) {
                        return new ParseResult.Fail("Cannot have Empty Type Limitation in " + this.getTokenName() + ": " + value, context);
                    }
                    ParseResult pr = this.checkForIllegalSeparator('.', substring);
                    if (!pr.passed()) {
                        return pr;
                    }
                    owner = context.getReferenceContext().getCDOMTypeReference(PCCLASS_CLASS, substring.split("\\."));
                } else if (lockPre.startsWith("CLASS=")) {
                    substring = lock.substring(pipeLoc + 7);
                    if (substring.length() == 0) {
                        return new ParseResult.Fail("Cannot have Empty Class Limitation in " + this.getTokenName() + ": " + value, context);
                    }
                    owner = context.getReferenceContext().getCDOMReference(PCCLASS_CLASS, substring);
                } else {
                    return new ParseResult.Fail("Invalid Limitation in HITDIE: " + lockPre, context);
                }
                lock = lock.substring(0, pipeLoc);
            }
            if (lock.startsWith("%/")) {
                int denom = Integer.parseInt(lock.substring(2));
                if (denom <= 0) {
                    return new ParseResult.Fail(this.getTokenName() + " was expecting a Positive Integer " + "for dividing Lock, was : " + lock.substring(2), context);
                }
                hdm = new HitDieFormula(new DividingFormula(denom));
            } else if (lock.startsWith("%*")) {
                int mult = Integer.parseInt(lock.substring(2));
                if (mult <= 0) {
                    return new ParseResult.Fail(this.getTokenName() + " was expecting a Positive " + "Integer for multiplying Lock, was : " + lock.substring(2), context);
                }
                hdm = new HitDieFormula(new MultiplyingFormula(mult));
            } else if (lock.startsWith("%+")) {
                int add = Integer.parseInt(lock.substring(2));
                if (add <= 0) {
                    return new ParseResult.Fail(this.getTokenName() + " was expecting a Positive " + "Integer for adding Lock, was : " + lock.substring(2), context);
                }
                hdm = new HitDieFormula(new AddingFormula(add));
            } else if (lock.startsWith("%-")) {
                int sub = Integer.parseInt(lock.substring(2));
                if (sub <= 0) {
                    return new ParseResult.Fail(this.getTokenName() + " was expecting a Positive " + "Integer for subtracting Lock, was : " + lock.substring(2), context);
                }
                hdm = new HitDieFormula(new SubtractingFormula(sub));
            } else if (lock.startsWith("%up")) {
                steps = Integer.parseInt(lock.substring(3));
                if (steps <= 0) {
                    return new ParseResult.Fail("Invalid Step Count: " + steps + " in " + this.getTokenName() + " up (must be positive)", context);
                }
                if (steps >= 5) {
                    return new ParseResult.Fail("Invalid Step Count: " + steps + " in " + this.getTokenName() + " up (too large)", context);
                }
                hdm = new HitDieStep(steps, new HitDie(12));
            } else if (lock.startsWith("%Hup")) {
                steps = Integer.parseInt(lock.substring(4));
                if (steps <= 0) {
                    return new ParseResult.Fail("Invalid Step Count: " + steps + " in " + this.getTokenName(), context);
                }
                hdm = new HitDieStep(steps, null);
            } else if (lock.startsWith("%down")) {
                steps = Integer.parseInt(lock.substring(5));
                if (steps <= 0) {
                    return new ParseResult.Fail("Invalid Step Count: " + steps + " in " + this.getTokenName() + " down (must be positive)", context);
                }
                if (steps >= 5) {
                    return new ParseResult.Fail("Invalid Step Count: " + steps + " in " + this.getTokenName() + " down (too large)", context);
                }
                hdm = new HitDieStep(-steps, new HitDie(4));
            } else if (lock.startsWith("%Hdown")) {
                steps = Integer.parseInt(lock.substring(6));
                if (steps <= 0) {
                    return new ParseResult.Fail("Invalid Step Count: " + steps + " in " + this.getTokenName(), context);
                }
                hdm = new HitDieStep(-steps, null);
            } else {
                int i = Integer.parseInt(lock);
                if (i <= 0) {
                    return new ParseResult.Fail("Invalid HitDie: " + i + " in " + this.getTokenName(), context);
                }
                hdm = new HitDieLock(new HitDie(i));
            }
            Processor<HitDie> mod = owner == null ? hdm : new ContextProcessor(hdm, owner);
            context.getObjectContext().put((CDOMObject)template, ObjectKey.HITDIE, mod);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage("Invalid Number in " + this.getTokenName() + ": " + nfe.getLocalizedMessage());
            cpr.addErrorMessage("  Must be an Integer");
            return cpr;
        }
    }

    @Override
    public String[] unparse(LoadContext context, PCTemplate template) {
        Processor<HitDie> hdcf = context.getObjectContext().getObject(template, ObjectKey.HITDIE);
        if (hdcf == null) {
            return null;
        }
        return new String[]{hdcf.getLSTformat()};
    }

    @Override
    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }
}

