/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.ability;

import pcgen.core.kit.KitAbilities;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CountToken
extends AbstractToken
implements CDOMPrimaryToken<KitAbilities> {
    @Override
    public String getTokenName() {
        return "COUNT";
    }

    @Override
    public Class<KitAbilities> getTokenClass() {
        return KitAbilities.class;
    }

    @Override
    public ParseResult parseToken(LoadContext context, KitAbilities kitAbil, String value) {
        try {
            Integer quan = Integer.valueOf(value);
            if (quan <= 0) {
                return new ParseResult.Fail(this.getTokenName() + " expected an integer > 0", context);
            }
            kitAbil.setCount(quan);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>", context);
        }
    }

    @Override
    public String[] unparse(LoadContext context, KitAbilities kitAbil) {
        Integer bd = kitAbil.getCount();
        if (bd == null) {
            return null;
        }
        return new String[]{bd.toString()};
    }
}

