/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.plugin.Spell;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import plugin.initiative.SpellModel;
import plugin.initiative.gui.Initiative;
import plugin.initiative.gui.StartEvent;

public class CastSpell
extends StartEvent {
    protected JEditorPane descText;
    protected JPanel descPanel;
    protected JScrollPane descScroll;

    public CastSpell(Frame parent, boolean modal, Initiative initiative) {
        super(parent, modal, initiative);
    }

    public CastSpell(Frame parent, boolean modal, Initiative initiative, String player, int init) {
        super(parent, modal, initiative, player, init);
    }

    public void setSpellModel(SpellModel model) {
        StringBuilder text = new StringBuilder();
        if (this.descPanel.getComponents().length == 0) {
            this.descText = new JEditorPane("text/html", "<html></html>");
            this.descScroll = new JScrollPane(this.descText);
            this.descPanel.add((Component)this.descScroll, "Center");
        }
        this.descText.setBackground(this.getContentPane().getBackground());
        text.append("<html><body><font size='-2'>");
        text.append("<b>Duration: </b>" + model.getDuration() + " ");
        text.append("<b>Range: </b>" + model.getRange() + " ");
        text.append("<b>Save: </b>" + model.getSaveInfo() + " ");
        text.append("<b>Cast: </b>" + model.getCastingTime() + " ");
        text.append("<b>Target/Area: </b>" + model.getTarget() + " ");
        text.append("<b>Desc: </b>" + model.getDesc() + " ");
        text.append("</font></body></html>");
        this.descText.setText(text.toString());
        this.descPanel.setPreferredSize(new Dimension(this.mainPanel.getWidth() - 16, 75));
        this.descPanel.setMaximumSize(new Dimension(this.mainPanel.getWidth() - 16, 75));
        this.descPanel.setMinimumSize(new Dimension(this.mainPanel.getWidth() - 16, 75));
        this.pack();
        this.tEffect.setText(model.getDesc());
    }

    public void setSpellName(String spellName) {
        this.tName.setText(spellName);
    }

    @Override
    protected void save() {
        this.initiative.initList.add(new Spell(this.tName.getText(), this.tPlayer.getText(), this.tEffect.getText(), (Integer)this.lDuration.getValue(), (Integer)this.lInit.getValue(), this.cbAlert.isSelected()));
        this.initiative.writeToCombatTabWithRound(this.tPlayer.getText() + " Cast " + this.tName.getText());
        this.initiative.refreshTable();
        this.initiative.grabFocus();
        this.initiative.focusNextInit();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void initComponents() {
        this.sTitle = "Cast Spell";
        this.sAlertLabel = "Alert when spell duration expires";
        this.basicSetup();
        this.initAllDefaultComponents();
        this.addDescriptionPanel();
        this.addButtons();
        this.finalizeSetup();
    }

    private void addDescriptionPanel() {
        GridBagConstraints gridBagConstraints = null;
        this.descPanel = new JPanel(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.gridBagRow++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.descPanel, gridBagConstraints);
    }
}

