/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;

public final class KitLevelAbility
extends BaseKit {
    private CDOMSingleRef<PCClass> theClassName;
    private int theLevel;
    private List<String> choiceList = new ArrayList<String>();
    private PersistentTransitionChoice<?> add;

    public void setClass(CDOMSingleRef<PCClass> className) {
        this.theClassName = className;
    }

    public CDOMSingleRef<PCClass> getPCClass() {
        return this.theClassName;
    }

    public void setLevel(int level) {
        this.theLevel = level;
    }

    public int getLevel() {
        return this.theLevel;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.add);
        buf.append(": [");
        boolean firstTime = true;
        for (String choiceStr : this.choiceList) {
            if (!firstTime) {
                buf.append(", ");
            }
            buf.append(choiceStr);
            firstTime = false;
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        return this.doApplication(aPC);
    }

    @Override
    public void apply(PlayerCharacter aPC) {
        this.doApplication(aPC);
    }

    private boolean doApplication(PlayerCharacter aPC) {
        List<PersistentTransitionChoice<?>> adds;
        PCClass theClass = this.theClassName.resolvesTo();
        PCClass classKeyed = aPC.getClassKeyed(theClass.getKeyName());
        if (classKeyed == null) {
            // empty if block
        }
        if ((adds = theClass.getListFor(ListKey.ADD)) == null) {
            // empty if block
        }
        for (PersistentTransitionChoice<?> ch : adds) {
            if (!this.add.equals(ch)) continue;
            this.process(aPC, classKeyed, ch);
            return true;
        }
        return false;
    }

    private <T> void process(PlayerCharacter pc, PCClass cl, PersistentTransitionChoice<T> ch) {
        ArrayList list = new ArrayList();
        for (String s : this.choiceList) {
            list.add(ch.decodeChoice(Globals.getContext(), s));
        }
        ch.act(list, cl, pc);
    }

    @Override
    public String getObjectName() {
        return "Class Feature";
    }

    public void addChoice(String string) {
        this.choiceList.add(string);
    }

    public void setAdd(PersistentTransitionChoice<?> name) {
        this.add = name;
    }

    public PersistentTransitionChoice<?> getAdd() {
        return this.add;
    }
}

