/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.QualifyingObject;
import pcgen.cdom.list.CompanionList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;

public class FollowerOption
extends ConcretePrereqObject
implements Comparable<FollowerOption>,
QualifyingObject {
    private int theAdjustment = 0;
    private final CDOMReference<Race> ref;
    private final CDOMSingleRef<CompanionList> list;

    public FollowerOption(CDOMReference<Race> race, CDOMSingleRef<CompanionList> listref) {
        if (race == null) {
            throw new IllegalArgumentException("Cannot have FollowerOption with null race");
        }
        if (listref == null) {
            throw new IllegalArgumentException("Cannot have FollowerOption with null list reference");
        }
        this.ref = race;
        this.list = listref;
    }

    public Race getRace() {
        Collection<Race> races = this.ref.getContainedObjects();
        return races.size() == 1 ? races.iterator().next() : null;
    }

    public CDOMReference<Race> getRaceRef() {
        return this.ref;
    }

    public void setAdjustment(int anAdjustment) {
        this.theAdjustment = anAdjustment;
    }

    public int getAdjustment() {
        return this.theAdjustment;
    }

    @Override
    public boolean qualifies(PlayerCharacter aPC, Object source) {
        int lvl;
        if (this.theAdjustment != 0 && (lvl = aPC.getEffectiveCompanionLevel(this.list.resolvesTo())) + this.theAdjustment <= 0) {
            return false;
        }
        return super.qualifies(aPC, source);
    }

    @Override
    public int compareTo(FollowerOption anO) {
        return ReferenceUtilities.compareRefs(this.ref, anO.ref);
    }

    public CDOMSingleRef<CompanionList> getListRef() {
        return this.list;
    }

    public Collection<FollowerOption> getExpandedOptions() {
        ArrayList<FollowerOption> options = new ArrayList<FollowerOption>();
        if (this.ref.getObjectCount() == 1) {
            options.add(this);
            return options;
        }
        for (Race r : this.ref.getContainedObjects()) {
            FollowerOption opt = new FollowerOption(CDOMDirectSingleRef.getRef(r), this.list);
            opt.setAdjustment(this.getAdjustment());
            opt.addAllPrerequisites(this.getPrerequisiteList());
            options.add(opt);
        }
        return options;
    }
}

