/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.List;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Description;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.util.Logging;

public class BenefitFormatting {
    public static String getBenefits(PlayerCharacter aPC, List<? extends Object> objList) {
        PObject sampleObject;
        if (objList.size() == 0) {
            return "";
        }
        Object b = objList.get(0);
        if (b instanceof PObject) {
            sampleObject = (PObject)b;
        } else if (b instanceof CNAbility) {
            sampleObject = ((CNAbility)b).getAbility();
        } else {
            Logging.errorPrint("Unable to resolve Description with object of type: " + b.getClass().getName());
            return "";
        }
        List<Description> theBenefits = sampleObject.getListFor(ListKey.BENEFIT);
        if (theBenefits == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(250);
        boolean needSpace = false;
        for (Description desc : theBenefits) {
            String str = desc.getDescription(aPC, objList);
            if (str.length() <= 0) continue;
            if (needSpace) {
                buf.append(' ');
            }
            buf.append(str);
            needSpace = true;
        }
        return buf.toString();
    }
}

