/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.fact;

import pcgen.base.lang.ObjectUtil;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Region;
import pcgen.cdom.enumeration.SubRegion;
import pcgen.cdom.facet.base.AbstractDataFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.core.PCTemplate;

public class RegionFacet
extends AbstractDataFacet<CharID, String>
implements DataFacetChangeListener<CharID, PCTemplate> {
    private TemplateFacet templateFacet;

    private RegionCacheInfo getConstructingInfo(CharID id) {
        RegionCacheInfo rci = this.getInfo(id);
        if (rci == null) {
            rci = new RegionCacheInfo();
            this.setCache(id, rci);
        }
        return rci;
    }

    private RegionCacheInfo getInfo(CharID id) {
        return (RegionCacheInfo)this.getCache(id);
    }

    public void setRegion(CharID id, Region region) {
        this.getConstructingInfo((CharID)id).region = region;
        this.updateRegion(id);
    }

    public void setSubRegion(CharID id, SubRegion subregion) {
        this.getConstructingInfo((CharID)id).subregion = subregion;
    }

    public String getCharacterRegion(CharID id) {
        RegionCacheInfo rci = this.getInfo(id);
        if (rci != null && rci.region != null) {
            return rci.region.toString();
        }
        return "None";
    }

    public String getRegion(CharID id) {
        String charRegion = this.getCharacterRegion(id);
        if (!charRegion.equalsIgnoreCase("None")) {
            return charRegion;
        }
        String region = "None";
        for (PCTemplate template : this.templateFacet.getSet(id)) {
            String tempRegion = this.getTemplateRegion(template);
            if (tempRegion.equals("None")) continue;
            region = tempRegion;
        }
        return region;
    }

    private String getTemplateRegion(PCTemplate template) {
        Region sr = template.get(ObjectKey.REGION);
        if (sr == null) {
            if (template.getSafe(ObjectKey.USETEMPLATENAMEFORREGION).booleanValue()) {
                return template.getDisplayName();
            }
            return "None";
        }
        return sr.toString();
    }

    public boolean matchesRegion(CharID id, Region r) {
        String current = this.getRegion(id);
        return r == null && "None".equals(current) || r != null && r.toString().equalsIgnoreCase(current);
    }

    public String getCharacterSubRegion(CharID id) {
        RegionCacheInfo rci = this.getInfo(id);
        if (rci != null && rci.subregion != null) {
            return rci.subregion.toString();
        }
        return "None";
    }

    public String getSubRegion(CharID id) {
        RegionCacheInfo rci = this.getInfo(id);
        if (rci != null && rci.subregion != null) {
            return rci.subregion.toString();
        }
        String s = "None";
        for (PCTemplate template : this.templateFacet.getSet(id)) {
            String tempSubRegion = this.getTemplateSubRegion(template);
            if (tempSubRegion.equals("None")) continue;
            s = tempSubRegion;
        }
        return s;
    }

    private String getTemplateSubRegion(PCTemplate template) {
        SubRegion sr = template.get(ObjectKey.SUBREGION);
        if (sr == null) {
            if (template.getSafe(ObjectKey.USETEMPLATENAMEFORSUBREGION).booleanValue()) {
                return template.getDisplayName();
            }
            return "None";
        }
        return sr.toString();
    }

    public String getFullRegion(CharID id) {
        String sub = this.getSubRegion(id);
        StringBuilder tempRegName = new StringBuilder(40).append(this.getRegion(id));
        if (!sub.equals("None")) {
            tempRegName.append(" (").append(sub).append(')');
        }
        return tempRegName.toString();
    }

    @Override
    public void copyContents(CharID source, CharID destination) {
        RegionCacheInfo sourceRCI = this.getInfo(source);
        if (sourceRCI != null) {
            RegionCacheInfo destRCI = this.getConstructingInfo(destination);
            destRCI.region = sourceRCI.region;
            destRCI.subregion = sourceRCI.subregion;
        }
    }

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, PCTemplate> dfce) {
        this.updateRegion(dfce.getCharID());
    }

    private void updateRegion(CharID id) {
        RegionCacheInfo rci = this.getInfo(id);
        String current = rci.cachedRegion;
        String newRegion = this.getRegion(id);
        if (current == null || !current.equals(newRegion)) {
            if (current != null) {
                this.fireDataFacetChangeEvent(id, current, 1);
            }
            rci.cachedRegion = newRegion;
            this.fireDataFacetChangeEvent(id, newRegion, 0);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, PCTemplate> dfce) {
        this.updateRegion(dfce.getCharID());
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    private static class RegionCacheInfo {
        public String cachedRegion;
        public Region region;
        public SubRegion subregion;

        private RegionCacheInfo() {
        }

        public String toString() {
            return this.region + " " + this.subregion + " " + this.cachedRegion;
        }

        public int hashCode() {
            return this.region == null ? -1 : this.region.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof RegionCacheInfo) {
                RegionCacheInfo other = (RegionCacheInfo)o;
                return ObjectUtil.compareWithNull((Object)this.region, (Object)other.region) && ObjectUtil.compareWithNull((Object)this.subregion, (Object)other.subregion) && ObjectUtil.compareWithNull((Object)this.cachedRegion, (Object)other.cachedRegion);
            }
            return false;
        }
    }
}

