/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import java.util.Collection;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.choiceset.AbilityRefChoiceSet;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;

public class ChoiceSet<T>
extends ConcretePrereqObject
implements PrereqObject,
SelectableSet<T> {
    private final PrimitiveChoiceSet<T> pcs;
    private final String setName;
    private String title = null;
    private final boolean useAny;

    public ChoiceSet(String name, PrimitiveChoiceSet<T> choice) {
        this(name, choice, false);
    }

    public ChoiceSet(String name, PrimitiveChoiceSet<T> choice, boolean any) {
        if (choice == null) {
            throw new IllegalArgumentException("PrimitiveChoiceSet cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.pcs = choice;
        this.setName = name;
        this.useAny = any;
    }

    @Override
    public String getLSTformat() {
        return this.pcs.getLSTformat(this.useAny);
    }

    @Override
    public Class<? super T> getChoiceClass() {
        return this.pcs.getChoiceClass();
    }

    @Override
    public Collection<? extends T> getSet(PlayerCharacter pc) {
        return this.pcs.getSet(pc);
    }

    @Override
    public String getName() {
        return this.setName;
    }

    @Override
    public void setTitle(String choiceTitle) {
        this.title = choiceTitle;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public GroupingState getGroupingState() {
        return this.pcs.getGroupingState();
    }

    public int hashCode() {
        return this.setName.hashCode() ^ this.pcs.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChoiceSet) {
            ChoiceSet other = (ChoiceSet)obj;
            return this.setName.equals(other.setName) && this.pcs.equals(other.pcs);
        }
        return false;
    }

    public static class AbilityChoiceSet
    extends ChoiceSet<CNAbilitySelection> {
        private final AbilityRefChoiceSet arcs;

        public AbilityChoiceSet(String name, AbilityRefChoiceSet choice) {
            super(name, choice);
            this.arcs = choice;
        }

        public CDOMSingleRef<AbilityCategory> getCategory() {
            return this.arcs.getCategory();
        }

        public Nature getNature() {
            return this.arcs.getNature();
        }
    }
}

