/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.HashMap;
import java.util.Map;
import pcgen.base.format.BooleanManager;
import pcgen.base.format.NumberManager;
import pcgen.base.format.OrderedPairManager;
import pcgen.base.format.StringManager;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.base.util.FormatManager;

public final class FormatManagerLibrary {
    private static CaseInsensitiveMap<FormatManager<?>> managerNameMap = new CaseInsensitiveMap();
    private static Map<Class<?>, FormatManager<?>> managerClassMap = new HashMap();

    private FormatManagerLibrary() {
    }

    public static FormatManager<?> getFormatManager(String formatName) {
        FormatManager fmtManager = (FormatManager)managerNameMap.get((Object)formatName);
        if (fmtManager == null) {
            throw new IllegalArgumentException("No FormatManager available for " + formatName);
        }
        return fmtManager;
    }

    public static <T> FormatManager<T> getFormatManager(Class<T> format) {
        FormatManager<?> fmtManager = managerClassMap.get(format);
        if (fmtManager == null) {
            throw new IllegalArgumentException("No FormatManager available for " + format);
        }
        return fmtManager;
    }

    public static void addFormatManager(FormatManager<?> fmtManager) {
        String fmIdent = fmtManager.getIdentifierType();
        FormatManager fmtManagerByName = (FormatManager)managerNameMap.get((Object)fmIdent);
        if (fmtManagerByName != null && !fmtManagerByName.equals(fmtManager)) {
            throw new IllegalArgumentException("Cannot set another Format Manager for " + fmIdent);
        }
        Class fmFormat = fmtManager.getManagedClass();
        FormatManager<?> fmtManagerByType = managerClassMap.get(fmFormat);
        if (fmtManagerByType != null && !fmtManagerByType.equals(fmtManager)) {
            throw new IllegalArgumentException("Cannot set another Format Manager for " + fmtManager.getManagedClass().getCanonicalName());
        }
        managerNameMap.put((Object)fmIdent, fmtManager);
        managerClassMap.put(fmtManager.getManagedClass(), fmtManager);
    }

    public static void reset() {
        managerNameMap.clear();
        managerClassMap.clear();
        FormatManagerLibrary.addFormatManager(new NumberManager());
        FormatManagerLibrary.addFormatManager(new StringManager());
        FormatManagerLibrary.addFormatManager(new BooleanManager());
        FormatManagerLibrary.addFormatManager(new OrderedPairManager());
    }

    static {
        FormatManagerLibrary.reset();
    }
}

