# This file generated by `mix dagger.gen`. Please DO NOT EDIT.
defmodule Dagger.ProjectCommand do
  @moduledoc "A command defined in a project that can be invoked from the CLI."
  use Dagger.QueryBuilder
  @type t() :: %__MODULE__{}
  defstruct [:selection, :client]

  (
    @doc "Documentation for what this command does."
    @spec description(t()) :: {:ok, Dagger.String.t() | nil} | {:error, term()}
    def description(%__MODULE__{} = project_command) do
      selection = select(project_command.selection, "description")
      execute(selection, project_command.client)
    end
  )

  (
    @doc "Flags accepted by this command."
    @spec flags(t()) :: {:ok, [Dagger.ProjectCommandFlag.t()] | nil} | {:error, term()}
    def flags(%__MODULE__{} = project_command) do
      selection = select(project_command.selection, "flags")
      execute(selection, project_command.client)
    end
  )

  (
    @doc "A unique identifier for this command."
    @spec id(t()) :: {:ok, Dagger.ProjectCommandID.t()} | {:error, term()}
    def id(%__MODULE__{} = project_command) do
      selection = select(project_command.selection, "id")
      execute(selection, project_command.client)
    end
  )

  (
    @doc "The name of the command."
    @spec name(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def name(%__MODULE__{} = project_command) do
      selection = select(project_command.selection, "name")
      execute(selection, project_command.client)
    end
  )

  (
    @doc "The name of the type returned by this command."
    @spec result_type(t()) :: {:ok, Dagger.String.t() | nil} | {:error, term()}
    def result_type(%__MODULE__{} = project_command) do
      selection = select(project_command.selection, "resultType")
      execute(selection, project_command.client)
    end
  )

  (
    @doc "Subcommands, if any, that this command provides."
    @spec subcommands(t()) :: {:ok, [Dagger.ProjectCommand.t()] | nil} | {:error, term()}
    def subcommands(%__MODULE__{} = project_command) do
      selection = select(project_command.selection, "subcommands")
      execute(selection, project_command.client)
    end
  )
end
