/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.plugin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class PluginClassLoader
extends URLClassLoader {
    private static final Set<PluginClassLoader> loaders = new CopyOnWriteArraySet<PluginClassLoader>();

    public PluginClassLoader(URL[] urls) {
        super(urls);
    }

    public void addToClassloaders() {
        loaders.add(this);
    }

    void addPath(Path path) {
        try {
            this.addURL(path.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void close() throws IOException {
        loaders.remove(this);
        super.close();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass0(name, resolve, true);
    }

    private Class<?> loadClass0(String name, boolean resolve, boolean checkOther) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (checkOther) {
                for (PluginClassLoader loader : loaders) {
                    if (loader == this) continue;
                    try {
                        return loader.loadClass0(name, resolve, false);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                    }
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

