/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy;

import java.io.IOException;
import java.util.Arrays;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ProxyOptions {
    private static final Logger logger = LogManager.getLogger(ProxyOptions.class);
    private final boolean help;
    private final @Nullable Integer port;

    ProxyOptions(String[] args) {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec help = parser.acceptsAll(Arrays.asList("h", "help"), "Print help").forHelp();
        ArgumentAcceptingOptionSpec<Integer> port = parser.acceptsAll(Arrays.asList("p", "port"), "Specify the bind port to be used. The configuration bind port will be ignored.").withRequiredArg().ofType(Integer.class);
        OptionSet set = parser.parse(args);
        this.help = set.has(help);
        this.port = (Integer)port.value(set);
        if (this.help) {
            try {
                parser.printHelpOn(System.out);
            }
            catch (IOException e) {
                logger.error("Could not print help", (Throwable)e);
            }
        }
    }

    boolean isHelp() {
        return this.help;
    }

    public @Nullable Integer getPort() {
        return this.port;
    }
}

