/*
 * Decompiled with CFR 0.152.
 */
package hless;

import hless.Atom;
import hless.Model;
import hless.Residue;
import hless.Str;
import hless.Triple;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PdbReader {
    Model m;
    String altPref = "5eE4dD3cC2bB1aA ";

    public PdbReader(Model model) {
        this.m = model;
    }

    public void read(String string) throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
        this.read(lineNumberReader);
        lineNumberReader.close();
    }

    public void read(LineNumberReader lineNumberReader) throws IOException {
        try {
            String string;
            boolean bl = false;
            boolean bl2 = false;
            while ((string = lineNumberReader.readLine()) != null && !bl2) {
                if (string.startsWith("ATOM  ") || string.startsWith("HETATM")) {
                    this.readATOM(string);
                    continue;
                }
                if (string.startsWith("MODEL ")) {
                    bl = true;
                    continue;
                }
                if (bl && string.startsWith("ENDMDL")) {
                    bl2 = true;
                    continue;
                }
                if (string.startsWith("REMARK   2")) {
                    Pattern pattern = Pattern.compile("\\d\\.\\d+");
                    Matcher matcher = pattern.matcher(string);
                    if (!matcher.find()) continue;
                    try {
                        this.m.resolution = Double.parseDouble(matcher.group());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (!string.startsWith("HEADER") || string.length() < 66) continue;
                this.m.pdbID = string.substring(62, 66);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void filter(String string, String string2) throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string2)));
        this.filter(lineNumberReader, printWriter);
        lineNumberReader.close();
        printWriter.close();
    }

    public void filter(LineNumberReader lineNumberReader, PrintWriter printWriter) throws IOException {
        String string;
        while ((string = lineNumberReader.readLine()) != null) {
            if (string.startsWith("ATOM  ") || string.startsWith("HETATM")) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(21, 27));
                stringBuffer.append(string.substring(17, 20));
                Residue residue = this.m.findResidue(stringBuffer.toString());
                if (residue == null) {
                    printWriter.println(string);
                    continue;
                }
                Atom atom = residue.findAtom(string.substring(12, 16));
                if (atom == null) {
                    printWriter.println(string);
                    continue;
                }
                if (atom.altConf != string.charAt(16)) continue;
                printWriter.println(PdbReader.writeATOM(atom));
                continue;
            }
            if (string.startsWith("ENDMDL")) {
                printWriter.println(string);
                while ((string = lineNumberReader.readLine()) != null) {
                    printWriter.println(string);
                }
                continue;
            }
            printWriter.println(string);
        }
        printWriter.flush();
    }

    void readATOM(String string) {
        block14: {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(21, 22));
                stringBuffer.append(string.substring(22, 26));
                stringBuffer.append(string.substring(26, 27));
                stringBuffer.append(string.substring(17, 20));
                Residue residue = this.m.getResidue(stringBuffer.toString());
                Atom atom = residue.getAtom(string.substring(12, 16));
                if (atom.altConf != '\u0000' && this.altPref.indexOf(string.charAt(16)) < this.altPref.indexOf(atom.altConf)) break block14;
                atom.altConf = string.charAt(16);
                try {
                    atom.serial = Integer.parseInt(string.substring(6, 11).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                try {
                    d = Double.parseDouble(string.substring(30, 38).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    d2 = Double.parseDouble(string.substring(38, 46).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    d3 = Double.parseDouble(string.substring(46, 54).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                atom.set(d, d2, d3);
                try {
                    atom.occupancy = Float.parseFloat(string.substring(54, 60).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    atom.tempFactor = Float.parseFloat(string.substring(60, 66).trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public static String writeATOM(Atom atom) {
        return PdbReader.writeATOM(atom, atom);
    }

    public static String writeATOM(Atom atom, Triple triple) {
        if (atom == null) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.000");
        StringBuffer stringBuffer = new StringBuffer("ATOM  ");
        stringBuffer.append(Str.padRight(Integer.toString(atom.serial), 5));
        stringBuffer.append(" ");
        stringBuffer.append(atom.name);
        stringBuffer.append(atom.altConf);
        stringBuffer.append(atom.parent.name.substring(6));
        stringBuffer.append(" ");
        stringBuffer.append(atom.parent.name.substring(0, 1));
        stringBuffer.append(atom.parent.name.substring(1, 6));
        stringBuffer.append("   ");
        stringBuffer.append(Str.padRight(decimalFormat2.format(triple.getX()), 8));
        stringBuffer.append(Str.padRight(decimalFormat2.format(triple.getY()), 8));
        stringBuffer.append(Str.padRight(decimalFormat2.format(triple.getZ()), 8));
        stringBuffer.append(Str.padRight(decimalFormat.format(atom.occupancy), 6));
        stringBuffer.append(Str.padRight(decimalFormat.format(atom.tempFactor), 6));
        stringBuffer.append("        ");
        return stringBuffer.toString();
    }
}

