/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.ReflectiveAction;
import driftwood.util.SoftLog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import king.HTMLHelp;
import king.KinCanvas;
import king.KingMain;
import king.ToolBox;
import king.ToolServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Plugin {
    protected ToolBox parent;
    protected KingMain kMain;
    protected KinCanvas kCanvas;
    protected ToolServices services;

    public Plugin(ToolBox toolBox) {
        this.parent = toolBox;
        this.kMain = toolBox.kMain;
        this.kCanvas = toolBox.kCanvas;
        this.services = toolBox.services;
    }

    public abstract JMenuItem getToolsMenuItem();

    public JMenuItem getHelpMenuItem() {
        return new JMenuItem(new ReflectiveAction(this.toString(), null, this, "onHelp"));
    }

    public void onHelp(ActionEvent actionEvent) {
        URL uRL = this.getHelpURL();
        if (uRL != null) {
            new HTMLHelp(this.kMain, uRL).show();
        } else {
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Unable to find documentation for this plugin.", "Sorry!", 0);
        }
    }

    public URL getHelpURL() {
        URL uRL = this.getClass().getResource("/king/html/king-manual.html");
        String string = this.getHelpAnchor();
        if (uRL != null && string != null) {
            try {
                uRL = new URL(uRL, string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace(SoftLog.err);
            }
            return uRL;
        }
        return null;
    }

    public String getHelpAnchor() {
        return null;
    }

    public static Collection getDependencies() {
        return Collections.EMPTY_LIST;
    }

    public static boolean isAppletSafe() {
        return true;
    }

    public void loadFileFromCmdline(ArrayList<File> arrayList, ArrayList<String> arrayList2) {
    }

    public void loadFromURL(URL uRL) {
    }
}

