/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane2;
import driftwood.util.SoftLog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import king.GroupEditor;
import king.KMessage;
import king.KinTreeModel;
import king.KingMain;
import king.KingPrefs;
import king.core.AGE;
import king.core.AHE;
import king.core.AHEImpl;
import king.core.KGroup;
import king.core.KList;
import king.core.Kinemage;

public class KinTree
implements KMessage.Subscriber {
    KingMain kMain;
    JFrame frame;
    JTree tree;
    JPopupMenu menu;
    GroupEditor groupEditor;
    ReflectiveAction acNew;
    ReflectiveAction acDelete;
    ReflectiveAction acProperties;
    ReflectiveAction acTransform;
    ReflectiveAction acVisible;
    ReflectiveAction acCut;
    ReflectiveAction acCopy;
    ReflectiveAction acPaste;
    ReflectiveAction acUp;
    ReflectiveAction acDown;
    AGE clipboard = null;
    int clipboardDepth = -1;
    static final long RELOAD_TREE_P = 28L;
    static final int RELOAD_TREE_K = 6;

    public KinTree(KingMain kingMain) {
        this.kMain = kingMain;
        this.tree = new JTree(new KinTreeModel(new Kinemage()));
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setEditable(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setUI(new NullTreeUI());
        this.tree.setCellRenderer(new OnOffRenderer());
        this.initActions();
        this.buildMenu();
        this.buildGUI();
        this.groupEditor = new GroupEditor(this.kMain, this.frame);
        this.kMain.subscribe(this);
    }

    private void initActions() {
        KingPrefs kingPrefs = this.kMain.getPrefs();
        this.acNew = new ReflectiveAction("New (sub)group", kingPrefs.addIcon, this, "onNewGroup");
        this.acNew.setTooltip("Create a new group or subgroup below the highlighted one");
        this.acNew.setMnemonic(78);
        this.acNew.setCommandKey("new");
        this.acNew.setAccelerator(155, 0);
        this.acNew.bind(this.tree);
        this.acDelete = new ReflectiveAction("Delete", kingPrefs.deleteIcon, this, "onDelete");
        this.acDelete.setTooltip("Discard the highlighted object from the hierarchy");
        this.acDelete.setMnemonic(68);
        this.acDelete.setCommandKey("delete");
        this.acDelete.setAccelerator(127, 0);
        this.acDelete.bind(this.tree);
        this.acProperties = new ReflectiveAction("Properties", null, this, "onProperties");
        this.acProperties.setTooltip("Edit properties associated with this object");
        this.acProperties.setMnemonic(82);
        this.acProperties.setCommandKey("properties");
        this.acProperties.setAccelerator(10, 0);
        this.acProperties.bind(this.tree);
        this.acTransform = new ReflectiveAction("Transform", null, this, "onTransform");
        this.acTransform.setTooltip("Rotate, translate, or scale the highlighted object");
        this.acTransform.setMnemonic(84);
        this.acVisible = new ReflectiveAction("Show/Hide", null, this, "onToggleVisibility");
        this.acVisible.setTooltip("Turn on (off) the button that controls this object");
        this.acVisible.setMnemonic(83);
        this.acVisible.setCommandKey("toggle-visible");
        this.acVisible.setAccelerator(47, 0);
        this.acVisible.bind(this.tree);
        this.acCut = new ReflectiveAction("Cut", kingPrefs.cutIcon, this, "onCut");
        this.acCut.setTooltip("Extract this object so it can be re-inserted elsewhere");
        this.acCut.setMnemonic(67);
        this.acCut.setCommandKey("cut");
        this.acCut.setAccelerator(88, KingMain.MENU_ACCEL_MASK);
        this.acCut.bind(this.tree);
        this.acCopy = new ReflectiveAction("Copy", kingPrefs.copyIcon, this, "onCopy");
        this.acCopy.setTooltip("Duplicate this object and place it on the clipboard");
        this.acCopy.setMnemonic(89);
        this.acCopy.setCommandKey("copy");
        this.acCopy.setAccelerator(67, KingMain.MENU_ACCEL_MASK);
        this.acCopy.bind(this.tree);
        this.acPaste = new ReflectiveAction("Paste", kingPrefs.pasteIcon, this, "onPaste");
        this.acPaste.setTooltip("Re-insert the last object that was Cut or Copied from the hierarchy");
        this.acPaste.setMnemonic(80);
        this.acPaste.setCommandKey("paste");
        this.acPaste.setAccelerator(86, KingMain.MENU_ACCEL_MASK);
        this.acPaste.bind(this.tree);
        this.acUp = new ReflectiveAction("Move up", kingPrefs.moveUpIcon, this, "onUp");
        this.acUp.setTooltip("Move this object toward the top of the list of its peers");
        this.acUp.setMnemonic(85);
        this.acUp.setCommandKey("up");
        this.acUp.setAccelerator(38, KingMain.MENU_ACCEL_MASK);
        this.acUp.bind(this.tree);
        this.acDown = new ReflectiveAction("Move down", kingPrefs.moveDownIcon, this, "onDown");
        this.acDown.setTooltip("Move this object toward the bottom of the list of its peers");
        this.acDown.setMnemonic(79);
        this.acDown.setCommandKey("down");
        this.acDown.setAccelerator(40, KingMain.MENU_ACCEL_MASK);
        this.acDown.bind(this.tree);
    }

    private void buildMenu() {
        this.menu = new JPopupMenu();
        this.menu.setInvoker(this.getTree());
        JMenuItem jMenuItem = new JMenuItem(this.acNew);
        JMenuItem jMenuItem2 = new JMenuItem(this.acDelete);
        JMenuItem jMenuItem3 = new JMenuItem(this.acProperties);
        JMenuItem jMenuItem4 = new JMenuItem(this.acTransform);
        JMenuItem jMenuItem5 = new JMenuItem(this.acVisible);
        JMenuItem jMenuItem6 = new JMenuItem(this.acCut);
        JMenuItem jMenuItem7 = new JMenuItem(this.acCopy);
        JMenuItem jMenuItem8 = new JMenuItem(this.acPaste);
        JMenuItem jMenuItem9 = new JMenuItem(this.acUp);
        JMenuItem jMenuItem10 = new JMenuItem(this.acDown);
        this.menu.add(jMenuItem5);
        this.menu.add(jMenuItem3);
        this.menu.addSeparator();
        this.menu.add(jMenuItem6);
        this.menu.add(jMenuItem7);
        this.menu.add(jMenuItem8);
        this.menu.add(jMenuItem2);
    }

    private void buildGUI() {
        this.frame = new JFrame();
        this.frame = new JFrame("Hierarchy window");
        this.frame.setDefaultCloseOperation(1);
        this.frame.setIconImage(this.kMain.getPrefs().windowIcon);
        Container container = this.frame.getContentPane();
        container.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.getTree());
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.width = 300;
        jScrollPane.setPreferredSize(dimension);
        container.add((Component)jScrollPane, "Center");
        JButton jButton = new JButton(this.acNew);
        jButton.setHorizontalAlignment(2);
        JButton jButton2 = new JButton(this.acCut);
        jButton2.setHorizontalAlignment(2);
        JButton jButton3 = new JButton(this.acCopy);
        jButton3.setHorizontalAlignment(2);
        JButton jButton4 = new JButton(this.acPaste);
        jButton4.setHorizontalAlignment(2);
        JButton jButton5 = new JButton(this.acUp);
        jButton5.setHorizontalAlignment(2);
        JButton jButton6 = new JButton(this.acDown);
        jButton6.setHorizontalAlignment(2);
        JButton jButton7 = new JButton(this.acDelete);
        jButton7.setHorizontalAlignment(2);
        JButton jButton8 = new JButton(this.acVisible);
        jButton8.setHorizontalAlignment(2);
        JButton jButton9 = new JButton(this.acProperties);
        jButton9.setHorizontalAlignment(2);
        JButton jButton10 = new JButton(this.acTransform);
        jButton10.setHorizontalAlignment(2);
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.weights(1.0, 0.0).center().hfill(true).memorize();
        tablePane2.addCell(jButton8).newRow();
        tablePane2.addCell(jButton9).newRow();
        tablePane2.addCell(jButton10).newRow();
        tablePane2.addCell(TablePane2.strut(0, 16)).newRow();
        tablePane2.addCell(jButton).newRow();
        tablePane2.addCell(jButton2).newRow();
        tablePane2.addCell(jButton3).newRow();
        tablePane2.addCell(jButton4).newRow();
        tablePane2.addCell(jButton5).newRow();
        tablePane2.addCell(jButton6).newRow();
        tablePane2.addCell(TablePane2.strut(0, 16)).newRow();
        tablePane2.addCell(jButton7).newRow();
        container.add((Component)tablePane2, "West");
        this.frame.pack();
    }

    public void show() {
        if (!this.frame.isVisible()) {
            this.frame.setLocationRelativeTo(this.kMain.getTopWindow());
            this.frame.setVisible(true);
        } else {
            this.frame.toFront();
        }
    }

    public void hide() {
        this.frame.dispose();
    }

    public void reveal(AGE aGE) {
        TreePath treePath = this.getTreePath(aGE);
        this.tree.scrollPathToVisible(treePath);
        this.tree.setSelectionPath(treePath);
    }

    private TreePath getTreePath(AGE aGE) {
        Object p = aGE.getParent();
        if (p == null) {
            return new TreePath(aGE);
        }
        return this.getTreePath((AGE)p).pathByAddingChild(aGE);
    }

    public void deliverMessage(KMessage kMessage) {
        TreeModel treeModel;
        if (kMessage.testProg(28L)) {
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage == null) {
                this.tree.setModel(new KinTreeModel(new Kinemage()));
                this.tree.setRootVisible(false);
            } else {
                this.tree.setModel(new KinTreeModel(kinemage));
                this.tree.setRootVisible(true);
            }
        } else if (kMessage.testKin(1)) {
            TreeModel treeModel2 = this.tree.getModel();
            if (treeModel2 instanceof KinTreeModel) {
                TreePath treePath = this.tree.getSelectionPath();
                int[] nArray = this.tree.getSelectionRows();
                Collection<TreePath> collection = KinTreeModel.memorizeVisibility(this.tree);
                ((KinTreeModel)treeModel2).kinChanged(true);
                KinTreeModel.restoreVisibility(this.tree, collection);
                if (treePath != null && this.tree.getRowForPath(treePath) != -1) {
                    this.tree.setSelectionPath(treePath);
                } else if (nArray != null) {
                    this.tree.setSelectionRows(nArray);
                }
            }
        } else if (kMessage.testKin(6) && (treeModel = this.tree.getModel()) instanceof KinTreeModel) {
            ((KinTreeModel)treeModel).kinChanged(false);
        }
        this.tree.treeDidChange();
    }

    public JTree getTree() {
        return this.tree;
    }

    public void onToggleVisibility(ActionEvent actionEvent) {
        AGE aGE;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (object == null || !(object instanceof AGE)) {
            return;
        }
        aGE.setOn(!(aGE = (AGE)object).isOn());
    }

    public void onProperties(ActionEvent actionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (object == null || !(object instanceof AGE)) {
            return;
        }
        boolean bl = false;
        if (object instanceof Kinemage) {
            bl = this.groupEditor.editKinemage((Kinemage)object);
        } else if (object instanceof KGroup) {
            KGroup kGroup = (KGroup)object;
            bl = kGroup.getDepth() == 1 ? this.groupEditor.editGroup(kGroup) : this.groupEditor.editSubgroup(kGroup);
        } else if (object instanceof KList) {
            bl = this.groupEditor.editList((KList)object);
        } else {
            JOptionPane.showMessageDialog(this.frame, "You can't edit this object's properties.", "Sorry!", 1);
        }
    }

    public void onTransform(ActionEvent actionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (object == null || !(object instanceof AGE)) {
            return;
        }
        this.groupEditor.transform((AGE)object);
    }

    public void onDelete(ActionEvent actionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        AGE aGE = (AGE)treePath.getLastPathComponent();
        if (aGE == null) {
            return;
        }
        if (aGE instanceof Kinemage) {
            if (JOptionPane.showConfirmDialog(this.frame, "Really close the current kinemage?", "Confirm delete", 0, 2) == 0) {
                this.kMain.getStable().closeCurrent();
            }
            return;
        }
        Object p = aGE.getParent();
        if (!(p == null || this.kMain.prefs.getBoolean("treeConfirmDelete") && JOptionPane.showConfirmDialog(this.frame, "Really delete the selected item, '" + aGE.toString() + "'?", "Confirm delete", 0, 2) != 0)) {
            ((AGE)p).remove((AGE)aGE);
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage != null) {
                kinemage.setModified(true);
            }
        }
    }

    public void onCut(ActionEvent actionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        AGE aGE = (AGE)treePath.getLastPathComponent();
        if (aGE == null || aGE instanceof Kinemage) {
            return;
        }
        Object p = aGE.getParent();
        if (p != null && (this.clipboard == null || JOptionPane.showConfirmDialog(this.frame, "An unpasted item is still in the clipboard -- discard it?", "Confirm delete", 0, 2) == 0)) {
            this.clipboard = aGE;
            this.clipboardDepth = this.clipboard.getDepth();
            ((AGE)p).remove((AGE)aGE);
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage != null) {
                kinemage.setModified(true);
            }
        }
    }

    public void onPaste(ActionEvent actionEvent) {
        Object object;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object2 = (AGE)treePath.getLastPathComponent();
        if (object2 == null) {
            return;
        }
        int n = ((AHEImpl)object2).getDepth();
        if (this.clipboard == null) {
            this.failPaste();
        } else if (object2 instanceof Kinemage && this.clipboard instanceof Kinemage) {
            ((Kinemage)object2).appendKinemage((Kinemage)this.clipboard);
            this.clipboard = null;
        } else if (n <= this.clipboardDepth - 1) {
            while (n < this.clipboardDepth - 1) {
                object = new KGroup("new");
                ((AGE)object).setHasButton(false);
                ((AGE)object2).add(object);
                object2 = object;
                ++n;
                treePath = treePath.pathByAddingChild(object);
            }
            ((AGE)object2).add(this.clipboard);
            this.tree.setSelectionPath(treePath.pathByAddingChild(this.clipboard));
            this.clipboard = null;
        } else if (n == this.clipboardDepth) {
            if (!this.kMain.prefs.getBoolean("treeConfirmMerge") || JOptionPane.showConfirmDialog(this.frame, "Merge these two?", "Confirm merge", 0, 2) == 0) {
                for (Object e : this.clipboard) {
                    ((AGE)object2).add((AHE)e);
                }
                this.clipboard = null;
            } else {
                object = ((AGE)object2).getParent();
                ArrayList arrayList = ((AGE)object).getChildren();
                int n2 = arrayList.indexOf(object2);
                arrayList.add(n2 + 1, this.clipboard);
                this.clipboard.setParent(object);
                ((AHEImpl)object).fireKinChanged(1);
                this.tree.setSelectionPath(treePath.getParentPath().pathByAddingChild(this.clipboard));
                this.clipboard = null;
            }
        } else {
            this.failPaste();
        }
        object = this.kMain.getKinemage();
        if (object != null) {
            ((Kinemage)object).setModified(true);
        }
    }

    void failPaste() {
        String string = "You can't paste that here.\nPut it higher up in the hierarchy.";
        if (this.clipboard == null) {
            string = "Nothing on the clipboard to paste!";
        }
        JOptionPane.showMessageDialog(this.frame, string, "Sorry!", 0);
    }

    public void onCopy(ActionEvent actionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        AGE aGE = (AGE)treePath.getLastPathComponent();
        if (aGE == null) {
            return;
        }
        if (this.clipboard == null || JOptionPane.showConfirmDialog(this.frame, "An unpasted item is still in the clipboard -- discard it?", "Confirm delete", 0, 2) == 0) {
            try {
                this.clipboard = aGE.clone();
                this.clipboardDepth = this.clipboard.getDepth();
                Kinemage kinemage = this.kMain.getKinemage();
                if (kinemage != null) {
                    kinemage.setModified(true);
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace(SoftLog.err);
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace(SoftLog.err);
            }
        }
    }

    public void onUp(ActionEvent actionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        AGE aGE = (AGE)treePath.getLastPathComponent();
        if (aGE == null) {
            return;
        }
        Object p = aGE.getParent();
        if (p == null) {
            return;
        }
        ArrayList arrayList = ((AGE)p).getChildren();
        int n = arrayList.indexOf(aGE);
        if (n == -1 || n == 0) {
            return;
        }
        arrayList.remove(n);
        arrayList.add(n - 1, aGE);
        ((AHEImpl)p).fireKinChanged(1);
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.setModified(true);
        }
    }

    public void onDown(ActionEvent actionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        AGE aGE = (AGE)treePath.getLastPathComponent();
        if (aGE == null) {
            return;
        }
        Object p = aGE.getParent();
        if (p == null) {
            return;
        }
        ArrayList arrayList = ((AGE)p).getChildren();
        int n = arrayList.indexOf(aGE);
        if (n == -1 || n == arrayList.size() - 1) {
            return;
        }
        arrayList.remove(n);
        arrayList.add(n + 1, aGE);
        ((AHEImpl)p).fireKinChanged(1);
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.setModified(true);
        }
    }

    public void onNewGroup(ActionEvent actionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        AGE aGE = (AGE)treePath.getLastPathComponent();
        if (aGE == null) {
            return;
        }
        if (aGE instanceof Kinemage) {
            KGroup kGroup = new KGroup("New group");
            ((Kinemage)aGE).add(kGroup);
            this.tree.setSelectionPath(treePath.pathByAddingChild(kGroup));
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage != null) {
                kinemage.setModified(true);
            }
        } else if (aGE instanceof KGroup && aGE.getDepth() == 1) {
            KGroup kGroup = new KGroup("New subgroup");
            ((KGroup)aGE).add(kGroup);
            this.tree.setSelectionPath(treePath.pathByAddingChild(kGroup));
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage != null) {
                kinemage.setModified(true);
            }
        } else {
            JOptionPane.showMessageDialog(this.frame, "You can't create a group/subgroup here.\nSelect the kinemage or a group and try again.", "Sorry!", 1);
        }
    }

    class NullTreeUI
    extends BasicTreeUI {
        NullTreeUI() {
        }

        protected KeyListener createKeyListener() {
            return new NullKeyHandler();
        }

        protected MouseListener createMouseListener() {
            return new PopupMouseHandler();
        }

        class PopupMouseHandler
        extends BasicTreeUI.MouseHandler {
            PopupMouseHandler() {
                super(NullTreeUI.this);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    KinTree.this.onProperties(null);
                } else {
                    super.mouseClicked(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() | 0x10, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), true);
                    super.mousePressed(mouseEvent2);
                    KinTree.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    super.mousePressed(mouseEvent);
                }
            }
        }

        class NullKeyHandler
        extends BasicTreeUI.KeyHandler {
            NullKeyHandler() {
                super(NullTreeUI.this);
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        }
    }

    class OnOffRenderer
    extends DefaultTreeCellRenderer {
        OnOffRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Object object2;
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            TreePath treePath = jTree.getPathForRow(n);
            if (treePath != null && (object2 = treePath.getLastPathComponent()) != null && object2 instanceof AGE) {
                AGE aGE = (AGE)object2;
                if (aGE.isOn()) {
                    this.setIcon(KinTree.this.kMain.getPrefs().treeOnIcon);
                } else {
                    this.setIcon(KinTree.this.kMain.getPrefs().treeOffIcon);
                }
            }
            return component;
        }
    }
}

