/*
 * Decompiled with CFR 0.152.
 */
package driftwood.util;

import driftwood.util.OutputStreamTee;
import driftwood.util.SoftOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class SoftLog
extends PrintStream {
    public static final SoftLog out = SoftLog.create(System.out);
    public static final SoftLog err = SoftLog.create(System.err);
    OutputStreamTee splitter;
    SoftOutputStream backlog;

    public static SoftLog create(OutputStream outputStream) {
        SoftOutputStream softOutputStream = new SoftOutputStream();
        OutputStreamTee outputStreamTee = new OutputStreamTee(outputStream, softOutputStream);
        return new SoftLog(outputStreamTee, softOutputStream);
    }

    private SoftLog(OutputStreamTee outputStreamTee, SoftOutputStream softOutputStream) {
        super(outputStreamTee);
        this.splitter = outputStreamTee;
        this.backlog = softOutputStream;
    }

    public String getString() {
        return this.backlog.getString();
    }

    public void clear() {
        this.backlog.clear();
    }

    public static boolean replaceSystemStreams() {
        try {
            System.setOut(out);
            System.setErr(err);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

