/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.sc.SidechainAngles2;
import driftwood.moldb2.Alignment;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.moldb2.Selection;
import driftwood.r3.SuperPoser;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class SubImpose {
    boolean verbose = false;
    boolean showTransform = false;
    boolean fix180flips = true;
    String structIn1 = null;
    String structIn2 = null;
    String kinOut = null;
    String pdbOut = null;
    String superimpose = null;
    Collection rmsd = new ArrayList();
    double leskSieve = 0.0;

    ModelState fix180rotations(ModelState modelState, ModelState modelState2, Alignment alignment) throws IOException {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        SidechainAngles2 sidechainAngles2 = new SidechainAngles2();
        int n = alignment.a.length;
        for (int i = 0; i < n; ++i) {
            if (alignment.a[i] == null || alignment.b[i] == null) continue;
            Residue residue = (Residue)alignment.a[i];
            Residue residue2 = (Residue)alignment.b[i];
            if (!residue.getName().equals(residue2.getName())) continue;
            String string = null;
            if ("PHE".equals(residue.getName())) {
                string = "chi2";
            } else if ("TYR".equals(residue.getName())) {
                string = "chi2";
            } else if ("ASP".equals(residue.getName())) {
                string = "chi2";
            } else {
                if (!"GLU".equals(residue.getName())) continue;
                string = "chi3";
            }
            try {
                double d;
                double d2;
                double d3 = sidechainAngles2.measureAngle(string, residue, modelState) % 360.0;
                if (d3 < 0.0) {
                    d3 += 360.0;
                }
                if ((d2 = sidechainAngles2.measureAngle(string, residue2, modelState2) % 360.0) < 0.0) {
                    d2 += 360.0;
                }
                if ((d = Math.abs(d3 - d2)) > 180.0) {
                    d = 360.0 - d;
                }
                if (!(d > 90.0)) continue;
                modelState = sidechainAngles2.setAngle(string, residue, modelState, d3 - 180.0);
                if (!this.verbose) continue;
                System.err.println("Flipped " + string + " for " + residue + "; " + decimalFormat.format(d3) + " - " + decimalFormat.format(d2) + " = " + decimalFormat.format(d) + "; " + decimalFormat.format(d3) + " --> " + decimalFormat.format(sidechainAngles2.measureAngle(string, residue, modelState)));
                continue;
            }
            catch (AtomException atomException) {
                System.err.println("Unable to flip " + string + " for " + residue + ": " + atomException.getMessage());
            }
        }
        return modelState.createCollapsed();
    }

    AtomState[][] getAtomsForSelection(Collection collection, ModelState modelState, Collection collection2, ModelState modelState2, String string, Alignment alignment) throws ParseException {
        Object object;
        Object object2;
        Selection selection = Selection.fromString(string);
        Collection collection3 = Model.extractOrderedStatesByName(collection, Collections.singleton(modelState));
        selection.init(collection3);
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
        for (AtomState atomState : collection3) {
            if (!selection.select(atomState)) continue;
            arrayList.add(atomState);
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < alignment.a.length; ++i) {
            if (alignment.a[i] == null) continue;
            hashMap.put(alignment.a[i], alignment.b[i]);
        }
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        for (AtomState object32 : arrayList) {
            object2 = null;
            Residue n2 = (Residue)hashMap.get(object32.getResidue());
            if (n2 != null && (object = n2.getAtom(object32.getName())) != null) {
                try {
                    object2 = modelState2.get((Atom)object);
                    ++n;
                }
                catch (AtomException atomState) {
                    atomState.printStackTrace();
                }
            }
            arrayList2.add(object2);
        }
        if (arrayList.size() != arrayList2.size() || n > arrayList.size()) {
            throw new RuntimeException("logical error; sel1=" + arrayList.size() + ", sel2=" + arrayList2.size() + ", matched=" + n);
        }
        AtomState[][] atomStateArray = new AtomState[2][n];
        Iterator iterator = arrayList.iterator();
        object2 = arrayList2.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = (AtomState)iterator.next();
            AtomState atomState = (AtomState)object2.next();
            if (atomState == null) continue;
            atomStateArray[0][n2] = object;
            atomStateArray[1][n2] = atomState;
            ++n2;
        }
        if (n2 != n) {
            throw new RuntimeException("logical error; idx=" + n2 + ", matched=" + n);
        }
        return atomStateArray;
    }

    static void sortByLeskSieve(Tuple3[] tuple3Array, Tuple3[] tuple3Array2) {
        SuperPoser superPoser = new SuperPoser(tuple3Array, tuple3Array2);
        Triple triple = new Triple();
        for (int i = tuple3Array.length; i > 0; --i) {
            superPoser.reset(tuple3Array, 0, tuple3Array2, 0, i);
            Transform transform = superPoser.superpos();
            double d = superPoser.calcRMSD(transform);
            int n = -1;
            double d2 = -1.0;
            for (int j = 0; j < i; ++j) {
                transform.transform(tuple3Array2[j], triple);
                double d3 = triple.sqDistance(tuple3Array[j]);
                if (!(d3 > d2)) continue;
                d2 = d3;
                n = j;
            }
            Tuple3 tuple3 = tuple3Array[i - 1];
            tuple3Array[i - 1] = tuple3Array[n];
            tuple3Array[n] = tuple3;
            tuple3 = tuple3Array2[i - 1];
            tuple3Array2[i - 1] = tuple3Array2[n];
            tuple3Array2[n] = tuple3;
        }
    }

    void writeKin(AtomState[][] atomStateArray, int n) throws IOException {
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(this.kinOut))));
        printStream.println("@kinemage");
        printStream.println("@group {correspondances} dominant");
        printStream.println("@vectorlist {pairs} color= green");
        for (int i = 0; i < n; ++i) {
            AtomState atomState = atomStateArray[0][i];
            AtomState atomState2 = atomStateArray[1][i];
            printStream.println("{" + atomState + "}P " + decimalFormat.format(atomState.getX()) + " " + decimalFormat.format(atomState.getY()) + " " + decimalFormat.format(atomState.getZ()));
            printStream.println("{" + atomState2 + "}L " + decimalFormat.format(atomState2.getX()) + " " + decimalFormat.format(atomState2.getY()) + " " + decimalFormat.format(atomState2.getZ()));
        }
        printStream.close();
    }

    public void Main() throws IOException, ParseException {
        Object object;
        if (this.structIn1 == null || this.structIn2 == null) {
            throw new IllegalArgumentException("must provide two structures");
        }
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(new File(this.structIn1));
        CoordinateFile coordinateFile2 = pdbReader.read(new File(this.structIn2));
        Model model = coordinateFile.getFirstModel();
        Model model2 = coordinateFile2.getFirstModel();
        ModelState modelState = model.getState();
        ModelState modelState2 = model2.getState();
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        System.err.println("rmsd\tn_atoms\tselection");
        Alignment alignment = Alignment.needlemanWunsch(model.getResidues().toArray(), model2.getResidues().toArray(), new SimpleResAligner());
        if (this.verbose) {
            System.err.println("Residue alignments:");
            for (int i = 0; i < alignment.a.length; ++i) {
                System.err.println("  " + alignment.a[i] + " <==> " + alignment.b[i]);
            }
            System.err.println();
        }
        if (this.fix180flips) {
            modelState = this.fix180rotations(modelState, modelState2, alignment);
        }
        Transform transform = new Transform();
        if (this.superimpose != null) {
            AtomState[][] atomStateArray = this.getAtomsForSelection(model.getResidues(), modelState, model2.getResidues(), modelState2, this.superimpose, alignment);
            if (this.verbose) {
                System.err.println("Atom alignments:");
                for (int i = 0; i < atomStateArray[0].length; ++i) {
                    System.err.println("  " + atomStateArray[0][i] + " <==> " + atomStateArray[1][i]);
                }
                System.err.println();
            }
            if (atomStateArray[0].length < 3) {
                throw new IllegalArgumentException("Can't superimpose on less than 3 atoms!");
            }
            Object object2 = new SuperPoser(atomStateArray[1], atomStateArray[0]);
            transform = ((SuperPoser)object2).superpos();
            System.err.println(decimalFormat.format(((SuperPoser)object2).calcRMSD(transform)) + "\t" + atomStateArray[0].length + "\t" + this.superimpose);
            int n = atomStateArray[0].length;
            if (this.leskSieve > 0.0) {
                int n2 = (int)Math.round(this.leskSieve * (double)atomStateArray[0].length);
                if (n2 < 3) {
                    System.err.println("WARNING: too few atoms for Lesk's sieve at " + decimalFormat.format(this.leskSieve));
                } else {
                    n = n2;
                    SubImpose.sortByLeskSieve(atomStateArray[0], atomStateArray[1]);
                    ((SuperPoser)object2).reset(atomStateArray[1], 0, atomStateArray[0], 0, n2);
                    transform = ((SuperPoser)object2).superpos();
                    System.err.println(decimalFormat.format(((SuperPoser)object2).calcRMSD(transform)) + "\t" + n2 + "\t[Lesk's sieve = " + decimalFormat.format(this.leskSieve) + "]");
                }
            }
            for (AtomState atomState : Model.extractOrderedStatesByName(model)) {
                transform.transform(atomState);
            }
            if (this.kinOut != null) {
                this.writeKin(atomStateArray, n);
            }
            if (this.pdbOut != null) {
                object = new PdbWriter(new File(this.pdbOut));
                ((PdbWriter)object).writeCoordinateFile(coordinateFile);
                ((PdbWriter)object).close();
            }
        } else {
            if (this.kinOut != null) {
                System.err.println("WARNING: can't use -kin without -super");
            }
            if (this.pdbOut != null) {
                System.err.println("WARNING: can't use -pdb without -super");
            }
        }
        for (Object object2 : this.rmsd) {
            AtomState[][] atomStateArray = this.getAtomsForSelection(model.getResidues(), modelState, model2.getResidues(), modelState2, (String)object2, alignment);
            if (this.verbose) {
                System.err.println("Atom alignments:");
                for (int i = 0; i < atomStateArray[0].length; ++i) {
                    System.err.println("  " + atomStateArray[0][i] + " <==> " + atomStateArray[1][i]);
                }
                System.err.println();
            }
            object = new SuperPoser(atomStateArray[1], atomStateArray[0]);
            System.out.println(decimalFormat.format(((SuperPoser)object).calcRMSD(new Transform())) + "\t" + atomStateArray[0].length + "\t" + (String)object2);
        }
        if (this.showTransform) {
            System.out.println("Transformation matrix (premult, Rx -> x'):");
            System.out.println(transform);
        }
    }

    public static void main(String[] stringArray) {
        SubImpose subImpose = new SubImpose();
        try {
            subImpose.parseArguments(stringArray);
            subImpose.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            subImpose.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(2);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("SubImpose.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'SubImpose.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.SubImpose");
        System.err.println("Copyright (C) 2007 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.structIn1 == null) {
            this.structIn1 = string;
        } else if (this.structIn2 == null) {
            this.structIn2 = string;
        } else {
            throw new IllegalArgumentException("too many arguments!");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-v")) {
            this.verbose = true;
        } else if (string.equals("-t")) {
            this.showTransform = true;
        } else if (string.equals("-noscflip")) {
            this.fix180flips = false;
        } else if (string.equals("-super")) {
            this.superimpose = string2;
        } else if (string.equals("-sieve")) {
            try {
                this.leskSieve = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string2 + " isn't a number!");
            }
            if (this.leskSieve <= 0.0 || this.leskSieve > 1.0) {
                throw new IllegalArgumentException("value for -sieve out of range (0,1]");
            }
        } else if (string.equals("-kin")) {
            this.kinOut = string2;
        } else if (string.equals("-pdb")) {
            this.pdbOut = string2;
        } else if (string.equals("-rms")) {
            this.rmsd.add(string2);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }

    static class SimpleResAligner
    implements Alignment.Scorer {
        SimpleResAligner() {
        }

        public int score(Object object, Object object2) {
            Residue residue = (Residue)object;
            Residue residue2 = (Residue)object2;
            if (residue == null || residue2 == null) {
                return -1;
            }
            if (residue.getName().equals(residue2.getName())) {
                return 2;
            }
            return 0;
        }
    }
}

