/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.sc.SidechainIdealizer;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Transform;
import driftwood.util.SoftLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CaRotation {
    static SidechainIdealizer sidechainIdealizer = null;

    public static Collection makeMobileGroup(Model model, Residue residue, Residue residue2) {
        Residue residue3;
        Residue residue4;
        Residue residue5;
        if (residue.compareTo(residue2) < 0) {
            residue5 = residue;
            residue4 = residue2;
        } else {
            residue5 = residue2;
            residue4 = residue;
        }
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        arrayList.add(residue5);
        for (residue3 = residue5.getNext(model); residue3 != null && !residue3.equals(residue4); residue3 = residue3.getNext(model)) {
            arrayList.add(residue3);
        }
        if (residue3 == null) {
            throw new IllegalArgumentException("Cannot connect residues " + residue5 + " and " + residue4);
        }
        arrayList.add(residue4);
        return arrayList;
    }

    public static ModelState makeConformation(Collection collection, ModelState modelState, double d, boolean bl) throws AtomException {
        Residue residue;
        Iterator iterator = collection.iterator();
        Residue residue2 = residue = (Residue)iterator.next();
        while (iterator.hasNext()) {
            residue = (Residue)iterator.next();
        }
        Atom atom = residue2.getAtom(" CA ");
        Atom atom2 = residue.getAtom(" CA ");
        if (atom == null || atom2 == null) {
            throw new AtomException("C-alpha is missing from " + residue2 + " or " + residue);
        }
        Atom[] atomArray = CaRotation.getMobileAtoms(collection);
        Transform transform = new Transform().likeRotation(modelState.get(atom), modelState.get(atom2), d);
        ModelState modelState2 = CaRotation.transformAtoms(transform, atomArray, modelState);
        if (bl && sidechainIdealizer != null) {
            modelState2 = sidechainIdealizer.idealizeSidechain(residue2, modelState2);
            modelState2 = sidechainIdealizer.idealizeSidechain(residue, modelState2);
        }
        return modelState2.createCollapsed(modelState);
    }

    public static ModelState twistPeptides(Residue[] residueArray, ModelState modelState, double[] dArray, boolean[] blArray) throws AtomException {
        int n;
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        Transform transform = new Transform();
        ModelState modelState2 = new ModelState(modelState);
        for (n = 0; n < residueArray.length - 1; ++n) {
            if (dArray[n] == 0.0) continue;
            arrayList.clear();
            Atom atom = residueArray[n].getAtom(" C  ");
            if (atom != null) {
                arrayList.add(atom);
            }
            if ((atom = residueArray[n].getAtom(" O  ")) != null) {
                arrayList.add(atom);
            }
            if ((atom = residueArray[n + 1].getAtom(" N  ")) != null) {
                arrayList.add(atom);
            }
            if ((atom = residueArray[n + 1].getAtom(" H  ")) != null) {
                arrayList.add(atom);
            }
            Atom atom2 = residueArray[n].getAtom(" CA ");
            Atom atom3 = residueArray[n + 1].getAtom(" CA ");
            if (atom2 == null || atom3 == null) {
                throw new AtomException("C-alpha is missing from " + residueArray[n] + " or " + residueArray[n + 1]);
            }
            Atom[] atomArray = arrayList.toArray(new Atom[arrayList.size()]);
            transform.likeRotation(modelState2.get(atom2), modelState2.get(atom3), dArray[n]);
            modelState2 = CaRotation.transformAtoms(transform, atomArray, modelState2);
        }
        for (n = 0; n < residueArray.length; ++n) {
            if (!blArray[n] || sidechainIdealizer == null) continue;
            modelState2 = sidechainIdealizer.idealizeSidechain(residueArray[n], modelState2);
        }
        return modelState2.createCollapsed(modelState);
    }

    static Atom[] getMobileAtoms(Collection collection) {
        String string;
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        Iterator iterator = collection.iterator();
        Residue residue = (Residue)iterator.next();
        for (Atom atom : residue.getAtoms()) {
            string = atom.getName();
            if (!string.equals(" C  ") && !string.equals(" O  ")) continue;
            arrayList.add(atom);
        }
        residue = (Residue)iterator.next();
        while (iterator.hasNext()) {
            for (Atom atom : residue.getAtoms()) {
                arrayList.add(atom);
            }
            residue = (Residue)iterator.next();
        }
        for (Atom atom : residue.getAtoms()) {
            string = atom.getName();
            if (!string.equals(" N  ") && !string.equals(" H  ")) continue;
            arrayList.add(atom);
        }
        return arrayList.toArray(new Atom[arrayList.size()]);
    }

    static ModelState transformAtoms(Transform transform, Atom[] atomArray, ModelState modelState) {
        ModelState modelState2 = new ModelState(modelState);
        for (int i = 0; i < atomArray.length; ++i) {
            try {
                AtomState atomState = modelState.get(atomArray[i]);
                AtomState atomState2 = (AtomState)atomState.clone();
                modelState2.add(atomState2);
                transform.transform(atomState2);
                continue;
            }
            catch (AtomException atomException) {
                SoftLog.err.println(atomException.getMessage());
            }
        }
        return modelState2;
    }

    static {
        try {
            sidechainIdealizer = new SidechainIdealizer();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

