/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.dangle;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResSpec {
    String origResName;
    int resOffset;
    Matcher regexName;
    boolean requireCis;

    public ResSpec(int n, boolean bl, String string) {
        this.resOffset = n;
        this.requireCis = bl;
        this.origResName = string;
        string = string.replace('_', ' ');
        this.regexName = string.startsWith("/") && string.endsWith("/") ? Pattern.compile(string.substring(1, string.length() - 1)).matcher("") : Pattern.compile(Pattern.quote(string)).matcher("");
    }

    public boolean isMatch(Model model, ModelState modelState, Residue residue) {
        if ((residue = this.getRes(model, modelState, residue, this.resOffset)) == null) {
            return false;
        }
        if (this.requireCis) {
            Residue residue2 = this.getRes(model, modelState, residue, -1);
            if (residue2 == null) {
                return false;
            }
            try {
                AtomState atomState = modelState.get(residue2.getAtom(" CA "));
                AtomState atomState2 = modelState.get(residue2.getAtom(" C  "));
                AtomState atomState3 = modelState.get(residue.getAtom(" N  "));
                AtomState atomState4 = modelState.get(residue.getAtom(" CA "));
                double d = Triple.dihedral(atomState, atomState2, atomState3, atomState4);
                if (d < -90.0 || d > 90.0) {
                    return false;
                }
            }
            catch (AtomException atomException) {
                return false;
            }
        }
        return this.regexName.reset(residue.getName()).matches();
    }

    private Residue getRes(Model model, ModelState modelState, Residue residue, int n) {
        Residue residue2 = residue;
        int n2 = Math.abs(n);
        for (int i = 0; i < n2; ++i) {
            Residue residue3 = residue2;
            residue2 = n > 0 ? residue.getNext(model) : residue.getPrev(model);
            if (residue2 == null) {
                return null;
            }
            if (!(n > 0 ? !this.checkConnection(model, modelState, residue3, residue2) : !this.checkConnection(model, modelState, residue2, residue3))) continue;
            return null;
        }
        return residue2;
    }

    private boolean checkConnection(Model model, ModelState modelState, Residue residue, Residue residue2) {
        Atom atom = null;
        Atom atom2 = null;
        Atom atom3 = null;
        Atom atom4 = null;
        atom = residue.getAtom(" C  ");
        atom2 = residue2.getAtom(" N  ");
        if (atom != null && atom2 != null) {
            try {
                AtomState atomState = modelState.get(atom);
                AtomState atomState2 = modelState.get(atom2);
                return atomState.sqDistance(atomState2) <= 4.0;
            }
            catch (AtomException atomException) {
                return false;
            }
        }
        atom3 = residue.getAtom(" O3*");
        if (atom3 == null) {
            atom3 = residue.getAtom(" O3'");
        }
        atom4 = residue2.getAtom(" P  ");
        if (atom3 != null && atom4 != null) {
            try {
                AtomState atomState = modelState.get(atom3);
                AtomState atomState3 = modelState.get(atom4);
                return atomState.sqDistance(atomState3) <= 4.84;
            }
            catch (AtomException atomException) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return "for " + (this.requireCis ? "cis " : "") + this.origResName;
    }
}

