/*
 * Decompiled with CFR 0.152.
 */
package dangle;

import dangle.GeomKinSmith;
import dangle.Measurement;
import dangle.Parser;
import driftwood.moldb2.CifReader;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.parser.CharWindow;
import driftwood.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class Dangle {
    boolean forcePDB = false;
    boolean forceCIF = false;
    boolean doWrap = false;
    boolean showDeviation = false;
    boolean outliersOnly = false;
    boolean doHets = false;
    boolean doParCoor = false;
    boolean doGeomKin;
    boolean subgroup = false;
    double sigmaCutoff = 4.0;
    Collection files = new ArrayList();
    Collection measurements = new ArrayList();
    TreeSet<Integer> resnums = null;
    static String aaNames = ":GLY:ALA:VAL:PHE:PRO:MET:ILE:LEU:ASP:GLU:LYS:ARG:SER:THR:TYR:HIS:CYS:ASN:GLN:TRP:ASX:GLX:ACE:FOR:NH2:NME:MSE:AIB:ABU:PCA:MLY:CYO:M3L:DGN:CSD:";
    static String naNames = ":  C:  G:  A:  T:  U:CYT:GUA:ADE:THY:URA:URI:CTP:CDP:CMP:GTP:GDP:GMP:ATP:ADP:AMP:TTP:TDP:TMP:UTP:UDP:UMP:GSP:H2U:PSU:4SU:1MG:2MG:M2G:5MC:5MU:T6A:1MA:RIA:OMC:OMG: YG:  I:7MG:C  :G  :A  :T  :U  :YG :I  : rC: rG: rA: rT: rU: dC: dG: dA: dT: dU: DC: DG: DA: DT: DU:";

    void fullOutput(String string, CoordinateFile coordinateFile) {
        int n;
        PrintStream printStream = System.out;
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        coordinateFile.deployDisulfidesToModels();
        Measurement[] measurementArray = this.measurements.toArray(new Measurement[this.measurements.size()]);
        printStream.print("# label:model:chain:number:ins:type");
        int n2 = Integer.MIN_VALUE;
        for (n = 0; n < measurementArray.length; ++n) {
            printStream.print(":" + measurementArray[n].getLabel());
            if (!this.showDeviation) continue;
            printStream.print(":sigma " + measurementArray[n].getLabel());
        }
        printStream.println();
        for (n = 0; n < measurementArray.length; ++n) {
            printStream.println("# " + measurementArray[n]);
        }
        double[] dArray = new double[measurementArray.length];
        double[] dArray2 = new double[measurementArray.length];
        for (Model model : coordinateFile.getModels()) {
            ModelState modelState = model.getState();
            String string2 = string + ":" + model.getName() + ":";
            for (Residue residue : model.getResidues()) {
                int n3;
                if (this.resnums != null && !this.resnums.contains(residue.getSequenceInteger())) continue;
                boolean bl = false;
                for (n3 = 0; n3 < measurementArray.length; ++n3) {
                    dArray[n3] = measurementArray[n3].measure(model, modelState, residue, this.doHets);
                    dArray2[n3] = measurementArray[n3].getDeviation();
                    if (Double.isNaN(dArray[n3])) continue;
                    bl = true;
                    if (measurementArray[n3].getType() != Measurement.TYPE_DIHEDRAL) continue;
                    dArray[n3] = this.wrap360(dArray[n3]);
                }
                if (!bl) continue;
                printStream.print(string2);
                printStream.print(residue.getChain() + ":" + residue.getSequenceNumber() + ":" + residue.getInsertionCode() + ":" + residue.getName());
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    printStream.print(":");
                    if (!Double.isNaN(dArray[n3])) {
                        printStream.print(decimalFormat.format(dArray[n3]));
                    } else {
                        printStream.print("__?__");
                    }
                    if (!this.showDeviation) continue;
                    printStream.print(":");
                    if (!Double.isNaN(dArray2[n3])) {
                        printStream.print(decimalFormat.format(dArray2[n3]));
                        continue;
                    }
                    printStream.print("__?__");
                }
                printStream.println();
            }
        }
    }

    void outliersOutput(String string, CoordinateFile coordinateFile) {
        PrintStream printStream = System.out;
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        coordinateFile.deployDisulfidesToModels();
        Measurement[] measurementArray = this.measurements.toArray(new Measurement[this.measurements.size()]);
        printStream.println("# label:model:chain:number:ins:type:measure:value:sigmas");
        double[] dArray = new double[measurementArray.length];
        double[] dArray2 = new double[measurementArray.length];
        for (Model model : coordinateFile.getModels()) {
            ModelState modelState = model.getState();
            String string2 = string + ":" + model.getName() + ":";
            for (Residue residue : model.getResidues()) {
                int n;
                if (this.resnums != null && !this.resnums.contains(residue.getSequenceInteger())) continue;
                boolean bl = false;
                for (n = 0; n < measurementArray.length; ++n) {
                    dArray[n] = measurementArray[n].measure(model, modelState, residue, this.doHets);
                    dArray2[n] = measurementArray[n].getDeviation();
                    if (Double.isNaN(dArray[n])) continue;
                    bl = true;
                    if (measurementArray[n].getType() != Measurement.TYPE_DIHEDRAL) continue;
                    dArray[n] = this.wrap360(dArray[n]);
                }
                if (!bl) continue;
                for (n = 0; n < dArray.length; ++n) {
                    if (Double.isNaN(dArray2[n]) || !(Math.abs(dArray2[n]) >= this.sigmaCutoff)) continue;
                    printStream.print(string2);
                    printStream.print(residue.getChain() + ":" + residue.getSequenceNumber() + ":" + residue.getInsertionCode() + ":" + residue.getName());
                    printStream.print(":" + measurementArray[n].getLabel() + ":" + decimalFormat.format(dArray[n]) + ":" + decimalFormat.format(dArray2[n]));
                    printStream.println();
                }
            }
        }
    }

    void parCoorOutput(String string, CoordinateFile coordinateFile) {
        Object object2;
        PrintStream printStream = System.out;
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        coordinateFile.deployDisulfidesToModels();
        Measurement[] measurementArray = this.measurements.toArray(new Measurement[this.measurements.size()]);
        Iterator iterator = coordinateFile.getModels().iterator();
        Model model = (Model)iterator.next();
        printStream.print("# model");
        for (Object object2 : model.getResidues()) {
            if (this.resnums != null && !this.resnums.contains(((Residue)object2).getSequenceInteger()) || !Dangle.isProtOrNucAcid((Residue)object2)) continue;
            for (int i = 0; i < measurementArray.length; ++i) {
                printStream.print(":" + object2 + " " + measurementArray[i].getLabel());
            }
        }
        printStream.println();
        Object object3 = new double[measurementArray.length];
        object2 = new double[measurementArray.length];
        for (Model model2 : coordinateFile.getModels()) {
            ModelState modelState = model2.getState();
            printStream.print(model2.getName());
            for (Residue residue : model2.getResidues()) {
                int n;
                if (this.resnums != null && !this.resnums.contains(residue.getSequenceInteger())) continue;
                boolean bl = false;
                for (n = 0; n < measurementArray.length; ++n) {
                    object3[n] = measurementArray[n].measure(model2, modelState, residue, this.doHets);
                    object2[n] = measurementArray[n].getDeviation();
                    if (Double.isNaN((double)object3[n])) continue;
                    bl = true;
                    if (measurementArray[n].getType() != Measurement.TYPE_DIHEDRAL) continue;
                    object3[n] = this.wrap360((double)object3[n]);
                }
                if (!bl) continue;
                for (n = 0; n < ((Object)object3).length; ++n) {
                    printStream.print(":");
                    if (!Double.isNaN((double)object3[n])) {
                        printStream.print(decimalFormat.format((double)object3[n]));
                        continue;
                    }
                    printStream.print("__?__");
                }
            }
            printStream.println();
        }
    }

    public void geomKinOutput(String string, CoordinateFile coordinateFile) {
        coordinateFile.deployDisulfidesToModels();
        GeomKinSmith geomKinSmith = new GeomKinSmith(string, coordinateFile, (ArrayList)this.measurements, this.sigmaCutoff, this.subgroup, this.doHets, this.resnums);
        geomKinSmith.makeKin();
    }

    static boolean isProtOrNucAcid(Residue residue) {
        String string = residue.getName();
        return aaNames.indexOf(string) != -1 || naNames.indexOf(string) != -1;
    }

    public void chooseMeasures() throws IOException, ParseException {
        if (this.measurements.isEmpty()) {
            if (this.doGeomKin) {
                System.err.println("No geom kin measurements specified -- loading defaults! (including cbdev)");
                this.measurements = new ArrayList();
                this.showDeviation = true;
                try {
                    this.loadMeasures("EnghHuber_IntlTblsF_1999.txt");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    this.loadMeasures("ParkinsonBerman_ActaCrystD_1996_RNA.txt");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    this.loadMeasures("GelbinBerman_JACS_1996_DNA.txt");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    this.measurements.add(Measurement.newBuiltin("cbdev"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                if (this.showDeviation) {
                    throw new IllegalArgumentException("Must specify measures to validate (try -protein, -rna, -dna)");
                }
                Parser parser = new Parser();
                String string = parser.BUILTIN.pattern().pattern().replace('|', ' ');
                this.measurements.addAll(parser.parse(new CharWindow(string)));
            }
        }
    }

    void loadMeasures(String string) throws IOException, ParseException {
        this.measurements.addAll(new Parser().parse(new CharWindow(this.getClass().getResource(string))));
    }

    private double wrap360(double d) {
        if (this.doWrap) {
            if ((d %= 360.0) < 0.0) {
                return d + 360.0;
            }
            return d;
        }
        return d;
    }

    void parseResnums(String string) throws NumberFormatException {
        String[] stringArray;
        this.resnums = new TreeSet();
        for (String string2 : stringArray = Strings.explode(string, ',', false, true)) {
            if (string2.indexOf("-") != -1) {
                int n;
                String[] stringArray2 = Strings.explode(string2, '-', false, true);
                int n2 = Integer.parseInt(stringArray2[0]);
                int n3 = Integer.parseInt(stringArray2[1]);
                if (n3 >= n2) {
                    for (n = n2; n <= n3; ++n) {
                        this.resnums.add(n);
                    }
                    continue;
                }
                for (n = n3; n <= n2; ++n) {
                    this.resnums.add(n);
                }
                continue;
            }
            this.resnums.add(Integer.parseInt(string2));
        }
    }

    public void Main() throws IOException, ParseException {
        PdbReader pdbReader = new PdbReader();
        CifReader cifReader = new CifReader();
        this.chooseMeasures();
        if (this.files.isEmpty()) {
            if (this.forceCIF) {
                this.fullOutput("", cifReader.read(System.in));
            } else {
                this.fullOutput("", pdbReader.read(System.in));
            }
        } else {
            for (File file : this.files) {
                CoordinateFile coordinateFile = this.forceCIF ? cifReader.read(file) : (this.forcePDB ? pdbReader.read(file) : (file.getName().toLowerCase().endsWith(".cif") ? cifReader.read(file) : pdbReader.read(file)));
                if (this.doGeomKin) {
                    this.geomKinOutput(file.getName(), coordinateFile);
                    continue;
                }
                if (this.doParCoor) {
                    this.parCoorOutput(file.getName(), coordinateFile);
                    continue;
                }
                if (this.outliersOnly) {
                    this.outliersOutput(file.getName(), coordinateFile);
                    continue;
                }
                this.fullOutput(file.getName(), coordinateFile);
            }
        }
    }

    public static void main(String[] stringArray) {
        Dangle dangle = new Dangle();
        try {
            dangle.parseArguments(stringArray);
            dangle.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            dangle.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    void parseArguments(String[] stringArray) {
        if (stringArray.length == 0) {
            this.showHelp(true);
            System.exit(1);
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("Dangle.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'Dangle.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("dangle.Dangle version " + this.getVersion() + " build " + this.getBuild());
        System.err.println("Copyright (C) 2007 by Ian W. Davis. All rights reserved.");
    }

    void showChanges(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("Dangle.changes");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate changes information in 'Dangle.changes' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("dangle.Dangle version " + this.getVersion() + " build " + this.getBuild());
        System.err.println("Copyright (C) 2007 by Ian W. Davis. All rights reserved.");
    }

    String getVersion() {
        InputStream inputStream = this.getClass().getResourceAsStream("version.props");
        if (inputStream == null) {
            System.err.println("\n*** Unable to locate version number in 'version.props' ***\n");
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                string = bufferedReader.readLine();
                if (string != null && string.indexOf("version=") != -1) {
                    return string.substring(string.indexOf("=") + 1);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return "?.??";
    }

    String getBuild() {
        InputStream inputStream = this.getClass().getResourceAsStream("buildnum.props");
        if (inputStream == null) {
            System.err.println("\n*** Unable to locate version number in 'buildnum.props' ***\n");
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                string = bufferedReader.readLine();
                if (string != null && string.indexOf("buildnum=") != -1) {
                    return string.substring(string.indexOf("=") + 1);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return "yyyymmdd.????";
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.files.add(file);
        } else {
            try {
                this.measurements.addAll(new Parser().parse(new CharWindow(string)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        }
        if (string.equals("-changes")) {
            this.showChanges(true);
            System.exit(0);
        } else if (string.equals("-cif")) {
            if (this.forcePDB) {
                throw new IllegalArgumentException("Can't specify both -cif and -pdb");
            }
            this.forceCIF = true;
        } else if (string.equals("-pdb")) {
            if (this.forceCIF) {
                throw new IllegalArgumentException("Can't specify both -cif and -pdb");
            }
            this.forcePDB = true;
        } else if (string.equals("-360")) {
            this.doWrap = true;
        } else if (string.equals("-validate") || string.equals("-val")) {
            this.showDeviation = true;
        } else if (string.equals("-sigma")) {
            try {
                this.sigmaCutoff = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Expected -sigma=#.#");
            }
        } else if (string.equals("-prot") || string.equals("-protein") || string.equals("-proteins")) {
            try {
                this.loadMeasures("EnghHuber_IntlTblsF_1999.txt");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string.equalsIgnoreCase("-rna")) {
            try {
                this.loadMeasures("ParkinsonBerman_ActaCrystD_1996_RNA.txt");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string.equalsIgnoreCase("-dna")) {
            try {
                this.loadMeasures("GelbinBerman_JACS_1996_DNA.txt");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string.equals("-outliers")) {
            this.showDeviation = true;
            this.outliersOnly = true;
        } else if (string.equals("-parcoor")) {
            this.doParCoor = true;
        } else if (string.equals("-geometrykin") || string.equals("-geomkin") || string.equals("-kin")) {
            this.doGeomKin = true;
        } else if (string.equals("-sub") || string.equals("-subgroup")) {
            this.subgroup = true;
        } else if (string.equals("-dohets") || string.equals("-hets")) {
            this.doHets = true;
        } else if (string.equals("-res") || string.equals("-resnum") || string.equals("-resnums") || string.equals("-residues")) {
            try {
                this.parseResnums(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("*** Error: Can't format '" + string2 + "' as list of resnum ranges!");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

