/* GDK - The GIMP Drawing Kit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-2001.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

/* Pablo d'Angelo: used for keysyms of the freepv platform interface */

#ifndef __FPV_KEYSYMS_H__
#define __FPV_KEYSYMS_H__


#define FPV_VoidSymbol 0xFFFFFF
#define FPV_BackSpace 0xFF08
#define FPV_Tab 0xFF09
#define FPV_Linefeed 0xFF0A
#define FPV_Clear 0xFF0B
#define FPV_Return 0xFF0D
#define FPV_Pause 0xFF13
#define FPV_Scroll_Lock 0xFF14
#define FPV_Sys_Req 0xFF15
#define FPV_Escape 0xFF1B
#define FPV_Delete 0xFFFF
#define FPV_Multi_key 0xFF20
#define FPV_Codeinput 0xFF37
#define FPV_SingleCandidate 0xFF3C
#define FPV_MultipleCandidate 0xFF3D
#define FPV_PreviousCandidate 0xFF3E
#define FPV_Kanji 0xFF21
#define FPV_Muhenkan 0xFF22
#define FPV_Henkan_Mode 0xFF23
#define FPV_Henkan 0xFF23
#define FPV_Romaji 0xFF24
#define FPV_Hiragana 0xFF25
#define FPV_Katakana 0xFF26
#define FPV_Hiragana_Katakana 0xFF27
#define FPV_Zenkaku 0xFF28
#define FPV_Hankaku 0xFF29
#define FPV_Zenkaku_Hankaku 0xFF2A
#define FPV_Touroku 0xFF2B
#define FPV_Massyo 0xFF2C
#define FPV_Kana_Lock 0xFF2D
#define FPV_Kana_Shift 0xFF2E
#define FPV_Eisu_Shift 0xFF2F
#define FPV_Eisu_toggle 0xFF30
#define FPV_Kanji_Bangou 0xFF37
#define FPV_Zen_Koho 0xFF3D
#define FPV_Mae_Koho 0xFF3E
#define FPV_Home 0xFF50
#define FPV_Left 0xFF51
#define FPV_Up 0xFF52
#define FPV_Right 0xFF53
#define FPV_Down 0xFF54
#define FPV_Prior 0xFF55
#define FPV_Page_Up 0xFF55
#define FPV_Next 0xFF56
#define FPV_Page_Down 0xFF56
#define FPV_End 0xFF57
#define FPV_Begin 0xFF58
#define FPV_Select 0xFF60
#define FPV_Print 0xFF61
#define FPV_Execute 0xFF62
#define FPV_Insert 0xFF63
#define FPV_Undo 0xFF65
#define FPV_Redo 0xFF66
#define FPV_Menu 0xFF67
#define FPV_Find 0xFF68
#define FPV_Cancel 0xFF69
#define FPV_Help 0xFF6A
#define FPV_Break 0xFF6B
#define FPV_Mode_switch 0xFF7E
#define FPV_script_switch 0xFF7E
#define FPV_Num_Lock 0xFF7F
#define FPV_KP_Space 0xFF80
#define FPV_KP_Tab 0xFF89
#define FPV_KP_Enter 0xFF8D
#define FPV_KP_F1 0xFF91
#define FPV_KP_F2 0xFF92
#define FPV_KP_F3 0xFF93
#define FPV_KP_F4 0xFF94
#define FPV_KP_Home 0xFF95
#define FPV_KP_Left 0xFF96
#define FPV_KP_Up 0xFF97
#define FPV_KP_Right 0xFF98
#define FPV_KP_Down 0xFF99
#define FPV_KP_Prior 0xFF9A
#define FPV_KP_Page_Up 0xFF9A
#define FPV_KP_Next 0xFF9B
#define FPV_KP_Page_Down 0xFF9B
#define FPV_KP_End 0xFF9C
#define FPV_KP_Begin 0xFF9D
#define FPV_KP_Insert 0xFF9E
#define FPV_KP_Delete 0xFF9F
#define FPV_KP_Equal 0xFFBD
#define FPV_KP_Multiply 0xFFAA
#define FPV_KP_Add 0xFFAB
#define FPV_KP_Separator 0xFFAC
#define FPV_KP_Subtract 0xFFAD
#define FPV_KP_Decimal 0xFFAE
#define FPV_KP_Divide 0xFFAF
#define FPV_KP_0 0xFFB0
#define FPV_KP_1 0xFFB1
#define FPV_KP_2 0xFFB2
#define FPV_KP_3 0xFFB3
#define FPV_KP_4 0xFFB4
#define FPV_KP_5 0xFFB5
#define FPV_KP_6 0xFFB6
#define FPV_KP_7 0xFFB7
#define FPV_KP_8 0xFFB8
#define FPV_KP_9 0xFFB9
#define FPV_F1 0xFFBE
#define FPV_F2 0xFFBF
#define FPV_F3 0xFFC0
#define FPV_F4 0xFFC1
#define FPV_F5 0xFFC2
#define FPV_F6 0xFFC3
#define FPV_F7 0xFFC4
#define FPV_F8 0xFFC5
#define FPV_F9 0xFFC6
#define FPV_F10 0xFFC7
#define FPV_F11 0xFFC8
#define FPV_L1 0xFFC8
#define FPV_F12 0xFFC9
#define FPV_L2 0xFFC9
#define FPV_F13 0xFFCA
#define FPV_L3 0xFFCA
#define FPV_F14 0xFFCB
#define FPV_L4 0xFFCB
#define FPV_F15 0xFFCC
#define FPV_L5 0xFFCC
#define FPV_F16 0xFFCD
#define FPV_L6 0xFFCD
#define FPV_F17 0xFFCE
#define FPV_L7 0xFFCE
#define FPV_F18 0xFFCF
#define FPV_L8 0xFFCF
#define FPV_F19 0xFFD0
#define FPV_L9 0xFFD0
#define FPV_F20 0xFFD1
#define FPV_L10 0xFFD1
#define FPV_F21 0xFFD2
#define FPV_R1 0xFFD2
#define FPV_F22 0xFFD3
#define FPV_R2 0xFFD3
#define FPV_F23 0xFFD4
#define FPV_R3 0xFFD4
#define FPV_F24 0xFFD5
#define FPV_R4 0xFFD5
#define FPV_F25 0xFFD6
#define FPV_R5 0xFFD6
#define FPV_F26 0xFFD7
#define FPV_R6 0xFFD7
#define FPV_F27 0xFFD8
#define FPV_R7 0xFFD8
#define FPV_F28 0xFFD9
#define FPV_R8 0xFFD9
#define FPV_F29 0xFFDA
#define FPV_R9 0xFFDA
#define FPV_F30 0xFFDB
#define FPV_R10 0xFFDB
#define FPV_F31 0xFFDC
#define FPV_R11 0xFFDC
#define FPV_F32 0xFFDD
#define FPV_R12 0xFFDD
#define FPV_F33 0xFFDE
#define FPV_R13 0xFFDE
#define FPV_F34 0xFFDF
#define FPV_R14 0xFFDF
#define FPV_F35 0xFFE0
#define FPV_R15 0xFFE0
#define FPV_Shift_L 0xFFE1
#define FPV_Shift_R 0xFFE2
#define FPV_Control_L 0xFFE3
#define FPV_Control_R 0xFFE4
#define FPV_Caps_Lock 0xFFE5
#define FPV_Shift_Lock 0xFFE6
#define FPV_Meta_L 0xFFE7
#define FPV_Meta_R 0xFFE8
#define FPV_Alt_L 0xFFE9
#define FPV_Alt_R 0xFFEA
#define FPV_Super_L 0xFFEB
#define FPV_Super_R 0xFFEC
#define FPV_Hyper_L 0xFFED
#define FPV_Hyper_R 0xFFEE
#define FPV_ISO_Lock 0xFE01
#define FPV_ISO_Level2_Latch 0xFE02
#define FPV_ISO_Level3_Shift 0xFE03
#define FPV_ISO_Level3_Latch 0xFE04
#define FPV_ISO_Level3_Lock 0xFE05
#define FPV_ISO_Group_Shift 0xFF7E
#define FPV_ISO_Group_Latch 0xFE06
#define FPV_ISO_Group_Lock 0xFE07
#define FPV_ISO_Next_Group 0xFE08
#define FPV_ISO_Next_Group_Lock 0xFE09
#define FPV_ISO_Prev_Group 0xFE0A
#define FPV_ISO_Prev_Group_Lock 0xFE0B
#define FPV_ISO_First_Group 0xFE0C
#define FPV_ISO_First_Group_Lock 0xFE0D
#define FPV_ISO_Last_Group 0xFE0E
#define FPV_ISO_Last_Group_Lock 0xFE0F
#define FPV_ISO_Left_Tab 0xFE20
#define FPV_ISO_Move_Line_Up 0xFE21
#define FPV_ISO_Move_Line_Down 0xFE22
#define FPV_ISO_Partial_Line_Up 0xFE23
#define FPV_ISO_Partial_Line_Down 0xFE24
#define FPV_ISO_Partial_Space_Left 0xFE25
#define FPV_ISO_Partial_Space_Right 0xFE26
#define FPV_ISO_Set_Margin_Left 0xFE27
#define FPV_ISO_Set_Margin_Right 0xFE28
#define FPV_ISO_Release_Margin_Left 0xFE29
#define FPV_ISO_Release_Margin_Right 0xFE2A
#define FPV_ISO_Release_Both_Margins 0xFE2B
#define FPV_ISO_Fast_Cursor_Left 0xFE2C
#define FPV_ISO_Fast_Cursor_Right 0xFE2D
#define FPV_ISO_Fast_Cursor_Up 0xFE2E
#define FPV_ISO_Fast_Cursor_Down 0xFE2F
#define FPV_ISO_Continuous_Underline 0xFE30
#define FPV_ISO_Discontinuous_Underline 0xFE31
#define FPV_ISO_Emphasize 0xFE32
#define FPV_ISO_Center_Object 0xFE33
#define FPV_ISO_Enter 0xFE34
#define FPV_dead_grave 0xFE50
#define FPV_dead_acute 0xFE51
#define FPV_dead_circumflex 0xFE52
#define FPV_dead_tilde 0xFE53
#define FPV_dead_macron 0xFE54
#define FPV_dead_breve 0xFE55
#define FPV_dead_abovedot 0xFE56
#define FPV_dead_diaeresis 0xFE57
#define FPV_dead_abovering 0xFE58
#define FPV_dead_doubleacute 0xFE59
#define FPV_dead_caron 0xFE5A
#define FPV_dead_cedilla 0xFE5B
#define FPV_dead_ogonek 0xFE5C
#define FPV_dead_iota 0xFE5D
#define FPV_dead_voiced_sound 0xFE5E
#define FPV_dead_semivoiced_sound 0xFE5F
#define FPV_dead_belowdot 0xFE60
#define FPV_dead_hook 0xFE61
#define FPV_dead_horn 0xFE62
#define FPV_First_Virtual_Screen 0xFED0
#define FPV_Prev_Virtual_Screen 0xFED1
#define FPV_Next_Virtual_Screen 0xFED2
#define FPV_Last_Virtual_Screen 0xFED4
#define FPV_Terminate_Server 0xFED5
#define FPV_AccessX_Enable 0xFE70
#define FPV_AccessX_Feedback_Enable 0xFE71
#define FPV_RepeatKeys_Enable 0xFE72
#define FPV_SlowKeys_Enable 0xFE73
#define FPV_BounceKeys_Enable 0xFE74
#define FPV_StickyKeys_Enable 0xFE75
#define FPV_MouseKeys_Enable 0xFE76
#define FPV_MouseKeys_Accel_Enable 0xFE77
#define FPV_Overlay1_Enable 0xFE78
#define FPV_Overlay2_Enable 0xFE79
#define FPV_AudibleBell_Enable 0xFE7A
#define FPV_Pointer_Left 0xFEE0
#define FPV_Pointer_Right 0xFEE1
#define FPV_Pointer_Up 0xFEE2
#define FPV_Pointer_Down 0xFEE3
#define FPV_Pointer_UpLeft 0xFEE4
#define FPV_Pointer_UpRight 0xFEE5
#define FPV_Pointer_DownLeft 0xFEE6
#define FPV_Pointer_DownRight 0xFEE7
#define FPV_Pointer_Button_Dflt 0xFEE8
#define FPV_Pointer_Button1 0xFEE9
#define FPV_Pointer_Button2 0xFEEA
#define FPV_Pointer_Button3 0xFEEB
#define FPV_Pointer_Button4 0xFEEC
#define FPV_Pointer_Button5 0xFEED
#define FPV_Pointer_DblClick_Dflt 0xFEEE
#define FPV_Pointer_DblClick1 0xFEEF
#define FPV_Pointer_DblClick2 0xFEF0
#define FPV_Pointer_DblClick3 0xFEF1
#define FPV_Pointer_DblClick4 0xFEF2
#define FPV_Pointer_DblClick5 0xFEF3
#define FPV_Pointer_Drag_Dflt 0xFEF4
#define FPV_Pointer_Drag1 0xFEF5
#define FPV_Pointer_Drag2 0xFEF6
#define FPV_Pointer_Drag3 0xFEF7
#define FPV_Pointer_Drag4 0xFEF8
#define FPV_Pointer_Drag5 0xFEFD
#define FPV_Pointer_EnableKeys 0xFEF9
#define FPV_Pointer_Accelerate 0xFEFA
#define FPV_Pointer_DfltBtnNext 0xFEFB
#define FPV_Pointer_DfltBtnPrev 0xFEFC
#define FPV_3270_Duplicate 0xFD01
#define FPV_3270_FieldMark 0xFD02
#define FPV_3270_Right2 0xFD03
#define FPV_3270_Left2 0xFD04
#define FPV_3270_BackTab 0xFD05
#define FPV_3270_EraseEOF 0xFD06
#define FPV_3270_EraseInput 0xFD07
#define FPV_3270_Reset 0xFD08
#define FPV_3270_Quit 0xFD09
#define FPV_3270_PA1 0xFD0A
#define FPV_3270_PA2 0xFD0B
#define FPV_3270_PA3 0xFD0C
#define FPV_3270_Test 0xFD0D
#define FPV_3270_Attn 0xFD0E
#define FPV_3270_CursorBlink 0xFD0F
#define FPV_3270_AltCursor 0xFD10
#define FPV_3270_KeyClick 0xFD11
#define FPV_3270_Jump 0xFD12
#define FPV_3270_Ident 0xFD13
#define FPV_3270_Rule 0xFD14
#define FPV_3270_Copy 0xFD15
#define FPV_3270_Play 0xFD16
#define FPV_3270_Setup 0xFD17
#define FPV_3270_Record 0xFD18
#define FPV_3270_ChangeScreen 0xFD19
#define FPV_3270_DeleteWord 0xFD1A
#define FPV_3270_ExSelect 0xFD1B
#define FPV_3270_CursorSelect 0xFD1C
#define FPV_3270_PrintScreen 0xFD1D
#define FPV_3270_Enter 0xFD1E
#define FPV_space 0x020
#define FPV_exclam 0x021
#define FPV_quotedbl 0x022
#define FPV_numbersign 0x023
#define FPV_dollar 0x024
#define FPV_percent 0x025
#define FPV_ampersand 0x026
#define FPV_apostrophe 0x027
#define FPV_quoteright 0x027
#define FPV_parenleft 0x028
#define FPV_parenright 0x029
#define FPV_asterisk 0x02a
#define FPV_plus 0x02b
#define FPV_comma 0x02c
#define FPV_minus 0x02d
#define FPV_period 0x02e
#define FPV_slash 0x02f
#define FPV_0 0x030
#define FPV_1 0x031
#define FPV_2 0x032
#define FPV_3 0x033
#define FPV_4 0x034
#define FPV_5 0x035
#define FPV_6 0x036
#define FPV_7 0x037
#define FPV_8 0x038
#define FPV_9 0x039
#define FPV_colon 0x03a
#define FPV_semicolon 0x03b
#define FPV_less 0x03c
#define FPV_equal 0x03d
#define FPV_greater 0x03e
#define FPV_question 0x03f
#define FPV_at 0x040
#define FPV_A 0x041
#define FPV_B 0x042
#define FPV_C 0x043
#define FPV_D 0x044
#define FPV_E 0x045
#define FPV_F 0x046
#define FPV_G 0x047
#define FPV_H 0x048
#define FPV_I 0x049
#define FPV_J 0x04a
#define FPV_K 0x04b
#define FPV_L 0x04c
#define FPV_M 0x04d
#define FPV_N 0x04e
#define FPV_O 0x04f
#define FPV_P 0x050
#define FPV_Q 0x051
#define FPV_R 0x052
#define FPV_S 0x053
#define FPV_T 0x054
#define FPV_U 0x055
#define FPV_V 0x056
#define FPV_W 0x057
#define FPV_X 0x058
#define FPV_Y 0x059
#define FPV_Z 0x05a
#define FPV_bracketleft 0x05b
#define FPV_backslash 0x05c
#define FPV_bracketright 0x05d
#define FPV_asciicircum 0x05e
#define FPV_underscore 0x05f
#define FPV_grave 0x060
#define FPV_quoteleft 0x060
#define FPV_a 0x061
#define FPV_b 0x062
#define FPV_c 0x063
#define FPV_d 0x064
#define FPV_e 0x065
#define FPV_f 0x066
#define FPV_g 0x067
#define FPV_h 0x068
#define FPV_i 0x069
#define FPV_j 0x06a
#define FPV_k 0x06b
#define FPV_l 0x06c
#define FPV_m 0x06d
#define FPV_n 0x06e
#define FPV_o 0x06f
#define FPV_p 0x070
#define FPV_q 0x071
#define FPV_r 0x072
#define FPV_s 0x073
#define FPV_t 0x074
#define FPV_u 0x075
#define FPV_v 0x076
#define FPV_w 0x077
#define FPV_x 0x078
#define FPV_y 0x079
#define FPV_z 0x07a
#define FPV_braceleft 0x07b
#define FPV_bar 0x07c
#define FPV_braceright 0x07d
#define FPV_asciitilde 0x07e
#define FPV_nobreakspace 0x0a0
#define FPV_exclamdown 0x0a1
#define FPV_cent 0x0a2
#define FPV_sterling 0x0a3
#define FPV_currency 0x0a4
#define FPV_yen 0x0a5
#define FPV_brokenbar 0x0a6
#define FPV_section 0x0a7
#define FPV_diaeresis 0x0a8
#define FPV_copyright 0x0a9
#define FPV_ordfeminine 0x0aa
#define FPV_guillemotleft 0x0ab
#define FPV_notsign 0x0ac
#define FPV_hyphen 0x0ad
#define FPV_registered 0x0ae
#define FPV_macron 0x0af
#define FPV_degree 0x0b0
#define FPV_plusminus 0x0b1
#define FPV_twosuperior 0x0b2
#define FPV_threesuperior 0x0b3
#define FPV_acute 0x0b4
#define FPV_mu 0x0b5
#define FPV_paragraph 0x0b6
#define FPV_periodcentered 0x0b7
#define FPV_cedilla 0x0b8
#define FPV_onesuperior 0x0b9
#define FPV_masculine 0x0ba
#define FPV_guillemotright 0x0bb
#define FPV_onequarter 0x0bc
#define FPV_onehalf 0x0bd
#define FPV_threequarters 0x0be
#define FPV_questiondown 0x0bf
#define FPV_Agrave 0x0c0
#define FPV_Aacute 0x0c1
#define FPV_Acircumflex 0x0c2
#define FPV_Atilde 0x0c3
#define FPV_Adiaeresis 0x0c4
#define FPV_Aring 0x0c5
#define FPV_AE 0x0c6
#define FPV_Ccedilla 0x0c7
#define FPV_Egrave 0x0c8
#define FPV_Eacute 0x0c9
#define FPV_Ecircumflex 0x0ca
#define FPV_Ediaeresis 0x0cb
#define FPV_Igrave 0x0cc
#define FPV_Iacute 0x0cd
#define FPV_Icircumflex 0x0ce
#define FPV_Idiaeresis 0x0cf
#define FPV_ETH 0x0d0
#define FPV_Eth 0x0d0
#define FPV_Ntilde 0x0d1
#define FPV_Ograve 0x0d2
#define FPV_Oacute 0x0d3
#define FPV_Ocircumflex 0x0d4
#define FPV_Otilde 0x0d5
#define FPV_Odiaeresis 0x0d6
#define FPV_multiply 0x0d7
#define FPV_Ooblique 0x0d8
#define FPV_Ugrave 0x0d9
#define FPV_Uacute 0x0da
#define FPV_Ucircumflex 0x0db
#define FPV_Udiaeresis 0x0dc
#define FPV_Yacute 0x0dd
#define FPV_THORN 0x0de
#define FPV_Thorn 0x0de
#define FPV_ssharp 0x0df
#define FPV_agrave 0x0e0
#define FPV_aacute 0x0e1
#define FPV_acircumflex 0x0e2
#define FPV_atilde 0x0e3
#define FPV_adiaeresis 0x0e4
#define FPV_aring 0x0e5
#define FPV_ae 0x0e6
#define FPV_ccedilla 0x0e7
#define FPV_egrave 0x0e8
#define FPV_eacute 0x0e9
#define FPV_ecircumflex 0x0ea
#define FPV_ediaeresis 0x0eb
#define FPV_igrave 0x0ec
#define FPV_iacute 0x0ed
#define FPV_icircumflex 0x0ee
#define FPV_idiaeresis 0x0ef
#define FPV_eth 0x0f0
#define FPV_ntilde 0x0f1
#define FPV_ograve 0x0f2
#define FPV_oacute 0x0f3
#define FPV_ocircumflex 0x0f4
#define FPV_otilde 0x0f5
#define FPV_odiaeresis 0x0f6
#define FPV_division 0x0f7
#define FPV_oslash 0x0f8
#define FPV_ugrave 0x0f9
#define FPV_uacute 0x0fa
#define FPV_ucircumflex 0x0fb
#define FPV_udiaeresis 0x0fc
#define FPV_yacute 0x0fd
#define FPV_thorn 0x0fe
#define FPV_ydiaeresis 0x0ff
#define FPV_Aogonek 0x1a1
#define FPV_breve 0x1a2
#define FPV_Lstroke 0x1a3
#define FPV_Lcaron 0x1a5
#define FPV_Sacute 0x1a6
#define FPV_Scaron 0x1a9
#define FPV_Scedilla 0x1aa
#define FPV_Tcaron 0x1ab
#define FPV_Zacute 0x1ac
#define FPV_Zcaron 0x1ae
#define FPV_Zabovedot 0x1af
#define FPV_aogonek 0x1b1
#define FPV_ogonek 0x1b2
#define FPV_lstroke 0x1b3
#define FPV_lcaron 0x1b5
#define FPV_sacute 0x1b6
#define FPV_caron 0x1b7
#define FPV_scaron 0x1b9
#define FPV_scedilla 0x1ba
#define FPV_tcaron 0x1bb
#define FPV_zacute 0x1bc
#define FPV_doubleacute 0x1bd
#define FPV_zcaron 0x1be
#define FPV_zabovedot 0x1bf
#define FPV_Racute 0x1c0
#define FPV_Abreve 0x1c3
#define FPV_Lacute 0x1c5
#define FPV_Cacute 0x1c6
#define FPV_Ccaron 0x1c8
#define FPV_Eogonek 0x1ca
#define FPV_Ecaron 0x1cc
#define FPV_Dcaron 0x1cf
#define FPV_Dstroke 0x1d0
#define FPV_Nacute 0x1d1
#define FPV_Ncaron 0x1d2
#define FPV_Odoubleacute 0x1d5
#define FPV_Rcaron 0x1d8
#define FPV_Uring 0x1d9
#define FPV_Udoubleacute 0x1db
#define FPV_Tcedilla 0x1de
#define FPV_racute 0x1e0
#define FPV_abreve 0x1e3
#define FPV_lacute 0x1e5
#define FPV_cacute 0x1e6
#define FPV_ccaron 0x1e8
#define FPV_eogonek 0x1ea
#define FPV_ecaron 0x1ec
#define FPV_dcaron 0x1ef
#define FPV_dstroke 0x1f0
#define FPV_nacute 0x1f1
#define FPV_ncaron 0x1f2
#define FPV_odoubleacute 0x1f5
#define FPV_udoubleacute 0x1fb
#define FPV_rcaron 0x1f8
#define FPV_uring 0x1f9
#define FPV_tcedilla 0x1fe
#define FPV_abovedot 0x1ff
#define FPV_Hstroke 0x2a1
#define FPV_Hcircumflex 0x2a6
#define FPV_Iabovedot 0x2a9
#define FPV_Gbreve 0x2ab
#define FPV_Jcircumflex 0x2ac
#define FPV_hstroke 0x2b1
#define FPV_hcircumflex 0x2b6
#define FPV_idotless 0x2b9
#define FPV_gbreve 0x2bb
#define FPV_jcircumflex 0x2bc
#define FPV_Cabovedot 0x2c5
#define FPV_Ccircumflex 0x2c6
#define FPV_Gabovedot 0x2d5
#define FPV_Gcircumflex 0x2d8
#define FPV_Ubreve 0x2dd
#define FPV_Scircumflex 0x2de
#define FPV_cabovedot 0x2e5
#define FPV_ccircumflex 0x2e6
#define FPV_gabovedot 0x2f5
#define FPV_gcircumflex 0x2f8
#define FPV_ubreve 0x2fd
#define FPV_scircumflex 0x2fe
#define FPV_kra 0x3a2
#define FPV_kappa 0x3a2
#define FPV_Rcedilla 0x3a3
#define FPV_Itilde 0x3a5
#define FPV_Lcedilla 0x3a6
#define FPV_Emacron 0x3aa
#define FPV_Gcedilla 0x3ab
#define FPV_Tslash 0x3ac
#define FPV_rcedilla 0x3b3
#define FPV_itilde 0x3b5
#define FPV_lcedilla 0x3b6
#define FPV_emacron 0x3ba
#define FPV_gcedilla 0x3bb
#define FPV_tslash 0x3bc
#define FPV_ENG 0x3bd
#define FPV_eng 0x3bf
#define FPV_Amacron 0x3c0
#define FPV_Iogonek 0x3c7
#define FPV_Eabovedot 0x3cc
#define FPV_Imacron 0x3cf
#define FPV_Ncedilla 0x3d1
#define FPV_Omacron 0x3d2
#define FPV_Kcedilla 0x3d3
#define FPV_Uogonek 0x3d9
#define FPV_Utilde 0x3dd
#define FPV_Umacron 0x3de
#define FPV_amacron 0x3e0
#define FPV_iogonek 0x3e7
#define FPV_eabovedot 0x3ec
#define FPV_imacron 0x3ef
#define FPV_ncedilla 0x3f1
#define FPV_omacron 0x3f2
#define FPV_kcedilla 0x3f3
#define FPV_uogonek 0x3f9
#define FPV_utilde 0x3fd
#define FPV_umacron 0x3fe
#define FPV_OE 0x13bc
#define FPV_oe 0x13bd
#define FPV_Ydiaeresis 0x13be
#define FPV_overline 0x47e
#define FPV_kana_fullstop 0x4a1
#define FPV_kana_openingbracket 0x4a2
#define FPV_kana_closingbracket 0x4a3
#define FPV_kana_comma 0x4a4
#define FPV_kana_conjunctive 0x4a5
#define FPV_kana_middledot 0x4a5
#define FPV_kana_WO 0x4a6
#define FPV_kana_a 0x4a7
#define FPV_kana_i 0x4a8
#define FPV_kana_u 0x4a9
#define FPV_kana_e 0x4aa
#define FPV_kana_o 0x4ab
#define FPV_kana_ya 0x4ac
#define FPV_kana_yu 0x4ad
#define FPV_kana_yo 0x4ae
#define FPV_kana_tsu 0x4af
#define FPV_kana_tu 0x4af
#define FPV_prolongedsound 0x4b0
#define FPV_kana_A 0x4b1
#define FPV_kana_I 0x4b2
#define FPV_kana_U 0x4b3
#define FPV_kana_E 0x4b4
#define FPV_kana_O 0x4b5
#define FPV_kana_KA 0x4b6
#define FPV_kana_KI 0x4b7
#define FPV_kana_KU 0x4b8
#define FPV_kana_KE 0x4b9
#define FPV_kana_KO 0x4ba
#define FPV_kana_SA 0x4bb
#define FPV_kana_SHI 0x4bc
#define FPV_kana_SU 0x4bd
#define FPV_kana_SE 0x4be
#define FPV_kana_SO 0x4bf
#define FPV_kana_TA 0x4c0
#define FPV_kana_CHI 0x4c1
#define FPV_kana_TI 0x4c1
#define FPV_kana_TSU 0x4c2
#define FPV_kana_TU 0x4c2
#define FPV_kana_TE 0x4c3
#define FPV_kana_TO 0x4c4
#define FPV_kana_NA 0x4c5
#define FPV_kana_NI 0x4c6
#define FPV_kana_NU 0x4c7
#define FPV_kana_NE 0x4c8
#define FPV_kana_NO 0x4c9
#define FPV_kana_HA 0x4ca
#define FPV_kana_HI 0x4cb
#define FPV_kana_FU 0x4cc
#define FPV_kana_HU 0x4cc
#define FPV_kana_HE 0x4cd
#define FPV_kana_HO 0x4ce
#define FPV_kana_MA 0x4cf
#define FPV_kana_MI 0x4d0
#define FPV_kana_MU 0x4d1
#define FPV_kana_ME 0x4d2
#define FPV_kana_MO 0x4d3
#define FPV_kana_YA 0x4d4
#define FPV_kana_YU 0x4d5
#define FPV_kana_YO 0x4d6
#define FPV_kana_RA 0x4d7
#define FPV_kana_RI 0x4d8
#define FPV_kana_RU 0x4d9
#define FPV_kana_RE 0x4da
#define FPV_kana_RO 0x4db
#define FPV_kana_WA 0x4dc
#define FPV_kana_N 0x4dd
#define FPV_voicedsound 0x4de
#define FPV_semivoicedsound 0x4df
#define FPV_kana_switch 0xFF7E
#define FPV_Arabic_comma 0x5ac
#define FPV_Arabic_semicolon 0x5bb
#define FPV_Arabic_question_mark 0x5bf
#define FPV_Arabic_hamza 0x5c1
#define FPV_Arabic_maddaonalef 0x5c2
#define FPV_Arabic_hamzaonalef 0x5c3
#define FPV_Arabic_hamzaonwaw 0x5c4
#define FPV_Arabic_hamzaunderalef 0x5c5
#define FPV_Arabic_hamzaonyeh 0x5c6
#define FPV_Arabic_alef 0x5c7
#define FPV_Arabic_beh 0x5c8
#define FPV_Arabic_tehmarbuta 0x5c9
#define FPV_Arabic_teh 0x5ca
#define FPV_Arabic_theh 0x5cb
#define FPV_Arabic_jeem 0x5cc
#define FPV_Arabic_hah 0x5cd
#define FPV_Arabic_khah 0x5ce
#define FPV_Arabic_dal 0x5cf
#define FPV_Arabic_thal 0x5d0
#define FPV_Arabic_ra 0x5d1
#define FPV_Arabic_zain 0x5d2
#define FPV_Arabic_seen 0x5d3
#define FPV_Arabic_sheen 0x5d4
#define FPV_Arabic_sad 0x5d5
#define FPV_Arabic_dad 0x5d6
#define FPV_Arabic_tah 0x5d7
#define FPV_Arabic_zah 0x5d8
#define FPV_Arabic_ain 0x5d9
#define FPV_Arabic_ghain 0x5da
#define FPV_Arabic_tatweel 0x5e0
#define FPV_Arabic_feh 0x5e1
#define FPV_Arabic_qaf 0x5e2
#define FPV_Arabic_kaf 0x5e3
#define FPV_Arabic_lam 0x5e4
#define FPV_Arabic_meem 0x5e5
#define FPV_Arabic_noon 0x5e6
#define FPV_Arabic_ha 0x5e7
#define FPV_Arabic_heh 0x5e7
#define FPV_Arabic_waw 0x5e8
#define FPV_Arabic_alefmaksura 0x5e9
#define FPV_Arabic_yeh 0x5ea
#define FPV_Arabic_fathatan 0x5eb
#define FPV_Arabic_dammatan 0x5ec
#define FPV_Arabic_kasratan 0x5ed
#define FPV_Arabic_fatha 0x5ee
#define FPV_Arabic_damma 0x5ef
#define FPV_Arabic_kasra 0x5f0
#define FPV_Arabic_shadda 0x5f1
#define FPV_Arabic_sukun 0x5f2
#define FPV_Arabic_switch 0xFF7E
#define FPV_Serbian_dje 0x6a1
#define FPV_Macedonia_gje 0x6a2
#define FPV_Cyrillic_io 0x6a3
#define FPV_Ukrainian_ie 0x6a4
#define FPV_Ukranian_je 0x6a4
#define FPV_Macedonia_dse 0x6a5
#define FPV_Ukrainian_i 0x6a6
#define FPV_Ukranian_i 0x6a6
#define FPV_Ukrainian_yi 0x6a7
#define FPV_Ukranian_yi 0x6a7
#define FPV_Cyrillic_je 0x6a8
#define FPV_Serbian_je 0x6a8
#define FPV_Cyrillic_lje 0x6a9
#define FPV_Serbian_lje 0x6a9
#define FPV_Cyrillic_nje 0x6aa
#define FPV_Serbian_nje 0x6aa
#define FPV_Serbian_tshe 0x6ab
#define FPV_Macedonia_kje 0x6ac
#define FPV_Ukrainian_ghe_with_upturn 0x6ad
#define FPV_Byelorussian_shortu 0x6ae
#define FPV_Cyrillic_dzhe 0x6af
#define FPV_Serbian_dze 0x6af
#define FPV_numerosign 0x6b0
#define FPV_Serbian_DJE 0x6b1
#define FPV_Macedonia_GJE 0x6b2
#define FPV_Cyrillic_IO 0x6b3
#define FPV_Ukrainian_IE 0x6b4
#define FPV_Ukranian_JE 0x6b4
#define FPV_Macedonia_DSE 0x6b5
#define FPV_Ukrainian_I 0x6b6
#define FPV_Ukranian_I 0x6b6
#define FPV_Ukrainian_YI 0x6b7
#define FPV_Ukranian_YI 0x6b7
#define FPV_Cyrillic_JE 0x6b8
#define FPV_Serbian_JE 0x6b8
#define FPV_Cyrillic_LJE 0x6b9
#define FPV_Serbian_LJE 0x6b9
#define FPV_Cyrillic_NJE 0x6ba
#define FPV_Serbian_NJE 0x6ba
#define FPV_Serbian_TSHE 0x6bb
#define FPV_Macedonia_KJE 0x6bc
#define FPV_Ukrainian_GHE_WITH_UPTURN 0x6bd
#define FPV_Byelorussian_SHORTU 0x6be
#define FPV_Cyrillic_DZHE 0x6bf
#define FPV_Serbian_DZE 0x6bf
#define FPV_Cyrillic_yu 0x6c0
#define FPV_Cyrillic_a 0x6c1
#define FPV_Cyrillic_be 0x6c2
#define FPV_Cyrillic_tse 0x6c3
#define FPV_Cyrillic_de 0x6c4
#define FPV_Cyrillic_ie 0x6c5
#define FPV_Cyrillic_ef 0x6c6
#define FPV_Cyrillic_ghe 0x6c7
#define FPV_Cyrillic_ha 0x6c8
#define FPV_Cyrillic_i 0x6c9
#define FPV_Cyrillic_shorti 0x6ca
#define FPV_Cyrillic_ka 0x6cb
#define FPV_Cyrillic_el 0x6cc
#define FPV_Cyrillic_em 0x6cd
#define FPV_Cyrillic_en 0x6ce
#define FPV_Cyrillic_o 0x6cf
#define FPV_Cyrillic_pe 0x6d0
#define FPV_Cyrillic_ya 0x6d1
#define FPV_Cyrillic_er 0x6d2
#define FPV_Cyrillic_es 0x6d3
#define FPV_Cyrillic_te 0x6d4
#define FPV_Cyrillic_u 0x6d5
#define FPV_Cyrillic_zhe 0x6d6
#define FPV_Cyrillic_ve 0x6d7
#define FPV_Cyrillic_softsign 0x6d8
#define FPV_Cyrillic_yeru 0x6d9
#define FPV_Cyrillic_ze 0x6da
#define FPV_Cyrillic_sha 0x6db
#define FPV_Cyrillic_e 0x6dc
#define FPV_Cyrillic_shcha 0x6dd
#define FPV_Cyrillic_che 0x6de
#define FPV_Cyrillic_hardsign 0x6df
#define FPV_Cyrillic_YU 0x6e0
#define FPV_Cyrillic_A 0x6e1
#define FPV_Cyrillic_BE 0x6e2
#define FPV_Cyrillic_TSE 0x6e3
#define FPV_Cyrillic_DE 0x6e4
#define FPV_Cyrillic_IE 0x6e5
#define FPV_Cyrillic_EF 0x6e6
#define FPV_Cyrillic_GHE 0x6e7
#define FPV_Cyrillic_HA 0x6e8
#define FPV_Cyrillic_I 0x6e9
#define FPV_Cyrillic_SHORTI 0x6ea
#define FPV_Cyrillic_KA 0x6eb
#define FPV_Cyrillic_EL 0x6ec
#define FPV_Cyrillic_EM 0x6ed
#define FPV_Cyrillic_EN 0x6ee
#define FPV_Cyrillic_O 0x6ef
#define FPV_Cyrillic_PE 0x6f0
#define FPV_Cyrillic_YA 0x6f1
#define FPV_Cyrillic_ER 0x6f2
#define FPV_Cyrillic_ES 0x6f3
#define FPV_Cyrillic_TE 0x6f4
#define FPV_Cyrillic_U 0x6f5
#define FPV_Cyrillic_ZHE 0x6f6
#define FPV_Cyrillic_VE 0x6f7
#define FPV_Cyrillic_SOFTSIGN 0x6f8
#define FPV_Cyrillic_YERU 0x6f9
#define FPV_Cyrillic_ZE 0x6fa
#define FPV_Cyrillic_SHA 0x6fb
#define FPV_Cyrillic_E 0x6fc
#define FPV_Cyrillic_SHCHA 0x6fd
#define FPV_Cyrillic_CHE 0x6fe
#define FPV_Cyrillic_HARDSIGN 0x6ff
#define FPV_Greek_ALPHAaccent 0x7a1
#define FPV_Greek_EPSILONaccent 0x7a2
#define FPV_Greek_ETAaccent 0x7a3
#define FPV_Greek_IOTAaccent 0x7a4
#define FPV_Greek_IOTAdieresis 0x7a5
#define FPV_Greek_IOTAdiaeresis FPV_Greek_IOTAdieresis
#define FPV_Greek_OMICRONaccent 0x7a7
#define FPV_Greek_UPSILONaccent 0x7a8
#define FPV_Greek_UPSILONdieresis 0x7a9
#define FPV_Greek_OMEGAaccent 0x7ab
#define FPV_Greek_accentdieresis 0x7ae
#define FPV_Greek_horizbar 0x7af
#define FPV_Greek_alphaaccent 0x7b1
#define FPV_Greek_epsilonaccent 0x7b2
#define FPV_Greek_etaaccent 0x7b3
#define FPV_Greek_iotaaccent 0x7b4
#define FPV_Greek_iotadieresis 0x7b5
#define FPV_Greek_iotaaccentdieresis 0x7b6
#define FPV_Greek_omicronaccent 0x7b7
#define FPV_Greek_upsilonaccent 0x7b8
#define FPV_Greek_upsilondieresis 0x7b9
#define FPV_Greek_upsilonaccentdieresis 0x7ba
#define FPV_Greek_omegaaccent 0x7bb
#define FPV_Greek_ALPHA 0x7c1
#define FPV_Greek_BETA 0x7c2
#define FPV_Greek_GAMMA 0x7c3
#define FPV_Greek_DELTA 0x7c4
#define FPV_Greek_EPSILON 0x7c5
#define FPV_Greek_ZETA 0x7c6
#define FPV_Greek_ETA 0x7c7
#define FPV_Greek_THETA 0x7c8
#define FPV_Greek_IOTA 0x7c9
#define FPV_Greek_KAPPA 0x7ca
#define FPV_Greek_LAMDA 0x7cb
#define FPV_Greek_LAMBDA 0x7cb
#define FPV_Greek_MU 0x7cc
#define FPV_Greek_NU 0x7cd
#define FPV_Greek_XI 0x7ce
#define FPV_Greek_OMICRON 0x7cf
#define FPV_Greek_PI 0x7d0
#define FPV_Greek_RHO 0x7d1
#define FPV_Greek_SIGMA 0x7d2
#define FPV_Greek_TAU 0x7d4
#define FPV_Greek_UPSILON 0x7d5
#define FPV_Greek_PHI 0x7d6
#define FPV_Greek_CHI 0x7d7
#define FPV_Greek_PSI 0x7d8
#define FPV_Greek_OMEGA 0x7d9
#define FPV_Greek_alpha 0x7e1
#define FPV_Greek_beta 0x7e2
#define FPV_Greek_gamma 0x7e3
#define FPV_Greek_delta 0x7e4
#define FPV_Greek_epsilon 0x7e5
#define FPV_Greek_zeta 0x7e6
#define FPV_Greek_eta 0x7e7
#define FPV_Greek_theta 0x7e8
#define FPV_Greek_iota 0x7e9
#define FPV_Greek_kappa 0x7ea
#define FPV_Greek_lamda 0x7eb
#define FPV_Greek_lambda 0x7eb
#define FPV_Greek_mu 0x7ec
#define FPV_Greek_nu 0x7ed
#define FPV_Greek_xi 0x7ee
#define FPV_Greek_omicron 0x7ef
#define FPV_Greek_pi 0x7f0
#define FPV_Greek_rho 0x7f1
#define FPV_Greek_sigma 0x7f2
#define FPV_Greek_finalsmallsigma 0x7f3
#define FPV_Greek_tau 0x7f4
#define FPV_Greek_upsilon 0x7f5
#define FPV_Greek_phi 0x7f6
#define FPV_Greek_chi 0x7f7
#define FPV_Greek_psi 0x7f8
#define FPV_Greek_omega 0x7f9
#define FPV_Greek_switch 0xFF7E
#define FPV_leftradical 0x8a1
#define FPV_topleftradical 0x8a2
#define FPV_horizconnector 0x8a3
#define FPV_topintegral 0x8a4
#define FPV_botintegral 0x8a5
#define FPV_vertconnector 0x8a6
#define FPV_topleftsqbracket 0x8a7
#define FPV_botleftsqbracket 0x8a8
#define FPV_toprightsqbracket 0x8a9
#define FPV_botrightsqbracket 0x8aa
#define FPV_topleftparens 0x8ab
#define FPV_botleftparens 0x8ac
#define FPV_toprightparens 0x8ad
#define FPV_botrightparens 0x8ae
#define FPV_leftmiddlecurlybrace 0x8af
#define FPV_rightmiddlecurlybrace 0x8b0
#define FPV_topleftsummation 0x8b1
#define FPV_botleftsummation 0x8b2
#define FPV_topvertsummationconnector 0x8b3
#define FPV_botvertsummationconnector 0x8b4
#define FPV_toprightsummation 0x8b5
#define FPV_botrightsummation 0x8b6
#define FPV_rightmiddlesummation 0x8b7
#define FPV_lessthanequal 0x8bc
#define FPV_notequal 0x8bd
#define FPV_greaterthanequal 0x8be
#define FPV_integral 0x8bf
#define FPV_therefore 0x8c0
#define FPV_variation 0x8c1
#define FPV_infinity 0x8c2
#define FPV_nabla 0x8c5
#define FPV_approximate 0x8c8
#define FPV_similarequal 0x8c9
#define FPV_ifonlyif 0x8cd
#define FPV_implies 0x8ce
#define FPV_identical 0x8cf
#define FPV_radical 0x8d6
#define FPV_includedin 0x8da
#define FPV_includes 0x8db
#define FPV_intersection 0x8dc
#define FPV_union 0x8dd
#define FPV_logicaland 0x8de
#define FPV_logicalor 0x8df
#define FPV_partialderivative 0x8ef
#define FPV_function 0x8f6
#define FPV_leftarrow 0x8fb
#define FPV_uparrow 0x8fc
#define FPV_rightarrow 0x8fd
#define FPV_downarrow 0x8fe
#define FPV_blank 0x9df
#define FPV_soliddiamond 0x9e0
#define FPV_checkerboard 0x9e1
#define FPV_ht 0x9e2
#define FPV_ff 0x9e3
#define FPV_cr 0x9e4
#define FPV_lf 0x9e5
#define FPV_nl 0x9e8
#define FPV_vt 0x9e9
#define FPV_lowrightcorner 0x9ea
#define FPV_uprightcorner 0x9eb
#define FPV_upleftcorner 0x9ec
#define FPV_lowleftcorner 0x9ed
#define FPV_crossinglines 0x9ee
#define FPV_horizlinescan1 0x9ef
#define FPV_horizlinescan3 0x9f0
#define FPV_horizlinescan5 0x9f1
#define FPV_horizlinescan7 0x9f2
#define FPV_horizlinescan9 0x9f3
#define FPV_leftt 0x9f4
#define FPV_rightt 0x9f5
#define FPV_bott 0x9f6
#define FPV_topt 0x9f7
#define FPV_vertbar 0x9f8
#define FPV_emspace 0xaa1
#define FPV_enspace 0xaa2
#define FPV_em3space 0xaa3
#define FPV_em4space 0xaa4
#define FPV_digitspace 0xaa5
#define FPV_punctspace 0xaa6
#define FPV_thinspace 0xaa7
#define FPV_hairspace 0xaa8
#define FPV_emdash 0xaa9
#define FPV_endash 0xaaa
#define FPV_signifblank 0xaac
#define FPV_ellipsis 0xaae
#define FPV_doubbaselinedot 0xaaf
#define FPV_onethird 0xab0
#define FPV_twothirds 0xab1
#define FPV_onefifth 0xab2
#define FPV_twofifths 0xab3
#define FPV_threefifths 0xab4
#define FPV_fourfifths 0xab5
#define FPV_onesixth 0xab6
#define FPV_fivesixths 0xab7
#define FPV_careof 0xab8
#define FPV_figdash 0xabb
#define FPV_leftanglebracket 0xabc
#define FPV_decimalpoint 0xabd
#define FPV_rightanglebracket 0xabe
#define FPV_marker 0xabf
#define FPV_oneeighth 0xac3
#define FPV_threeeighths 0xac4
#define FPV_fiveeighths 0xac5
#define FPV_seveneighths 0xac6
#define FPV_trademark 0xac9
#define FPV_signaturemark 0xaca
#define FPV_trademarkincircle 0xacb
#define FPV_leftopentriangle 0xacc
#define FPV_rightopentriangle 0xacd
#define FPV_emopencircle 0xace
#define FPV_emopenrectangle 0xacf
#define FPV_leftsinglequotemark 0xad0
#define FPV_rightsinglequotemark 0xad1
#define FPV_leftdoublequotemark 0xad2
#define FPV_rightdoublequotemark 0xad3
#define FPV_prescription 0xad4
#define FPV_minutes 0xad6
#define FPV_seconds 0xad7
#define FPV_latincross 0xad9
#define FPV_hexagram 0xada
#define FPV_filledrectbullet 0xadb
#define FPV_filledlefttribullet 0xadc
#define FPV_filledrighttribullet 0xadd
#define FPV_emfilledcircle 0xade
#define FPV_emfilledrect 0xadf
#define FPV_enopencircbullet 0xae0
#define FPV_enopensquarebullet 0xae1
#define FPV_openrectbullet 0xae2
#define FPV_opentribulletup 0xae3
#define FPV_opentribulletdown 0xae4
#define FPV_openstar 0xae5
#define FPV_enfilledcircbullet 0xae6
#define FPV_enfilledsqbullet 0xae7
#define FPV_filledtribulletup 0xae8
#define FPV_filledtribulletdown 0xae9
#define FPV_leftpointer 0xaea
#define FPV_rightpointer 0xaeb
#define FPV_club 0xaec
#define FPV_diamond 0xaed
#define FPV_heart 0xaee
#define FPV_maltesecross 0xaf0
#define FPV_dagger 0xaf1
#define FPV_doubledagger 0xaf2
#define FPV_checkmark 0xaf3
#define FPV_ballotcross 0xaf4
#define FPV_musicalsharp 0xaf5
#define FPV_musicalflat 0xaf6
#define FPV_malesymbol 0xaf7
#define FPV_femalesymbol 0xaf8
#define FPV_telephone 0xaf9
#define FPV_telephonerecorder 0xafa
#define FPV_phonographcopyright 0xafb
#define FPV_caret 0xafc
#define FPV_singlelowquotemark 0xafd
#define FPV_doublelowquotemark 0xafe
#define FPV_cursor 0xaff
#define FPV_leftcaret 0xba3
#define FPV_rightcaret 0xba6
#define FPV_downcaret 0xba8
#define FPV_upcaret 0xba9
#define FPV_overbar 0xbc0
#define FPV_downtack 0xbc2
#define FPV_upshoe 0xbc3
#define FPV_downstile 0xbc4
#define FPV_underbar 0xbc6
#define FPV_jot 0xbca
#define FPV_quad 0xbcc
#define FPV_uptack 0xbce
#define FPV_circle 0xbcf
#define FPV_upstile 0xbd3
#define FPV_downshoe 0xbd6
#define FPV_rightshoe 0xbd8
#define FPV_leftshoe 0xbda
#define FPV_lefttack 0xbdc
#define FPV_righttack 0xbfc
#define FPV_hebrew_doublelowline 0xcdf
#define FPV_hebrew_aleph 0xce0
#define FPV_hebrew_bet 0xce1
#define FPV_hebrew_beth 0xce1
#define FPV_hebrew_gimel 0xce2
#define FPV_hebrew_gimmel 0xce2
#define FPV_hebrew_dalet 0xce3
#define FPV_hebrew_daleth 0xce3
#define FPV_hebrew_he 0xce4
#define FPV_hebrew_waw 0xce5
#define FPV_hebrew_zain 0xce6
#define FPV_hebrew_zayin 0xce6
#define FPV_hebrew_chet 0xce7
#define FPV_hebrew_het 0xce7
#define FPV_hebrew_tet 0xce8
#define FPV_hebrew_teth 0xce8
#define FPV_hebrew_yod 0xce9
#define FPV_hebrew_finalkaph 0xcea
#define FPV_hebrew_kaph 0xceb
#define FPV_hebrew_lamed 0xcec
#define FPV_hebrew_finalmem 0xced
#define FPV_hebrew_mem 0xcee
#define FPV_hebrew_finalnun 0xcef
#define FPV_hebrew_nun 0xcf0
#define FPV_hebrew_samech 0xcf1
#define FPV_hebrew_samekh 0xcf1
#define FPV_hebrew_ayin 0xcf2
#define FPV_hebrew_finalpe 0xcf3
#define FPV_hebrew_pe 0xcf4
#define FPV_hebrew_finalzade 0xcf5
#define FPV_hebrew_finalzadi 0xcf5
#define FPV_hebrew_zade 0xcf6
#define FPV_hebrew_zadi 0xcf6
#define FPV_hebrew_qoph 0xcf7
#define FPV_hebrew_kuf 0xcf7
#define FPV_hebrew_resh 0xcf8
#define FPV_hebrew_shin 0xcf9
#define FPV_hebrew_taw 0xcfa
#define FPV_hebrew_taf 0xcfa
#define FPV_Hebrew_switch 0xFF7E
#define FPV_Thai_kokai 0xda1
#define FPV_Thai_khokhai 0xda2
#define FPV_Thai_khokhuat 0xda3
#define FPV_Thai_khokhwai 0xda4
#define FPV_Thai_khokhon 0xda5
#define FPV_Thai_khorakhang 0xda6
#define FPV_Thai_ngongu 0xda7
#define FPV_Thai_chochan 0xda8
#define FPV_Thai_choching 0xda9
#define FPV_Thai_chochang 0xdaa
#define FPV_Thai_soso 0xdab
#define FPV_Thai_chochoe 0xdac
#define FPV_Thai_yoying 0xdad
#define FPV_Thai_dochada 0xdae
#define FPV_Thai_topatak 0xdaf
#define FPV_Thai_thothan 0xdb0
#define FPV_Thai_thonangmontho 0xdb1
#define FPV_Thai_thophuthao 0xdb2
#define FPV_Thai_nonen 0xdb3
#define FPV_Thai_dodek 0xdb4
#define FPV_Thai_totao 0xdb5
#define FPV_Thai_thothung 0xdb6
#define FPV_Thai_thothahan 0xdb7
#define FPV_Thai_thothong 0xdb8
#define FPV_Thai_nonu 0xdb9
#define FPV_Thai_bobaimai 0xdba
#define FPV_Thai_popla 0xdbb
#define FPV_Thai_phophung 0xdbc
#define FPV_Thai_fofa 0xdbd
#define FPV_Thai_phophan 0xdbe
#define FPV_Thai_fofan 0xdbf
#define FPV_Thai_phosamphao 0xdc0
#define FPV_Thai_moma 0xdc1
#define FPV_Thai_yoyak 0xdc2
#define FPV_Thai_rorua 0xdc3
#define FPV_Thai_ru 0xdc4
#define FPV_Thai_loling 0xdc5
#define FPV_Thai_lu 0xdc6
#define FPV_Thai_wowaen 0xdc7
#define FPV_Thai_sosala 0xdc8
#define FPV_Thai_sorusi 0xdc9
#define FPV_Thai_sosua 0xdca
#define FPV_Thai_hohip 0xdcb
#define FPV_Thai_lochula 0xdcc
#define FPV_Thai_oang 0xdcd
#define FPV_Thai_honokhuk 0xdce
#define FPV_Thai_paiyannoi 0xdcf
#define FPV_Thai_saraa 0xdd0
#define FPV_Thai_maihanakat 0xdd1
#define FPV_Thai_saraaa 0xdd2
#define FPV_Thai_saraam 0xdd3
#define FPV_Thai_sarai 0xdd4
#define FPV_Thai_saraii 0xdd5
#define FPV_Thai_saraue 0xdd6
#define FPV_Thai_sarauee 0xdd7
#define FPV_Thai_sarau 0xdd8
#define FPV_Thai_sarauu 0xdd9
#define FPV_Thai_phinthu 0xdda
#define FPV_Thai_maihanakat_maitho 0xdde
#define FPV_Thai_baht 0xddf
#define FPV_Thai_sarae 0xde0
#define FPV_Thai_saraae 0xde1
#define FPV_Thai_sarao 0xde2
#define FPV_Thai_saraaimaimuan 0xde3
#define FPV_Thai_saraaimaimalai 0xde4
#define FPV_Thai_lakkhangyao 0xde5
#define FPV_Thai_maiyamok 0xde6
#define FPV_Thai_maitaikhu 0xde7
#define FPV_Thai_maiek 0xde8
#define FPV_Thai_maitho 0xde9
#define FPV_Thai_maitri 0xdea
#define FPV_Thai_maichattawa 0xdeb
#define FPV_Thai_thanthakhat 0xdec
#define FPV_Thai_nikhahit 0xded
#define FPV_Thai_leksun 0xdf0
#define FPV_Thai_leknung 0xdf1
#define FPV_Thai_leksong 0xdf2
#define FPV_Thai_leksam 0xdf3
#define FPV_Thai_leksi 0xdf4
#define FPV_Thai_lekha 0xdf5
#define FPV_Thai_lekhok 0xdf6
#define FPV_Thai_lekchet 0xdf7
#define FPV_Thai_lekpaet 0xdf8
#define FPV_Thai_lekkao 0xdf9
#define FPV_Hangul 0xff31
#define FPV_Hangul_Start 0xff32
#define FPV_Hangul_End 0xff33
#define FPV_Hangul_Hanja 0xff34
#define FPV_Hangul_Jamo 0xff35
#define FPV_Hangul_Romaja 0xff36
#define FPV_Hangul_Codeinput 0xff37
#define FPV_Hangul_Jeonja 0xff38
#define FPV_Hangul_Banja 0xff39
#define FPV_Hangul_PreHanja 0xff3a
#define FPV_Hangul_PostHanja 0xff3b
#define FPV_Hangul_SingleCandidate 0xff3c
#define FPV_Hangul_MultipleCandidate 0xff3d
#define FPV_Hangul_PreviousCandidate 0xff3e
#define FPV_Hangul_Special 0xff3f
#define FPV_Hangul_switch 0xFF7E
#define FPV_Hangul_Kiyeog 0xea1
#define FPV_Hangul_SsangKiyeog 0xea2
#define FPV_Hangul_KiyeogSios 0xea3
#define FPV_Hangul_Nieun 0xea4
#define FPV_Hangul_NieunJieuj 0xea5
#define FPV_Hangul_NieunHieuh 0xea6
#define FPV_Hangul_Dikeud 0xea7
#define FPV_Hangul_SsangDikeud 0xea8
#define FPV_Hangul_Rieul 0xea9
#define FPV_Hangul_RieulKiyeog 0xeaa
#define FPV_Hangul_RieulMieum 0xeab
#define FPV_Hangul_RieulPieub 0xeac
#define FPV_Hangul_RieulSios 0xead
#define FPV_Hangul_RieulTieut 0xeae
#define FPV_Hangul_RieulPhieuf 0xeaf
#define FPV_Hangul_RieulHieuh 0xeb0
#define FPV_Hangul_Mieum 0xeb1
#define FPV_Hangul_Pieub 0xeb2
#define FPV_Hangul_SsangPieub 0xeb3
#define FPV_Hangul_PieubSios 0xeb4
#define FPV_Hangul_Sios 0xeb5
#define FPV_Hangul_SsangSios 0xeb6
#define FPV_Hangul_Ieung 0xeb7
#define FPV_Hangul_Jieuj 0xeb8
#define FPV_Hangul_SsangJieuj 0xeb9
#define FPV_Hangul_Cieuc 0xeba
#define FPV_Hangul_Khieuq 0xebb
#define FPV_Hangul_Tieut 0xebc
#define FPV_Hangul_Phieuf 0xebd
#define FPV_Hangul_Hieuh 0xebe
#define FPV_Hangul_A 0xebf
#define FPV_Hangul_AE 0xec0
#define FPV_Hangul_YA 0xec1
#define FPV_Hangul_YAE 0xec2
#define FPV_Hangul_EO 0xec3
#define FPV_Hangul_E 0xec4
#define FPV_Hangul_YEO 0xec5
#define FPV_Hangul_YE 0xec6
#define FPV_Hangul_O 0xec7
#define FPV_Hangul_WA 0xec8
#define FPV_Hangul_WAE 0xec9
#define FPV_Hangul_OE 0xeca
#define FPV_Hangul_YO 0xecb
#define FPV_Hangul_U 0xecc
#define FPV_Hangul_WEO 0xecd
#define FPV_Hangul_WE 0xece
#define FPV_Hangul_WI 0xecf
#define FPV_Hangul_YU 0xed0
#define FPV_Hangul_EU 0xed1
#define FPV_Hangul_YI 0xed2
#define FPV_Hangul_I 0xed3
#define FPV_Hangul_J_Kiyeog 0xed4
#define FPV_Hangul_J_SsangKiyeog 0xed5
#define FPV_Hangul_J_KiyeogSios 0xed6
#define FPV_Hangul_J_Nieun 0xed7
#define FPV_Hangul_J_NieunJieuj 0xed8
#define FPV_Hangul_J_NieunHieuh 0xed9
#define FPV_Hangul_J_Dikeud 0xeda
#define FPV_Hangul_J_Rieul 0xedb
#define FPV_Hangul_J_RieulKiyeog 0xedc
#define FPV_Hangul_J_RieulMieum 0xedd
#define FPV_Hangul_J_RieulPieub 0xede
#define FPV_Hangul_J_RieulSios 0xedf
#define FPV_Hangul_J_RieulTieut 0xee0
#define FPV_Hangul_J_RieulPhieuf 0xee1
#define FPV_Hangul_J_RieulHieuh 0xee2
#define FPV_Hangul_J_Mieum 0xee3
#define FPV_Hangul_J_Pieub 0xee4
#define FPV_Hangul_J_PieubSios 0xee5
#define FPV_Hangul_J_Sios 0xee6
#define FPV_Hangul_J_SsangSios 0xee7
#define FPV_Hangul_J_Ieung 0xee8
#define FPV_Hangul_J_Jieuj 0xee9
#define FPV_Hangul_J_Cieuc 0xeea
#define FPV_Hangul_J_Khieuq 0xeeb
#define FPV_Hangul_J_Tieut 0xeec
#define FPV_Hangul_J_Phieuf 0xeed
#define FPV_Hangul_J_Hieuh 0xeee
#define FPV_Hangul_RieulYeorinHieuh 0xeef
#define FPV_Hangul_SunkyeongeumMieum 0xef0
#define FPV_Hangul_SunkyeongeumPieub 0xef1
#define FPV_Hangul_PanSios 0xef2
#define FPV_Hangul_KkogjiDalrinIeung 0xef3
#define FPV_Hangul_SunkyeongeumPhieuf 0xef4
#define FPV_Hangul_YeorinHieuh 0xef5
#define FPV_Hangul_AraeA 0xef6
#define FPV_Hangul_AraeAE 0xef7
#define FPV_Hangul_J_PanSios 0xef8
#define FPV_Hangul_J_KkogjiDalrinIeung 0xef9
#define FPV_Hangul_J_YeorinHieuh 0xefa
#define FPV_Korean_Won 0xeff
#define FPV_EcuSign 0x20a0
#define FPV_ColonSign 0x20a1
#define FPV_CruzeiroSign 0x20a2
#define FPV_FFrancSign 0x20a3
#define FPV_LiraSign 0x20a4
#define FPV_MillSign 0x20a5
#define FPV_NairaSign 0x20a6
#define FPV_PesetaSign 0x20a7
#define FPV_RupeeSign 0x20a8
#define FPV_WonSign 0x20a9
#define FPV_NewSheqelSign 0x20aa
#define FPV_DongSign 0x20ab
#define FPV_EuroSign 0x20ac

#endif /* __FPV_KEYSYMS_H__ */
