/*
 *    WMAcpiLoad - A dockapp to monitor ACPI status
 *    Copyright (C) 2002  Thomas Nemeth <tnemeth@free.fr>
 *
 *    Patch by Alan Carriou <cariou_alan@yahoo.fr> (C) 2004-2005
 *
 *    Based on work by Seiichi SATO <ssato@sh.rim.or.jp>
 *    Copyright (C) 2001,2002  Seiichi SATO <ssato@sh.rim.or.jp>
 *    and on work by Mark Staggs <me@markstaggs.net>
 *    Copyright (C) 2002  Mark Staggs <me@markstaggs.net>

 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.

 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.

 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include "lib_acpi.h"
#include "wmacpiload.h"
#include "ac_adapter.h"

/************************************************************************
 * Global constants definitions
 ************************************************************************/

const char *const ac_adapter_dir = "/ac_adapter/";
const char *const ac_adapter_state_file = "/state";

/************************************************************************
 * Function definitions
 ************************************************************************/

void *
ac_adapter_init(struct dirent *fd)
{
    AC_adapter *acad;

    if (fd == NULL)
        return NULL;

    acad = malloc(sizeof(*acad));
    if (!acad) {
        fprintf(stderr, "%s : could not allocate memory for "
                "AC adapter information concerning AC Adapter '%s'\n",
                PACKAGE, fd->d_name);
        return NULL;
    }

    acad->status = Other;
    acad->name = NULL;
    acad->next = NULL;
    acad->statefile = NULL;

    acad->name = malloc(strlen(fd->d_name) + 1);
    if (acad->name == NULL) {
        fprintf(stderr, "%s : could not allocate memory "
                "for AC adapter name concerning AC adapter '%s'\n",
                PACKAGE, fd->d_name);
        free(acad);
        return NULL;
    }
    strcpy(acad->name, fd->d_name);

    acad->statefile =
        strcat4("/proc/acpi", ac_adapter_dir, acad->name,
                ac_adapter_state_file);
    if (acad->statefile == NULL) {
        fprintf(stderr, "%s : could not allocate memory "
                "for AC adapter statefile concerning AC adapter '%s'\n",
                PACKAGE, fd->d_name);
        free(acad->name);
        free(acad);
        return NULL;
    }

    if (verbose)
        printf("Found AC adapter %s\n", acad->name);

    return acad;
}

void
ac_adapter_update_status(AC_adapter *acad)
{
    char buf[10];

    if (acad != NULL) {
        if (parse_file(acad->statefile, "state:", buf, sizeof buf) != NULL) {
            if (strcmp(buf, "on-line") == 0) {
                if (verbose && (acad->status != On_line))
                    printf("AC adapter %s set on-line\n", acad->name);
                acad->status = On_line;
            } else if (strcmp(buf, "off-line") == 0) {
                if (verbose && (acad->status != Off_line))
                    printf("AC adapter %s set off-line\n", acad->name);
                acad->status = Off_line;
            } else {
                acad->status = Other;
            }
        } else {
            acad->status = Other;
        }
    }
}

void
ac_adapter_free(AC_adapter *acad)
{
    if (acad != NULL) {
        MYFREE(acad->name);
        MYFREE(acad->statefile);
        free(acad);
    }
}
