/*
* Copyright(c) 2018 Intel Corporation
* SPDX - License - Identifier: BSD - 2 - Clause - Patent
*/

#include "EbRateControlTables.h"
static const EB_Bit_Number initialRateControlSad64x64Tables[] = {				
	// QP = 0 NEW 			
	    0,	    0,	    0,	    0,
	    0,	    0,	19064,	21410,
	21781,	22938,	23734,	24222,
	24242,	24233,	24377,	26487,
	26950,	28615,	29670,	29941,
	29857,	29336,	29130,	29572,
	29583,	29507,	29359,	29711,
	29789,	29753,	29766,	29528,
	29487,	29511,	29611,	29756,
	29758,	29933,	30202,	30579,
	30618,	30870,	31006,	31339,
	31364,	31566,	31687,	31982,
	32063,	32155,	32396,	32551,
	32640,	32651,	32787,	32978,
	32923,	33063,	33139,	33235,
	33288,	33350,	33382,	34440,
	// QP = 1 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	18221,	20496,
	20860,	21997,	22789,	23260,
	23283,	23277,	23417,	25456,
	25906,	27517,	28544,	28819,
	28739,	28240,	28046,	28479,
	28492,	28419,	28277,	28619,
	28697,	28662,	28675,	28443,
	28404,	28427,	28526,	28669,
	28671,	28841,	29104,	29474,
	29512,	29758,	29891,	30218,
	30243,	30439,	30558,	30847,
	30927,	31019,	31253,	31404,
	31492,	31504,	31635,	31824,
	31767,	31908,	31983,	32076,
	32126,	32187,	32217,	33261,
	// QP = 2 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	17109,	19287,
	19632,	20731,	21499,	21947,
	21966,	21954,	22094,	24133,
	24583,	26189,	27209,	27477,
	27395,	26896,	26700,	27132,
	27142,	27071,	26926,	27266,
	27342,	27305,	27318,	27087,
	27048,	27072,	27169,	27312,
	27313,	27485,	27746,	28114,
	28151,	28395,	28528,	28851,
	28878,	29072,	29189,	29478,
	29557,	29647,	29879,	30031,
	30118,	30128,	30259,	30446,
	30389,	30528,	30601,	30694,
	30746,	30806,	30837,	31865,
	// QP = 3 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	16145,	18267,
	18604,	19688,	20447,	20882,
	20904,	20894,	21032,	23054,
	23498,	25089,	26096,	26357,
	26277,	25781,	25590,	26017,
	26029,	25959,	25818,	26156,
	26232,	26196,	26208,	25979,
	25939,	25963,	26059,	26201,
	26202,	26371,	26629,	26993,
	27030,	27271,	27404,	27723,
	27751,	27942,	28058,	28343,
	28421,	28510,	28740,	28892,
	28977,	28987,	29117,	29301,
	29246,	29381,	29456,	29546,
	29596,	29656,	29687,	30703,
	// QP = 4 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	14466,	16764,
	17121,	18263,	19044,	19493,
	19515,	19505,	19640,	21686,
	22138,	23742,	24755,	25011,
	24929,	24429,	24236,	24666,
	24677,	24609,	24468,	24812,
	24888,	24855,	24869,	24642,
	24603,	24628,	24726,	24869,
	24871,	25041,	25302,	25665,
	25703,	25944,	26077,	26400,
	26424,	26617,	26734,	27020,
	27096,	27186,	27416,	27566,
	27651,	27663,	27794,	27979,
	27922,	28058,	28132,	28222,
	28273,	28332,	28363,	29381,
	// QP = 5 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	13448,	15643,
	16002,	17119,	17892,	18326,
	18349,	18336,	18472,	20515,
	20962,	22564,	23574,	23823,
	23740,	23238,	23043,	23466,
	23475,	23407,	23267,	23607,
	23683,	23650,	23666,	23441,
	23404,	23430,	23527,	23671,
	23673,	23842,	24099,	24461,
	24497,	24738,	24869,	25189,
	25214,	25405,	25520,	25804,
	25880,	25970,	26197,	26346,
	26430,	26441,	26571,	26752,
	26698,	26831,	26906,	26996,
	27046,	27104,	27136,	28145,
	// QP = 6			
	    0,	    0,	    0,	    0,
	    0,	    0,	11823,	14174,
	14548,	15711,	16489,	16927,
	16944,	16927,	17066,	19162,
	19624,	21263,	22292,	22541,
	22456,	21939,	21736,	22163,
	22174,	22098,	21956,	22298,
	22374,	22342,	22357,	22134,
	22094,	22122,	22222,	22367,
	22370,	22543,	22805,	23170,
	23208,	23451,	23584,	23907,
	23931,	24126,	24243,	24529,
	24606,	24694,	24925,	25075,
	25161,	25172,	25302,	25486,
	25428,	25564,	25640,	25729,
	25779,	25838,	25869,	26882,
	// QP = 7 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	11047,	13263,
	13626,	14758,	15535,	15968,
	15989,	15973,	16111,	18171,
	18622,	20229,	21240,	21487,
	21403,	20895,	20697,	21116,
	21125,	21054,	20913,	21248,
	21322,	21290,	21305,	21086,
	21049,	21078,	21178,	21322,
	21325,	21495,	21752,	22112,
	22148,	22387,	22519,	22836,
	22860,	23051,	23166,	23447,
	23522,	23611,	23836,	23984,
	24068,	24079,	24208,	24387,
	24332,	24466,	24537,	24627,
	24677,	24735,	24764,	25766,
	// QP = 8 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	 9513,	11784,
	12142,	13291,	14070,	14500,
	14519,	14503,	14642,	16742,
	17200,	18832,	19854,	20099,
	20014,	19498,	19297,	19720,
	19731,	19657,	19515,	19853,
	19926,	19893,	19907,	19687,
	19649,	19679,	19780,	19927,
	19930,	20102,	20362,	20726,
	20763,	21005,	21136,	21458,
	21482,	21675,	21791,	22074,
	22150,	22239,	22467,	22616,
	22699,	22712,	22840,	23022,
	22965,	23100,	23173,	23262,
	23313,	23371,	23401,	24404,
	// QP = 9			
	    0,	    0,	    0,	    0,
	    0,	    0,	 8757,	10863,
	11200,	12284,	13028,	13441,
	13460,	13449,	13589,	15669,
	16127,	17751,	18769,	19008,
	18923,	18408,	18205,	18625,
	18634,	18561,	18418,	18753,
	18828,	18795,	18807,	18587,
	18548,	18575,	18676,	18822,
	18826,	18997,	19255,	19619,
	19654,	19896,	20028,	20348,
	20372,	20564,	20679,	20963,
	21037,	21126,	21353,	21502,
	21584,	21596,	21725,	21906,
	21850,	21983,	22057,	22147,
	22195,	22254,	22284,	23283,
	// QP = 10 NEW			
				
	    0,	    0,	    0,	    0,
	    0,	    0,	 7397,	 9510,
	 9849,	10958,	11724,	12152,
	12174,	12162,	12304,	14418,
	14880,	16525,	17551,	17785,
	17697,	17172,	16963,	17382,
	17391,	17317,	17173,	17510,
	17585,	17553,	17566,	17348,
	17308,	17339,	17440,	17588,
	17592,	17764,	18025,	18389,
	18425,	18667,	18799,	19121,
	19145,	19337,	19453,	19735,
	19811,	19901,	20127,	20276,
	20361,	20370,	20500,	20680,
	20624,	20757,	20830,	20920,
	20969,	21028,	21057,	22059,
	// QP = 11 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	 6115,	 8119,
	 8448,	 9531,	10277,	10703,
	10726,	10716,	10862,	13003,
	13473,	15143,	16186,	16425,
	16335,	15800,	15587,	16006,
	16015,	15936,	15787,	16125,
	16201,	16167,	16181,	15959,
	15919,	15949,	16052,	16201,
	16205,	16379,	16643,	17012,
	17049,	17293,	17427,	17753,
	17775,	17971,	18089,	18375,
	18449,	18540,	18769,	18922,
	19006,	19015,	19146,	19329,
	19273,	19408,	19481,	19571,
	19620,	19679,	19709,	20724,
				
	// QP = 12 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	 5252,	 7138,
	 7459,	 8506,	 9229,	 9649,
	 9671,	 9663,	 9813,	11944,
	12414,	14077,	15119,	15365,
	15276,	14745,	14532,	14951,
	14960,	14880,	14730,	15065,
	15140,	15105,	15117,	14895,
	14855,	14885,	14988,	15136,
	15139,	15314,	15578,	15944,
	15982,	16227,	16360,	16686,
	16709,	16904,	17022,	17309,
	17384,	17473,	17705,	17854,
	17939,	17949,	18080,	18263,
	18206,	18341,	18416,	18505,
	18554,	18613,	18644,	19661,
				
	// QP = 13 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	 4362,	 6083,
	 6381,	 7376,	 8070,	 8477,
	 8501,	 8497,	 8654,	10759,
	11223,	12872,	13908,	14159,
	14073,	13550,	13343,	13759,
	13770,	13689,	13539,	13871,
	13947,	13909,	13919,	13694,
	13653,	13681,	13782,	13927,
	13931,	14103,	14365,	14731,
	14769,	15011,	15144,	15469,
	15492,	15686,	15803,	16089,
	16164,	16254,	16483,	16634,
	16717,	16728,	16860,	17041,
	16982,	17119,	17193,	17282,
	17332,	17391,	17421,	18442,
				
	// QP = 14			
	    0,	    0,	    0,	    0,
	    0,	    0,	 3448,	 4986,
	 5252,	 6165,	 6825,	 7218,
	 7242,	 7246,	 7404,	 9462,
	 9917,	11539,	12565,	12826,
	12742,	12232,	12031,	12452,
	12461,	12382,	12233,	12563,
	12640,	12601,	12608,	12376,
	12336,	12360,	12457,	12598,
	12601,	12771,	13030,	13394,
	13431,	13673,	13805,	14127,
	14150,	14343,	14461,	14745,
	14820,	14910,	15139,	15289,
	15374,	15384,	15515,	15699,
	15639,	15774,	15848,	15939,
	15987,	16047,	16078,	17105,
				
	// QP = 15 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	 2694,	 4201,
	 4438,	 5283,	 5894,	 6259,
	 6284,	 6296,	 6451,	 8442,
	 8883,	10461,	11463,	11729,
	11648,	11161,	10973,	11386,
	11395,	11322,	11178,	11505,
	11581,	11542,	11548,	11314,
	11274,	11293,	11386,	11519,
	11521,	11687,	11940,	12297,
	12333,	12569,	12698,	13016,
	13037,	13227,	13343,	13622,
	13696,	13784,	14012,	14158,
	14243,	14251,	14381,	14562,
	14505,	14639,	14712,	14801,
	14852,	14909,	14940,	15967,
				
	// QP = 16 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	 1798,	 3038,
	 3259,	 4010,	 4575,	 4973,
	 4994,	 5035,	 5185,	 7159,
	 7590,	 9156,	10154,	10429,
	10350,	 9874,	 9691,	10106,
	10117,	10042,	 9903,	10231,
	10305,	10266,	10272,	10034,
	 9993,	10009,	10099,	10226,
	10228,	10391,	10643,	10994,
	11032,	11267,	11395,	11711,
	11732,	11922,	12035,	12315,
	12389,	12476,	12701,	12849,
	12935,	12942,	13073,	13253,
	13195,	13329,	13403,	13490,
	13543,	13600,	13631,	14672,
				
	// QP = 17 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	 1179,	 2079,
	 2231,	 2726,	 2954,	 3449,
	 3505,	 3620,	 3838,	 5806,
	 6225,	 7771,	 8751,	 9036,
	 8968,	 8503,	 8335,	 8755,
	 8770,	 8701,	 8566,	 8899,
	 8970,	 8941,	 8944,	 8707,
	 8666,	 8679,	 8764,	 8885,
	 8887,	 9045,	 9293,	 9637,
	 9670,	 9900,	10027,	10336,
	10357,	10544,	10655,	10929,
	11002,	11089,	11309,	11456,
	11541,	11547,	11679,	11858,
	11797,	11931,	12005,	12092,
	12145,	12201,	12232,	13285,
				
	// QP = 18 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	  916,	 1661,
	 1767,	 2096,	 2049,	 2022,
	 2028,	 2223,	 2513,	 4678,
	 5145,	 6780,	 7769,	 8045,
	 7974,	 7493,	 7307,	 7726,
	 7747,	 7679,	 7536,	 7890,
	 7964,	 7952,	 7967,	 7769,
	 7725,	 7758,	 7857,	 7998,
	 8009,	 8165,	 8412,	 8769,
	 8795,	 9028,	 9151,	 9460,
	 9477,	 9664,	 9771,	10042,
	10110,	10199,	10413,	10558,
	10642,	10650,	10778,	10951,
	10893,	11025,	11095,	11183,
	11234,	11290,	11319,	12364,
				
	// QP = 19 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	  542,	 1148,
	 1245,	 1526,	 1487,	 1384,
	 1361,	 1477,	 1698,	 3622,
	 4078,	 5620,	 6583,	 6847,
	 6773,	 6303,	 6124,	 6529,
	 6546,	 6467,	 6333,	 6655,
	 6731,	 6712,	 6712,	 6514,
	 6461,	 6494,	 6610,	 6750,
	 6765,	 6927,	 7178,	 7536,
	 7557,	 7807,	 7933,	 8242,
	 8252,	 8442,	 8548,	 8811,
	 8887,	 8972,	 9181,	 9327,
	 9410,	 9414,	 9543,	 9715,
	 9661,	 9792,	 9859,	 9950,
	 9996,	10055,	10084,	11139,
				
    // QP = 20 NEW				
	    0,	    0,	    0,	    0,
	        0,	   0,	 452,	 957,
	      729,	 949,	1036,	1145,
	     1146,	1291,	1514,	2966,
	     3294,	4394,	5166,	5627,
	     5612,	5435,	5459,	6029,
	     6061,	6081,	6062,	6392,
	     6459,	6467,	6465,	6331,
	     6293,	6334,	6437,	6570,
	     6584,	6724,	6941,	7248,
	     7265,	7475,	7587,	7836,
	     7859,	8017,	8103,	8324,
	     8377,	8457,	8620,	8752,
	     8813,	8825,	8918,	9078,
	     9040,	9138,	9204,	9280,
	     9310,	9358,	9389,	10165,
	 			
     // QP = 21 NEW				
	    0,	    0,	    0,	    0,
	        0,	   0,	 376,	 797,
	      426,	 590,	 722,	 947,
	      965,	1129,	1350,	2429,
	     2660,	3435,	4054,	4625,
	     4649,	4687,	4867,	5566,
	     5612,	5719,	5802,	6139,
	     6197,	6231,	6226,	6153,
	     6129,	6178,	6269,	6395,
	     6408,	6527,	6712,	6970,
	     6984,	7158,	7255,	7450,
	     7484,	7613,	7680,	7863,
	     7897,	7972,	8093,	8213,
	     8254,	8273,	8334,	8483,
	     8459,	8527,	8593,	8655,
	     8670,	8709,	8741,	9277,
	 			
     // QP = 22 NEW				
	    0,	    0,	    0,	    0,
	        0,	   0,	 314,	 664,
	      249,	 366,	 503,	 783,
	      812,	 987,	1204,	1989,
	     2149,	2685,	3182,	3801,
	     3852,	4041,	4339,	5140,
	     5196,	5378,	5553,	5896,
	     5947,	6003,	5997,	5980,
	     5969,	6026,	6105,	6224,
	     6236,	6336,	6490,	6704,
	     6713,	6854,	6939,	7084,
	     7128,	7229,	7280,	7429,
	     7444,	7515,	7598,	7707,
	     7731,	7755,	7788,	7928,
	     7915,	7958,	8022,	8072,
	     8075,	8105,	8138,	8466,
	 			
     // QP = 23 NEW				
	    0,	    0,	    0,	    0,
	        0,	   0,	 261,	 554,
	      146,	 228,	 350,	 648,
	      684,	 863,	1074,	1629,
	     1735,	2099,	2497,	3124,
	     3192,	3485,	3868,	4746,
	     4811,	5057,	5315,	5662,
	     5706,	5784,	5776,	5812,
	     5814,	5877,	5946,	6058,
	     6069,	6151,	6276,	6447,
	     6454,	6563,	6636,	6735,
	     6788,	6865,	6901,	7018,
	     7017,	7084,	7134,	7233,
	     7240,	7270,	7278,	7408,
	     7407,	7426,	7489,	7529,
	     7520,	7543,	7577,	7726,
	 			
     // QP = 24 NEW				
	    0,	    0,	    0,	    0,
	        0,	   0,	 218,	 461,
	       85,	 142,	 244,	 536,
	      576,	 755,	 958,	1334,
	     1402,	1641,	1960,	2567,
	     2644,	3005,	3448,	4382,
	     4455,	4756,	5087,	5438,
	     5475,	5573,	5563,	5649,
	     5662,	5732,	5790,	5896,
	     5907,	5971,	6068,	6200,
	     6204,	6284,	6346,	6403,
	     6465,	6519,	6541,	6630,
	     6614,	6678,	6697,	6787,
	     6781,	6815,	6801,	6923,
	     6930,	6930,	6991,	7022,
	     7004,	7020,	7055,	7050,
				
	// QP = 25 NEW			
	    0,	    0,	    0,	    0,
	    0,	    7,	   19,	   48,
	   50,	   88,	  170,	  443,
	  485,	  660,	  854,	 1092,
	 1132,	 1283,	 1538,	 2110,
	 2191,	 2591,	 3074,	 4046,
	 4125,	 4472,	 4869,	 5223,
	 5254,	 5369,	 5358,	 5490,
	 5515,	 5591,	 5639,	 5739,
	 5749,	 5796,	 5868,	 5963,
	 5964,	 6017,	 6069,	 6088,
	 6157,	 6191,	 6200,	 6263,
	 6235,	 6295,	 6288,	 6369,
	 6351,	 6389,	 6356,	 6469,
	 6485,	 6467,	 6527,	 6549,
	 6523,	 6533,	 6568,	 6434,
				
	// QP = 26 NEW			
	    0,	    0,	    0,	    0,
	    0,	    2,	   12,	   29,
	   30,	   53,	  105,	  283,
	  312,	  427,	  547,	  665,
	  688,	  779,	  939,	 1306,
	 1368,	 1691,	 2049,	 2499,
	 2514,	 2684,	 3153,	 3834,
	 3904,	 4189,	 4290,	 4491,
	 4525,	 4616,	 4670,	 4774,
	 4786,	 4830,	 4900,	 4991,
	 4994,	 5042,	 5092,	 5118,
	 5181,	 5213,	 5226,	 5284,
	 5262,	 5315,	 5314,	 5395,
	 5375,	 5408,	 5390,	 5488,
	 5504,	 5491,	 5546,	 5570,
	 5553,	 5558,	 5590,	 5504,
				
	// QP = 27 NEW			
	    0,	    0,	    0,	    0,
	    0,	    2,	    9,	   20,
	   20,	   35,	   70,	  190,
	  209,	  286,	  359,	  385,
	  384,	  393,	  484,	  662,
	  712,	  968,	 1221,	 1573,
	 1587,	 1801,	 2134,	 2454,
	 2505,	 2685,	 2843,	 3315,
	 3389,	 3633,	 3793,	 3968,
	 3984,	 4036,	 4110,	 4205,
	 4205,	 4255,	 4304,	 4332,
	 4386,	 4419,	 4433,	 4492,
	 4477,	 4522,	 4530,	 4603,
	 4583,	 4616,	 4602,	 4693,
	 4707,	 4702,	 4745,	 4770,
	 4759,	 4766,	 4795,	 4750,
				
	// QP = 28 NEW			
	    0,	    0,	    0,	    0,
	    0,	    1,	    7,	   15,
	   15,	   24,	   49,	  132,
	  145,	  197,	  245,	  248,
	  243,	  230,	  276,	  379,
	  412,	  570,	  733,	 1049,
	 1069,	 1175,	 1285,	 1532,
	 1586,	 1759,	 1918,	 2225,
	 2276,	 2507,	 2752,	 3096,
	 3114,	 3240,	 3344,	 3460,
	 3463,	 3518,	 3571,	 3606,
	 3650,	 3684,	 3704,	 3760,
	 3746,	 3788,	 3800,	 3872,
	 3854,	 3885,	 3877,	 3961,
	 3973,	 3972,	 4010,	 4031,
	 4032,	 4037,	 4067,	 4060,
				
	// QP = 29 NEW			
	    0,	    0,	    0,	    0,
	    0,	    2,	    6,	   11,
	   11,	   18,	   36,	   94,
	  103,	  139,	  171,	  169,
	  165,	  151,	  179,	  245,
	  263,	  363,	  462,	  673,
	  696,	  790,	  868,	 1058,
	 1097,	 1227,	 1368,	 1612,
	 1652,	 1818,	 2013,	 2315,
	 2335,	 2471,	 2595,	 2743,
	 2753,	 2818,	 2881,	 2923,
	 2963,	 2994,	 3022,	 3074,
	 3067,	 3105,	 3120,	 3186,
	 3167,	 3199,	 3201,	 3272,
	 3283,	 3287,	 3321,	 3340,
	 3348,	 3350,	 3377,	 3410,
				
	// QP = 30 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    5,	    9,
	    9,	   14,	   28,	   71,
	   77,	  104,	  126,	  123,
	  120,	  108,	  128,	  176,
	  188,	  257,	  322,	  473,
	  496,	  555,	  585,	  737,
	  775,	  902,	 1049,	 1262,
	 1293,	 1425,	 1590,	 1842,
	 1865,	 1994,	 2118,	 2279,
	 2297,	 2371,	 2451,	 2514,
	 2548,	 2589,	 2620,	 2679,
	 2677,	 2714,	 2729,	 2789,
	 2777,	 2809,	 2809,	 2881,
	 2887,	 2891,	 2920,	 2936,
	 2958,	 2954,	 2978,	 3037,
				
	// QP = 31 NEW			
	    0,	    0,	    0,	    0,
	    0,	    1,	    4,	    8,
	    7,	   11,	   21,	   52,
	   57,	   75,	   91,	   87,
	   85,	   76,	   90,	  122,
	  129,	  175,	  219,	  328,
	  346,	  395,	  404,	  511,
	  537,	  628,	  759,	  937,
	  968,	 1073,	 1197,	 1400,
	 1418,	 1520,	 1622,	 1771,
	 1783,	 1855,	 1933,	 2004,
	 2030,	 2070,	 2114,	 2175,
	 2177,	 2210,	 2232,	 2289,
	 2277,	 2305,	 2313,	 2378,
	 2384,	 2390,	 2414,	 2428,
	 2454,	 2450,	 2475,	 2562,
				
	// QP = 32 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    3,	    6,
	    6,	    9,	   16,	   39,
	   42,	   55,	   66,	   63,
	   61,	   55,	   65,	   87,
	   92,	  123,	  154,	  234,
	  247,	  285,	  289,	  367,
	  386,	  456,	  563,	  704,
	  728,	  808,	  906,	 1061,
	 1083,	 1160,	 1245,	 1369,
	 1376,	 1443,	 1516,	 1590,
	 1611,	 1650,	 1694,	 1756,
	 1763,	 1793,	 1815,	 1870,
	 1861,	 1887,	 1899,	 1955,
	 1959,	 1968,	 1986,	 2004,
	 2031,	 2027,	 2048,	 2152,
				
	// QP = 33 NEW 			
	    0,	    0,	    0,	    0,
	    0,	    1,	    3,	    5,
	    5,	    7,	   13,	   30,
	   32,	   42,	   50,	   47,
	   45,	   41,	   48,	   65,
	   68,	   90,	  113,	  172,
	  183,	  211,	  212,	  271,
	  285,	  338,	  426,	  533,
	  557,	  619,	  696,	  818,
	  835,	  898,	  966,	 1067,
	 1077,	 1131,	 1195,	 1273,
	 1286,	 1329,	 1381,	 1443,
	 1454,	 1486,	 1507,	 1561,
	 1553,	 1580,	 1592,	 1641,
	 1646,	 1656,	 1671,	 1688,
	 1713,	 1712,	 1733,	 1841,
				
	// QP = 34 NEW 			
	    0,	    0,	    0,	    0,
	    0,	    0,	    2,	    4,
	    4,	    6,	   10,	   23,
	   25,	   32,	   38,	   35,
	   34,	   31,	   36,	   49,
	   52,	   68,	   85,	  130,
	  139,	  161,	  161,	  205,
	  216,	  258,	  330,	  414,
	  435,	  482,	  546,	  642,
	  654,	  705,	  757,	  840,
	  847,	  894,	  949,	 1017,
	 1028,	 1074,	 1118,	 1195,
	 1199,	 1239,	 1262,	 1318,
	 1315,	 1339,	 1352,	 1398,
	 1402,	 1410,	 1425,	 1440,
	 1467,	 1466,	 1483,	 1591,
				
	// QP = 35 NEW 			
	    0,	    0,	    0,	    0,
	    0,	    0,	    2,	    3,
	    3,	    5,	    8,	   19,
	   20,	   25,	   30,	   27,
	   26,	   23,	   28,	   38,
	   41,	   53,	   66,	  101,
	  107,	  125,	  124,	  160,
	  169,	  203,	  262,	  331,
	  348,	  387,	  441,	  523,
	  529,	  569,	  616,	  685,
	  692,	  729,	  774,	  838,
	  841,	  877,	  925,	  995,
	 1004,	 1051,	 1076,	 1132,
	 1137,	 1164,	 1180,	 1223,
	 1228,	 1237,	 1249,	 1266,
	 1293,	 1288,	 1309,	 1419,
				
	// QP = 36 NEW 			
	    0,	    0,	    0,	    0,
	    0,	    1,	    1,	    3,
	    3,	    4,	    7,	   15,
	   16,	   20,	   23,	   21,
	   20,	   18,	   22,	   30,
	   32,	   41,	   51,	   77,
	   82,	   96,	   95,	  124,
	  130,	  158,	  204,	  261,
	  275,	  307,	  353,	  422,
	  428,	  465,	  503,	  562,
	  568,	  601,	  641,	  700,
	  700,	  733,	  772,	  835,
	  842,	  887,	  911,	  961,
	  972,	  994,	 1015,	 1056,
	 1060,	 1072,	 1083,	 1099,
	 1124,	 1125,	 1142,	 1246,
				
	// QP = 37 NEW			
	    0,	    0,	    0,	    0,
	    0,	    1,	    1,	    2,
	    2,	    3,	    6,	   12,
	   13,	   16,	   19,	   17,
	   16,	   15,	   17,	   24,
	   26,	   33,	   41,	   62,
	   66,	   77,	   76,	   98,
	  104,	  127,	  165,	  211,
	  223,	  250,	  290,	  349,
	  356,	  388,	  422,	  474,
	  483,	  511,	  547,	  604,
	  602,	  632,	  668,	  725,
	  735,	  772,	  796,	  840,
	  853,	  874,	  894,	  929,
	  937,	  951,	  960,	  977,
	  999,	 1001,	 1018,	 1120,
				
	// QP = 38 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    1,	    2,
	    2,	    3,	    5,	   10,
	   11,	   13,	   15,	   14,
	   13,	   12,	   14,	   19,
	   20,	   26,	   33,	   48,
	   51,	   59,	   58,	   76,
	   80,	   98,	  127,	  163,
	  174,	  195,	  229,	  277,
	  283,	  310,	  339,	  383,
	  392,	  417,	  448,	  499,
	  497,	  524,	  556,	  605,
	  615,	  646,	  669,	  706,
	  718,	  736,	  757,	  787,
	  795,	  808,	  816,	  833,
	  852,	  853,	  871,	  965,
				
	// QP = 39 NEW			
	    0,	    0,	    0,	    0,
	    0,	    1,	    1,	    2,
	    2,	    2,	    4,	    8,
	    9,	   11,	   12,	   11,
	   11,	    9,	   11,	   16,
	   17,	   21,	   26,	   39,
	   41,	   47,	   46,	   60,
	   63,	   77,	  101,	  130,
	  137,	  154,	  183,	  225,
	  230,	  252,	  278,	  317,
	  326,	  351,	  376,	  427,
	  424,	  447,	  479,	  524,
	  534,	  562,	  583,	  618,
	  630,	  647,	  668,	  698,
	  703,	  718,	  727,	  745,
	  761,	  763,	  779,	  873,
				
	// QP = 40 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    1,	    1,
	    1,	    2,	    3,	    7,
	    7,	    9,	   10,	    9,
	    8,	    8,	    9,	   13,
	   14,	   17,	   21,	   30,
	   32,	   37,	   36,	   46,
	   48,	   59,	   77,	   99,
	  105,	  119,	  141,	  175,
	  178,	  200,	  220,	  251,
	  261,	  280,	  301,	  348,
	  344,	  365,	  395,	  432,
	  440,	  464,	  488,	  517,
	  528,	  544,	  563,	  592,
	  597,	  610,	  620,	  637,
	  652,	  655,	  671,	  759,
				
	// QP = 41 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    1,	    1,
	    1,	    2,	    3,	    6,
	    6,	    7,	    8,	    7,
	    7,	    6,	    7,	   10,
	   11,	   14,	   17,	   25,
	   26,	   30,	   29,	   36,
	   38,	   46,	   61,	   77,
	   82,	   92,	  111,	  137,
	  141,	  157,	  174,	  201,
	  209,	  227,	  243,	  286,
	  280,	  299,	  326,	  359,
	  368,	  390,	  408,	  437,
	  446,	  461,	  481,	  511,
	  515,	  529,	  539,	  556,
	  571,	  577,	  591,	  679,
				
	// QP = 42 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    1,	    1,
	    1,	    1,	    2,	    5,
	    5,	    6,	    7,	    6,
	    6,	    5,	    6,	    8,
	    9,	   11,	   14,	   20,
	   20,	   23,	   22,	   28,
	   29,	   35,	   47,	   58,
	   63,	   70,	   85,	  105,
	  108,	  122,	  133,	  156,
	  162,	  177,	  188,	  225,
	  220,	  235,	  259,	  286,
	  296,	  314,	  328,	  353,
	  363,	  375,	  395,	  421,
	  426,	  440,	  448,	  469,
	  478,	  490,	  500,	  588,
				
	// QP = 43 NEW 			
	    0,	    0,	    0,	    0,
	    0,	    0,	    1,	    1,
	    1,	    1,	    2,	    4,
	    4,	    5,	    6,	    5,
	    5,	    4,	    5,	    7,
	    7,	    9,	   11,	   16,
	   17,	   19,	   18,	   23,
	   24,	   28,	   38,	   46,
	   49,	   55,	   67,	   83,
	   85,	   97,	  105,	  123,
	  128,	  141,	  149,	  180,
	  176,	  188,	  209,	  230,
	  239,	  256,	  268,	  290,
	  297,	  311,	  328,	  349,
	  356,	  367,	  377,	  396,
	  404,	  418,	  430,	  521,
				
	// QP = 44 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    1,	    1,
	    1,	    1,	    2,	    3,
	    3,	    4,	    5,	    4,
	    4,	    3,	    4,	    6,
	    6,	    8,	    9,	   13,
	   13,	   15,	   14,	   18,
	   19,	   22,	   29,	   36,
	   38,	   43,	   51,	   64,
	   66,	   75,	   82,	   96,
	  100,	  110,	  115,	  140,
	  137,	  146,	  163,	  180,
	  189,	  200,	  211,	  228,
	  234,	  247,	  261,	  279,
	  282,	  295,	  301,	  320,
	  328,	  341,	  349,	  437,
				
	// QP = 45 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    1,	    1,
	    1,	    1,	    1,	    3,
	    3,	    3,	    4,	    3,
	    3,	    3,	    3,	    5,
	    5,	    6,	    7,	   10,
	   10,	   12,	   11,	   14,
	   14,	   17,	   23,	   28,
	   29,	   33,	   40,	   49,
	   51,	   59,	   63,	   74,
	   78,	   85,	   89,	  110,
	  106,	  114,	  128,	  141,
	  147,	  157,	  166,	  180,
	  186,	  196,	  208,	  223,
	  226,	  238,	  242,	  260,
	  266,	  278,	  288,	  371,
				
	// QP = 46 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	    1,
	    1,	    1,	    1,	    2,
	    2,	    3,	    3,	    3,
	    3,	    2,	    3,	    4,
	    4,	    5,	    6,	    8,
	    8,	   10,	    9,	   11,
	   12,	   14,	   18,	   22,
	   23,	   26,	   31,	   39,
	   41,	   46,	   50,	   57,
	   61,	   67,	   70,	   86,
	   84,	   91,	  102,	  111,
	  117,	  125,	  131,	  143,
	  149,	  157,	  167,	  179,
	  180,	  191,	  197,	  212,
	  215,	  226,	  235,	  312,
				
	// QP = 47 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	    1,
	    0,	    1,	    1,	    2,
	    2,	    2,	    3,	    2,
	    2,	    2,	    2,	    3,
	    3,	    4,	    5,	    7,
	    7,	    8,	    7,	    9,
	    9,	   11,	   15,	   18,
	   18,	   20,	   25,	   31,
	   32,	   36,	   39,	   46,
	   48,	   52,	   55,	   68,
	   66,	   71,	   80,	   88,
	   92,	   97,	  103,	  113,
	  117,	  123,	  133,	  143,
	  145,	  154,	  158,	  170,
	  174,	  184,	  189,	  260,
				
	// QP = 48 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	    0,
	    0,	    1,	    1,	    2,
	    2,	    2,	    2,	    2,
	    2,	    2,	    2,	    3,
	    3,	    3,	    4,	    5,
	    5,	    6,	    6,	    7,
	    8,	    9,	   12,	   14,
	   15,	   16,	   20,	   24,
	   25,	   29,	   31,	   36,
	   38,	   41,	   44,	   54,
	   52,	   56,	   64,	   70,
	   73,	   77,	   82,	   91,
	   94,	  100,	  106,	  115,
	  116,	  124,	  129,	  138,
	  141,	  150,	  155,	  218,
				
	// QP = 49 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	    0,
	    0,	    0,	    1,	    1,
	    1,	    2,	    2,	    2,
	    1,	    1,	    2,	    2,
	    2,	    3,	    3,	    4,
	    4,	    5,	    5,	    6,
	    6,	    7,	    9,	   11,
	   12,	   13,	   16,	   19,
	   20,	   23,	   25,	   29,
	   30,	   33,	   35,	   43,
	   41,	   45,	   50,	   55,
	   59,	   61,	   65,	   73,
	   76,	   80,	   86,	   92,
	   93,	   99,	  104,	  112,
	  114,	  121,	  127,	  181,
				
	// QP = 50			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	    0,
	    0,	    0,	    1,	    1,
	    1,	    1,	    2,	    1,
	    1,	    1,	    1,	    2,
	    2,	    2,	    3,	    4,
	    4,	    4,	    4,	    5,
	    5,	    6,	    8,	    9,
	   10,	   11,	   13,	   16,
	   16,	   18,	   20,	   23,
	   24,	   26,	   28,	   35,
	   32,	   35,	   40,	   44,
	   46,	   48,	   52,	   57,
	   60,	   64,	   67,	   73,
	   74,	   79,	   83,	   90,
	   91,	   97,	  102,	  148,
				
	// QP = 51			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	    1,
	    1,	    1,	    1,	    1,
	    1,	    1,	    1,	    2,
	    2,	    2,	    2,	    3,
	    3,	    4,	    3,	    4,
	    4,	    5,	    6,	    7,
	    8,	    9,	   11,	   13,
	   14,	   15,	   16,	   19,
	   20,	   21,	   22,	   28,
	   26,	   29,	   32,	   35,
	   38,	   39,	   42,	   46,
	   49,	   52,	   54,	   60,
	   61,	   64,	   67,	   73,
	   73,	   77,	   83,	  122,
};				
				
				
				
static const EB_Bit_Number initialRateControlIntraSad64x64Tables[] = {				
	// QP = 0 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	22636,
	22804,	23718,	23852,	24210,
	23882,	24027,	24723,	25937,
	24896,	27051,	30603,	31453,
	30784,	29404,	30546,	31836,
	32090,	31576,	31532,	32354,
	31761,	32869,	32349,	31100,
	32368,	32773,	31148,	31299,
	32400,	31203,	32530,	33114,
	31942,	32664,	33074,	32774,
	32967,	33796,	34026,	33873,
	34018,	33566,	33505,	33776,
	34656,	33412,	33047,	34654,
	34543,	33790,	34751,	34184,
	34744,	34563,	34510,	35474,
	// QP = 1 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	21659,
	21816,	22686,	22860,	23146,
	22961,	22904,	23810,	24897,
	23850,	26033,	29440,	30276,
	29599,	28297,	29378,	30650,
	30930,	30445,	30407,	31191,
	30586,	31676,	31198,	30016,
	31223,	31615,	30048,	30194,
	31185,	30078,	31338,	31915,
	30882,	31510,	31926,	31660,
	31791,	32623,	32868,	32707,
	32824,	32408,	32327,	32611,
	33459,	32300,	31943,	33432,
	33331,	32635,	33511,	33026,
	33511,	33404,	33292,	34267,
	// QP = 2			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	20399,
	20567,	21406,	21530,	21929,
	21604,	21684,	22474,	23556,
	22611,	24706,	28076,	28899,
	28275,	26929,	28047,	29297,
	29548,	29095,	29020,	29833,
	29249,	30324,	29833,	28626,
	29780,	30181,	28604,	28818,
	29824,	28750,	29998,	30512,
	29412,	30121,	30537,	30248,
	30429,	31252,	31414,	31288,
	31421,	30982,	30933,	31208,
	32051,	30854,	30518,	31943,
	31952,	31237,	32142,	31609,
	32102,	31959,	31906,	32837,
	// QP = 3			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	19278,
	19449,	20318,	20495,	20815,
	20537,	20503,	21392,	22463,
	21541,	23616,	26914,	27740,
	27129,	25796,	26901,	28122,
	28442,	27938,	27874,	28713,
	28091,	29162,	28709,	27509,
	28679,	29114,	27560,	27700,
	28685,	27664,	28835,	29447,
	28371,	28998,	29423,	29193,
	29293,	30094,	30347,	30154,
	30299,	29876,	29795,	30090,
	30902,	29774,	29426,	30865,
	30778,	30106,	30959,	30464,
	30976,	30850,	30753,	31702,
	// QP = 4			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	18171,
	18354,	19219,	19332,	19723,
	19474,	19490,	20348,	21392,
	20368,	22505,	25809,	26611,
	25991,	24661,	25761,	26942,
	27288,	26798,	26731,	27550,
	26911,	28042,	27558,	26384,
	27526,	27936,	26419,	26553,
	27574,	26480,	27685,	28267,
	27204,	27832,	28294,	28032,
	28155,	28976,	29137,	28959,
	29115,	28814,	28717,	28962,
	29719,	28627,	28291,	29654,
	29652,	28941,	29761,	29304,
	29797,	29674,	29572,	30538,
	// QP = 5			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	17304,
	17457,	18373,	18467,	18776,
	18583,	18576,	19376,	20392,
	19573,	21570,	24793,	25581,
	24983,	23657,	24776,	25934,
	26202,	25721,	25718,	26507,
	25892,	26948,	26449,	25395,
	26469,	26895,	25391,	25548,
	26495,	25496,	26647,	27165,
	26147,	26758,	27200,	26942,
	27075,	27839,	28026,	27878,
	28012,	27638,	27560,	27891,
	28602,	27515,	27171,	28499,
	28483,	27837,	28660,	28174,
	28676,	28553,	28469,	29365,
	// QP = 6			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	15929,
	16089,	16985,	17125,	17491,
	17251,	17283,	18054,	19104,
	18314,	20221,	23516,	24335,
	23720,	22396,	23479,	24639,
	24980,	24523,	24413,	25215,
	24647,	25710,	25220,	24072,
	25195,	25631,	24133,	24282,
	25225,	24149,	25378,	25927,
	24881,	25491,	25929,	25656,
	25833,	26621,	26803,	26604,
	26773,	26352,	26292,	26584,
	27341,	26252,	25940,	27300,
	27286,	26603,	27454,	26947,
	27432,	27279,	27167,	28112,
	// QP = 7			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	14880,
	15069,	15956,	16137,	16474,
	16195,	16274,	17013,	18093,
	17175,	19187,	22485,	23231,
	22634,	21368,	22434,	23566,
	23858,	23427,	23355,	24114,
	23568,	24595,	24112,	23011,
	24110,	24575,	23075,	23184,
	24166,	23173,	24319,	24888,
	23815,	24442,	24833,	24637,
	24776,	25525,	25705,	25503,
	25659,	25296,	25215,	25490,
	26246,	25199,	24904,	26188,
	26180,	25489,	26316,	25833,
	26304,	26186,	26103,	27009,
	// QP = 8			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	13746,
	13894,	14720,	14893,	15257,
	14973,	15025,	15803,	16851,
	15988,	17920,	21188,	21995,
	21377,	20093,	21107,	22309,
	22570,	22144,	22077,	22829,
	22295,	23282,	22820,	21751,
	22828,	23247,	21787,	21932,
	22876,	21875,	23024,	23546,
	22486,	23156,	23575,	23275,
	23442,	24200,	24380,	24242,
	24385,	23965,	23914,	24167,
	24947,	23860,	23570,	24889,
	24872,	24182,	25009,	24486,
	25011,	24872,	24812,	25682,
	// QP = 9 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	12644,
	12844,	13728,	13872,	14304,
	14018,	13956,	14863,	15842,
	14974,	16981,	20166,	20918,
	20330,	19073,	20106,	21294,
	21529,	21121,	21044,	21784,
	21235,	22283,	21797,	20747,
	21782,	22261,	20823,	20944,
	21863,	20876,	22020,	22541,
	21425,	22116,	22537,	22261,
	22440,	23180,	23345,	23186,
	23330,	22950,	22880,	23167,
	23891,	22853,	22545,	23817,
	23831,	23158,	23965,	23527,
	23957,	23852,	23782,	24640,
	// QP = 10 NEW			
				
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	11514,
	11684,	12528,	12643,	13059,
	12783,	12779,	13652,	14690,
	13845,	15753,	18925,	19726,
	19150,	17862,	18913,	20057,
	20354,	19916,	19866,	20598,
	20056,	21068,	20616,	19489,
	20567,	21018,	19535,	19650,
	20618,	19626,	20761,	21328,
	20235,	20913,	21289,	21021,
	21183,	21922,	22118,	21999,
	22111,	21710,	21680,	21946,
	22663,	21580,	21278,	22568,
	22616,	21924,	22754,	22227,
	22784,	22604,	22541,	23392,
	// QP = 11 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	10630,
	10786,	11619,	11781,	12167,
	11834,	11885,	12764,	13787,
	12899,	14895,	18047,	18837,
	18207,	16962,	17993,	19141,
	19397,	18970,	18891,	19631,
	19055,	20083,	19662,	18612,
	19654,	20150,	18668,	18764,
	19780,	18745,	19902,	20417,
	19290,	20002,	20427,	20163,
	20268,	21030,	21198,	21045,
	21230,	20798,	20725,	21031,
	21732,	20708,	20418,	21640,
	21691,	20988,	21828,	21315,
	21796,	21639,	21631,	22465,
				
	// QP = 12 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	 9344,
	 9545,	10341,	10496,	10916,
	10660,	10698,	11527,	12506,
	11605,	13628,	16847,	17618,
	17024,	15743,	16781,	17898,
	18200,	17803,	17668,	18421,
	17851,	18901,	18406,	17358,
	18429,	18925,	17404,	17517,
	18516,	17530,	18701,	19254,
	18116,	18813,	19232,	18926,
	19081,	19815,	19993,	19899,
	20042,	19552,	19555,	19803,
	20554,	19543,	19182,	20473,
	20487,	19760,	20636,	20171,
	20629,	20462,	20377,	21271,
				
	// QP = 13 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	 8432,
	 8573,	 9428,	 9562,	 9983,
	 9642,	 9722,	10557,	11542,
	10651,	12611,	15744,	16537,
	15938,	14720,	15759,	16886,
	17132,	16736,	16634,	17395,
	16836,	17854,	17393,	16305,
	17394,	17815,	16345,	16498,
	17465,	16440,	17592,	18156,
	17035,	17698,	18106,	17828,
	17962,	18724,	18871,	18749,
	18871,	18503,	18497,	18697,
	19406,	18392,	18068,	19397,
	19393,	18734,	19512,	19065,
	19520,	19379,	19308,	20139,
				
	// QP = 14 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	 7285,
	 7445,	 8289,	 8492,	 8746,
	 8455,	 8574,	 9369,	10346,
	 9473,	11443,	14522,	15289,
	14716,	13523,	14566,	15683,
	15915,	15513,	15453,	16193,
	15665,	16634,	16164,	15107,
	16197,	16592,	15159,	15353,
	16256,	15203,	16417,	16928,
	15827,	16477,	16857,	16635,
	16703,	17512,	17632,	17548,
	17681,	17234,	17208,	17467,
	18197,	17164,	16858,	18147,
	18142,	17480,	18283,	17773,
	18286,	18110,	18084,	18902,
				
	// QP = 15 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	 6214,
	 6406,	 7229,	 7436,	 7675,
	 7449,	 7582,	 8347,	 9325,
	 8482,	10387,	13458,	14232,
	13671,	12453,	13483,	14620,
	14823,	14430,	14398,	15153,
	14606,	15605,	15137,	14080,
	15145,	15569,	14115,	14300,
	15182,	14186,	15350,	15858,
	14756,	15452,	15763,	15516,
	15667,	16472,	16569,	16462,
	16563,	16178,	16134,	16424,
	17139,	16112,	15795,	17090,
	17063,	16422,	17253,	16707,
	17208,	17077,	17011,	17839,
				
	// QP = 16 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	 5089,
	 5295,	 6085,	 6250,	 6500,
	 6352,	 6344,	 7187,	 8204,
	 7275,	 9209,	12282,	13060,
	12449,	11293,	12320,	13458,
	13687,	13243,	13218,	13965,
	13458,	14422,	13950,	12890,
	13937,	14400,	12961,	13098,
	14038,	13030,	14174,	14678,
	13614,	14266,	14592,	14359,
	14528,	15266,	15432,	15313,
	15391,	15032,	14973,	15198,
	15971,	14933,	14689,	15883,
	15940,	15238,	16039,	15559,
	16021,	15913,	15859,	16669,
				
	// QP = 17 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	 4258,
	 4410,	 5177,	 5338,	 5619,
	 5381,	 5501,	 6175,	 7168,
	 6335,	 8238,	11256,	12062,
	11451,	10296,	11287,	12446,
	12658,	12254,	12223,	12948,
	12435,	13416,	12951,	11897,
	12955,	13370,	11964,	12147,
	13009,	12010,	13184,	13684,
	12626,	13289,	13645,	13353,
	13519,	14268,	14393,	14302,
	14362,	14079,	13991,	14218,
	14980,	13929,	13593,	14932,
	14914,	14211,	15021,	14514,
	15051,	14897,	14839,	15651,
				
	// QP = 18 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	 3353,
	 3493,	 4214,	 4330,	 4599,
	 4420,	 4486,	 5191,	 6224,
	 5417,	 7217,	10145,	10892,
	10338,	 9231,	10181,	11268,
	11489,	11157,	11127,	11804,
	11248,	12314,	11820,	10808,
	11808,	12212,	10874,	11011,
	11873,	10888,	12050,	12523,
	11467,	12150,	12457,	12199,
	12363,	13104,	13245,	13158,
	13203,	12877,	12795,	13042,
	13775,	12697,	12444,	13776,
	13699,	13087,	13831,	13356,
	13842,	13685,	13659,	14495,
				
	// QP = 19 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	 2656,
	 2789,	 3394,	 3522,	 3849,
	 3653,	 3726,	 4374,	 5366,
	 4579,	 6257,	 9138,	 9873,
	 9361,	 8274,	 9211,	10283,
	10512,	10161,	10125,	10819,
	10289,	11250,	10834,	 9824,
	10812,	11198,	 9848,	10057,
	10892,	 9901,	11027,	11498,
	10424,	11180,	11421,	11178,
	11365,	12108,	12208,	12108,
	12181,	11846,	11802,	12052,
	12715,	11708,	11417,	12699,
	12698,	12094,	12816,	12368,
	12822,	12686,	12596,	13468,
				
	// QP = 20 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	 1940,
	 2058,	 2584,	 2713,	 3020,
	 2842,	 2981,	 3498,	 4392,
	 3672,	 5306,	 8051,	 8729,
	 8210,	 7210,	 8107,	 9179,
	 9353,	 8998,	 9009,	 9650,
	 9133,	10105,	 9694,	 8749,
	 9676,	10028,	 8700,	 8920,
	 9732,	 8790,	 9903,	10317,
	 9341,	10004,	10282,	10031,
	10174,	10903,	11012,	10965,
	10979,	10659,	10612,	10886,
	11532,	10521,	10271,	11524,
	11478,	10898,	11633,	11217,
	11601,	11546,	11426,	12284,
				
	// QP = 21 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	 1406,
	 1508,	 1943,	 2045,	 2362,
	 2225,	 2298,	 2817,	 3561,
	 3002,	 4491,	 7094,	 7752,
	 7280,	 6353,	 7152,	 8168,
	 8358,	 8050,	 8010,	 8731,
	 8205,	 9085,	 8725,	 7739,
	 8685,	 9004,	 7794,	 7939,
	 8685,	 7772,	 8871,	 9286,
	 8443,	 8992,	 9232,	 8986,
	 9154,	 9850,	10029,	 9921,
	 9928,	 9675,	 9598,	 9874,
	10484,	 9483,	 9189,	10483,
	10406,	 9902,	10581,	10189,
	10561,	10487,	10412,	11239,
				
	// QP = 22 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	  935,
	 1011,	 1343,	 1472,	 1733,
	 1660,	 1720,	 2176,	 2820,
	 2348,	 3666,	 6111,	 6765,
	 6356,	 5438,	 6227,	 7191,
	 7333,	 7061,	 7035,	 7716,
	 7196,	 8040,	 7699,	 6744,
	 7653,	 7934,	 6760,	 6927,
	 7612,	 6791,	 7780,	 8204,
	 7379,	 7950,	 8184,	 7917,
	 8047,	 8729,	 8926,	 8795,
	 8828,	 8569,	 8493,	 8741,
	 9399,	 8372,	 8132,	 9400,
	 9335,	 8789,	 9462,	 9097,
	 9512,	 9361,	 9293,	10111,
				
	// QP = 23 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	  661,
	  727,	  969,	 1068,	 1324,
	 1298,	 1316,	 1715,	 2268,
	 1927,	 3027,	 5217,	 5826,
	 5467,	 4689,	 5374,	 6329,
	 6449,	 6197,	 6175,	 6850,
	 6358,	 7124,	 6848,	 5923,
	 6775,	 7011,	 5927,	 6044,
	 6714,	 5934,	 6824,	 7264,
	 6566,	 7040,	 7216,	 7010,
	 7126,	 7759,	 8012,	 7799,
	 7878,	 7670,	 7532,	 7778,
	 8405,	 7457,	 7194,	 8406,
	 8305,	 7845,	 8424,	 8076,
	 8507,	 8377,	 8315,	 9114,
				
	// QP = 24 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	  433,
	  473,	  640,	  714,	  997,
	  974,	  998,	 1361,	 1769,
	 1582,	 2469,	 4379,	 4973,
	 4661,	 4025,	 4625,	 5495,
	 5638,	 5381,	 5373,	 6007,
	 5563,	 6248,	 6010,	 5139,
	 5912,	 6132,	 5076,	 5265,
	 5826,	 5145,	 5960,	 6369,
	 5749,	 6104,	 6263,	 6131,
	 6204,	 6805,	 7046,	 6860,
	 6895,	 6746,	 6630,	 6825,
	 7417,	 6535,	 6309,	 7431,
	 7362,	 6959,	 7490,	 7128,
	 7533,	 7408,	 7376,	 8135,
				
	// QP = 25 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	  281,
	  305,	  428,	  485,	  759,
	  712,	  822,	 1059,	 1402,
	 1277,	 1989,	 3535,	 4091,
	 3856,	 3359,	 3895,	 4741,
	 4823,	 4637,	 4664,	 5243,
	 4832,	 5420,	 5230,	 4440,
	 5157,	 5255,	 4338,	 4474,
	 5008,	 4400,	 5091,	 5500,
	 4920,	 5251,	 5424,	 5279,
	 5343,	 5856,	 6172,	 5972,
	 5938,	 5857,	 5724,	 5987,
	 6459,	 5649,	 5452,	 6503,
	 6372,	 6088,	 6481,	 6208,
	 6612,	 6534,	 6456,	 7192,
				
	// QP = 26 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	  168,
	  182,	  253,	  312,	  561,
	  527,	  587,	  820,	 1060,
	 1007,	 1533,	 2640,	 3168,
	 2976,	 2677,	 3140,	 3886,
	 3925,	 3845,	 3906,	 4416,
	 4100,	 4581,	 4474,	 3714,
	 4320,	 4428,	 3600,	 3747,
	 4104,	 3643,	 4239,	 4590,
	 4103,	 4338,	 4537,	 4414,
	 4477,	 4908,	 5168,	 4950,
	 4978,	 4908,	 4813,	 5028,
	 5468,	 4758,	 4631,	 5521,
	 5401,	 5183,	 5452,	 5219,
	 5575,	 5535,	 5480,	 6192,
				
	// QP = 27 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	  121,
	  126,	  162,	  208,	  427,
	  399,	  484,	  653,	  857,
	  833,	 1176,	 1954,	 2409,
	 2279,	 2121,	 2491,	 3184,
	 3186,	 3190,	 3264,	 3753,
	 3454,	 3896,	 3796,	 3155,
	 3670,	 3713,	 3026,	 3121,
	 3433,	 3044,	 3567,	 3811,
	 3430,	 3652,	 3769,	 3682,
	 3733,	 4154,	 4365,	 4131,
	 4206,	 4147,	 4064,	 4280,
	 4619,	 3989,	 3880,	 4674,
	 4623,	 4438,	 4639,	 4398,
	 4764,	 4760,	 4683,	 5368,
				
	// QP = 28 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   88,
	   87,	  110,	  147,	  316,
	  323,	  365,	  518,	  645,
	  697,	  890,	 1300,	 1660,
	 1589,	 1580,	 1857,	 2407,
	 2430,	 2486,	 2580,	 3032,
	 2800,	 3167,	 3123,	 2566,
	 2982,	 3011,	 2438,	 2555,
	 2710,	 2473,	 2877,	 3069,
	 2758,	 2947,	 3036,	 3008,
	 3012,	 3348,	 3507,	 3381,
	 3433,	 3353,	 3291,	 3511,
	 3734,	 3254,	 3196,	 3810,
	 3805,	 3686,	 3766,	 3622,
	 3874,	 3949,	 3861,	 4527,
				
	// QP = 29 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   70,
	   70,	   82,	  105,	  257,
	  262,	  314,	  427,	  515,
	  577,	  686,	  849,	 1113,
	 1086,	 1166,	 1360,	 1798,
	 1803,	 1922,	 2021,	 2412,
	 2214,	 2553,	 2572,	 2127,
	 2416,	 2399,	 1972,	 2044,
	 2154,	 2022,	 2334,	 2447,
	 2152,	 2391,	 2448,	 2424,
	 2450,	 2706,	 2882,	 2713,
	 2737,	 2732,	 2682,	 2810,
	 3021,	 2630,	 2690,	 3092,
	 3118,	 3042,	 3067,	 2908,
	 3158,	 3250,	 3187,	 3812,
				
	// QP = 30 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   58,
	   62,	   65,	   88,	  217,
	  223,	  283,	  355,	  420,
	  482,	  553,	  557,	  776,
	  767,	  895,	 1043,	 1381,
	 1376,	 1483,	 1600,	 1979,
	 1767,	 2107,	 2175,	 1787,
	 2037,	 1943,	 1627,	 1710,
	 1752,	 1711,	 1926,	 2039,
	 1819,	 1987,	 2059,	 2071,
	 2027,	 2256,	 2376,	 2231,
	 2257,	 2290,	 2300,	 2343,
	 2522,	 2199,	 2278,	 2595,
	 2641,	 2613,	 2566,	 2501,
	 2601,	 2743,	 2741,	 3315,
				
	// QP = 31 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   52,
	   52,	   57,	   75,	  176,
	  189,	  239,	  295,	  353,
	  412,	  438,	  336,	  475,
	  488,	  636,	  742,	  957,
	  954,	 1084,	 1195,	 1457,
	 1355,	 1587,	 1640,	 1445,
	 1565,	 1522,	 1295,	 1377,
	 1349,	 1412,	 1541,	 1597,
	 1403,	 1586,	 1618,	 1644,
	 1636,	 1759,	 1887,	 1745,
	 1758,	 1840,	 1821,	 1836,
	 1945,	 1757,	 1857,	 2028,
	 2138,	 2102,	 2059,	 2018,
	 2065,	 2198,	 2204,	 2733,
				
	// QP = 32 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   46,
	   44,	   50,	   69,	  154,
	  155,	  198,	  242,	  290,
	  335,	  334,	  189,	  266,
	  295,	  428,	  486,	  608,
	  612,	  720,	  823,	 1013,
	  936,	 1104,	 1173,	 1119,
	 1159,	 1084,	 1024,	 1064,
	 1014,	 1101,	 1176,	 1197,
	 1096,	 1249,	 1233,	 1279,
	 1268,	 1360,	 1426,	 1326,
	 1318,	 1453,	 1438,	 1407,
	 1490,	 1344,	 1505,	 1539,
	 1686,	 1665,	 1569,	 1580,
	 1625,	 1698,	 1766,	 2206,
				
	// QP = 33 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   43,
	   40,	   45,	   60,	  135,
	  148,	  175,	  194,	  228,
	  290,	  273,	  121,	  159,
	  192,	  308,	  339,	  408,
	  399,	  489,	  575,	  694,
	  651,	  753,	  846,	  873,
	  866,	  799,	  810,	  870,
	  796,	  898,	  934,	  950,
	  872,	  983,	 1000,	 1009,
	 1001,	 1048,	 1082,	 1023,
	 1032,	 1144,	 1171,	 1111,
	 1145,	 1066,	 1242,	 1204,
	 1335,	 1360,	 1294,	 1299,
	 1281,	 1328,	 1440,	 1815,
				
	// QP = 34 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   37,
	   35,	   39,	   55,	  111,
	  136,	  140,	  169,	  190,
	  249,	  225,	   86,	  102,
	  138,	  239,	  250,	  262,
	  270,	  327,	  405,	  457,
	  458,	  512,	  590,	  678,
	  636,	  577,	  651,	  694,
	  623,	  738,	  744,	  741,
	  699,	  818,	  803,	  821,
	  815,	  833,	  846,	  825,
	  812,	  953,	  932,	  881,
	  885,	  856,	 1040,	  954,
	 1069,	 1077,	 1039,	 1062,
	 1041,	 1069,	 1200,	 1503,
				
	// QP = 35 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   33,
	   32,	   35,	   47,	  109,
	  114,	  127,	  147,	  158,
	  201,	  195,	   75,	   87,
	  112,	  197,	  209,	  202,
	  210,	  253,	  314,	  346,
	  355,	  400,	  456,	  567,
	  511,	  466,	  559,	  612,
	  524,	  659,	  638,	  640,
	  603,	  711,	  668,	  734,
	  695,	  691,	  701,	  696,
	  693,	  817,	  820,	  736,
	  750,	  763,	  919,	  820,
	  925,	  920,	  911,	  940,
	  892,	  914,	 1057,	 1317,
				
	// QP = 36 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   30,
	   29,	   32,	   45,	   85,
	   95,	  100,	  121,	  143,
	  167,	  164,	   61,	   71,
	   92,	  155,	  166,	  158,
	  156,	  195,	  232,	  246,
	  271,	  296,	  335,	  471,
	  386,	  363,	  468,	  508,
	  441,	  558,	  542,	  526,
	  503,	  613,	  567,	  614,
	  586,	  590,	  582,	  591,
	  581,	  697,	  694,	  619,
	  611,	  657,	  784,	  697,
	  796,	  771,	  773,	  785,
	  767,	  781,	  883,	 1131,
				
	// QP = 37 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   28,
	   28,	   29,	   39,	   81,
	   82,	  102,	  106,	  119,
	  140,	  137,	   55,	   62,
	   80,	  142,	  142,	  136,
	  134,	  170,	  202,	  213,
	  224,	  247,	  274,	  402,
	  322,	  319,	  406,	  448,
	  399,	  499,	  477,	  466,
	  459,	  539,	  490,	  553,
	  526,	  510,	  512,	  532,
	  520,	  623,	  624,	  564,
	  553,	  587,	  704,	  609,
	  723,	  691,	  682,	  704,
	  675,	  680,	  814,	 1022,
				
	// QP = 38 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   25,
	   25,	   26,	   35,	   70,
	   67,	   88,	   90,	  100,
	  114,	  117,	   45,	   52,
	   67,	  114,	  112,	  104,
	  108,	  133,	  157,	  167,
	  174,	  192,	  214,	  323,
	  265,	  250,	  333,	  373,
	  340,	  416,	  388,	  402,
	  401,	  453,	  427,	  465,
	  456,	  441,	  441,	  458,
	  438,	  522,	  534,	  490,
	  484,	  513,	  603,	  519,
	  613,	  587,	  590,	  608,
	  602,	  580,	  696,	  888,
				
	// QP = 39 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   23,
	   23,	   24,	   30,	   60,
	   60,	   81,	   82,	   83,
	  102,	  104,	   40,	   47,
	   60,	   97,	  101,	   96,
	   95,	  122,	  136,	  145,
	  160,	  169,	  185,	  285,
	  228,	  214,	  301,	  323,
	  301,	  375,	  362,	  355,
	  359,	  406,	  388,	  416,
	  422,	  400,	  397,	  413,
	  392,	  471,	  487,	  451,
	  432,	  455,	  543,	  480,
	  562,	  536,	  527,	  560,
	  550,	  534,	  639,	  812,
				
	// QP = 40 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   22,
	   21,	   22,	   30,	   59,
	   56,	   66,	   69,	   68,
	   79,	   83,	   35,	   41,
	   50,	   80,	   87,	   81,
	   78,	  100,	  107,	  116,
	  130,	  133,	  152,	  238,
	  187,	  185,	  252,	  279,
	  256,	  314,	  302,	  308,
	  297,	  341,	  321,	  365,
	  366,	  347,	  345,	  346,
	  339,	  403,	  417,	  392,
	  379,	  413,	  477,	  419,
	  490,	  455,	  463,	  474,
	  480,	  463,	  562,	  714,
				
	// QP = 41 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   21,
	   20,	   23,	   28,	   56,
	   51,	   54,	   56,	   65,
	   65,	   66,	   33,	   36,
	   45,	   68,	   75,	   73,
	   68,	   88,	  101,	  100,
	  107,	  119,	  134,	  204,
	  161,	  161,	  225,	  248,
	  234,	  274,	  273,	  275,
	  275,	  306,	  288,	  338,
	  322,	  309,	  318,	  315,
	  307,	  353,	  379,	  348,
	  352,	  375,	  425,	  388,
	  438,	  420,	  418,	  427,
	  450,	  420,	  497,	  653,
				
	// QP = 42 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   19,
	   18,	   19,	   27,	   41,
	   44,	   49,	   47,	   54,
	   52,	   59,	   30,	   31,
	   37,	   59,	   64,	   62,
	   55,	   76,	   82,	   84,
	   89,	   96,	  114,	  167,
	  141,	  144,	  189,	  216,
	  197,	  235,	  228,	  233,
	  235,	  272,	  252,	  287,
	  283,	  270,	  277,	  277,
	  265,	  319,	  334,	  300,
	  305,	  325,	  376,	  340,
	  376,	  366,	  363,	  375,
	  396,	  370,	  447,	  574,
				
	// QP = 43 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   19,
	   18,	   19,	   23,	   40,
	   39,	   41,	   46,	   49,
	   41,	   48,	   26,	   28,
	   32,	   50,	   51,	   53,
	   50,	   61,	   74,	   75,
	   80,	   84,	   97,	  151,
	  128,	  124,	  168,	  186,
	  182,	  208,	  205,	  204,
	  207,	  235,	  223,	  251,
	  260,	  244,	  241,	  243,
	  242,	  284,	  289,	  284,
	  280,	  296,	  332,	  308,
	  333,	  324,	  316,	  341,
	  361,	  335,	  404,	  524,
				
	// QP = 44 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   17,
	   16,	   18,	   20,	   35,
	   34,	   40,	   41,	   37,
	   43,	   45,	   23,	   25,
	   30,	   41,	   43,	   42,
	   40,	   55,	   60,	   62,
	   66,	   74,	   80,	  120,
	  100,	  105,	  140,	  150,
	  149,	  172,	  171,	  177,
	  171,	  196,	  192,	  209,
	  220,	  211,	  202,	  204,
	  206,	  253,	  251,	  240,
	  239,	  255,	  286,	  275,
	  273,	  281,	  284,	  283,
	  307,	  281,	  334,	  453,
				
	// QP = 45 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   15,
	   15,	   16,	   21,	   33,
	   33,	   34,	   32,	   32,
	   40,	   37,	   19,	   22,
	   25,	   36,	   37,	   36,
	   35,	   47,	   51,	   49,
	   56,	   59,	   68,	  102,
	   86,	   93,	  114,	  136,
	  123,	  156,	  138,	  142,
	  147,	  160,	  157,	  179,
	  194,	  182,	  184,	  190,
	  176,	  218,	  213,	  212,
	  200,	  224,	  249,	  239,
	  246,	  244,	  240,	  254,
	  280,	  247,	  302,	  395,
				
	// QP = 46 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   14,
	   15,	   15,	   17,	   31,
	   32,	   34,	   32,	   31,
	   33,	   30,	   18,	   20,
	   22,	   31,	   33,	   32,
	   30,	   39,	   42,	   43,
	   44,	   49,	   60,	   87,
	   71,	   77,	  104,	  110,
	  110,	  126,	  119,	  131,
	  128,	  137,	  138,	  155,
	  164,	  149,	  153,	  154,
	  150,	  190,	  179,	  182,
	  182,	  193,	  210,	  207,
	  220,	  217,	  220,	  212,
	  234,	  218,	  259,	  343,
				
	// QP = 47 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   13,
	   15,	   15,	   19,	   30,
	   30,	   28,	   29,	   28,
	   28,	   27,	   16,	   18,
	   19,	   25,	   29,	   27,
	   26,	   33,	   35,	   38,
	   38,	   39,	   51,	   73,
	   58,	   62,	   82,	   97,
	   97,	  104,	   97,	  107,
	  106,	  110,	  121,	  130,
	  145,	  134,	  129,	  136,
	  124,	  152,	  153,	  161,
	  160,	  163,	  180,	  182,
	  185,	  184,	  183,	  188,
	  202,	  183,	  221,	  297,
				
	// QP = 48 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   12,
	   12,	   13,	   17,	   27,
	   26,	   29,	   25,	   26,
	   26,	   24,	   15,	   17,
	   17,	   24,	   26,	   25,
	   28,	   28,	   30,	   32,
	   31,	   35,	   42,	   58,
	   50,	   54,	   65,	   80,
	   80,	   87,	   85,	   93,
	   87,	   96,	  100,	  111,
	  119,	  118,	  114,	  117,
	  115,	  144,	  127,	  141,
	  135,	  145,	  149,	  158,
	  158,	  160,	  151,	  160,
	  183,	  160,	  190,	  259,
				
	// QP = 49 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   11,
	   12,	   12,	   16,	   23,
	   22,	   23,	   22,	   23,
	   23,	   24,	   13,	   15,
	   16,	   21,	   21,	   22,
	   22,	   25,	   28,	   31,
	   27,	   29,	   35,	   46,
	   45,	   46,	   58,	   70,
	   65,	   74,	   67,	   80,
	   78,	   79,	   80,	   95,
	  102,	  100,	   93,	   97,
	   95,	  120,	  106,	  119,
	  121,	  128,	  128,	  142,
	  132,	  139,	  137,	  135,
	  158,	  139,	  162,	  223,
				
	// QP = 50 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   11,
	   11,	   12,	   15,	   22,
	   19,	   22,	   19,	   20,
	   21,	   21,	   14,	   14,
	   16,	   18,	   19,	   19,
	   20,	   21,	   23,	   24,
	   24,	   26,	   32,	   40,
	   36,	   40,	   49,	   56,
	   56,	   59,	   56,	   69,
	   68,	   63,	   73,	   80,
	   84,	   86,	   84,	   81,
	   79,	  103,	   88,	  100,
	  101,	  105,	  109,	  124,
	  109,	  109,	  113,	  111,
	  135,	  120,	  142,	  191,
				
	// QP = 51 NEW			
	    0,	    0,	    0,	    0,
	    0,	    0,	    0,	   10,
	   11,	   12,	   14,	   20,
	   18,	   22,	   18,	   21,
	   21,	   20,	   11,	   13,
	   14,	   17,	   16,	   16,
	   19,	   20,	   24,	   21,
	   22,	   24,	   28,	   33,
	   34,	   38,	   42,	   51,
	   42,	   49,	   47,	   59,
	   62,	   58,	   62,	   67,
	   68,	   66,	   73,	   73,
	   65,	   85,	   78,	   90,
	   92,	  101,	   91,	  107,
	   96,	  103,	   96,	   98,
	  122,	  104,	  119,	  166,
};				





/**************************************
 * Function Declarations
 **************************************/
EB_ERRORTYPE RateControlTablesInit(
    RateControlTables_t *initialRateControlTablesArray)
{
    int qpIndex, intervalIndex, temporalIndex;
    for(qpIndex = 0; qpIndex < 52; qpIndex++){
        for(intervalIndex= 0; intervalIndex < NUMBER_OF_SAD_INTERVALS;intervalIndex++){
             for (temporalIndex=0; temporalIndex < MAX_TEMPORAL_LAYERS; temporalIndex++){
                     if (intervalIndex < (NUMBER_OF_SAD_INTERVALS >> 1)){
                    // intrinsics used in initial RC are assuming signed 16 bits is the maximum
                    initialRateControlTablesArray[qpIndex].sadBitsArray[temporalIndex][intervalIndex] = 
                        CLIP3(1,
                        (EB_U16)((1<<15)-1),
                        (EB_U16)initialRateControlSad64x64Tables[qpIndex*(NUMBER_OF_SAD_INTERVALS >> 1) + intervalIndex]);

                    initialRateControlTablesArray[qpIndex].intraSadBitsArray[temporalIndex][intervalIndex] = 
                        CLIP3(1,
                        (EB_U16)((1<<15)-1),
                        (EB_U16)initialRateControlIntraSad64x64Tables[qpIndex*(NUMBER_OF_SAD_INTERVALS >> 1) + intervalIndex]);

                }
                else{

                    initialRateControlTablesArray[qpIndex].sadBitsArray[temporalIndex][intervalIndex] = 
                        CLIP3(1,
                        (EB_U16)((1<<15)-1),
                        (EB_U16)initialRateControlSad64x64Tables[qpIndex*(NUMBER_OF_SAD_INTERVALS >> 1) + ((NUMBER_OF_SAD_INTERVALS >> 1) - 1)]);
                    initialRateControlTablesArray[qpIndex].intraSadBitsArray[temporalIndex][intervalIndex] = 
                        CLIP3(1,
                        (EB_U16)((1<<15)-1),
                        initialRateControlIntraSad64x64Tables[qpIndex*(NUMBER_OF_SAD_INTERVALS >> 1) + ((NUMBER_OF_SAD_INTERVALS >> 1) - 1)]);

                }


             }
        }
    }
    return EB_ErrorNone;
}


