/*
* Copyright(c) 2018 Intel Corporation
* SPDX - License - Identifier: BSD - 2 - Clause - Patent
*/


// EbLambdaRateTables.h file contains all material to estimate the rate of intra, inter and skip modes
#ifndef EbLambdaRateTables_h
#define EbLambdaRateTables_h
#ifdef __cplusplus
extern "C" {
#endif

#define NUMBER_OF_INTRA_MODES_MINUS_TWO  34
#define LUMA_INTRA_MODE_BITS_GRE31       196608 // farctional number of bit required for signaling luma intra mode greater than 31
#define QP_NUM                           52

// *Note - As of Oct 2011, the JCT-VC uses the PSNR forumula
//  PSNR = (LUMA_WEIGHT * PSNRy + PSNRu + PSNRv) / (2+LUMA_WEIGHT)
#define LUMA_WEIGHT                      1
#define CHROMA_WEIGHT                    1
#define RATE_WEIGHT                      1

// Precision macros used in the mode decision
#define BIT_ESTIMATE_PRECISION           15
#define LAMBDA_PRECISION                 16
#define COST_PRECISION                   8
#define MD_SHIFT                         (BIT_ESTIMATE_PRECISION + LAMBDA_PRECISION - COST_PRECISION)
#define MD_OFFSET                        (1 << (MD_SHIFT-1))

// Precision macros for chroma weight
// *Note - As in JCTVC-G1102,
#define CHROMA_WEIGHT_PRECISION          16
#define CHROMA_WEIGHT_SHIFT              (CHROMA_WEIGHT_PRECISION - COST_PRECISION)
#define CHROMA_WEIGHT_OFFSET             (1 << (CHROMA_WEIGHT_SHIFT - 1))

// Precision macro used in the motion estimation search
#define ME_SHIFT                         (BIT_ESTIMATE_PRECISION + LAMBDA_PRECISION)

// Syntax element macro
#define  ZERO_COST                       0
#define  TU_SPLIT_ZERO                   0
#define  TU_SPLIT_TAB_OFFSET             4 // offset to parse transSubDivFlag tables
#define  CBF_TAB_OFFSET                  3 // offset to parse Cbf tables
#define  SPLIT_FLAG_ZERO                 0
#define  SPLIT_TAB_OFFSET                3 // offset to parse split flag tables
#define  SKIP_FLAG_ZERO                  0
#define  SKIP_FLAG_ONE                   1
#define  SKIP_TAB_OFFSET                 3 // offset to parse skip flag tables

// Lamda table for mode decision -
// GOP structure: IPPPP...
// lambda values are << 16
// From JCTVC-F802
static const EB_U32 lambdaModeDecisionLdSad[QP_NUM] = {
    12456,   13982,   15694,   17616,
    19773,   22194,   24912,   27963,
    31388,   35231,   39546,   44389,
    49825,   55926,   62775,   70463,
    79092,   88777,   99649,  111852,
    125550,  140925,  158183,  177555,
    199298,  223705,  251100,  281851,
    316367,  355109,  398597,  447410,
    502201,  563701,  632733,  710219,
    797194,  894820, 1004401, 1127402,
    1265466, 1420438, 1594387, 1789639,
    2008802, 2254804, 2530932, 2840875,
    3188775, 3579278, 4017604, 4509608
};

static const EB_U32 lambdaModeDecisionLdSadQpScaling [QP_NUM] = {
    15756,    17685,     19851,      22282,
    25011,    28074,     31512,      35371,
    39702,    44564,     50022,      56148,
    63024,    70742,     79405,      89129,
    100044,   112295,    126047,     141483,
    158810,   178258,    200088,     224591,
    252095,   294521,    343068,     398597,
    462083,   534633,    617504,     712118,
    820090,   943252,   1083680,    1243728,
    1426063,  1600702,   1796727,    2016758,
    2263734,  2540956,   2852127,    3201404,
    3593454,  4033516,   4527469,    5081912,
    5704253,  6402808,   7186909,    8067033
};

static const EB_U32 lambdaModeDecisionLdSse[QP_NUM] = {
    2367,      2983,      3758,       4735,
    5966,      7516,      9470,      11931,
    15033,     18940,     23863,      30065,
    37880,     47726,     60130,      75760,
    95451,    120261,    151519,     190902,
    240522,    303038,    381805,     481044,
    606077,    763609,    962087,    1212154,
    1527218,   1924174,   2424308,    3054436,
    3848349,   4848615,   6108873,    7696697,
    9697231,  12217745,  15393394,   19394462,
    24435491, 30786789,  38788923,   48870981,
    61573578, 77577847,  97741962,  123147156,
    155155694,195483924, 246294311,  310311387
};

static const EB_U32 lambdaModeDecisionLdSseQpScaling [QP_NUM] = {
    3788,       4773,       6013,       7576,
    9545,      12026,      15152,      19090,
    24052,      30304,      38180,      48104,
    60608,      76361,      96209,     121215,
    152722,     192417,     242431,     305444,
    384835,     484862,     610887,     769670,
    969723,    1323589,    1795896,    2424308,
    3258065,    4361462,    5818339,    7737905,
    10262263,   13576123,   17919360,   23603205,
    31031139,   39096785,   49258862,   62062277,
    78193570,   98517724,  124124555,  156387139,
    197035449,  248249110,  312774279,  394070898,
    496498219,  625548558,  788141796,  992996439
};
static const EB_U32 lambdaChromaModeDecisionLdSad[QP_NUM] = {
    12456,  13982,  15694,  17616,
    19773,  22194,  24912,  27963,
    31388,  35231,  39546,  44389,
    49825,  55926,  62775,  70463,
    79092,  88777,  99649, 111852,
    125550, 140925, 158183, 177555,
    199298, 223705, 251100, 281851,
    316367, 355109, 355109, 398597,
    447410, 502201, 502201, 563701,
    632733, 632733, 710219, 710219,
    797194, 797194, 894820, 894820,
    894820,1004401,1004401,1004401,
    1127402,1127402,1127402,1127402
};
static const EB_U32 lambdaChromaModeDecisionLdSadQPScaling[QP_NUM] = {
    15756,  17685,  19851,  22282,
    25011,  28074,  31512,  35371,
    39702,  44564,  50022,  56148,
    63024,  70742,  79405,  89129,
    100044, 112295, 126047, 141483,
    158810, 178258, 200088, 224591,
    252095, 294521, 343068, 398597,
    462083, 534633, 534633, 617504,
    712118, 820090, 820090, 943252,
    1083680,1083680,1243728,1243728,
    1426063,1426063,1600702,1600702,
    1600702,1796727,1796727,1796727,
    2016758,2016758,2016758,2016758
};
static const EB_U32 lambdaChromaModeDecisionLdSse[QP_NUM] = {
    2367,    2983,    3758,    4735,
    5966,    7516,    9470,   11931,
    15033,   18940,   23863,   30065,
    37880,   47726,   60130,   75760,
    95451,  120261,  151519,  190902,
    240522,  303038,  381805,  481044,
    606077,  763609,  962087, 1212154,
    1527218, 1924174, 1924174, 2424308,
    3054436, 3848349, 3848349, 4848615,
    6108873, 6108873, 7696697, 7696697,
    9697231, 9697231,12217745,12217745,
    12217745,15393394,15393394,15393394,
    19394462,19394462,19394462,19394462
};
static const EB_U32 lambdaChromaModeDecisionLdSseQpScaling[QP_NUM] = {
    3788,     4773,     6013,    7576,
    9545,    12026,    15152,   19090,
    24052,    30304,   38180,   48104,
    60608,    76361,   96209,  121215,
    152722,   192417,  242431,  305444,
    384835,   484862,  610887,  769670,
    969723,  1323589, 1795896, 2424308,
    3258065, 4361462, 4361462, 5818339,
    7737905,10262263,10262263,13576123,
    17919360,17919360,23603205,23603205,
    31031139,31031139,39096785,39096785,
    39096785,49258862,49258862,49258862,
    62062277,62062277,62062277,62062277

};

// Chroma weight table for mode decision -
// weight values are << 16
// From JCTVC-G1102
static const EB_U32 ChromaWeightFactorLd[QP_NUM] = {
    65536,  65536,  65536,   65536, //QP 0-3
    65536,  65536,  65536,   65536, //QP 4-7
    65536,  65536,  65536,   65536, //QP 8-11
    65536,  65536,  65536,   65536, //QP 12-15
    65536,  65536,  65536,   65536, //QP 16-19
    65536,  65536,  65536,   65536, //QP 20-23
    65536,  65536,  65536,   65536, //QP 24-27
    65536,  65536,  82570,   82570, //QP 28-31
    82570,  82570, 104032,  104032, //QP 32-35
    104032, 131072, 131072,  165140, //QP 36-39
    165140, 208064, 208064,  262144, //QP 40-43
    330281, 330281, 416128,  524288, //QP 44-47
    524288, 660561, 832255, 1048576  //QP 48-51
};
static const EB_U32 ChromaWeightFactorLdQpScaling[QP_NUM] = {
    65536, 65536, 65536, 65536, //QP 0-3
    65536, 65536, 65536, 65536, //QP 4-7
    65536, 65536, 65536, 65536, //QP 8-11
    65536, 65536, 65536, 65536, //QP 12-15
    65536, 65536, 65536, 65536, //QP 16-19
    65536, 65536, 65536, 65536, //QP 20-23
    65536, 65536, 65536, 65536, //QP 24-27
    65536, 65536, 87427, 87157, //QP 28-31
    86916, 86699,114435,113940, //QP 32-35
    113489,142988,136771,172320, //QP 36-39
    165140,208064,208064,262144, //QP 40-43
    330281,330281,416128,524288, //QP 44-47
    524288,660561,832255,1048576 //QP 48-51
};

// For I_SLICE in the base layer
static const EB_U32 lambdaModeDecisionISliceSad[QP_NUM] = {
    9973   ,    11194  ,    12565  ,    14104  ,
    15831  ,    17769  ,    19945  ,    22388  ,
    25130  ,    28207  ,    31661  ,    35539  ,
    39891  ,    44776  ,    50259  ,    56414  ,
    63323  ,    71078  ,    79782  ,    89552  ,
    100519 ,    112829 ,    126646 ,    142155 ,
    159564 ,    179104 ,    201038 ,    225657 ,
    253292 ,    284310 ,    319127 ,    358208 ,
    402075 ,    451314 ,    506583 ,    568620 ,
    638255 ,    716417 ,    804151 ,    902628 ,
    1013166,    1137241,    1276509,    1432833,
    1608301,    1805257,    2026332,    2274481,
    2553019,    2865667,    3216602,    3610514
};


static const EB_U32 lambdaModeDecisionISliceSse[QP_NUM] = {
    1518,     1912,       2409,      3035,
    3824,     4818,       6070,      7648,
    9636,     12141,      15296,     19272,
    24281,    30592,      38544,     48562,
    61185,    77088,      97124,     122369,
    154175,   194249,     244738,    308351,
    388497,   489476,     616701,    776995,
    978952,   1233402,    1553990,   1957904,
    2466805,  3107979,    3915808,   4933610,
    6215959,  7831617,    9867219,   12431917,
    15663234, 19734438,   24863834,  31326468,
    39468876, 49727668,   62652936,  78937753,
    99455336, 125305872,  157875506, 198910673
};

// For Random Access
static const EB_U32 lambdaModeDecisionRaSadBase[QP_NUM] = {
    10893,   12227,   13724,   15404,
    17291,   19408,   21785,   24453,
    27448,   30809,   34582,   38817,
    43570,   48906,   54895,   61618,
    69164,   77634,   87141,   97812,
    109790,  123236,  138327,  155267,
    174281,  195624,  219581,  246471,
    276654,  310534,  348563,  391249,
    439162,  492942,  553309,  621068,
    697126,  782497,  878323,  985885,
    1106618, 1242137, 1394251, 1564994,
    1756647, 1971769, 2213236, 2484273,
    2788503, 3129988, 3513293, 3943538
};
static const EB_U32 lambdaModeDecisionRaSseBase[QP_NUM] = {
    1810,      2281,      2874,      3621,
    4562,      5748,      7242,      9124,
    11496,     14483,     18248,     22991,
    28967,     36496,     45982,     57934,
    72992,     91964,     115868,    145984,
    183928,    231735,    291968,    367857,
    463471,    583936,    735714,    926941,
    1167873,   1471427,   1853882,   2335745,
    2942855,   3707765,   4671491,   5885710,
    7415529,   9342982,   11771419,  14831059,
    18685963,  23542839,  29662118,  37371927,
    47085677,  59324236,  74743853,  94171354,
    118648472, 149487707, 188342709, 237296943

};
static const EB_U32 lambdaModeDecisionRaSadRefNonBase[QP_NUM] = {
    13778,   15465,   17359,   19485,
    21871,   24550,   27556,   30931,
    34719,   38971,   43743,   49100,
    55113,   61862,   69438,   77941,
    87486,   98200,   110225,  123724,
    138875,  155882,  174972,  196399,
    220450,  257551,  300005,  348563,
    404080,  467523,  539991,  622729,
    717148,  824850,  947651,  1087609,
    1247056, 1399773, 1571192, 1763604,
    1979578, 2222002, 2494112, 2799547,
    3142385, 3527208, 3959157, 4444003,
    4988225, 5599093, 6284770, 7054415

};
static const EB_U32 lambdaModeDecisionRaSseRefNonBase[QP_NUM] = {
    2897,      3650,      4598,      5793,
    7299,      9196,      11587,     14598,
    18393,     23174,     29197,     36786,
    46347,     58394,     73571,     92694,
    116787,    147143,    185388,    233575,
    294285,    370776,    467149,    588571,
    741553,    1012156,   1373332,   1853882,
    2491462,   3335235,   4449318,   5917222,
    7847613,   10381741,  13703040,  18049510,
    23729694,  29897541,  37668542,  47459389,
    59795083,  75337083,  94918777,  119590165,
    150674167, 189837554, 239180331, 301348334,
    379675109, 478360662, 602696667, 759350218

};

static const EB_U32 lambdaModeDecisionRaSadNonRef[QP_NUM] = {

    19107,   21447,   24073,   27021,
    30330,   34045,   38214,   42893,
    48146,   54042,   60661,   68089,
    76427,   85787,   96293,   108085,
    121321,  136178,  152855,  171574,
    192585,  216169,  242642,  272356,
    305710,  357159,  416031,  483370,
    560358,  648338,  748833,  863569,
    994505,  1143861, 1314155, 1508242,
    1729356, 1941136, 2178852, 2445678,
    2745181, 3081362, 3458712, 3882273,
    4357704, 4891357, 5490363, 6162724,
    6917423, 7764545, 8715407, 9782714

};

static const EB_U32 lambdaModeDecisionRaSseNonRef[QP_NUM] = {
    5571,       7018,       8843,       11141,
    14037,      17685,      22282,      28074,
    35371,      44564,      56148,      70742,
    89129,      112295,     141483,     178258,
    224591,     282967,     356516,     449182,
    565934,     713032,     898364,     1131867,
    1426063,    1946455,    2641024,    3565158,
    4791273,    6413914,    8556380,    11379273,
    15091563,   19964887,   26352000,   34710595,
    45634028,   57495272,   72439503,   91268055,
    114990544,  144879007,  182536110,  229981087,
    289758013,  365072220,  459962175,  579516026,
    730144440,  919924350,  1159032053, 1460288881

};
static const EB_U32 ChromaWeightFactorRaBase[QP_NUM] = {
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  82570,  82570,
    82570,  82570,  104032, 104032,
    104032, 131072, 131072, 165140,
    165140, 208064, 208064, 262144,
    330281, 330281, 416128, 524288,
    524288, 660561, 832255, 1048576

};

static const EB_U32 ChromaWeightFactorRaRefNonBase[QP_NUM] = {

    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  87427,  87157,
    86916,  86699,  114435, 113940,
    113489, 142988, 136771, 172320,
    165140, 208064, 208064, 262144,
    330281, 330281, 416128, 524288,
    524288, 660561, 832255, 1048576

};

static const EB_U32 ChromaWeightFactorRaNonRef[QP_NUM] = {

    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  65536,  65536,
    65536,  65536,  87427,  87157,
    86916,  86699,  114435, 113940,
    113489, 142988, 136771, 172320,
    165140, 208064, 208064, 262144,
    330281, 330281, 416128, 524288,
    524288, 660561, 832255, 1048576

};

static const EB_U32 intraLumaModeMapping[] = { // intra luma mode mapping for scaling
    3,  4,  4,  3,  5,  5,  5,  3,  1,  1,  1,  3,  6,  6,  6,  3,  7,  7,  4,  3,  8,  8,  8,  3,  2,  2,  2,  3,  9,  9,  9,  3,  3,  3,        // conversion to 9 modes
    3,  3,  3,  3,  3,  3,  3,  1,  1,  1,  1,  1,  1,  1,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3         // conversion to 3 modes
};
#ifdef __cplusplus
}
#endif
#endif //EbLambdaRateTables_h
