/*
Copyright (c) 2018 James Ahlborn

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package com.healthmarketscience.jackcess.impl;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Simple LRU cache implementation which keeps at most the configured maximum
 * number of elements.
 * @author James Ahlborn
 */
public class SimpleCache<K,V> extends LinkedHashMap<K,V>
{
  private static final long serialVersionUID = 20180313L;  

  private final int _maxSize;

  public SimpleCache(int maxSize) {
    super(16, 0.75f, true);
    _maxSize = maxSize;
  }

  protected int getMaxSize() {
    return _maxSize;
  }

  @Override
  protected boolean removeEldestEntry(Map.Entry<K, V> e) {
    return(size() > _maxSize);
  }
}
