//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//

#include "G4CascadeKzeroBarNChannel.hh"
#include "G4InuclParticleNames.hh"
using namespace G4InuclParticleNames;

namespace {
  // Outgoing particle types of a given multiplicity

  static const G4int k0bn2bfs[8][2] =
    {{k0b,neu}, {kmi,pro}, {pi0,lam}, {pip,sm},
     {pi0,s0},  {pim,sp},  {kpl,xim}, {k0,xi0} };

  static const G4int k0bn3bfs[20][3] =
    {{k0b,neu,pi0}, {kmi,neu,pip}, {k0b,pro,pim}, {kmi,pro,pi0},  
     {pi0,pi0,lam}, {pip,pim,lam}, {k0,k0b,lam},  {kpl,kmi,lam},
     {pip,pi0,sm},  {pi0,pi0,s0},  {pip,pim,s0},  {pim,pi0,sp},
     {kpl,k0b,sm},  {k0,k0b,s0},   {kpl,kmi,s0},  {kmi,k0,sp},
     {kpl,pim,xi0}, {k0,pi0,xi0},  {k0,pip,xim},  {kpl,pi0,xim} };

  static const G4int k0bn4bfs[42][4] =
    {{neu,pi0,pi0,k0b}, {neu,pip,pim,k0b}, {neu,pip,pi0,kmi}, {pro,pim,pi0,k0b},
     {pro,pi0,pi0,kmi}, {pro,pip,pim,kmi}, {neu,k0,k0b,k0b},  {neu,kpl,kmi,k0b},
     {pro,kmi,k0,k0b},  {pro,kpl,kmi,kmi}, {pi0,pi0,pi0,lam}, {pip,pim,pi0,lam},
     {pi0,k0,k0b,lam},  {pi0,kpl,kmi,lam}, {pip,kmi,k0,lam},  {pim,kpl,k0b,lam},
     {pip,pi0,pi0,sm},  {pip,pip,pim,sm},  {pip,k0,k0b,sm},   {pip,kpl,kmi,sm},
     {pi0,kpl,k0b,sm},  {pi0,pi0,pi0,s0},  {pip,pim,pi0,s0},  {pi0,k0,k0b,s0},
     {pi0,kpl,kmi,s0},  {pip,kmi,k0,s0},   {pim,kpl,k0b,s0},  {pim,pi0,pi0,sp},
     {pip,pim,pim,sp},  {pim,k0,k0b,sp},   {pim,kpl,kmi,sp},  {pi0,kmi,k0,sp},
     {pip,pi0,k0,xim},  {pi0,pi0,kpl,xim}, {pip,pim,kpl,xim}, {kpl,kpl,kmi,xim},
     {kpl,k0,k0b,xim},  {pi0,pi0,k0,xi0},  {pip,pim,k0,xi0},  {pim,pi0,kpl,xi0},
     {kpl,kmi,k0,xi0},  {k0,k0,k0b,xi0} };

  static const G4int k0bn5bfs[68][5] =
    {{neu,pi0,pi0,pi0,k0b}, {neu,pip,pim,pi0,k0b}, {neu,pip,pi0,pi0,kmi},
     {neu,pip,pip,pim,kmi}, {pro,pim,pi0,pi0,k0b}, {pro,pip,pim,pim,k0b},
     {pro,pi0,pi0,pi0,kmi}, {pro,pip,pim,pi0,kmi}, {neu,pi0,k0,k0b,k0b},
     {neu,pi0,kpl,kmi,k0b}, {neu,pip,kmi,k0,k0b},  {neu,pim,kpl,k0b,k0b},
     {neu,pip,kpl,kmi,kmi}, {pro,pim,k0,k0b,k0b},  {pro,pim,kpl,kmi,k0b},
     {pro,pi0,kmi,k0,k0b},  {pro,pi0,kpl,kmi,kmi}, {pro,pip,kmi,kmi,k0},
     {pi0,pi0,pi0,pi0,lam}, {pip,pim,pi0,pi0,lam}, {pip,pip,pim,pim,lam},
     {pip,pim,k0,k0b,lam},  {pi0,pi0,k0,k0b,lam},  {pip,pim,kpl,kmi,lam},
     {pi0,pi0,kpl,kmi,lam}, {pim,pi0,kpl,k0b,lam}, {pip,pi0,kmi,k0,lam},
     {pip,pi0,pi0,pi0,sm},  {pip,pip,pim,pi0,sm},  {pip,pi0,k0,k0b,sm},
     {pip,pi0,kpl,kmi,sm},  {pi0,pi0,kpl,k0b,sm},  {pip,pip,kmi,k0,sm},
     {pip,pim,kpl,k0b,sm},  {pi0,pi0,pi0,pi0,s0},  {pip,pim,pi0,pi0,s0},
     {pip,pip,pim,pim,s0},  {pip,pim,k0,k0b,s0},   {pi0,pi0,k0,k0b,s0},
     {pip,pim,kpl,kmi,s0},  {pi0,pi0,kpl,kmi,s0},  {pim,pi0,kpl,k0b,s0},
     {pip,pi0,kmi,k0,s0},   {pim,pi0,pi0,pi0,sp},  {pip,pim,pim,pi0,sp},
     {pim,pi0,k0,k0b,sp},   {pim,pi0,kpl,kmi,sp},  {pi0,pi0,kmi,k0,sp},
     {pip,pim,kmi,k0,sp},   {pim,pim,kpl,k0b,sp},  {pip,pi0,pi0,k0,xim},
     {pip,pip,pim,k0,xim},  {pi0,pi0,pi0,kpl,xim}, {pip,pim,pi0,kpl,xim},
     {pi0,pi0,pi0,k0,xi0},  {pip,pim,pi0,k0,xi0},  {pim,pi0,pi0,kpl,xi0},
     {pip,pim,pim,kpl,xi0}, {pip,k0,k0,k0b,xim},   {pip,kpl,kmi,k0,xim},
     {pi0,kpl,k0,k0b,xim},  {pi0,kpl,kpl,kmi,xim}, {pim,kpl,kpl,k0b,xim},
     {pip,kmi,k0,k0,xi0},   {pi0,k0,k0,k0b,xi0},   {pi0,kpl,kmi,k0,xi0},
     {pim,kpl,k0,k0b,xi0},  {pim,kpl,kpl,kmi,xi0} };

  static const G4int k0bn6bfs[78][6] =
    {{neu,pi0,pi0,pi0,pi0,k0b}, {neu,pip,pim,pi0,pi0,k0b},
     {neu,pip,pip,pim,pim,k0b}, {neu,pip,pi0,pi0,pi0,kmi},
     {neu,pip,pip,pim,pi0,kmi}, {pro,pi0,pi0,pi0,pi0,kmi},
     {pro,pip,pim,pi0,pi0,kmi}, {pro,pip,pip,pim,pim,kmi},
     {pro,pim,pi0,pi0,pi0,k0b}, {pro,pip,pim,pim,pi0,k0b},
     {neu,pi0,pi0,k0,k0b,k0b},  {neu,pip,pim,k0,k0b,k0b},
     {neu,pim,pi0,kpl,k0b,k0b}, {neu,pip,pim,kpl,kmi,k0b},
     {neu,pip,pip,kmi,kmi,k0},  {neu,pi0,pi0,kpl,kmi,k0b},
     {neu,pip,pi0,kmi,k0,k0b},  {neu,pip,pi0,kpl,kmi,kmi},
     {pro,pip,pi0,kmi,kmi,k0},  {pro,pi0,pi0,kpl,kmi,kmi},
     {pro,pip,pim,kpl,kmi,kmi}, {pro,pim,pim,kpl,k0b,k0b},
     {pro,pim,pi0,k0,k0b,k0b},  {pro,pi0,pi0,kmi,k0,k0b},
     {pro,pip,pim,kmi,k0,k0b},  {pro,pim,pi0,kpl,kmi,k0b},
     {pi0,pi0,pi0,pi0,pi0,lam}, {pip,pim,pi0,pi0,pi0,lam},
     {pip,pip,pim,pim,pi0,lam}, {pip,pip,pim,kmi,k0,lam},
     {pi0,pi0,pi0,k0,k0b,lam},  {pip,pim,pi0,k0,k0b,lam},
     {pip,pi0,pi0,kmi,k0,lam},  {pi0,pi0,pi0,kpl,kmi,lam},
     {pip,pim,pi0,kpl,kmi,lam}, {pim,pi0,pi0,kpl,k0b,lam},
     {pip,pim,pim,kpl,k0b,lam}, {pip,pi0,pi0,pi0,pi0,sm},
     {pip,pip,pim,pi0,pi0,sm},  {pip,pip,pip,pim,pim,sm},
     {pip,pip,pi0,kmi,k0,sm},   {pip,pim,pi0,kpl,k0b,sm},
     {pi0,pi0,pi0,kpl,k0b,sm},  {pip,pi0,pi0,k0,k0b,sm},
     {pip,pip,pim,k0,k0b,sm},   {pip,pi0,pi0,kpl,kmi,sm},
     {pip,pip,pim,kpl,kmi,sm},  {pi0,pi0,pi0,pi0,pi0,s0},
     {pip,pim,pi0,pi0,pi0,s0},  {pip,pip,pim,pim,pi0,s0},
     {pip,pi0,pi0,kmi,k0,s0},   {pi0,pi0,pi0,k0,k0b,s0},
     {pip,pim,pi0,k0,k0b,s0},   {pip,pip,pim,kmi,k0,s0},
     {pi0,pi0,pi0,kpl,kmi,s0},  {pip,pim,pi0,kpl,kmi,s0},
     {pim,pi0,pi0,kpl,k0b,s0},  {pip,pim,pim,kpl,k0b,s0},
     {pim,pi0,pi0,pi0,pi0,sp},  {pip,pim,pim,pi0,pi0,sp},
     {pip,pip,pim,pim,pim,sp},  {pi0,pi0,pi0,kmi,k0,sp},
     {pip,pim,pi0,kmi,k0,sp},   {pim,pi0,pi0,k0,k0b,sp},
     {pip,pim,pim,k0,k0b,sp},   {pim,pi0,pi0,kpl,kmi,sp},
     {pip,pim,pim,kpl,kmi,sp},  {pim,pim,pi0,kpl,k0b,sp},
     {pip,pi0,pi0,pi0,k0,xim},  {pip,pip,pim,pi0,k0,xim},
     {pi0,pi0,pi0,pi0,kpl,xim}, {pip,pip,pim,pim,kpl,xim},
     {pip,pim,pi0,pi0,kpl,xim}, {pi0,pi0,pi0,pi0,k0,xi0},
     {pip,pim,pi0,pi0,k0,xi0},  {pip,pip,pim,pim,k0,xi0},
     {pim,pi0,pi0,pi0,kpl,xi0}, {pip,pim,pim,pi0,kpl,xi0} };

  static const G4int k0bn7bfs[96][7] =
    {{neu,pi0,pi0,pi0,pi0,pi0,k0b}, {neu,pip,pim,pi0,pi0,pi0,k0b},
     {neu,pip,pip,pim,pim,pi0,k0b}, {neu,pip,pi0,pi0,pi0,pi0,kmi},
     {neu,pip,pip,pip,pim,pim,kmi}, {neu,pip,pip,pim,pi0,pi0,kmi},
     {pro,pi0,pi0,pi0,pi0,pi0,kmi}, {pro,pip,pim,pi0,pi0,pi0,kmi},
     {pro,pip,pip,pim,pim,pi0,kmi}, {pro,pim,pi0,pi0,pi0,pi0,k0b},
     {pro,pip,pip,pim,pim,pim,k0b}, {pro,pip,pim,pim,pi0,pi0,k0b},
     {neu,pip,pip,pi0,kmi,kmi,k0},  {neu,pip,pi0,pi0,kmi,k0,k0b},
     {neu,pi0,pi0,pi0,k0,k0b,k0b},  {neu,pip,pi0,pi0,kpl,kmi,kmi},
     {neu,pip,pip,pim,kmi,k0,k0b},  {neu,pip,pip,pim,kpl,kmi,kmi},
     {neu,pim,pi0,pi0,kpl,k0b,k0b}, {neu,pip,pim,pi0,k0,k0b,k0b}, 
     {neu,pip,pim,pim,kpl,k0b,k0b}, {neu,pi0,pi0,pi0,kpl,kmi,k0b},
     {neu,pip,pim,pi0,kpl,kmi,k0b}, {pro,pip,pi0,pi0,kmi,kmi,k0},
     {pro,pim,pi0,pi0,kpl,kmi,k0b}, {pro,pi0,pi0,pi0,kpl,kmi,kmi},
     {pro,pip,pip,pim,kmi,kmi,k0},  {pro,pip,pim,pim,kpl,kmi,k0b},
     {pro,pim,pi0,pi0,k0,k0b,k0b},  {pro,pip,pim,pi0,kpl,kmi,kmi},
     {pro,pip,pim,pim,k0,k0b,k0b},  {pro,pim,pim,pi0,kpl,k0b,k0b},
     {pro,pi0,pi0,pi0,kmi,k0,k0b},  {pro,pip,pim,pi0,kmi,k0,k0b},
     {pi0,pi0,pi0,pi0,pi0,pi0,lam}, {pip,pim,pi0,pi0,pi0,pi0,lam},
     {pip,pip,pim,pim,pi0,pi0,lam}, {pip,pip,pip,pim,pim,pim,lam},
     {pip,pip,pim,pi0,kmi,k0,lam},  {pip,pi0,pi0,pi0,kmi,k0,lam},
     {pip,pip,pim,pim,k0,k0b,lam},  {pi0,pi0,pi0,pi0,k0,k0b,lam},
     {pip,pim,pi0,pi0,k0,k0b,lam},  {pim,pi0,pi0,pi0,kpl,k0b,lam},
     {pip,pip,pim,pim,kpl,kmi,lam}, {pi0,pi0,pi0,pi0,kpl,kmi,lam},
     {pip,pim,pi0,pi0,kpl,kmi,lam}, {pip,pim,pim,pi0,kpl,k0b,lam},
     {pip,pi0,pi0,pi0,pi0,pi0,sm},  {pip,pip,pim,pi0,pi0,pi0,sm},
     {pip,pip,pip,pim,pim,pi0,sm},  {pip,pip,pim,pi0,k0,k0b,sm},
     {pip,pip,pip,pim,kmi,k0,sm},   {pip,pip,pi0,pi0,kmi,k0,sm},
     {pi0,pi0,pi0,pi0,kpl,k0b,sm},  {pip,pip,pim,pi0,kpl,kmi,sm},
     {pip,pi0,pi0,pi0,k0,k0b,sm},   {pip,pip,pim,pim,kpl,k0b,sm},
     {pip,pim,pi0,pi0,kpl,k0b,sm},  {pip,pi0,pi0,pi0,kpl,kmi,sm},
     {pi0,pi0,pi0,pi0,pi0,pi0,s0},  {pip,pim,pi0,pi0,pi0,pi0,s0},
     {pip,pip,pim,pim,pi0,pi0,s0},  {pip,pip,pip,pim,pim,pim,s0},
     {pip,pip,pim,pi0,kmi,k0,s0},   {pip,pi0,pi0,pi0,kmi,k0,s0},
     {pip,pip,pim,pim,k0,k0b,s0},   {pi0,pi0,pi0,pi0,k0,k0b,s0},
     {pip,pim,pi0,pi0,k0,k0b,s0},   {pim,pi0,pi0,pi0,kpl,k0b,s0},
     {pip,pip,pim,pim,kpl,kmi,s0},  {pi0,pi0,pi0,pi0,kpl,kmi,s0},
     {pip,pim,pi0,pi0,kpl,kmi,s0},  {pip,pim,pim,pi0,kpl,k0b,s0},
     {pim,pi0,pi0,pi0,pi0,pi0,sp},  {pip,pim,pim,pi0,pi0,pi0,sp},
     {pip,pip,pim,pim,pim,pi0,sp},  {pip,pim,pi0,pi0,kmi,k0,sp},
     {pip,pip,pim,pim,kmi,k0,sp},   {pim,pi0,pi0,pi0,k0,k0b,sp},
     {pi0,pi0,pi0,pi0,kmi,k0,sp},   {pip,pim,pim,pi0,k0,k0b,sp},
     {pim,pim,pi0,pi0,kpl,k0b,sp},  {pim,pi0,pi0,pi0,kpl,kmi,sp},
     {pip,pim,pim,pi0,kpl,kmi,sp},  {pip,pim,pim,pim,kpl,k0b,sp},
     {pip,pi0,pi0,pi0,pi0,k0,xim},  {pip,pim,pi0,pi0,pi0,kpl,xim},
     {pip,pip,pip,pim,pim,k0,xim},  {pip,pip,pim,pi0,pi0,k0,xim},
     {pip,pip,pim,pim,pi0,kpl,xim}, {pim,pi0,pi0,pi0,pi0,kpl,xi0},
     {pip,pip,pim,pim,pi0,k0,xi0},  {pip,pim,pi0,pi0,pi0,k0,xi0},
     {pip,pip,pim,pim,pim,kpl,xi0}, {pip,pim,pim,pi0,pi0,kpl,xi0} };

  static const G4int k0bn8bfs[40][8] =
    {{neu,pip,pim,pi0,pi0,pi0,pi0,k0b}, {neu,pip,pip,pim,pim,pi0,pi0,k0b},
     {neu,pip,pip,pip,pim,pim,pim,k0b}, {neu,pip,pi0,pi0,pi0,pi0,pi0,kmi},
     {neu,pip,pip,pip,pim,pim,pi0,kmi}, {neu,pi0,pi0,pi0,pi0,pi0,pi0,k0b},
     {neu,pip,pip,pim,pi0,pi0,pi0,kmi}, {pro,pip,pim,pi0,pi0,pi0,pi0,kmi},
     {pro,pip,pip,pim,pim,pi0,pi0,kmi}, {pro,pip,pip,pip,pim,pim,pim,kmi},
     {pro,pim,pi0,pi0,pi0,pi0,pi0,k0b}, {pro,pip,pim,pim,pi0,pi0,pi0,k0b},
     {pro,pi0,pi0,pi0,pi0,pi0,pi0,kmi}, {pro,pip,pip,pim,pim,pim,pi0,k0b},
     {pip,pim,pi0,pi0,pi0,pi0,pi0,lam}, {pip,pip,pim,pim,pi0,pi0,pi0,lam},
     {pip,pip,pip,pim,pim,pim,pi0,lam}, {pip,pi0,pi0,pi0,pi0,pi0,pi0,sm},
     {pip,pip,pim,pi0,pi0,pi0,pi0,sm},  {pip,pip,pip,pim,pim,pi0,pi0,sm},
     {pip,pip,pip,pip,pim,pim,pim,sm},  {pip,pim,pi0,pi0,pi0,pi0,pi0,s0},
     {pip,pip,pim,pim,pi0,pi0,pi0,s0},  {pip,pip,pip,pim,pim,pim,pi0,s0},
     {pim,pi0,pi0,pi0,pi0,pi0,pi0,sp},  {pip,pim,pim,pi0,pi0,pi0,pi0,sp},
     {pip,pip,pim,pim,pim,pi0,pi0,sp},  {pip,pip,pip,pim,pim,pim,pim,sp},
     {pip,pip,pim,pi0,pi0,pi0,k0,xim},  {pip,pip,pim,pim,pi0,pi0,kpl,xim},
     {pip,pip,pip,pim,pim,pim,kpl,xim}, {pip,pip,pip,pim,pim,pi0,k0,xim},
     {pip,pim,pi0,pi0,pi0,pi0,kpl,xim}, {pip,pi0,pi0,pi0,pi0,pi0,k0,xim},
     {pip,pim,pim,pi0,pi0,pi0,kpl,xi0}, {pip,pip,pim,pim,pi0,pi0,k0,xi0},
     {pip,pip,pip,pim,pim,pim,k0,xi0},  {pip,pip,pim,pim,pim,pi0,kpl,xi0},
     {pip,pim,pi0,pi0,pi0,pi0,k0,xi0},  {pim,pi0,pi0,pi0,pi0,pi0,kpl,xi0} };

  static const G4int k0bn9bfs[42][9] =
    {{neu,pip,pip,pim,pim,pi0,pi0,pi0,k0b}, {neu,pip,pip,pip,pim,pim,pim,pi0,k0b},
     {neu,pip,pip,pim,pi0,pi0,pi0,pi0,kmi}, {neu,pip,pip,pip,pip,pim,pim,pim,kmi},
     {neu,pip,pip,pip,pim,pim,pi0,pi0,kmi}, {neu,pip,pim,pi0,pi0,pi0,pi0,pi0,k0b},
     {neu,pip,pi0,pi0,pi0,pi0,pi0,pi0,kmi}, {neu,pi0,pi0,pi0,pi0,pi0,pi0,pi0,k0b},
     {pro,pip,pip,pip,pim,pim,pim,pi0,kmi}, {pro,pip,pim,pim,pi0,pi0,pi0,pi0,k0b},
     {pro,pip,pip,pip,pim,pim,pim,pim,k0b}, {pro,pip,pip,pim,pim,pim,pi0,pi0,k0b},
     {pro,pip,pip,pim,pim,pi0,pi0,pi0,kmi}, {pro,pip,pim,pi0,pi0,pi0,pi0,pi0,kmi},
     {pro,pim,pi0,pi0,pi0,pi0,pi0,pi0,k0b}, {pro,pi0,pi0,pi0,pi0,pi0,pi0,pi0,kmi},
     {pip,pip,pip,pim,pim,pim,pi0,pi0,lam}, {pip,pip,pim,pim,pi0,pi0,pi0,pi0,lam},
     {pip,pim,pi0,pi0,pi0,pi0,pi0,pi0,lam}, {pip,pip,pip,pip,pim,pim,pim,pim,lam},
     {pip,pip,pip,pim,pim,pi0,pi0,pi0,sm},  {pip,pip,pip,pip,pim,pim,pim,pi0,sm},
     {pip,pip,pim,pi0,pi0,pi0,pi0,pi0,sm},  {pip,pip,pip,pim,pim,pim,pi0,pi0,s0},
     {pip,pip,pim,pim,pi0,pi0,pi0,pi0,s0},  {pip,pim,pi0,pi0,pi0,pi0,pi0,pi0,s0},
     {pip,pip,pip,pip,pim,pim,pim,pim,s0},  {pip,pip,pim,pim,pim,pi0,pi0,pi0,sp},
     {pip,pip,pip,pim,pim,pim,pim,pi0,sp},  {pip,pim,pim,pi0,pi0,pi0,pi0,pi0,sp},
     {pip,pip,pip,pim,pim,pi0,pi0,k0,xim},  {pip,pip,pip,pim,pim,pim,pi0,kpl,xim},
     {pip,pip,pim,pi0,pi0,pi0,pi0,k0,xim},  {pip,pip,pim,pim,pi0,pi0,pi0,kpl,xim},
     {pip,pip,pip,pip,pim,pim,pim,k0,xim},  {pip,pim,pi0,pi0,pi0,pi0,pi0,kpl,xim},
     {pip,pip,pip,pim,pim,pim,pi0,k0,xi0},  {pip,pim,pim,pi0,pi0,pi0,pi0,kpl,xi0},
     {pip,pip,pim,pim,pi0,pi0,pi0,k0,xi0},  {pip,pip,pim,pim,pim,pi0,pi0,kpl,xi0},
     {pip,pip,pip,pim,pim,pim,pim,kpl,xi0}, {pip,pim,pi0,pi0,pi0,pi0,pi0,k0,xi0} };

  // Cross sections for K0b n -> 2-9 body final states
  // 
  // first index:     0-7: channels for mult = 2
  //                 8-27: channels for mult = 3 
  //                28-69: channels for mult = 4
  //               70-137: channels for mult = 5
  //              138-215: channels for mult = 6
  //              216-311: channels for mult = 7
  //              312-351: channels for mult = 8
  //              352-393: channels for mult = 9
  //
  // second index: kinetic energy
  // 
  static const G4double k0bnCrossSections[394][30] = {
    //
    // multiplicity 2 (8 channels)
    //  
    // K0b n
    {150.0, 92.0, 75.0, 60.0, 51.0, 43.6, 37.0, 32.0, 22.2, 17.5,
      14.0, 19.1, 20.3, 21.5, 13.9, 10.0,  8.7,  9.0,  7.9,  6.4,
       5.2,  4.5,  4.1,  3.7,  3.4,  3.1,  3.0,  2.9,  2.7,  2.6},

    // K- p 
    { 74.0, 30.0, 19.0, 12.2,  9.1,   7.4,   6.4,  12.03,  4.5,   4.0,
       3.0,  4.0,  4.8,  8.3,  2.9,   1.7,   1.8,   1.8,   1.0,   0.8,
       0.5,  0.3,  0.2,  0.13, 0.086, 0.055, 0.037, 0.023, 0.014, 0.009},

    // L pi0
    { 89.6, 32.5, 19.9, 12.1, 10.0,   6.9,   5.4,   4.3,   3.1,   2.52,
       2.63, 3.0,  3.4,  2.6,  1.4,   1.1,   1.3,   1.0,   0.6,   0.37,
       0.20, 0.10, 0.05, 0.03, 0.018, 0.012, 0.008, 0.005, 0.004, 0.002},

    // S- pi+
    { 49.0, 27.2, 20.4, 15.1,  12.5,  10.9,  10.6,  10.495, 6.1,   4.04,
       2.9,  2.2,  1.7,  1.8,   1.3,   1.3,   1.2,   1.0,   0.63,  0.4,
       0.28, 0.18, 0.12, 0.075, 0.046, 0.028, 0.018, 0.01,  0.006, 0.004},

    // S0 pi0
    { 42.6, 20.5,  14.4,   9.9,   7.8,   5.6,   4.16,  7.8,  2.6,  1.9,
       1.7,  0.98,  0.7,   0.9,   0.5,   0.3,   0.24,  0.21, 0.13, 0.077,
       0.05, 0.027, 0.015, 0.008, 0.004, 0.002, 0.001, 0.0,  0.0,  0.0},

    // S+ pi-
    {140.0,  68.0,  30.0,  14.5,  13.0,   8.3,   6.45,  7.5,   3.005, 2.4,
       3.1,   2.4,   1.2,   1.5,   0.8,   0.47,  0.38,  0.33,  0.19,  0.12,
       0.077, 0.042, 0.023, 0.012, 0.006, 0.003, 0.002, 0.001, 0.0,   0.0},

    // Xi- K+
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.016, 0.058, 0.082, 0.095, 0.053, 0.043,
      0.02, 0.008, 0.003, 0.001, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0},

    // Xi0 K0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.03,  0.11, 0.155, 0.179, 0.098, 0.083,
      0.039, 0.016, 0.006, 0.002, 0.001, 0.0,  0.0,   0.0,   0.0,   0.0},

    //
    //  multiplicity 3 (20 channels)
    //
    // K0b n pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.011,
      0.067, 0.36, 0.69,  1.15,  1.391, 1.251, 1.471, 1.7,  1.55, 1.28,
      1.01,  0.78, 0.593, 0.434, 0.328, 0.25,  0.187, 0.13, 0.10, 0.073},

    // K- n pi+
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.011,
      0.035, 0.101, 0.27,  0.93,  2.0,   1.631, 1.8,   2.0,  1.9,   1.8,
      1.38,  0.85,  0.603, 0.425, 0.299, 0.22,  0.158, 0.11, 0.075, 0.052},

    // K0b p pi-
    { 0.0,   0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,  0.0,  0.025,
      0.076, 0.20, 0.39, 0.83, 1.691, 1.921, 2.2,   2.7,  2.7,  2.3,
      1.82,  1.41, 1.07, 0.78, 0.579, 0.44,  0.335, 0.24, 0.17, 0.13},

    // K- p pi0
    { 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.011,
      0.067, 0.36, 0.69, 1.15,  1.391, 1.251, 1.471, 1.7,  1.55, 1.28,
      1.01,  0.78, 0.59, 0.434, 0.328, 0.25,  0.187, 0.13, 0.10, 0.073},

    // L pi0 pi0
    { 0.0,   0.0, 0.004, 0.007, 0.029, 0.089, 0.3,   1.0,   0.72,  0.951,
      1.3,   1.8, 1.9,   2.08,  1.491, 1.35,  1.25,  1.1,   0.9,   0.606,
      0.372, 0.2, 0.114, 0.063, 0.033, 0.017, 0.010, 0.004, 0.002, 0.001},

    // L pi+ pi-
    { 0.0,   0.0, 0.006, 0.013, 0.058, 0.179, 0.6,   2.0,   1.45,  1.9,
      2.6,   3.6, 3.8,   4.15,  2.99,  2.7,   2.5,   2.2,   1.8,   1.212,
      0.744, 0.4, 0.227, 0.125, 0.065, 0.035, 0.020, 0.009, 0.005, 0.002},

    // L K0 K0b
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.02,  0.072,
      0.071, 0.055, 0.042, 0.031, 0.023, 0.018, 0.014, 0.010, 0.007, 0.005},

    // L K+ K-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.02,  0.072,
      0.071, 0.055, 0.042, 0.031, 0.023, 0.018, 0.014, 0.010, 0.007, 0.005},

    // S- pi+ pi0
    { 0.0,  0.0,   0.0,   0.0,   0.002, 0.007, 0.034, 0.15,  0.09,  0.21,
      0.42, 0.559, 0.749, 1.01,  1.1,   1.2,   1.2,   1.1,   0.9,   0.64,
      0.43, 0.273, 0.178, 0.106, 0.066, 0.041, 0.026, 0.015, 0.009, 0.005},

    // S0 pi0 pi0
    { 0.0,   0.0,   0.0,  0.0,   0.002, 0.004, 0.008, 0.045, 0.038, 0.09,
      0.2,   0.315, 0.27, 0.263, 0.4,   0.43,  0.42,  0.38,  0.3,   0.23,
      0.158, 0.105, 0.07, 0.042, 0.027, 0.017, 0.011, 0.006, 0.004, 0.002},

    // S0 pi+ pi-
    { 0.0,   0.0,  0.0,   0.0,   0.004, 0.009, 0.018, 0.09,  0.077, 0.18,
      0.4,   0.63, 0.55,  0.525, 0.8,   0.86,  0.84,  0.76,  0.6,   0.45,
      0.315, 0.21, 0.138, 0.086, 0.054, 0.035, 0.023, 0.013, 0.008, 0.005},

    // S+ pi- pi0
    { 0.0,  0.0,   0.0,   0.0,   0.005, 0.012, 0.03,  0.09,  0.12,  0.25,
      0.47, 0.71,  0.74,  0.83,  0.8,   0.8,   0.81,  0.8,   0.7,   0.55,
      0.38, 0.244, 0.158, 0.096, 0.061, 0.04,  0.025, 0.014, 0.009, 0.005},

    // S- K0b K+
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.01,
      0.011, 0.007, 0.005, 0.003, 0.002, 0.001, 0.001, 0.0, 0.0, 0.0},

    // S0 K0 K0b
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.031,
      0.033, 0.021, 0.013, 0.008, 0.005, 0.003, 0.002, 0.001, 0.001, 0.0},

    // S0 K+ K-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.028,
      0.033, 0.025, 0.019, 0.014, 0.01,  0.007, 0.005, 0.003, 0.002, 0.001},

    // S+ K0 K-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.008,
      0.015, 0.013, 0.011, 0.009, 0.004, 0.002, 0.001, 0.0,   0.0,   0.0},

    // Xi0 K+ pi-
    { 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.001, 0.032, 0.07, 0.084,
      0.053, 0.03, 0.018, 0.01, 0.005, 0.003, 0.002, 0.001, 0.0,  0.0},

    // Xi0 K0 pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.03, 0.025, 0.047,
      0.032, 0.018, 0.011, 0.006, 0.003, 0.002, 0.001, 0.0,  0.0,   0.0},

    // Xi- K0 pi+
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.019, 0.042, 0.05,
      0.032, 0.018, 0.011, 0.006, 0.003, 0.002, 0.001, 0.0,   0.0,   0.0},

    // Xi- K+ pi0
    { 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.032, 0.07, 0.084,
      0.053, 0.03, 0.018, 0.01, 0.005, 0.003, 0.002, 0.001, 0.0,  0.0},

    //
    //  multiplicity 4 (42 channels)
    //
    // n K0b 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0,   0.0,   0.001, 0.005, 0.018, 0.041, 0.085, 0.23, 0.37, 0.55,
      0.637, 0.647, 0.577, 0.509, 0.45,  0.403, 0.374, 0.34, 0.30, 0.27},

    // n K0b pi+ pi-
    { 0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0,  0.0,  0.002, 0.01,  0.037, 0.082, 0.17,  0.46, 0.74, 1.1,
      1.27, 1.26, 1.16,  1.016, 0.908, 0.816, 0.749, 0.67, 0.60, 0.54},

    // n K- pi+ pi0
    { 0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0,  0.0,  0.004, 0.01,  0.024, 0.04,  0.065, 0.19, 0.44, 0.95,
      1.08, 0.99, 0.86,  0.737, 0.64,  0.557, 0.502, 0.43, 0.38, 0.32},

    // p K0b pi- pi0
    { 0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0,  0.0,  0.004, 0.01,  0.024, 0.04,  0.065, 0.19, 0.44, 0.95,
      1.08, 0.99, 0.86,  0.737, 0.64,  0.557, 0.502, 0.43, 0.38, 0.32},

    // p K- 2pi0
    { 0.0,  0.0,   0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,  0.0,   0.0004, 0.002, 0.007, 0.017, 0.04,  0.105, 0.21, 0.38,
      0.48, 0.522, 0.39,   0.279, 0.201, 0.144, 0.108, 0.08,  0.05, 0.039},

    // p K- pi+ pi-
    { 0.0,  0.0,  0.0,    0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0,  0.0,  0.0006, 0.003, 0.014, 0.035, 0.08,  0.21, 0.43, 0.77,
      0.96, 1.04, 0.78,   0.558, 0.401, 0.288, 0.217, 0.15, 0.11, 0.077},

    // n K0 K0b K0b
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.003, 0.006, 0.015, 0.026, 0.026, 0.027, 0.027, 0.027},

    // n K+ K- K0b
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.008, 0.012, 0.013, 0.013, 0.013, 0.013},

    // p K0 K0b K-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.003, 0.006, 0.015, 0.026, 0.026, 0.027, 0.027, 0.027},

    // p K+ K- K-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.008, 0.012, 0.013, 0.013, 0.013, 0.013},

    // L 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.005, 0.025, 0.04,  0.067, 0.086, 0.25,  0.33, 0.37,  0.355, 0.33,
      0.276, 0.199, 0.113, 0.06,  0.032, 0.017, 0.01, 0.005, 0.003, 0.001},

    // L pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.001,
      0.03, 0.15, 0.24, 0.384, 0.516, 1.49,  2.0,   2.2,  2.15,  2.0,
      1.67, 1.19, 0.67, 0.37,  0.19,  0.106, 0.061, 0.03, 0.016, 0.008},

    // L K0 K0b pi0
    { 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.003, 0.07, 0.069, 0.06, 0.055, 0.048, 0.046, 0.04, 0.037, 0.032},

    // L K+ K- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.034, 0.034, 0.029, 0.026, 0.023, 0.022, 0.019, 0.018, 0.016},

    // L K0 K- pi+
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.001,
      0.009, 0.209, 0.205, 0.183, 0.164, 0.144, 0.138, 0.12, 0.11, 0.097},

    // L K+ K0b pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.034, 0.034, 0.029, 0.026, 0.023, 0.022, 0.019, 0.018, 0.016},

    // S- pi+ 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.002, 0.012, 0.09,  0.15,  0.09,  0.13,  0.22, 0.27,  0.27,
      0.255, 0.219, 0.146, 0.101, 0.068, 0.045, 0.031, 0.02, 0.013, 0.009},

    // S- 2pi+ pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.002, 0.012, 0.09,  0.15,  0.09,  0.13,  0.22, 0.27,  0.27,
      0.255, 0.219, 0.146, 0.101, 0.068, 0.045, 0.031, 0.02, 0.013, 0.009},

    // S- K0 K0b pi+
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.004, 0.023, 0.032, 0.027, 0.02, 0.015, 0.013, 0.009, 0.007, 0.005},

    // S- K+ K- pi+
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.002, 0.011, 0.016, 0.014, 0.01, 0.008, 0.006, 0.004, 0.003, 0.002},

    // S- K+ K0b pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.002, 0.011, 0.016, 0.014, 0.01, 0.008, 0.006, 0.004, 0.003, 0.002},

    // S0 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.001, 0.004, 0.03,  0.05,  0.03,  0.043, 0.073, 0.09,  0.09,
      0.085, 0.073, 0.05,  0.034, 0.022, 0.015, 0.011, 0.007, 0.004, 0.003},

    // S0 pi+ pi- pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.0,   0.0,
      0.0,  0.004, 0.024, 0.18,  0.3,   0.18, 0.26,  0.44, 0.54,  0.54,
      0.51, 0.438, 0.293, 0.203, 0.135, 0.09, 0.063, 0.04, 0.026, 0.018},

    // S0 K0 K0b pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.007, 0.011, 0.01, 0.007, 0.005, 0.004, 0.003, 0.002, 0.001},

    // S0 K+ K- pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.007, 0.011, 0.01, 0.007, 0.005, 0.004, 0.003, 0.002, 0.001},

    // S0 K0 K- pi+
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.007, 0.011, 0.01, 0.007, 0.005, 0.004, 0.003, 0.002, 0.001},

    // S0 K+ K0b pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.003, 0.015, 0.023, 0.018, 0.013, 0.011, 0.009, 0.006, 0.005, 0.003},

    // S+ pi- 2pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.002, 0.031, 0.065, 0.041, 0.055, 0.075, 0.09,  0.095,
      0.088, 0.07, 0.05,  0.035, 0.024 ,0.016, 0.012, 0.008, 0.006, 0.004},

    // S+ pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.001, 0.004, 0.063, 0.13,  0.082, 0.11,  0.15,  0.18,  0.19,
      0.176, 0.139, 0.098, 0.07,  0.048, 0.034, 0.025, 0.017, 0.012, 0.008},

    // S+ K0 K0b pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.003, 0.015, 0.021, 0.018, 0.013, 0.011, 0.009, 0.006, 0.005, 0.003},

    // S+ K+ K- pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.003, 0.015, 0.021, 0.018, 0.013, 0.011, 0.009, 0.006, 0.005, 0.003},

    // S+ K0 K- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.008, 0.011, 0.009, 0.007, 0.005, 0.004, 0.003, 0.002, 0.001},

    // Xi- K0 pi+ pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.008,
      0.014, 0.02, 0.021, 0.013, 0.008, 0.005, 0.003, 0.002, 0.001, 0.001},

    // Xi- K+ 2pi0
    { 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.001, 0.006,
      0.01, 0.015, 0.016, 0.01, 0.006, 0.004, 0.002, 0.001, 0.001, 0.0},

    // Xi- K+ pi+ pi-
    { 0.0,  0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.002, 0.012,
      0.02, 0.03, 0.032, 0.02, 0.012, 0.008, 0.004, 0.003, 0.002, 0.001},

    // Xi- K+ K+ K-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.001, 0.003, 0.002, 0.001, 0.0, 0.0, 0.0, 0.0},

    // Xi- K0 K0b K-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.0,
      0.0, 0.0, 0.002, 0.007, 0.004, 0.003, 0.001, 0.001, 0.0, 0.0},

    // Xi0 K0 2pi0
    { 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.0,
      0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.004,
      0.007, 0.01, 0.01, 0.007, 0.004, 0.002, 0.001, 0.001, 0.0, 0.0},

    // Xi0 K0 pi+ pi-
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.008,
      0.014, 0.02, 0.021, 0.013, 0.008, 0.005, 0.003, 0.002, 0.001, 0.001},

    // Xi0 K+ pi- pi0
    { 0.0,  0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.002, 0.012,
      0.02, 0.03, 0.032, 0.02, 0.012, 0.008, 0.004, 0.003, 0.002, 0.001},

    // Xi0 K0 K+ K-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0, 0.0,
      0.0, 0.0, 0.002, 0.007, 0.004, 0.003, 0.001, 0.001, 0.0, 0.0},

    // Xi0 K0 K0 K0b
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.001, 0.003, 0.002, 0.001, 0.0, 0.0, 0.0, 0.0},

    //
    //  multiplicity 5 (68 channels)
    // 
    // n K0b 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.002, 0.012, 0.005, 0.03,
      0.067, 0.117, 0.145, 0.154, 0.149, 0.128, 0.112, 0.093, 0.078, 0.065},

    // n K0b pi+ pi- pi0
    { 0.0,   0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,
      0.0,   0.0, 0.0,   0.0,   0.002, 0.004, 0.01, 0.07, 0.03, 0.18,
      0.408, 0.7, 0.869, 0.926, 0.89,  0.768, 0.67, 0.56, 0.47, 0.39},

    // n K- pi+ 2pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.001, 0.008, 0.003, 0.016,
      0.069, 0.13, 0.158, 0.164, 0.152, 0.125, 0.108, 0.09,  0.07,  0.06},

    // n K- 2pi+ pi-
    { 0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,   0.0,   0.0,   0.001, 0.002, 0.015, 0.006, 0.033,
      0.14, 0.27, 0.316, 0.328, 0.306, 0.259, 0.226, 0.18,  0.15,  0.12},

    // p K0b pi- 2pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.001, 0.002, 0.004, 0.014, 0.025, 0.05,
      0.186, 0.34, 0.415, 0.444, 0.43,  0.384, 0.335, 0.28,  0.24,  0.2},

    // p K0b pi+ 2pi-
    { 0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,   0.0,   0.001, 0.002, 0.004, 0.014, 0.025, 0.05,
      0.19, 0.34, 0.415, 0.444, 0.43,  0.384, 0.335, 0.28,  0.24,  0.2},

    // p K- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.002, 0.012, 0.005, 0.03,
      0.067, 0.117, 0.145, 0.164, 0.148, 0.128, 0.112, 0.093, 0.078, 0.065},

    // p K- pi+ pi- pi0
    { 0.0,   0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,
      0.0,   0.0, 0.0,   0.0,   0.002, 0.004, 0.01, 0.07, 0.03, 0.18,
      0.402, 0.7, 0.869, 0.926, 0.89,  0.768, 0.67, 0.56, 0.47, 0.39},

    // n K0 K0b K0b pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.005, 0.01, 0.01, 0.008, 0.007, 0.005, 0.004, 0.003},

    // n K+ K- K0b pi0
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.01, 0.018, 0.018, 0.015, 0.014, 0.011, 0.009, 0.007},

    // n K0 K0b K- pi+
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.01, 0.018, 0.018, 0.015, 0.014, 0.011, 0.009, 0.007},

    // n K+ K0b K0b pi-
    { 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.005, 0.01, 0.01, 0.008, 0.007, 0.005, 0.004, 0.003},

    // n K+ K- K- pi+
    { 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.005, 0.01, 0.01, 0.008, 0.007, 0.005, 0.004, 0.003},

    // p K0 K0b K0b pi-
    { 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.005, 0.01, 0.01, 0.008, 0.007, 0.005, 0.004, 0.003},

    // p K+ K- K0b pi-
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.01, 0.018, 0.018, 0.015, 0.014, 0.011, 0.009, 0.007},

    // p K0 K0b K- pi0
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.01, 0.018, 0.018, 0.015, 0.014, 0.011, 0.009, 0.007},

    // p K+ K- K- pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.005, 0.01, 0.01, 0.008, 0.007, 0.005, 0.004, 0.003},

    // p K0 K- K- pi+
    { 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.005, 0.01, 0.01, 0.008, 0.007, 0.005, 0.004, 0.003},

    // L 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.003, 0.004, 0.006,
      0.008, 0.007, 0.006, 0.005, 0.003, 0.002, 0.001, 0.0,   0.0,   0.0},

    // L pi+ pi- 2pi0
    { 0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,  0.001, 0.004, 0.007, 0.012, 0.04,  0.045, 0.075,
      0.09, 0.085, 0.07, 0.053, 0.037, 0.025, 0.019, 0.012, 0.008, 0.005},

    // L 2pi+ 2pi-
    { 0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.001, 0.003, 0.008, 0.014, 0.024, 0.08,  0.09,  0.15,
      0.18, 0.17, 0.138, 0.106, 0.073, 0.05,  0.036, 0.024, 0.016, 0.011},

    // L K0 K0b pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.009, 0.019, 0.019, 0.017, 0.016, 0.015, 0.013, 0.012},

    // L K0 K0b 2pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.004, 0.01, 0.01, 0.009, 0.008, 0.007, 0.006, 0.006},

    // L K+ K- pi+ pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.001, 0.005, 0.018, 0.039, 0.039, 0.035, 0.032, 0.03, 0.027, 0.024},

    // L K+ K- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.009, 0.019, 0.019, 0.017, 0.016, 0.015, 0.013, 0.012},

    // L K+ K0b pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.001, 0.005, 0.018, 0.039, 0.039, 0.035, 0.032, 0.03, 0.027, 0.024},

    // L K0 K- pi+ pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.001, 0.005, 0.018, 0.039, 0.039, 0.035, 0.032, 0.03, 0.027, 0.024},

    // S- pi+ 3pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,   0.001, 0.002, 0.007, 0.017, 0.04,
      0.056, 0.063, 0.06, 0.051, 0.035, 0.024, 0.018, 0.012, 0.008, 0.005},

    // S- 2pi+ pi- pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.001, 0.002, 0.004, 0.006, 0.02,  0.05,  0.12,
      0.167, 0.19, 0.179, 0.154, 0.106, 0.073, 0.053, 0.035, 0.024, 0.016},

    // S- K0 K0b pi+ pi0
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.01, 0.012, 0.011, 0.01, 0.01, 0.009, 0.009, 0.008},

    // S- K+ K- pi+ pi0
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.01, 0.012, 0.011, 0.01, 0.01, 0.009, 0.009, 0.008},

    // S- K+ K0b 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.006, 0.006, 0.005, 0.005, 0.004, 0.004, 0.004},

    // S- K0 K- 2pi+
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.006, 0.006, 0.005, 0.005, 0.004, 0.004, 0.004},

    // S- K+ K0b pi+ pi-
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.01, 0.012, 0.011, 0.01, 0.01, 0.009, 0.009, 0.008},

    // S0 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.002, 0.004, 0.01,
      0.014, 0.016, 0.015, 0.013, 0.009, 0.006, 0.004, 0.003, 0.002, 0.001},

    // S0 pi+ pi- 2pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.001, 0.002, 0.004, 0.006, 0.02,  0.05,  0.12,
      0.167, 0.19, 0.179, 0.154, 0.106, 0.073, 0.053, 0.035, 0.024, 0.016},

    // S0 2pi+ 2pi-
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.001, 0.002, 0.003, 0.01,  0.025, 0.06,
      0.083, 0.095, 0.09, 0.077, 0.053, 0.036, 0.027, 0.017, 0.012, 0.008},

    // S0 K0 K0b pi+ pi-
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.01, 0.012, 0.011, 0.01, 0.009, 0.009, 0.009, 0.008},

    // S0 K0 K0b 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.006, 0.006, 0.005, 0.005, 0.004, 0.004, 0.004},

    // S0 K+ K- pi+ pi-
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.01, 0.012, 0.011, 0.01, 0.009, 0.009, 0.009, 0.008},

    // S0 K+ K- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.006, 0.006, 0.005, 0.005, 0.004, 0.004, 0.004},

    // S0 K+ K0b pi- pi0
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.01, 0.012, 0.011, 0.01, 0.009, 0.009, 0.009, 0.008},

    // S0 K0 K- pi+ pi0
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.01, 0.012, 0.011, 0.01, 0.009, 0.009, 0.009, 0.008},

    // S+ pi- 3pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,   0.001, 0.002, 0.007, 0.017, 0.01,
      0.056, 0.063, 0.06, 0.051, 0.036, 0.024, 0.018, 0.012, 0.008, 0.005},

    // S+ pi+ 2pi- pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.001, 0.002, 0.004, 0.006, 0.02,  0.05,  0.12,
      0.167, 0.19, 0.179, 0.154, 0.106, 0.073, 0.053, 0.035, 0.024, 0.016},

    // S+ K0 K0b pi- pi0
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.01, 0.012, 0.011, 0.01, 0.009, 0.009, 0.009, 0.008},

    // S+ K+ K- pi- pi0
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.01, 0.012, 0.011, 0.01, 0.009, 0.009, 0.009, 0.008},

    // S+ K0 K- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.006, 0.006, 0.005, 0.005, 0.004, 0.004, 0.004},

    // S+ K0 K- pi+ pi-
    { 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.01, 0.012, 0.011, 0.01, 0.009, 0.009, 0.009, 0.008},

    // S+ K+ K0b 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.006, 0.006, 0.005, 0.005, 0.004, 0.004, 0.004},

    // Xi- K0 pi+ 2pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.006, 0.01, 0.01, 0.009, 0.008, 0.005, 0.003, 0.002},

    // Xi- K0 2pi+ pi-
    { 0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.006, 0.01, 0.01, 0.009, 0.008, 0.005, 0.003, 0.002},

    // Xi- K+ 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.002, 0.002, 0.001, 0.001},

    // Xi- K+ pi+ pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.001,
      0.002, 0.004, 0.011, 0.019, 0.019, 0.017, 0.015, 0.01, 0.007, 0.005},

    // Xi0 K0 3pi0 
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.002, 0.002, 0.001, 0.001},

    // Xi0 K0 pi+ pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.001,
      0.002, 0.004, 0.011, 0.019, 0.019, 0.017, 0.015, 0.01, 0.007, 0.005},

    // Xi0 K+ pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.006, 0.01, 0.01, 0.009, 0.008, 0.005, 0.003, 0.002},

    // Xi0 K+ pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.006, 0.01, 0.01, 0.009, 0.008, 0.005, 0.003, 0.002},

    // Xi- K0 K0 K0b pi+ 
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.002, 0.001, 0.001, 0.0},

    // Xi- K0 K+ K- pi+
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.006, 0.005, 0.003, 0.002, 0.001},

    // Xi- K0 K0b K+ pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.006, 0.005, 0.003, 0.002, 0.001},

    // Xi- K+ K+ K- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.002, 0.001, 0.001, 0.0},

    // Xi- K+ K+ K0b pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.002, 0.001, 0.001, 0.0},

    // Xi0 K0 K0 K- pi+
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.002, 0.001, 0.001, 0.0},

    // Xi0 K0 K0 K0b pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.002, 0.001, 0.001, 0.0},

    // Xi0 K0 K+ K- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.006, 0.005, 0.003, 0.002, 0.001},

    // Xi0 K0 K0b K+ pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.006, 0.005, 0.003, 0.002, 0.001},

    // Xi0 K+ K+ K- pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.002, 0.001, 0.001, 0.0},

    //
    //  multiplicity 6 (78 channels)
    // 
    // n K0b 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.001, 0.009, 0.022, 0.031, 0.039, 0.04, 0.037, 0.032, 0.026, 0.022},

    // n K0b pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.002,
      0.01, 0.11, 0.257, 0.377, 0.463, 0.488, 0.442, 0.378, 0.31, 0.26},

    // n K0b 2pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.001,
      0.005, 0.055, 0.128, 0.188, 0.232, 0.244, 0.217, 0.189, 0.15, 0.13},

    // n K- pi+ 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.003, 0.037, 0.086, 0.125, 0.154, 0.159, 0.148, 0.126, 0.10, 0.087},

    // n K- 2pi+ pi- pi0
    { 0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.002,
      0.01, 0.11, 0.257, 0.377, 0.463, 0.488, 0.442, 0.378, 0.31, 0.26},

    // p K- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.001, 0.009, 0.022, 0.031, 0.039, 0.04, 0.037, 0.032, 0.026, 0.022},

    // p K- pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.002,
      0.01, 0.11, 0.257, 0.377, 0.463, 0.488, 0.442, 0.378, 0.31, 0.26},

    // p K- 2pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.001,
      0.005, 0.055, 0.128, 0.188, 0.232, 0.244, 0.217, 0.189, 0.15, 0.13},

    // p K0b pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.003, 0.037, 0.086, 0.125, 0.154, 0.159, 0.148, 0.126, 0.10, 0.087},

    // p K0b pi+ 2pi- pi0
    { 0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.002,
      0.01, 0.11, 0.257, 0.377, 0.463, 0.488, 0.442, 0.378, 0.31, 0.26},

    // n K0 K0b K0b 2pi0 
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.01, 0.01, 0.009, 0.007, 0.006, 0.005},

    // n K0 K0b K0b pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.01, 0.018, 0.02, 0.018, 0.015, 0.012, 0.01},

    // n K+ K0b K0b pi- pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.01, 0.018, 0.02, 0.018, 0.015, 0.012, 0.01},

    // n K+ K- K0b pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.008, 0.02, 0.037, 0.04, 0.036, 0.029, 0.024, 0.02},

    // n K0 K- K- 2pi+ 
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.01, 0.01, 0.009, 0.007, 0.006, 0.005},

    // n K+ K- K0b 2pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.01, 0.018, 0.02, 0.018, 0.015, 0.012, 0.01},

    // n K0 K0b K- pi+ pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.008, 0.02, 0.037, 0.04, 0.036, 0.029, 0.024, 0.02},

    // n K+ K- K- pi+ pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.01, 0.018, 0.02, 0.018, 0.015, 0.012, 0.01},

    // p K0 K- K- pi+ pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.01, 0.018, 0.02, 0.018, 0.015, 0.012, 0.01},

    // p K+ K- K- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.01, 0.01, 0.009, 0.007, 0.006, 0.005},

    // p K+ K- K- pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.01, 0.018, 0.02, 0.018, 0.015, 0.012, 0.01},

    // p K+ K0b K0b 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.01, 0.01, 0.009, 0.007, 0.006, 0.005},

    // p K0 K0b K0b pi- pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.01, 0.018, 0.02, 0.018, 0.015, 0.012, 0.01},

    // p K0 K0b K- 2pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.01, 0.018, 0.02, 0.018, 0.015, 0.012, 0.01},

    // p K0 K0b K- pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.008, 0.019, 0.037, 0.04, 0.035, 0.029, 0.024, 0.02},

    // p K+ K- K0b pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.008, 0.019, 0.037, 0.04, 0.035, 0.029, 0.024, 0.02},

    // L 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.002,
      0.006, 0.009, 0.011, 0.011, 0.008, 0.007, 0.005, 0.004, 0.003, 0.002},

    // L pi+ pi- 3pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.001, 0.002, 0.003, 0.007, 0.016, 0.05,
      0.113, 0.18, 0.217, 0.206, 0.162, 0.127, 0.105, 0.085, 0.064, 0.05},

    // L 2pi+ 2pi- pi0
    { 0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,   0.0,   0.002, 0.003, 0.004, 0.011, 0.024, 0.075,
      0.17, 0.27, 0.326, 0.309, 0.241, 0.192, 0.158, 0.126, 0.095, 0.075},

    // L K0 K- 2pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.007, 0.016, 0.012, 0.011, 0.008, 0.006, 0.005},

    // L K0 K0b 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.006, 0.004, 0.004, 0.003, 0.002, 0.002},

    // L K0 K0b pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.003, 0.008, 0.013, 0.033, 0.025, 0.022, 0.017, 0.012, 0.01},

    // L K0 K- pi+ 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.007, 0.016, 0.012, 0.011, 0.008, 0.006, 0.005},

    // L K+ K- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
     0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
     0.0, 0.0, 0.001, 0.002, 0.006, 0.004, 0.004, 0.003, 0.002, 0.002},

    // L K+ K- pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.003, 0.008, 0.013, 0.033, 0.025, 0.022, 0.017, 0.012, 0.01},

    // L K+ K0b pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.007, 0.016, 0.012, 0.011, 0.008, 0.006, 0.005},

    // L K+ K0b pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.007, 0.016, 0.012, 0.011, 0.008, 0.006, 0.005},

    // S- pi+ 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.001, 0.002, 0.006,
      0.014, 0.022, 0.027, 0.025, 0.02, 0.015, 0.013, 0.01,  0.008, 0.006},

    // S- 2pi+ pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.003, 0.006, 0.012, 0.036,
      0.084, 0.135, 0.163, 0.153, 0.122, 0.095, 0.079, 0.063, 0.048, 0.036},

    // S- 3pi+ 2pi- 
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.001, 0.002, 0.004, 0.012,
      0.028, 0.045, 0.054, 0.051, 0.04, 0.032, 0.027, 0.021, 0.016, 0.012},

    // S- K0 K- 2pi+ pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.007, 0.005, 0.004, 0.003, 0.002},

    // S- K+ K0b pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.008, 0.015, 0.013, 0.01, 0.008, 0.006, 0.004},

    // S- K+ K0b 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.002, 0.001, 0.001, 0.0},

    // S- K0 K0b pi+ 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.007, 0.005, 0.004, 0.003, 0.002},

    // S- K0 K0b 2pi+ pi- 
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.007, 0.005, 0.004, 0.003, 0.002},

    // S- K+ K- pi+ 2pi0 
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.007, 0.005, 0.004, 0.003, 0.002},

    // S- K+ K- 2pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.007, 0.005, 0.004, 0.003, 0.002},

    // S0 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001,
      0.003, 0.004, 0.005, 0.005, 0.004, 0.003, 0.003, 0.002, 0.002, 0.001},

    // S0 pi+ pi- 3pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.0,   0.001, 0.002, 0.003, 0.008, 0.025,
      0.056, 0.09, 0.109, 0.102, 0.081, 0.063, 0.052, 0.042, 0.032, 0.025},

    // S0 2pi+ 2pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.001, 0.002, 0.003, 0.005, 0.012, 0.037,
      0.085, 0.135, 0.163, 0.154, 0.121, 0.096, 0.079, 0.063, 0.048, 0.037},

    // S0 K0 K- pi+ 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.008, 0.006, 0.005, 0.004, 0.003, 0.002},

    // S0 K0 K0b 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.002, 0.002, 0.001, 0.001, 0.0},

    // S0 K0 K0b pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.007, 0.016, 0.012, 0.011, 0.008, 0.006, 0.005},

    // S0 K0 K- 2pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.008, 0.006, 0.005, 0.004, 0.003, 0.002},

    // S0 K+ K- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.002, 0.002, 0.001, 0.001, 0.0},

    // S0 K+ K- pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.007, 0.016, 0.012, 0.011, 0.008, 0.006, 0.005},

    // S0 K+ K0b pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.008, 0.006, 0.005, 0.004, 0.003, 0.002},

    // S0 K+ K0b pi+ 2pi- 
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.008, 0.006, 0.005, 0.004, 0.003, 0.002},

    // S+ pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.001, 0.002, 0.006,
      0.014, 0.022, 0.027, 0.025, 0.02, 0.015, 0.013, 0.01,  0.008, 0.006},

    // S+ pi+ 2pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.003, 0.006, 0.012, 0.036,
      0.084, 0.135, 0.163, 0.153, 0.122, 0.095, 0.08,  0.063, 0.048, 0.036},

    // S+ 2pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.001, 0.002, 0.004, 0.012,
      0.028, 0.045, 0.054, 0.051, 0.04, 0.032, 0.027, 0.021, 0.016, 0.012},

    // S+ K0 K- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.002, 0.001, 0.001, 0.0},

    // S+ K0 K- pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.008, 0.015, 0.013, 0.01, 0.008, 0.006, 0.004},

    // S+ K0 K0b pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.007, 0.005, 0.004, 0.003, 0.002},

    // S+ K0 K0b pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.007, 0.005, 0.004, 0.003, 0.002},

    // S+ K+ K- pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.007, 0.005, 0.004, 0.003, 0.002},

    // S+ K+ K- pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.007, 0.005, 0.004, 0.003, 0.002},

    // S+ K+ K0b 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.008, 0.007, 0.005, 0.004, 0.003, 0.002},

    // Xi- K0 pi+ 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.004, 0.005, 0.005, 0.004, 0.004, 0.003, 0.002},

    // Xi- K0 2pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0, 0.001, 0.004, 0.013, 0.015, 0.015, 0.014, 0.013, 0.01, 0.008},

    // Xi- K+ 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001},

    // Xi- K+ 2pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.007, 0.008, 0.008, 0.007, 0.006, 0.005, 0.004},

    // Xi- K+ pi+ pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0, 0.001, 0.004, 0.013, 0.015, 0.015, 0.014, 0.013, 0.01, 0.008},

    // Xi0 K0 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001},

    // Xi0 K0 pi+ pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0, 0.001, 0.004, 0.013, 0.015, 0.015, 0.014, 0.013, 0.01, 0.008},

    // Xi0 K0 2pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.007, 0.008, 0.008, 0.007, 0.006, 0.005, 0.004},

    // Xi0 K+ pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.004, 0.005, 0.005, 0.004, 0.004, 0.003, 0.002},

    // Xi0 K+ pi+ 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0, 0.001, 0.004, 0.013, 0.015, 0.015, 0.014, 0.013, 0.01, 0.008},

    //
    //  multiplicity 7 (96 channels)
    // 
    // n K0b 5pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.01, 0.014, 0.017, 0.015, 0.014, 0.012},

    // n K0b pi+ pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0, 0.0,   0.0,   0.0,   0.0,   0.001,
      0.003, 0.013, 0.041, 0.103, 0.2, 0.295, 0.327, 0.307, 0.272, 0.241},

    // n K0b 2pi+ 2pi- pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.002,
      0.005, 0.02, 0.062, 0.155, 0.299, 0.442, 0.489, 0.46, 0.408, 0.361},

    // n K- pi+ 4pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.01, 0.025, 0.05, 0.074, 0.081, 0.077, 0.068, 0.06},

    // n K- 3pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.005, 0.014, 0.035, 0.069, 0.102, 0.112, 0.106, 0.094, 0.083},

    // n K- 2pi+ pi- 2pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.002,
      0.005, 0.02, 0.062, 0.155, 0.299, 0.442, 0.489, 0.46, 0.408, 0.361},

    // p K- 5pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.003, 0.006, 0.013, 0.018, 0.021, 0.019, 0.017, 0.015},

    // p K- pi+ pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.002,
      0.004, 0.017, 0.052, 0.13, 0.251, 0.37, 0.414, 0.391, 0.343, 0.303},

    // p K- 2pi+ 2pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.003,
      0.006, 0.025, 0.078, 0.195, 0.167, 0.247, 0.275, 0.258, 0.229, 0.202},

    // p K0b pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.004, 0.013, 0.032, 0.063, 0.092, 0.102, 0.096, 0.086, 0.076},

    // p K0b 2pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001,
      0.002, 0.008, 0.026, 0.065, 0.125, 0.185, 0.207, 0.194, 0.171, 0.152},

    // p K0b pi+ 2pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.003,
      0.006, 0.025, 0.078, 0.195, 0.167, 0.247, 0.275, 0.258, 0.229, 0.202},

    // n K0 K- K- 2pi+ pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.005, 0.008, 0.009, 0.008, 0.007, 0.006},

    // n K0 K0b K- pi+ 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.010, 0.014, 0.017, 0.015, 0.014, 0.012},

    // n K0 K0b K0b 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.002, 0.002},

    // n K+ K- K- pi+ 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.005, 0.008, 0.009, 0.008, 0.007, 0.006},

    // n K0 K0b K- 2pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.010, 0.014, 0.017, 0.015, 0.014, 0.012},

    // n K+ K- K- 2pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.005, 0.008, 0.009, 0.008, 0.007, 0.006},

    // n K+ K0b K0b pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.005, 0.008, 0.009, 0.008, 0.007, 0.006},

    // n K0 K0b K0b pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.010, 0.014, 0.017, 0.015, 0.014, 0.012},

     // n K+ K0b K0b pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.005, 0.008, 0.009, 0.008, 0.007, 0.006},

    // n K+ K- K0b 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.005, 0.006, 0.005, 0.004, 0.004},

    // n K+ K- K0b pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.007, 0.019, 0.029, 0.033, 0.031, 0.028, 0.024},

    // p K0 K- K- pi+ 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.006, 0.01, 0.011, 0.01, 0.008, 0.007},

    // p K+ K- K0b pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.006, 0.013, 0.018, 0.021, 0.019, 0.017, 0.015},

    // p K+ K- K- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.003, 0.002},

    // p K0 K- K- 2pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.006, 0.01, 0.011, 0.01, 0.008, 0.007},

    // p K+ K- K0b pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.006, 0.013, 0.018, 0.021, 0.019, 0.017, 0.015},

    // p K0 K0b K0b pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.006, 0.01, 0.011, 0.01, 0.008, 0.007},

    // p K+ K- K- pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.006, 0.013, 0.018, 0.021, 0.019, 0.017, 0.015},

    // p K0 K0b K0b pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.006, 0.01, 0.011, 0.01, 0.008, 0.007},

    // p K+ K0b K0b 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.006, 0.01, 0.011, 0.01, 0.008, 0.007},

    // p K0 K0b K- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.006, 0.006, 0.005},

    // p K0 K0b K- pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.006, 0.013, 0.025, 0.036, 0.041, 0.038, 0.034, 0.03},

    // L 6pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.002, 0.002, 0.002, 0.001, 0.001, 0.001, 0.001, 0.0},

    // L pi+ pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.003, 0.006, 0.013,
      0.031, 0.051, 0.062, 0.055, 0.044, 0.036, 0.03, 0.022, 0.018, 0.013},

    // L 2pi+ 2pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.009, 0.018, 0.04,
      0.094, 0.153, 0.184, 0.164, 0.135, 0.108, 0.089, 0.068, 0.054, 0.04},

    // L 3pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.002, 0.004, 0.009,
      0.021, 0.034, 0.041, 0.035, 0.03, 0.024, 0.02, 0.015, 0.012, 0.009},

    // L K0 K- 2pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.009, 0.017, 0.023, 0.027, 0.027, 0.026, 0.024},

    // L K0 K- pi+ 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.001, 0.003, 0.006, 0.008, 0.009, 0.009, 0.009, 0.008},

    // L K0 K0b 2pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.005, 0.009, 0.012, 0.014, 0.014, 0.013, 0.012},

    // L K0 K0b 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002},

    // L K0 K0b pi+ pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.009, 0.017, 0.023, 0.027, 0.027, 0.026, 0.024},

    // L K+ K0b pi- 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.001, 0.003, 0.006, 0.008, 0.009, 0.009, 0.009, 0.008},

    // L K+ K- 2pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.005, 0.009, 0.012, 0.014, 0.014, 0.013, 0.012},

    // L K+ K- 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002},

    // L K+ K- pi+ pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.009, 0.017, 0.023, 0.027, 0.027, 0.026, 0.024},

    // L K+ K0b pi+ 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.004, 0.009, 0.017, 0.023, 0.027, 0.027, 0.026, 0.024},

    // S- pi+ 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001,
      0.003, 0.005, 0.006, 0.006, 0.005, 0.004, 0.003, 0.002, 0.002, 0.001},

    // S- pi- 2pi+ 3pi0
    { 0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.003, 0.006, 0.012,
      0.03, 0.051, 0.06, 0.055, 0.043, 0.035, 0.03, 0.021, 0.018, 0.012},

    // S- 3pi+ 2pi- pi0
    { 0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.003, 0.006, 0.012,
      0.03, 0.051, 0.06, 0.055, 0.043, 0.035, 0.03, 0.021, 0.018, 0.012},

    // S- K0 K0b 2pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.009, 0.012, 0.014, 0.014, 0.013, 0.012},

    // S- K0 K- 3pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S- K0 K- 2pi+ 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S- K+ K0b 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S- K+ K- 2pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.009, 0.012, 0.014, 0.014, 0.013, 0.012},

    // S- K0 K0b pi+ 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S- K+ K0b 2pi+ 2pi- 
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S- K+ K0b pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.009, 0.012, 0.014, 0.014, 0.013, 0.012},

    // S- K+ K- pi+ 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S0 6pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 0.001, 0.001, 0.001, 0.001, 0.0, 0.0, 0.0, 0.0, 0.0},

    // S0 pi+ pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.003, 0.006,
      0.015, 0.025, 0.031, 0.027, 0.022, 0.018, 0.015, 0.011, 0.009, 0.006},

    // S0 2pi+ 2pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.004, 0.009, 0.02,
      0.047, 0.076, 0.092, 0.082, 0.068, 0.054, 0.044, 0.034, 0.027, 0.02},

    // S0 3pi+ 3pi- 
    { 0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.001, 0.002, 0.004,
      0.01, 0.017, 0.02, 0.018, 0.014, 0.012, 0.01, 0.007, 0.006, 0.004},

    // S0 K0 K- 2pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.009, 0.012, 0.014, 0.014, 0.013, 0.012},

    // S0 K0 K- pi+ 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S0 K0 K0b 2pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S0 K0 K0b 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S0 K0 K0b pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.009, 0.012, 0.014, 0.014, 0.013, 0.012},

    // S0 K+ K0b pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S0 K+ K- 2pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S0 K+ K- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S0 K+ K- pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.009, 0.012, 0.014, 0.014, 0.013, 0.012},

    // S0 K+ K0b pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.009, 0.012, 0.014, 0.014, 0.013, 0.012},

    // S+ pi- 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001,
      0.003, 0.005, 0.006, 0.006, 0.005, 0.004, 0.003, 0.002, 0.002, 0.001},

    // S+ pi+ 2pi- 3pi0
    { 0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.003, 0.006, 0.012,
      0.03, 0.051, 0.06, 0.055, 0.043, 0.035, 0.03, 0.021, 0.018, 0.012},

    // S+ 2pi+ 3pi- pi0
    { 0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,  0.003, 0.006, 0.012,
      0.03, 0.051, 0.06, 0.055, 0.043, 0.035, 0.03, 0.021, 0.018, 0.012},

    // S+ K0 K- pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.009, 0.012, 0.014, 0.014, 0.013, 0.012},

    // S+ K0 K- 2pi+ 2pi- 
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S+ K0 K0b pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S+ K0 K- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S+ K0 K0b pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.009, 0.012, 0.014, 0.014, 0.013, 0.012},

    // S+ K+ K0b 2pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S+ K+ K- pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // S+ K+ K- pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.009, 0.012, 0.014, 0.014, 0.013, 0.012},

    // S+ K+ K0b pi+ 3pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.005, 0.004, 0.004},

    // Xi- K0 pi+ 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    // Xi- K+ pi+ pi- 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.001, 0.002, 0.002, 0.005, 0.006, 0.007, 0.007, 0.006},

    // Xi- K0 3pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.003},

    // Xi- K0 2pi+ pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.005, 0.008, 0.01, 0.011, 0.011, 0.01},

    // Xi- K+ 2pi+ 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.005, 0.008, 0.01, 0.011, 0.011, 0.01},

    // Xi0 K+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    // Xi0 K0 2pi+ 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.005, 0.008, 0.01, 0.011, 0.011, 0.01},

    // Xi0 K0 pi+ pi- 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.001, 0.002, 0.002, 0.005, 0.006, 0.007, 0.007, 0.006},

    // Xi0 K+ 2pi+ 3pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.003},

    // Xi0 K+ pi+ 2pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.005, 0.008, 0.01, 0.011, 0.011, 0.01},

    //
    //  multiplicity 8 (40 channels)
    // 
    // n K0b pi+ pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.002,
      0.006, 0.017, 0.028, 0.036, 0.046, 0.062, 0.079, 0.109, 0.132, 0.153},

    // n K0b 2pi+ 2pi- 2pi0
    { 0.0,  0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.004,
      0.02, 0.05, 0.086, 0.107, 0.14, 0.184, 0.236, 0.327, 0.394, 0.459},

    // n K0b 3pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.006, 0.011, 0.019, 0.024, 0.031, 0.041, 0.052, 0.073, 0.087, 0.102},

    // n K- pi+ 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.005, 0.007, 0.009, 0.012, 0.016, 0.022, 0.026, 0.031},

    // n K- 3pi+ 2pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.003,
      0.013, 0.034, 0.057, 0.071, 0.093, 0.122, 0.157, 0.218, 0.263, 0.306},

    // n K0b 6pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.003, 0.004, 0.004},

    // n K- 2pi+ pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.003,
      0.013, 0.034, 0.057, 0.071, 0.093, 0.122, 0.157, 0.218, 0.263, 0.306},

    // p K- pi+ pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.002,
      0.006, 0.017, 0.028, 0.036, 0.046, 0.062, 0.079, 0.109, 0.132, 0.153},

    // p K- 2pi+ 2pi- 2pi0
    { 0.0,  0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.004,
      0.02, 0.05, 0.086, 0.107, 0.14, 0.184, 0.236, 0.327, 0.394, 0.459},

    // p K- 3pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.006, 0.011, 0.019, 0.024, 0.031, 0.041, 0.052, 0.073, 0.087, 0.102},

    // p K0b pi- 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.005, 0.007, 0.009, 0.012, 0.016, 0.022, 0.026, 0.031},

    // p K0b pi+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.003,
      0.013, 0.034, 0.057, 0.071, 0.093, 0.122, 0.157, 0.218, 0.263, 0.306},

    // p K- 6pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.003, 0.004, 0.004},

    // p K0b 2pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.003,
      0.013, 0.034, 0.057, 0.071, 0.093, 0.122, 0.157, 0.218, 0.263, 0.306},

    // L pi+ pi- 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.001, 0.003,
      0.004, 0.005, 0.011, 0.014, 0.016, 0.02, 0.023, 0.026, 0.028, 0.031},

    // L 2pi+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.007, 0.015,
      0.019, 0.024, 0.054, 0.068, 0.083, 0.098, 0.118, 0.131, 0.143, 0.151},

    // L 3pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.005, 0.01,
      0.013, 0.016, 0.027, 0.034, 0.042, 0.049, 0.059, 0.065, 0.073, 0.075},

    // S- pi+ 6pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.002, 0.002},

    // S- 2pi+ pi- 4pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.004,
      0.005, 0.007, 0.01, 0.012, 0.015, 0.018, 0.022, 0.023, 0.027, 0.029},

    // S- 3pi+ 2pi- 2pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.003, 0.007,
      0.009, 0.012, 0.02, 0.025, 0.03, 0.037, 0.044, 0.048, 0.053, 0.055},

    // S- 4pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001,
      0.001, 0.002, 0.003, 0.004, 0.005, 0.007, 0.007, 0.009, 0.009, 0.008},

    // S0 pi+ pi- 5pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.001,
      0.002, 0.003, 0.004, 0.005, 0.006, 0.007, 0.008, 0.01, 0.011, 0.011},

    // S0 2pi+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.003, 0.007,
      0.01,  0.012, 0.02, 0.025, 0.03, 0.037, 0.044, 0.048, 0.053, 0.055},

    // S0 3pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.002, 0.005,
      0.006, 0.008, 0.013, 0.017, 0.02, 0.025, 0.029, 0.032, 0.035, 0.037},

    // S+ pi- 6pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.002, 0.002},

    // S+ pi+ 2pi- 4pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.001, 0.004,
      0.005, 0.007, 0.01, 0.012, 0.015, 0.018, 0.023, 0.023, 0.027, 0.029},

    // S+ 2pi+ 3pi- 2pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   0.003, 0.007,
      0.01,  0.012, 0.02, 0.025, 0.03, 0.037, 0.044, 0.048, 0.053, 0.055},

    // S+ 3pi+ 4pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.001,
      0.001, 0.002, 0.003, 0.004, 0.005, 0.007, 0.007, 0.009, 0.009, 0.008},

    // Xi- K0 2pi+ pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.01, 0.012, 0.015},

    // Xi- K+ 2pi+ 2pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.005, 0.007, 0.01, 0.015, 0.018, 0.02},

    // Xi- K+ 3pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.003, 0.004, 0.004},

    // Xi- K0 3pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.01, 0.012, 0.015},

    // Xi- K+ pi+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.005, 0.006},

    // Xi- K0 pi+ 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.002, 0.002},

    // Xi0 K+ pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.01, 0.012, 0.015},

    // Xi0 K0 2pi+ 2pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.005, 0.007, 0.01, 0.015, 0.018, 0.02},

    // Xi0 K0 3pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.003, 0.004, 0.004},

    // Xi0 K+ 2pi+ 3pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.006, 0.007, 0.01, 0.012, 0.015},

    // Xi0 K0 pi+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.005, 0.006},

    // Xi0 K+ pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.002, 0.002},

    //
    //  multiplicity 9 (42 channels)
    // 
    // n K0b 2pi+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.004, 0.01, 0.03, 0.07, 0.126, 0.214, 0.363, 0.536, 0.675},

    // n K0b 3pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.007, 0.02, 0.047, 0.084, 0.143, 0.242, 0.358, 0.45},

    // n K- 2pi+ pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.005, 0.015, 0.035, 0.063, 0.107, 0.181, 0.268, 0.338},

    // n K- 4pi+ 3pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.001, 0.002, 0.005, 0.012, 0.021, 0.036, 0.06, 0.09, 0.113},

    // n K- 3pi+ 2pi- 2pi0
    { 0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.004, 0.01, 0.03, 0.07, 0.126, 0.214, 0.363, 0.536, 0.675},

    // n K0b pi+ pi- 5pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.006, 0.014, 0.025, 0.042, 0.075, 0.109, 0.135},

    // n K- pi+ 6pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.005, 0.007, 0.012, 0.018, 0.022},

    // n K0b 7pi0   
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.003},

    // p K- 3pi+ 3pi- pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.003, 0.007, 0.02, 0.047, 0.084, 0.143, 0.242, 0.358, 0.45},

    // p K0b pi+ 2pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.005, 0.015, 0.035, 0.063, 0.107, 0.181, 0.268, 0.338},

    // p K0b 3pi+ 4pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.001, 0.002, 0.005, 0.012, 0.021, 0.036, 0.06, 0.09, 0.113},

    // p K0b 2pi+ 3pi- 2pi0
    { 0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.004, 0.01, 0.03, 0.07, 0.126, 0.214, 0.363, 0.536, 0.675},

    // p K- 2pi+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.004, 0.01, 0.03, 0.07, 0.126, 0.214, 0.363, 0.536, 0.675},

    // p K- pi+ pi- 5pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.006, 0.014, 0.025, 0.042, 0.075, 0.109, 0.135},

    // p K0b pi- 6pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.005, 0.007, 0.012, 0.018, 0.022},

    // p K- 7pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.003},

    // L 3pi+ 3pi- 2pi0
    { 0.0,   0.0,   0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,  0.001,
      0.002, 0.004, 0.01, 0.02, 0.04, 0.05, 0.065, 0.101, 0.13, 0.148},

    // L 2pi+ 2pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.001,
      0.002, 0.003, 0.007, 0.015, 0.03, 0.038, 0.049, 0.075, 0.098, 0.111},

    // L pi+ pi- 6pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.007, 0.009, 0.013, 0.015},

    // L 4pi+ 4pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.005, 0.007, 0.008, 0.011, 0.016, 0.018},

    // S- 3pi+ 2pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,   0.0,
      0.001, 0.002, 0.005, 0.01, 0.02, 0.025, 0.033, 0.05, 0.065, 0.075},

    // S- 4pi+ 3pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.005, 0.01, 0.013, 0.016, 0.025, 0.033, 0.038},

    // S- 2pi+ pi- 5pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,
      0.0, 0.001, 0.002, 0.003, 0.006, 0.008, 0.01, 0.015, 0.02, 0.022},

    // S0 3pi+ 3pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,   0.0,
      0.001, 0.002, 0.005, 0.01, 0.02, 0.025, 0.033, 0.05, 0.065, 0.075},

    // S0 2pi+ 2pi- 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.002, 0.004, 0.008, 0.015, 0.018, 0.024, 0.038, 0.049, 0.057},

    // S0 pi+ pi- 6pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.005, 0.006, 0.008},

    // S0 4pi+ 4pi- 
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.004, 0.006, 0.008, 0.009},

    // S+ 2pi+ 3pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,   0.0,
      0.001, 0.002, 0.005, 0.01, 0.02, 0.025, 0.033, 0.05, 0.065, 0.075},

    // S+ 3pi+ 4pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.005, 0.01, 0.013, 0.016, 0.025, 0.033, 0.038},

    // S+ pi+ 2pi- 5pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,
      0.0, 0.001, 0.002, 0.003, 0.006, 0.008, 0.01, 0.015, 0.02, 0.022},

    // Xi- K0 3pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.006, 0.007, 0.008, 0.01, 0.013, 0.015},

    // Xi- K+ 3pi+ 3pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.006, 0.007, 0.009, 0.011},

    // Xi- K0 2pi+ pi- 4pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.004, 0.005, 0.006, 0.007},

    // Xi- K+ 2pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.006, 0.007, 0.008, 0.01, 0.013, 0.015},

    // Xi- K0 4pi+ 3pi- 
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.003, 0.003},

    // Xi- K+ pi+ pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.003, 0.003},

    // Xi0 K0 3pi+ 3pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.006, 0.007, 0.009, 0.011},

    // Xi0 K+ pi+ 2pi- 4pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.004, 0.005, 0.006, 0.007},

    // Xi0 K0 2pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.006, 0.007, 0.008, 0.01, 0.013, 0.015},

    // Xi0 K+ 2pi+ 3pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.006, 0.007, 0.008, 0.01, 0.013, 0.015},

    // Xi0 K+ 3pi+ 4pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.003, 0.003},

    // Xi0 K0 pi+ pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.003, 0.003}
  };
}

const G4CascadeKzeroBarNChannelData::data_t
G4CascadeKzeroBarNChannelData::data(k0bn2bfs, k0bn3bfs, k0bn4bfs, k0bn5bfs,
                                    k0bn6bfs, k0bn7bfs, k0bn8bfs, k0bn9bfs,
				    k0bnCrossSections, k0b*neu, "KzeroBarN");
