--
-- (C) 2019-23 - ntop.org
--

--
-- This script performs the scheduled vulnerability scans
--

local dirs = ntop.getDirs()
package.path = dirs.installdir .. "/scripts/lua/modules/?.lua;" .. package.path
package.path = dirs.installdir .. "/scripts/lua/modules/vulnerability_scan/?.lua;".. package.path
local vs_utils = require "vs_utils"

-- ###########################

local use_coroutines
local max_num_scans_for_loop = ntop.getCache("ntopng.prefs.host_to_scan_max_num_scans")

if((max_num_scans_for_loop == nil) or (max_num_scans_for_loop == "")) then
   max_num_scans_for_loop = 4 -- avoid lasting too long (too many loops)
else
   max_num_scans_for_loop = tonumber(max_num_scans_for_loop)
end

if(max_num_scans_for_loop > 16) then
   max_num_scans_for_loop = 16
elseif(max_num_scans_for_loop < 1) then
   max_num_scans_for_loop = 1
end

if(max_num_scans_for_loop == 1) then
   use_coroutines = false
else
   use_coroutines = true
end

local num_scans = vs_utils.process_all_scheduled_scans(max_num_scans_for_loop, use_coroutines)

if(ntop.isEnterpriseL()) then
   -- send the notification at the end of periodic scan
   local is_periodic_scan_over, periodicity = vs_utils.is_periodic_scan_over()
   
   if (is_periodic_scan_over) then
      vs_utils.notify_end_periodicity_or_all_scan(true, periodicity)
   end
end

local is_scan_all_over = vs_utils.is_scan_all_over()

if (is_scan_all_over) then
   -- send notification at the end of scan all
   vs_utils.notify_end_periodicity_or_all_scan(false, nil)
end

