/*  job_test.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_TEST_H_
#define JOB_TEST_H_

#include "job.h"

namespace Reduze {

/// Job template
class Test: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("test");
		s.set_short_description("Empty job template.");
		s.set_long_description("Template job for quick and easy implementation"
			" of some user defined actions.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	Test() {
		add_auto_options();
	}
	virtual ~Test() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;
protected:
	virtual void add_auto_options() {
	}
	virtual void init();
private:
};

}

#endif /* JOB_TEST_H_ */
