/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog;

import com.jfrog.GradleDepTreeResults;
import com.jfrog.GradleDependencyNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;

public class Utils {
    private static final String indentationSpace = "  ";

    public static void saveToFileAsJson(File outputFile, GradleDepTreeResults results) {
        try (FileWriter fileWriter = new FileWriter(outputFile);
             BufferedWriter writer = new BufferedWriter(fileWriter);){
            writer.append("{").append(System.lineSeparator());
            writer.append(indentationSpace).append(Utils.quotedKey("root")).append("\"").append(results.getRoot()).append("\",").append(System.lineSeparator());
            writer.append(indentationSpace).append(Utils.quotedKey("nodes"));
            Utils.appendMap(writer, results.getNodes(), indentationSpace);
            writer.append(System.lineSeparator()).append("}");
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new GradleException("File '" + outputFile + "' is not writable", (Throwable)e);
        }
    }

    private static void appendToFileAsJson(Writer writer, GradleDependencyNode dependencyTree, String baseIndentation) throws IOException {
        writer.append("{").append(System.lineSeparator());
        String keyIndentation = baseIndentation + indentationSpace;
        writer.append(keyIndentation).append(Utils.quotedKey("unresolved")).append(String.valueOf(dependencyTree.isUnresolved())).append(",").append(System.lineSeparator());
        writer.append(keyIndentation).append(Utils.quotedKey("configurations")).append(Utils.stringSetToJson(dependencyTree.getConfigurations())).append(",").append(System.lineSeparator());
        writer.append(keyIndentation).append(Utils.quotedKey("children")).append(Utils.stringSetToJson(dependencyTree.getChildren()));
        writer.append(System.lineSeparator()).append(baseIndentation).append("}");
    }

    private static String quotedKey(String str) {
        return "\"" + str + "\": ";
    }

    private static String stringSetToJson(Set<String> strSet) {
        return strSet.stream().sorted().map(str -> "\"" + str + "\"").collect(Collectors.joining(", ", "[", "]"));
    }

    private static void appendMap(Writer writer, Map<String, GradleDependencyNode> map, String baseIndentation) throws IOException {
        String keyIndentation = baseIndentation + indentationSpace;
        boolean firstItem = true;
        writer.append("{").append(System.lineSeparator());
        for (Map.Entry<String, GradleDependencyNode> entry : map.entrySet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                writer.append(",").append(System.lineSeparator());
            }
            writer.append(keyIndentation).append(Utils.quotedKey(entry.getKey()));
            Utils.appendToFileAsJson(writer, entry.getValue(), keyIndentation);
        }
        writer.append(System.lineSeparator()).append(baseIndentation).append("}");
    }
}

