/* 
   crypt -- take a soon-to-be password from the command line, and output
	    it in it's crypted form.  This is probably not the best
	    implementation ever done. :)

   Copyright (C) 2000 A.L.Lambert.
   
   Version 1.1 by Joachim Fenkes <dojoe@gmx.net> - added MD5 support.
   Version 1.2 - fixes a bug introduced by A.L.Lambert in the argv[] handling.
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

#include "include.h"

void cr_version(char *me) {
	/* some quick mutzing around to get the == of `basename $0` */
	char lme[LSIZE];
	char *ptr;
	ptr = strrchr(me, '/');
	if(ptr != NULL) {
		++ptr;
		strncpy(lme, ptr, sizeof(lme));
	} else {
		strncpy(lme, me, sizeof(lme));
	}
	
	/* print copyright and version info to user */
	fprintf(stderr, "%s v %s - copyright 2000 A.L.Lambert\n", lme, VERSION);
}

void cr_usage(char *me) {
	/* some quick mutzing around to get the == of `basename $0` */
	char lme[LSIZE];
	char *ptr;
	ptr = strrchr(me, '/');
	if(ptr != NULL) {
		++ptr;
		strncpy(lme, ptr, sizeof(lme));
	} else {
		strncpy(lme, me, sizeof(lme));
	}
	/* print yee ole usage info to the user */
	cr_version(me);
	fprintf(stderr, "\n");
        fprintf(stderr, "Usage: %s [-mhVqd] [-s salt] password_to_crypt\n", lme);  
	fprintf(stderr, " -m = Employ MD5 encryption.\n");
	fprintf(stderr, " -q = Quiet mode - for use with 'cleartext | %s'.\n", lme);
	fprintf(stderr, " -h = This help message.\n");
	fprintf(stderr, " -V = Print version info and exit.\n");
	fprintf(stderr, " -s salt = Specify the salt to use\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " -d = Debug mode (developer use only).\n");
}

/* function to ask the user for a password (if they didn't specify one on the cmdline */
short int cr_getpass() {
	char line[LSIZE];
	char *ptr;
	/* use stderr so if user is > stdout we don't interfere with it */
	if(! quiet) fprintf(stderr, "Enter the password to encrypt: ");
	/* get our input from user */
	fgets(line, sizeof(line), stdin);

	/* if there's a \n in this guy (there most likely is) null byte it - that's our EOL */
	ptr = strchr(line, '\n');
	if (ptr != NULL) {
		ptr[0] = '\0';
	}

	if(strlen(line) < 1) {	/* make sure it's at least a 1 character password */
		fprintf(stderr, "error: you must specify a password to encrypt!\n");
		/* nope, no input from user - return error */
		return -1;
	}
	
	/* if we made it here, we should be good - copy our variable */
	strncpy(cleartext_pass, line, LSIZE);	/* copy user intput into cleartext_pass value */
	
	/* if we made it here, return no error */	
	return 0;
}

short int cr_getopt(int argc, char **argv) {
	int opt;

	/* sane values to start with */
	md5 = 0;
	debug = 0;
	quiet = 0;
	do_salt = 0;
	
	/* while we have '-*' options, process them via the switch statement below */
	while((opt = getopt(argc, argv, "s:mdhVq")) != -1) {
		switch(opt) {
			case 's':
				if(debug) fprintf(stderr, "Salt provided on command line: <%s>\n", salt);
				strncpy(salt, optarg, LSIZE);
				do_salt = 1;	/* don't need to go get a salt, user supplied one */
				break;
			case 'm':	/* we want to do MD5 crypt of the password */
				md5 = 1;
				break;
			case 'd':	/* someone wants to see what all we're doing in here */
				debug = 1;
				fprintf(stderr, "-d specified on command line; debug mode enabled\n");
				break;
			case 'h':	/* print help and get outta here */
				cr_usage(argv[0]);
				return -1; /* tell calling function not to continue */
				break;
			case 'q':
				quiet = 1;
				break;
			case 'V':	/* print version info */
				cr_version(argv[0]);
				return -1; /* tell calling function not to continue */
				break;
			default:	/* invalid option - tell user about it */
				cr_usage(argv[0]);
				return -1; /* tell calling function not to continue */
				/* do nothing */
				break;
		}
	}
	/* ok, now we need to figure out what our passord to be crypted is - we will sin, and
	 * assume it's the only thing left on the command line unparsed by getopt() */
	
	/* make sure user didn't accidentally try to specify 2 or more passwords on the command line */
	if(argv[optind] != NULL && argv[optind + 1] != NULL) {
		fprintf(stderr, "%s: too many args -- more than one password_to_crypt specified!\n", argv[0]);
		return -1;
	}
	
	/* make sure we even have an unparsed arg to consider a password to be crypted */
	if(argv[optind] == NULL) {	/* oops - user didn't specify on command line - let them enter it not */
		if(cr_getpass() != 0) return -1;/* if they still refused to give us text, then error out now */
	} else {	/* user gave us password on command line, copy it to apropo variable now */
 		strcpy(cleartext_pass, argv[optind]);
	}
			
	if(debug && md5) fprintf(stderr, "Using MD5 encryption\n");
	if(debug) fprintf(stderr, "cleartext_pass: <%s>\n", cleartext_pass);
	return 0;
}
