#include <X11/Xlib.h>	// Bool
#include <stdio.h>	// sprintf
#include <stdlib.h>	// strtol, NULL
#include <string.h>	
#include <ctype.h>	
#include "plugin_common.h"

const char *Separators1 = "=;,#";
const char *Separators2 = ";,#";
const char *Separators3 = " \t;,";

const char *Delim1= "[({";
const char *Delim2= "])}";

Bool parse_parm_plusminus(char *parm, int *valPtr, short *dirPtr, char **sepPtr)
{
  short dir = 0;
  int val = 0;
  char *sep;
  
  while (*parm == ' ') parm++;
  
  if (*parm == '+') { dir = 1; parm++; }
  if (*parm == '-') { dir = -1; parm++; }
  if (*parm == '=') { dir = 2; parm++; }

  val = strtol(parm, &sep, 0);
  if (sepPtr == NULL) {
    if (*sep != ' ' && *sep != '\0') return False;
  } else
	*sepPtr=sep;
  
  *valPtr = val;
  *dirPtr = dir;
  return True;	
}



// parmAttrib contains contains either
// PARM_ATTRIB values (of < 0), or for
// ATTRIB_CHAR (>=0) maxumimum attrib length

Bool lookup_parms(const char *string, int parmCount,
	const char *parmNames[],  const int parmAttrib[],
	void *parmValuesReturn[], char *messageReturn, int messageReturnLen)
{
    char *strcopy, *token, *next;
    const char *srcPtr;
    Bool success = True;
    Bool no;
    int attrib, dataType, dataLen;
    long dataValue;
    void *destPtr;
    int j;
    char delim;
    
    if (string == NULL) return False;

    token = strcopy = strdup(string);
    if (strcopy == NULL) return False;

    *messageReturn = '\0';

    do
    {
	next = strpbrk(token, Separators1);
	
	if (next == NULL) 
	    delim = '\0';
	else {
	    delim = *next;
	    *next++ = '\0';
	}   
	
	if (*token == '\0') continue;
	
	no = False;	
	for (j=0; j<parmCount &&
	          strcasecmp(token, parmNames[j]) != 0; j++);

	if (j >= parmCount && 
	    delim != '=' &&  strncasecmp(token, "no", 2) == 0) {

	    no = True;	
	    for (j=0; j<parmCount &&
	          strcasecmp(token+2, parmNames[j]) != 0; j++);
	}


	if (j >= parmCount) {
	    snprintf (messageReturn, messageReturnLen, "Invalid argument: %s\n", token);
	    success = False;
	    continue;	
	}

	attrib = parmAttrib[j];
	dataType = attrib & 0xffff0000;
	dataLen = attrib & 0xffff;

	if (no && dataType != ATTRIB_BOOL) {
	    snprintf (messageReturn, messageReturnLen, "Invalid argument: %s\n", token);
	    success = False;
	    continue;	
	}

	if (delim != '=') {
	    if (dataType == ATTRIB_BOOL)
		srcPtr = no ? "n" : "y";
	    else {
		snprintf (messageReturn, messageReturnLen, "No value for %s\n", token);
	        success = False;
	        continue;	
	    }	
	} else {
	    if (next == NULL)
	        srcPtr = "";
	    else {
	        srcPtr = next;
		
	        if (dataType == ATTRIB_CHAR_CUSTOM_SEP &&
	           ispunct(delim = *next) && delim != '/') {
	    	    // Custom delimiter

		    // Convert '(' to ')', etc
		    destPtr = strchr(Delim1, delim);
		    if (destPtr != NULL)
			delim = Delim2[(const char *)destPtr-Delim1];
		    
		    next = strchr(++srcPtr, delim);
		    
		} else 
		    // Standard delimiter
		    next = strpbrk(srcPtr, Separators2);
		
                if (next != NULL && *next == '#')
		    next = NULL;
				    
		if (next != NULL && *next != '\0') {
		    *next++ = '\0';
			
		    // Bypassing multiple separators and spaces
		    next += strspn(next, Separators2);
		    
	            if (*next == '#') next = NULL;
		}
	    }
	}

	destPtr = parmValuesReturn[j];
	
	switch (dataType) {
	    case ATTRIB_CHAR:
	    case ATTRIB_CHAR_CUSTOM_SEP:
		strncpy(destPtr, (char *)srcPtr, dataLen);
		break;

	    case ATTRIB_INT: 
		dataValue = strtol((char *)srcPtr,(char **) &srcPtr, 0);
		if (*srcPtr != '\0') {			
		    snprintf (messageReturn, messageReturnLen,  "Invalid value for %s\n", token);
	    	    success = False;
		} else {
		    switch(dataLen) 
		    {
			case 2:
			    *(short *)destPtr = (short) dataValue;
			    break;   

			case 8:
			    *(long *)destPtr = dataValue;
			    break;   

			default:
			    *(int *)destPtr = (int)dataValue;
			    break;   
		    }
		
		}
		break;

	    case ATTRIB_BOOL:
		delim = *srcPtr;
		if (strchr("yY1", delim) != NULL)
		    *(Bool *)destPtr = True;
		else 
		if (strchr("nN0", delim) != NULL)
		    *(Bool *)destPtr = False;
		else {
		    snprintf (messageReturn, messageReturnLen, "Invalid value for %s\n", token);
	    	    success = False;
		}	
	}

    } while (success && (token = next) != NULL && *token != '#');
    
    free(strcopy);
    return success;
    
}

