/*  ---------------------------------------------------------------
    xhkeys. Jul 2002
    Copyright (C) 2002,  Michael Glickman  <wmalms@yahoo.com>
    License: GPL
    --------------------------------------------------------------- */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "xhkeys_conf.h"

#ifdef USE_DMALLOC
#include <dmalloc.h>
#endif

#include "xhkeys.h"

extern Display *dpy;
extern Window  wnd;
extern Window  root_wnd;
extern unsigned long keyLattency, keyPause;
extern unsigned long clickLattency, clickPause;

static Window findWindow(char *wndName, short selection)
{  
  Window res = None;

  switch(selection)
  {
	case 0:		// WM_CLASS
	  {	 
		char *appName, *clsName;
		clsName = wndName;
		appName = strsep(&clsName, ":");
		if (appName != NULL && clsName != NULL) 
		  res =findWindowByWMClass(root_wnd, appName, clsName);  
	  }
	  break;
	  
	case 1:		// Title
	  res = findWindowByTitle(root_wnd, wndName);   	  	  
	  break;
	  
	case 2:		// Id
	  {
		Window id;
		char *next;
		
		id = strtoul(wndName, &next, 0);
		if (*next == '\0')
	  	  res = findWindowById(root_wnd, id);   	  	  
	  }
	  break;


	case 3:		// Stacking order  
	  switch(toupper(*wndName))
	  {
	  	case 'B':	// Bottom most
			res = findVisibleWindow(root_wnd, 1);
			break;
			
	  	case 'T':	// Top most
			res = findVisibleWindow(root_wnd, -1);
			break;

	  	case 'F':	// Input focus
		{
			int revertTo;
			if (XGetInputFocus(dpy, &res, &revertTo) == False) 
			    res = None;
		}	
			break;
			
	    
	  	case 'R':	// Rooe
			res = root_wnd;
			break;
	  	
	  }		
	  break;
  }
  
  return res;

}

Bool setFocusedWindow(Window target, Window *oldFocus, int *oldRevertTo)
{
    return XGetInputFocus(dpy, oldFocus, oldRevertTo) &&
	   XSetInputFocus(dpy, target, RevertToNone, CurrentTime);
//	XSetInputFocus(dpy, target, oldRevertTo, CurrentTime);
}	

Bool resetFocusedWindow(Window oldFocus, int oldRevertTo)
{
   return XSetInputFocus(dpy, oldFocus, oldRevertTo, CurrentTime);
}

static Bool sendButtonEvent(Window target, int x, int y,
                     unsigned int button, unsigned int modif, int sendRelease)
{ 
    XEvent xev;
    Bool success;
    Window childWnd;
    int root_x, root_y;

    if (XTranslateCoordinates(dpy, target, root_wnd, x, y, &root_x, &root_y, &childWnd) == False) {
	root_x = x; root_y = y;
    }
  
    xev.type = ButtonPress;
    xev.xbutton.serial = 0;
    xev.xbutton.send_event = False;
    xev.xbutton.display = dpy;
    xev.xbutton.window = target;
    xev.xbutton.root = root_wnd;
    xev.xbutton.subwindow = 0;
    xev.xbutton.time = CurrentTime;  /* ?! */
    xev.xbutton.x = x;
    xev.xbutton.y = y;
    xev.xbutton.x_root = root_x;
    xev.xbutton.y_root = root_y;
    xev.xbutton.state = modif;
    xev.xbutton.button = button;
    xev.xbutton.same_screen = True;
    
  
    if (sendRelease & 1)
	success = XSendEvent(dpy, target, True, ButtonPressMask, &xev);
    else
	success = True;        

    if (success && (sendRelease & 2)) {
	if (sendRelease & 1) usleep(clickLattency);
        xev.type = ButtonRelease;
	success = XSendEvent(dpy, target, True, ButtonReleaseMask, &xev);
    }	
  
    return success;
}


Bool ProcessWndButton(const char * command, short target_sel)
{
    char *cmdcopy = NULL;
    char *wndName, *btnStr;
    unsigned int modif, btnno;
    int sendRelease;
    Bool success = False;  
    char *strNext;
    Window target;
    int x, y;

    Window oldFocus;
    int oldRevertTo;	
  
    strNext = cmdcopy = strdup(command);
    if (cmdcopy == NULL) goto OutOfHere;

    wndName = strsep(&strNext, ";");
    if (wndName == NULL) goto OutOfHere;  

    target = findWindow(wndName, target_sel);  
    if (target == None) goto OutOfHere;

    x = 0; y = 0;
    btnno = 1; modif = 0;
    sendRelease = 3;

    btnStr = strsep(&strNext, ";");
    if (btnStr == NULL) goto SendIt; 
    x = (int) strtol(btnStr, (char **)NULL, 0);
  
    btnStr = strsep(&strNext, ";");
    if (btnStr == NULL) goto SendIt; 
    y = (int) strtol(btnStr, (char **)NULL, 0);

    btnStr = strsep(&strNext, ";");
    if (btnStr == NULL) goto SendIt; 
    btnno = atoi(btnStr);
  	
    btnStr = strsep(&strNext, ";");
    if (btnStr == NULL) goto SendIt; 
    modif = (unsigned int) strtoul(btnStr, (char **)NULL, 0);


    btnStr = strsep(&strNext, ";");
    if (btnStr == NULL) goto SendIt; 
    sendRelease = atoi(btnStr);  
  

SendIt:
    setFocusedWindow(target, &oldFocus, &oldRevertTo);

    success = True;
        
    if (sendRelease == 0)
	 XRaiseWindow(dpy, target);    
    else {
	int count = 1;
	
	btnStr = strsep(&strNext, "");
	if (btnStr != NULL) count = atoi(btnStr);
	
        for(; success && --count >= 0; ) {
	    success = sendButtonEvent(target, x, y, btnno, modif, sendRelease);
	    if (count > 0) usleep(clickPause);
	}

	resetFocusedWindow(oldFocus, oldRevertTo); 
    }	

OutOfHere:
  if (cmdcopy) free(cmdcopy);    	
  return success;

}

//==========================================================================

static Bool sendKeyEvent(Window target, KeyCode kcode, unsigned int modif, int sendRelease)
{ 
    XEvent xev;
    Bool success;
    
    Window oldFocus;
    int oldRevertTo;
  
    xev.type = KeyPress;
    xev.xkey.serial = 0;
    xev.xkey.send_event = False;
    xev.xkey.display = dpy;
    xev.xkey.window = target;
    xev.xkey.root = root_wnd;
    xev.xkey.subwindow = 0;
    xev.xkey.time = CurrentTime;  /* ?! */
    xev.xkey.x = 0;
    xev.xkey.y = 0;
    xev.xkey.x_root = 0;
    xev.xkey.y_root = 0;
    xev.xkey.state = modif;
    xev.xkey.keycode = kcode;
    xev.xkey.same_screen = True;

    setFocusedWindow(target, &oldFocus, &oldRevertTo);

    if (sendRelease & 1) 
        success = XSendEvent(dpy, target, True, KeyPressMask, &xev);
    else
	success = True;	

    if (success && (sendRelease & 2)) {
        if (sendRelease & 1) usleep(keyLattency);
        xev.type = KeyRelease;
        success = XSendEvent(dpy, target, True, KeyReleaseMask, &xev);
    }	

    return success;
}


Bool ProcessWndKey(const char * command, short target_sel, short type_modif)
{
    char *cmdcopy = NULL;
    char *wndName, *keyStr;
    char *strNext;
    KeyCode kcode;
    unsigned int modif;
    int sendRelease;

    Bool success = False;  
    Window target;

    Window oldFocus;
    int oldRevertTo;	
  

    strNext = cmdcopy = strdup(command);
    if (cmdcopy == NULL) goto OutOfHere;

    wndName = strsep(&strNext, ";");
    if (wndName == NULL) goto OutOfHere;  

    target = findWindow(wndName, target_sel);  
    if (target == None) goto OutOfHere;
  
    keyStr = strsep(&strNext, ";");
    if (keyStr == NULL) goto OutOfHere ; 

    if (type_modif == 1) {
	/* Scan Code */ 
        kcode = (KeyCode) strtoul(keyStr, (char **)NULL, 0);
	if (kcode == 0) goto OutOfHere;
    } else {
	KeySym ksym = 
	    /* KeySym symbolic */
	    (type_modif == 0)  ?  XStringToKeysym(keyStr)
	    /* KeySym numeric */
	                       :  (KeySym) strtoul(keyStr, (char **)NULL, 0);    
        if (ksym == NoSymbol) goto OutOfHere;

	kcode = XKeysymToKeycode(dpy, ksym);
	if (kcode == NoSymbol) goto OutOfHere;
    }
    
    
    modif = 0;  
    sendRelease = 3;

    keyStr = strsep(&strNext, ";"); 
    if (keyStr == NULL) goto SendIt;
    modif = (unsigned int) strtoul(keyStr, (char **)NULL, 0);
  
    keyStr = strsep(&strNext, ";"); 
    if (keyStr == NULL)  goto SendIt;
    sendRelease = atoi(keyStr);
  	  

SendIt:
    setFocusedWindow(target, &oldFocus, &oldRevertTo);

    if (sendRelease == 0)
	 XRaiseWindow(dpy, target);    
    else {
        int count = 1;


        keyStr = strsep(&strNext, ""); 
	if (keyStr != NULL)  count = atoi(keyStr);

        for(success = True; success && --count >= 0; ) {
	    success = sendKeyEvent(target, kcode, modif, sendRelease);
    	    if (count > 0) usleep(keyPause);  
	} 

	resetFocusedWindow(oldFocus, oldRevertTo); 
    }	

OutOfHere:
  if (cmdcopy) free(cmdcopy);    	
  return success;

}

