/*
 * Do not edit: automatically generated by mkavrintel.pl
 *
 * avrintel.h
 *
 * Microchip AVR8L, AVR8, XMEGA and AVR8X family description of interrupts, configurations and more
 *
 * Published under GNU General Public License, version 3 (GPL-3.0)
 * Meta-author Stefan Rueger <stefan.rueger@urclocks.com>
 *
 * v 1.3
 * 27.05.2023
 *
 */

#ifndef avrintel_h
#define avrintel_h

typedef struct {
  int value;                    // Value (to be shifted into mask position)
  const char *label;            // Symbolic label for this config item
  const char *vcomment;         // Expanded semantic comment
} Valueitem_t;

typedef struct {
  const char *name;             // Name of this configuration item
  int nvalues;                  // Number of (symbolic) values
  const Valueitem_t *vlist;     // Pointer to nvalues value items
  const char *memtype;          // Fuse/Lock memory for this configuration
  int memoffset;                // Byte offset within fuses (always 0 for lock)
  int mask;                     // Bit mask of fuse/lock memory
  int lsh;                      // Values need shifting left by lsh to be in mask
  int initval;                  // Factory default, to be shifted into mask position
  const char *ccomment;         // Expanded semantic name for this configuration item
} Configitem_t;

typedef struct {                // Value of -1 typically means unknown
  const char *name;             // Name of part
  uint16_t mcuid;               // ID of MCU in 0..2039
  uint8_t  avrarch;             // F_AVR8L, F_AVR8, F_XMEGA or F_AVR8X
  uint8_t sigs[3];              // Signature bytes
  int32_t flashoffset;          // Flash offset
  int32_t flashsize;            // Flash size
  int16_t pagesize;             // Flash page size
  int8_t  nboots;               // Number of supported boot sections
  int16_t bootsize;             // Size of (smallest) boot section
  int32_t eepromoffset;         // EEPROM offset
  int32_t eepromsize;           // EEPROM size
  int32_t eeprompagesize;       // EEPROM page size
  int32_t sramstart;            // SRAM offset
  int32_t sramsize;             // SRAM size
  int8_t  nfuses;               // Number of fuse bytes
  int8_t  nlocks;               // Number of lock bytes
  uint8_t ninterrupts;          // Number of vectors in interrupt vector table
  const char * const *isrtable; // Interrupt vector table vector names
  uint8_t nconfigs;             // Number of configuration bitfields in fuses/locks
  const Configitem_t *cfgtable; // Configuration bitfield table
} uPcore_t;

#define F_AVR8L               1 // TPI programming, ATtiny(4|5|9|10|20|40|102|104)
#define F_AVR8                2 // ISP programming with SPI, "classic" AVRs
#define F_XMEGA               4 // PDI programming, ATxmega family
#define F_AVR8X               8 // UPDI programming, newer 8-bit MCUs

#define UB_N_MCU           2040 // mcuid is in 0..2039

extern const uPcore_t uP_table[380];


// MCU id: running number in arbitrary order; once assigned never change for backward compatibility

#define id_attiny4           0u
#define id_attiny5           1u
#define id_attiny9           2u
#define id_attiny10          3u
#define id_attiny20          4u
#define id_attiny40          5u
#define id_attiny102         6u
#define id_attiny104         7u
#define id_attiny11          8u
#define id_attiny12          9u
#define id_attiny13         10u
#define id_attiny13a        11u
#define id_attiny15         12u
#define id_attiny22         13u
#define id_attiny24         14u
#define id_attiny24a        15u
#define id_attiny25         16u
#define id_attiny26         17u
#define id_attiny28         18u
#define id_attiny43u        19u
#define id_attiny44         20u
#define id_attiny44a        21u
#define id_attiny45         22u
#define id_attiny48         23u
#define id_attiny84         24u
#define id_attiny84a        25u
#define id_attiny85         26u
#define id_attiny87         27u
#define id_attiny88         28u
#define id_attiny167        29u
#define id_attiny261        30u
#define id_attiny261a       31u
#define id_attiny441        32u
#define id_attiny461        33u
#define id_attiny461a       34u
#define id_attiny828        35u
#define id_attiny828r       36u
#define id_attiny841        37u
#define id_attiny861        38u
#define id_attiny861a       39u
#define id_attiny1634       40u
#define id_attiny1634r      41u
#define id_attiny2313       42u
#define id_attiny2313a      43u
#define id_attiny4313       44u
#define id_atmega8          45u
#define id_atmega8a         46u
#define id_atmega8hva       47u
#define id_atmega8u2        48u
#define id_atmega16         49u
#define id_atmega16a        50u
#define id_atmega16hva      51u
#define id_atmega16hvb      52u
#define id_atmega16hvbrevb  53u
#define id_atmega16m1       54u
#define id_atmega16hva2     55u
#define id_atmega16u2       56u
#define id_atmega16u4       57u
#define id_atmega32         58u
#define id_atmega32a        59u
#define id_atmega32hvb      60u
#define id_atmega32hvbrevb  61u
#define id_atmega32c1       62u
#define id_atmega32m1       63u
#define id_atmega32hve2    379u
#define id_atmega32u2       64u
#define id_atmega32u4       65u
#define id_atmega32u6       66u
#define id_atmega48         67u
#define id_atmega48a        68u
#define id_atmega48p        69u
#define id_atmega48pa       70u
#define id_atmega48pb       71u
#define id_atmega64         72u
#define id_atmega64a        73u
#define id_atmega64hve      74u
#define id_atmega64c1       75u
#define id_atmega64m1       76u
#define id_atmega64hve2     77u
#define id_atmega64rfr2     78u
#define id_atmega88         79u
#define id_atmega88a        80u
#define id_atmega88p        81u
#define id_atmega88pa       82u
#define id_atmega88pb       83u
#define id_atmega103        84u
#define id_atmega103comp   374u
#define id_atmega128        85u
#define id_atmega128a       86u
#define id_atmega128rfa1    87u
#define id_atmega128rfr2    88u
#define id_atmega161        89u
#define id_atmega161comp   375u
#define id_atmega162        90u
#define id_atmega163        91u
#define id_atmega164a       92u
#define id_atmega164p       93u
#define id_atmega164pa      94u
#define id_atmega165        95u
#define id_atmega165a       96u
#define id_atmega165p       97u
#define id_atmega165pa      98u
#define id_atmega168        99u
#define id_atmega168a      100u
#define id_atmega168p      101u
#define id_atmega168pa     102u
#define id_atmega168pb     103u
#define id_atmega169       104u
#define id_atmega169a      105u
#define id_atmega169p      106u
#define id_atmega169pa     107u
#define id_atmega256rfr2   108u
#define id_atmega323       109u
#define id_atmega324a      110u
#define id_atmega324p      111u
#define id_atmega324pa     112u
#define id_atmega324pb     113u
#define id_atmega325       114u
#define id_atmega325a      115u
#define id_atmega325p      116u
#define id_atmega325pa     117u
#define id_atmega328       118u
#define id_atmega328p      119u
#define id_atmega328pb     120u
#define id_atmega329       121u
#define id_atmega329a      122u
#define id_atmega329p      123u
#define id_atmega329pa     124u
#define id_atmega406       125u
#define id_atmega640       126u
#define id_atmega644       127u
#define id_atmega644a      128u
#define id_atmega644p      129u
#define id_atmega644pa     130u
#define id_atmega644rfr2   131u
#define id_atmega645       132u
#define id_atmega645a      133u
#define id_atmega645p      134u
#define id_atmega649       135u
#define id_atmega649a      136u
#define id_atmega649p      137u
#define id_atmega1280      138u
#define id_atmega1281      139u
#define id_atmega1284      140u
#define id_atmega1284p     141u
#define id_atmega1284rfr2  142u
#define id_atmega2560      143u
#define id_atmega2561      144u
#define id_atmega2564rfr2  145u
#define id_atmega3250      146u
#define id_atmega3250a     147u
#define id_atmega3250p     148u
#define id_atmega3250pa    149u
#define id_atmega3290      150u
#define id_atmega3290a     151u
#define id_atmega3290p     152u
#define id_atmega3290pa    153u
#define id_atmega6450      154u
#define id_atmega6450a     155u
#define id_atmega6450p     156u
#define id_atmega6490      157u
#define id_atmega6490a     158u
#define id_atmega6490p     159u
#define id_atmega8515      160u
#define id_atmega8535      161u
#define id_at43usb320      162u
#define id_at43usb355      163u
#define id_at76c711        164u
#define id_at86rf401       165u
#define id_at89s51         372u
#define id_at89s52         373u
#define id_at90pwm1        166u
#define id_at90pwm2        167u
#define id_at90pwm2b       168u
#define id_at90pwm3        169u
#define id_at90pwm3b       170u
#define id_at90can32       171u
#define id_at90can64       172u
#define id_at90pwm81       173u
#define id_at90usb82       174u
#define id_at90scr100      175u
#define id_at90scr100h     376u
#define id_at90can128      176u
#define id_at90pwm161      177u
#define id_at90usb162      178u
#define id_at90pwm216      179u
#define id_at90pwm316      180u
#define id_at90usb646      181u
#define id_at90usb647      182u
#define id_at90s1200       183u
#define id_at90usb1286     184u
#define id_at90usb1287     185u
#define id_at90s2313       186u
#define id_at90s2323       187u
#define id_at90s2333       188u
#define id_at90s2343       189u
#define id_at90s4414       190u
#define id_at90s4433       191u
#define id_at90s4434       192u
#define id_at90s8515       193u
#define id_at90s8515comp   377u
#define id_at90c8534       194u
#define id_at90s8535       195u
#define id_at90s8535comp   378u
#define id_at94k           196u
#define id_ata5272         197u
#define id_ata5505         198u
#define id_ata5700m322     199u
#define id_ata5702m322     200u
#define id_ata5781         201u
#define id_ata5782         202u
#define id_ata5783         203u
#define id_ata5787         204u
#define id_ata5790         205u
#define id_ata5790n        206u
#define id_ata5791         207u
#define id_ata5795         208u
#define id_ata5831         209u
#define id_ata5832         210u
#define id_ata5833         211u
#define id_ata5835         212u
#define id_ata6285         213u
#define id_ata6286         214u
#define id_ata6289         215u
#define id_ata6612c        216u
#define id_ata6613c        217u
#define id_ata6614q        218u
#define id_ata6616c        219u
#define id_ata6617c        220u
#define id_ata8210         221u
#define id_ata8215         222u
#define id_ata8510         223u
#define id_ata8515         224u
#define id_ata664251       225u
#define id_m3000           226u
#define id_lgt8f88p        227u
#define id_lgt8f168p       228u
#define id_lgt8f328p       229u
#define id_atxmega8e5      230u
#define id_atxmega16a4     231u
#define id_atxmega16a4u    232u
#define id_atxmega16c4     233u
#define id_atxmega16d4     234u
#define id_atxmega16e5     235u
#define id_atxmega32c3     236u
#define id_atxmega32d3     237u
#define id_atxmega32a4     238u
#define id_atxmega32a4u    239u
#define id_atxmega32c4     240u
#define id_atxmega32d4     241u
#define id_atxmega32e5     242u
#define id_atxmega64a1     243u
#define id_atxmega64a1u    244u
#define id_atxmega64b1     245u
#define id_atxmega64a3     246u
#define id_atxmega64a3u    247u
#define id_atxmega64b3     248u
#define id_atxmega64c3     249u
#define id_atxmega64d3     250u
#define id_atxmega64a4     251u
#define id_atxmega64a4u    252u
#define id_atxmega64d4     253u
#define id_atxmega128a1    254u
#define id_atxmega128a1revd 255u
#define id_atxmega128a1u   256u
#define id_atxmega128b1    257u
#define id_atxmega128a3    258u
#define id_atxmega128a3u   259u
#define id_atxmega128b3    260u
#define id_atxmega128c3    261u
#define id_atxmega128d3    262u
#define id_atxmega128a4    263u
#define id_atxmega128a4u   264u
#define id_atxmega128d4    265u
#define id_atxmega192a1    266u
#define id_atxmega192a3    267u
#define id_atxmega192a3u   268u
#define id_atxmega192c3    269u
#define id_atxmega192d3    270u
#define id_atxmega256a1    271u
#define id_atxmega256a3    272u
#define id_atxmega256a3b   273u
#define id_atxmega256a3bu  274u
#define id_atxmega256a3u   275u
#define id_atxmega256c3    276u
#define id_atxmega256d3    277u
#define id_atxmega384c3    278u
#define id_atxmega384d3    279u
#define id_attiny202       280u
#define id_attiny204       281u
#define id_attiny212       282u
#define id_attiny214       283u
#define id_attiny402       284u
#define id_attiny404       285u
#define id_attiny406       286u
#define id_attiny412       287u
#define id_attiny414       288u
#define id_attiny416       289u
#define id_attiny416auto   290u
#define id_attiny417       291u
#define id_attiny424       292u
#define id_attiny426       293u
#define id_attiny427       294u
#define id_attiny804       295u
#define id_attiny806       296u
#define id_attiny807       297u
#define id_attiny814       298u
#define id_attiny816       299u
#define id_attiny817       300u
#define id_attiny824       301u
#define id_attiny826       302u
#define id_attiny827       303u
#define id_attiny1604      304u
#define id_attiny1606      305u
#define id_attiny1607      306u
#define id_attiny1614      307u
#define id_attiny1616      308u
#define id_attiny1617      309u
#define id_attiny1624      310u
#define id_attiny1626      311u
#define id_attiny1627      312u
#define id_attiny3214      313u
#define id_attiny3216      314u
#define id_attiny3217      315u
#define id_attiny3224      316u
#define id_attiny3226      317u
#define id_attiny3227      318u
#define id_atmega808       319u
#define id_atmega809       320u
#define id_atmega1608      321u
#define id_atmega1609      322u
#define id_atmega3208      323u
#define id_atmega3209      324u
#define id_atmega4808      325u
#define id_atmega4809      326u
#define id_avr8ea28        327u
#define id_avr8ea32        328u
#define id_avr16dd14       329u
#define id_avr16dd20       330u
#define id_avr16dd28       331u
#define id_avr16ea28       332u
#define id_avr16dd32       333u
#define id_avr16ea32       334u
#define id_avr16ea48       335u
#define id_avr32dd14       336u
#define id_avr32dd20       337u
#define id_avr32da28       338u
#define id_avr32db28       339u
#define id_avr32dd28       340u
#define id_avr32ea28       341u
#define id_avr32da32       342u
#define id_avr32db32       343u
#define id_avr32dd32       344u
#define id_avr32ea32       345u
#define id_avr32da48       346u
#define id_avr32db48       347u
#define id_avr32ea48       348u
#define id_avr64dd14       349u
#define id_avr64dd20       350u
#define id_avr64da28       351u
#define id_avr64db28       352u
#define id_avr64dd28       353u
#define id_avr64ea28       354u
#define id_avr64da32       355u
#define id_avr64db32       356u
#define id_avr64dd32       357u
#define id_avr64ea32       358u
#define id_avr64da48       359u
#define id_avr64db48       360u
#define id_avr64ea48       361u
#define id_avr64da64       362u
#define id_avr64db64       363u
#define id_avr128da28      364u
#define id_avr128db28      365u
#define id_avr128da32      366u
#define id_avr128db32      367u
#define id_avr128da48      368u
#define id_avr128db48      369u
#define id_avr128da64      370u
#define id_avr128db64      371u


// Interrupt vector table sizes (number of vectors)

#define vts_attiny4          10
#define vts_attiny5          11
#define vts_attiny9          10
#define vts_attiny10         11
#define vts_attiny20         17
#define vts_attiny40         18
#define vts_attiny102        16
#define vts_attiny104        16
#define vts_attiny11          5
#define vts_attiny12          6
#define vts_attiny13         10
#define vts_attiny13a        10
#define vts_attiny15          9
#define vts_attiny22          3
#define vts_attiny24         17
#define vts_attiny24a        17
#define vts_attiny25         15
#define vts_attiny26         12
#define vts_attiny28          6
#define vts_attiny43u        16
#define vts_attiny44         17
#define vts_attiny44a        17
#define vts_attiny45         15
#define vts_attiny48         20
#define vts_attiny84         17
#define vts_attiny84a        17
#define vts_attiny85         15
#define vts_attiny87         20
#define vts_attiny88         20
#define vts_attiny167        20
#define vts_attiny261        19
#define vts_attiny261a       19
#define vts_attiny441        30
#define vts_attiny461        19
#define vts_attiny461a       19
#define vts_attiny828        26
#define vts_attiny828r       26
#define vts_attiny841        30
#define vts_attiny861        19
#define vts_attiny861a       19
#define vts_attiny1634       28
#define vts_attiny1634r      28
#define vts_attiny2313       19
#define vts_attiny2313a      21
#define vts_attiny4313       21
#define vts_atmega8          19
#define vts_atmega8a         19
#define vts_atmega8hva       21
#define vts_atmega8u2        29
#define vts_atmega16         21
#define vts_atmega16a        21
#define vts_atmega16hva      21
#define vts_atmega16hvb      29
#define vts_atmega16hvbrevb  29
#define vts_atmega16m1       31
#define vts_atmega16hva2     22
#define vts_atmega16u2       29
#define vts_atmega16u4       43
#define vts_atmega32         21
#define vts_atmega32a        21
#define vts_atmega32hvb      29
#define vts_atmega32hvbrevb  29
#define vts_atmega32c1       31
#define vts_atmega32m1       31
#define vts_atmega32hve2     25
#define vts_atmega32u2       29
#define vts_atmega32u4       43
#define vts_atmega32u6       38
#define vts_atmega48         26
#define vts_atmega48a        26
#define vts_atmega48p        26
#define vts_atmega48pa       26
#define vts_atmega48pb       27
#define vts_atmega64         35
#define vts_atmega64a        35
#define vts_atmega64hve      25
#define vts_atmega64c1       31
#define vts_atmega64m1       31
#define vts_atmega64hve2     25
#define vts_atmega64rfr2     77
#define vts_atmega88         26
#define vts_atmega88a        26
#define vts_atmega88p        26
#define vts_atmega88pa       26
#define vts_atmega88pb       27
#define vts_atmega103        24
#define vts_atmega128        35
#define vts_atmega128a       35
#define vts_atmega128rfa1    72
#define vts_atmega128rfr2    77
#define vts_atmega161        21
#define vts_atmega162        28
#define vts_atmega163        18
#define vts_atmega164a       31
#define vts_atmega164p       31
#define vts_atmega164pa      31
#define vts_atmega165        22
#define vts_atmega165a       22
#define vts_atmega165p       22
#define vts_atmega165pa      22
#define vts_atmega168        26
#define vts_atmega168a       26
#define vts_atmega168p       26
#define vts_atmega168pa      26
#define vts_atmega168pb      27
#define vts_atmega169        23
#define vts_atmega169a       23
#define vts_atmega169p       23
#define vts_atmega169pa      23
#define vts_atmega256rfr2    77
#define vts_atmega323        21
#define vts_atmega324a       31
#define vts_atmega324p       31
#define vts_atmega324pa      31
#define vts_atmega324pb      51
#define vts_atmega325        22
#define vts_atmega325a       22
#define vts_atmega325p       22
#define vts_atmega325pa      22
#define vts_atmega328        26
#define vts_atmega328p       26
#define vts_atmega328pb      45
#define vts_atmega329        23
#define vts_atmega329a       23
#define vts_atmega329p       23
#define vts_atmega329pa      23
#define vts_atmega406        23
#define vts_atmega640        57
#define vts_atmega644        28
#define vts_atmega644a       31
#define vts_atmega644p       31
#define vts_atmega644pa      31
#define vts_atmega644rfr2    77
#define vts_atmega645        22
#define vts_atmega645a       22
#define vts_atmega645p       22
#define vts_atmega649        23
#define vts_atmega649a       23
#define vts_atmega649p       23
#define vts_atmega1280       57
#define vts_atmega1281       57
#define vts_atmega1284       35
#define vts_atmega1284p      35
#define vts_atmega1284rfr2   77
#define vts_atmega2560       57
#define vts_atmega2561       57
#define vts_atmega2564rfr2   77
#define vts_atmega3250       25
#define vts_atmega3250a      25
#define vts_atmega3250p      25
#define vts_atmega3250pa     25
#define vts_atmega3290       25
#define vts_atmega3290a      25
#define vts_atmega3290p      25
#define vts_atmega3290pa     25
#define vts_atmega6450       25
#define vts_atmega6450a      25
#define vts_atmega6450p      25
#define vts_atmega6490       25
#define vts_atmega6490a      25
#define vts_atmega6490p      25
#define vts_atmega8515       17
#define vts_atmega8535       21
#define vts_at86rf401         3
#define vts_at90pwm1         32
#define vts_at90pwm2         32
#define vts_at90pwm2b        32
#define vts_at90pwm3         32
#define vts_at90pwm3b        32
#define vts_at90can32        37
#define vts_at90can64        37
#define vts_at90pwm81        20
#define vts_at90usb82        29
#define vts_at90scr100       38
#define vts_at90scr100h      38
#define vts_at90can128       37
#define vts_at90pwm161       20
#define vts_at90usb162       29
#define vts_at90pwm216       32
#define vts_at90pwm316       32
#define vts_at90usb646       38
#define vts_at90usb647       38
#define vts_at90s1200         4
#define vts_at90usb1286      38
#define vts_at90usb1287      38
#define vts_at90s2313        11
#define vts_at90s2323         3
#define vts_at90s2333        14
#define vts_at90s2343         3
#define vts_at90s4414        13
#define vts_at90s4433        14
#define vts_at90s4434        17
#define vts_at90s8515        13
#define vts_at90s8535        17
#define vts_ata5272          37
#define vts_ata5505          20
#define vts_ata5700m322      51
#define vts_ata5702m322      51
#define vts_ata5781          42
#define vts_ata5782          42
#define vts_ata5783          42
#define vts_ata5787          44
#define vts_ata5790          30
#define vts_ata5790n         31
#define vts_ata5791          31
#define vts_ata5795          23
#define vts_ata5831          42
#define vts_ata5832          42
#define vts_ata5833          42
#define vts_ata5835          44
#define vts_ata6285          27
#define vts_ata6286          27
#define vts_ata6289          27
#define vts_ata6612c         26
#define vts_ata6613c         26
#define vts_ata6614q         26
#define vts_ata6616c         20
#define vts_ata6617c         20
#define vts_ata8210          42
#define vts_ata8215          42
#define vts_ata8510          42
#define vts_ata8515          42
#define vts_ata664251        20
#define vts_lgt8f88p         26
#define vts_lgt8f168p        26
#define vts_lgt8f328p        26
#define vts_atxmega8e5       43
#define vts_atxmega16a4      94
#define vts_atxmega16a4u    127
#define vts_atxmega16c4     127
#define vts_atxmega16d4      91
#define vts_atxmega16e5      43
#define vts_atxmega32c3     127
#define vts_atxmega32d3     114
#define vts_atxmega32a4      94
#define vts_atxmega32a4u    127
#define vts_atxmega32c4     127
#define vts_atxmega32d4      91
#define vts_atxmega32e5      43
#define vts_atxmega64a1     125
#define vts_atxmega64a1u    127
#define vts_atxmega64b1      81
#define vts_atxmega64a3     122
#define vts_atxmega64a3u    127
#define vts_atxmega64b3      54
#define vts_atxmega64c3     127
#define vts_atxmega64d3     114
#define vts_atxmega64a4u    127
#define vts_atxmega64d4      91
#define vts_atxmega128a1    125
#define vts_atxmega128a1revd 125
#define vts_atxmega128a1u   127
#define vts_atxmega128b1     81
#define vts_atxmega128a3    122
#define vts_atxmega128a3u   127
#define vts_atxmega128b3     54
#define vts_atxmega128c3    127
#define vts_atxmega128d3    114
#define vts_atxmega128a4u   127
#define vts_atxmega128d4     91
#define vts_atxmega192a3    122
#define vts_atxmega192a3u   127
#define vts_atxmega192c3    127
#define vts_atxmega192d3    114
#define vts_atxmega256a3    122
#define vts_atxmega256a3b   122
#define vts_atxmega256a3bu  127
#define vts_atxmega256a3u   127
#define vts_atxmega256c3    127
#define vts_atxmega256d3    114
#define vts_atxmega384c3    127
#define vts_atxmega384d3    114
#define vts_attiny202        26
#define vts_attiny204        26
#define vts_attiny212        26
#define vts_attiny214        26
#define vts_attiny402        26
#define vts_attiny404        26
#define vts_attiny406        26
#define vts_attiny412        26
#define vts_attiny414        26
#define vts_attiny416        26
#define vts_attiny416auto    26
#define vts_attiny417        26
#define vts_attiny424        30
#define vts_attiny426        30
#define vts_attiny427        30
#define vts_attiny804        31
#define vts_attiny806        31
#define vts_attiny807        31
#define vts_attiny814        26
#define vts_attiny816        26
#define vts_attiny817        26
#define vts_attiny824        30
#define vts_attiny826        30
#define vts_attiny827        30
#define vts_attiny1604       31
#define vts_attiny1606       31
#define vts_attiny1607       31
#define vts_attiny1614       31
#define vts_attiny1616       31
#define vts_attiny1617       31
#define vts_attiny1624       30
#define vts_attiny1626       30
#define vts_attiny1627       30
#define vts_attiny3214       31
#define vts_attiny3216       31
#define vts_attiny3217       31
#define vts_attiny3224       30
#define vts_attiny3226       30
#define vts_attiny3227       30
#define vts_atmega808        36
#define vts_atmega809        40
#define vts_atmega1608       36
#define vts_atmega1609       40
#define vts_atmega3208       36
#define vts_atmega3209       40
#define vts_atmega4808       36
#define vts_atmega4809       40
#define vts_avr16dd14        36
#define vts_avr16dd20        36
#define vts_avr16dd28        36
#define vts_avr16ea28        37
#define vts_avr16dd32        36
#define vts_avr16ea32        37
#define vts_avr16ea48        45
#define vts_avr32dd14        36
#define vts_avr32dd20        36
#define vts_avr32da28        41
#define vts_avr32db28        42
#define vts_avr32dd28        36
#define vts_avr32ea28        37
#define vts_avr32da32        44
#define vts_avr32db32        44
#define vts_avr32dd32        36
#define vts_avr32ea32        37
#define vts_avr32da48        58
#define vts_avr32db48        61
#define vts_avr32ea48        45
#define vts_avr64dd14        36
#define vts_avr64dd20        36
#define vts_avr64da28        41
#define vts_avr64db28        42
#define vts_avr64dd28        36
#define vts_avr64ea28        37
#define vts_avr64da32        44
#define vts_avr64db32        44
#define vts_avr64dd32        36
#define vts_avr64ea32        37
#define vts_avr64da48        58
#define vts_avr64db48        61
#define vts_avr64ea48        45
#define vts_avr64da64        64
#define vts_avr64db64        65
#define vts_avr128da28       41
#define vts_avr128db28       42
#define vts_avr128da32       44
#define vts_avr128db32       44
#define vts_avr128da48       58
#define vts_avr128db48       61
#define vts_avr128da64       64
#define vts_avr128db64       65


// Suggested vector bootloader interrupt: first unused vector or slot just above vector table

#define vbu_attiny4          10
#define vbu_attiny5          11
#define vbu_attiny9          10
#define vbu_attiny10         11
#define vbu_attiny20         17
#define vbu_attiny40         18
#define vbu_attiny102        16
#define vbu_attiny104        16
#define vbu_attiny11          5
#define vbu_attiny12          6
#define vbu_attiny13         10
#define vbu_attiny13a        10
#define vbu_attiny15          9
#define vbu_attiny22          3
#define vbu_attiny24         17
#define vbu_attiny24a        17
#define vbu_attiny25         15
#define vbu_attiny26         12
#define vbu_attiny28          6
#define vbu_attiny43u        16
#define vbu_attiny44         17
#define vbu_attiny44a        17
#define vbu_attiny45         15
#define vbu_attiny48         20
#define vbu_attiny84         17
#define vbu_attiny84a        17
#define vbu_attiny85         15
#define vbu_attiny87         20
#define vbu_attiny88         20
#define vbu_attiny167        20
#define vbu_attiny261        19
#define vbu_attiny261a       19
#define vbu_attiny441        30
#define vbu_attiny461        19
#define vbu_attiny461a       19
#define vbu_attiny828        26
#define vbu_attiny828r       26
#define vbu_attiny841        30
#define vbu_attiny861        19
#define vbu_attiny861a       19
#define vbu_attiny1634       28
#define vbu_attiny1634r      28
#define vbu_attiny2313       19
#define vbu_attiny2313a      21
#define vbu_attiny4313       21
#define vbu_atmega8          19
#define vbu_atmega8a         19
#define vbu_atmega8hva       21
#define vbu_atmega8u2        29
#define vbu_atmega16         21
#define vbu_atmega16a        21
#define vbu_atmega16hva      21
#define vbu_atmega16hvb      29
#define vbu_atmega16hvbrevb  29
#define vbu_atmega16m1       31
#define vbu_atmega16hva2     22
#define vbu_atmega16u2       29
#define vbu_atmega16u4        5
#define vbu_atmega32         21
#define vbu_atmega32a        21
#define vbu_atmega32hvb      29
#define vbu_atmega32hvbrevb  29
#define vbu_atmega32c1       31
#define vbu_atmega32m1       31
#define vbu_atmega32hve2     25
#define vbu_atmega32u2       29
#define vbu_atmega32u4        5
#define vbu_atmega32u6       38
#define vbu_atmega48         26
#define vbu_atmega48a        26
#define vbu_atmega48p        26
#define vbu_atmega48pa       26
#define vbu_atmega48pb       27
#define vbu_atmega64         35
#define vbu_atmega64a        35
#define vbu_atmega64hve      25
#define vbu_atmega64c1       31
#define vbu_atmega64m1       31
#define vbu_atmega64hve2     25
#define vbu_atmega64rfr2     51
#define vbu_atmega88         26
#define vbu_atmega88a        26
#define vbu_atmega88p        26
#define vbu_atmega88pa       26
#define vbu_atmega88pb       27
#define vbu_atmega103        24
#define vbu_atmega128        35
#define vbu_atmega128a       35
#define vbu_atmega128rfa1    51
#define vbu_atmega128rfr2    51
#define vbu_atmega161        21
#define vbu_atmega162        28
#define vbu_atmega163        18
#define vbu_atmega164a       31
#define vbu_atmega164p       31
#define vbu_atmega164pa      31
#define vbu_atmega165        22
#define vbu_atmega165a       22
#define vbu_atmega165p       22
#define vbu_atmega165pa      22
#define vbu_atmega168        26
#define vbu_atmega168a       26
#define vbu_atmega168p       26
#define vbu_atmega168pa      26
#define vbu_atmega168pb      27
#define vbu_atmega169        23
#define vbu_atmega169a       23
#define vbu_atmega169p       23
#define vbu_atmega169pa      23
#define vbu_atmega256rfr2    51
#define vbu_atmega323        21
#define vbu_atmega324a       31
#define vbu_atmega324p       31
#define vbu_atmega324pa      31
#define vbu_atmega324pb      51
#define vbu_atmega325        22
#define vbu_atmega325a       22
#define vbu_atmega325p       22
#define vbu_atmega325pa      22
#define vbu_atmega328        26
#define vbu_atmega328p       26
#define vbu_atmega328pb      45
#define vbu_atmega329        23
#define vbu_atmega329a       23
#define vbu_atmega329p       23
#define vbu_atmega329pa      23
#define vbu_atmega406        23
#define vbu_atmega640        57
#define vbu_atmega644        28
#define vbu_atmega644a       31
#define vbu_atmega644p       31
#define vbu_atmega644pa      31
#define vbu_atmega644rfr2    51
#define vbu_atmega645        22
#define vbu_atmega645a       22
#define vbu_atmega645p       22
#define vbu_atmega649        23
#define vbu_atmega649a       23
#define vbu_atmega649p       23
#define vbu_atmega1280       57
#define vbu_atmega1281       51
#define vbu_atmega1284       35
#define vbu_atmega1284p      35
#define vbu_atmega1284rfr2   51
#define vbu_atmega2560       57
#define vbu_atmega2561       51
#define vbu_atmega2564rfr2   51
#define vbu_atmega3250       22
#define vbu_atmega3250a      22
#define vbu_atmega3250p      22
#define vbu_atmega3250pa     22
#define vbu_atmega3290       25
#define vbu_atmega3290a      25
#define vbu_atmega3290p      25
#define vbu_atmega3290pa     25
#define vbu_atmega6450       22
#define vbu_atmega6450a      22
#define vbu_atmega6450p      22
#define vbu_atmega6490       25
#define vbu_atmega6490a      25
#define vbu_atmega6490p      25
#define vbu_atmega8515       17
#define vbu_atmega8535       21
#define vbu_at86rf401         3
#define vbu_at90pwm1         14
#define vbu_at90pwm2         14
#define vbu_at90pwm2b        14
#define vbu_at90pwm3         14
#define vbu_at90pwm3b        14
#define vbu_at90can32        37
#define vbu_at90can64        37
#define vbu_at90pwm81        20
#define vbu_at90usb82        29
#define vbu_at90scr100       24
#define vbu_at90scr100h      24
#define vbu_at90can128       37
#define vbu_at90pwm161       20
#define vbu_at90usb162       29
#define vbu_at90pwm216       14
#define vbu_at90pwm316       14
#define vbu_at90usb646       38
#define vbu_at90usb647       38
#define vbu_at90s1200         4
#define vbu_at90usb1286      38
#define vbu_at90usb1287      38
#define vbu_at90s2313        11
#define vbu_at90s2323         3
#define vbu_at90s2333        14
#define vbu_at90s2343         3
#define vbu_at90s4414        13
#define vbu_at90s4433        14
#define vbu_at90s4434        17
#define vbu_at90s8515        13
#define vbu_at90s8535        17
#define vbu_ata5272          17
#define vbu_ata5505          20
#define vbu_ata5700m322      51
#define vbu_ata5702m322      51
#define vbu_ata5781          42
#define vbu_ata5782          42
#define vbu_ata5783          42
#define vbu_ata5787          44
#define vbu_ata5790          30
#define vbu_ata5790n         31
#define vbu_ata5791          31
#define vbu_ata5795          23
#define vbu_ata5831          42
#define vbu_ata5832          42
#define vbu_ata5833          42
#define vbu_ata5835          44
#define vbu_ata6285          27
#define vbu_ata6286          27
#define vbu_ata6289          27
#define vbu_ata6612c         26
#define vbu_ata6613c         26
#define vbu_ata6614q         26
#define vbu_ata6616c         20
#define vbu_ata6617c         20
#define vbu_ata8210          42
#define vbu_ata8215          42
#define vbu_ata8510          42
#define vbu_ata8515          42
#define vbu_ata664251        20
#define vbu_lgt8f88p         26
#define vbu_lgt8f168p        26
#define vbu_lgt8f328p        26
#define vbu_atxmega8e5       43
#define vbu_atxmega16a4      36
#define vbu_atxmega16a4u     36
#define vbu_atxmega16c4       6
#define vbu_atxmega16d4       6
#define vbu_atxmega16e5      43
#define vbu_atxmega32c3       6
#define vbu_atxmega32d3       6
#define vbu_atxmega32a4      36
#define vbu_atxmega32a4u     36
#define vbu_atxmega32c4       6
#define vbu_atxmega32d4       6
#define vbu_atxmega32e5      43
#define vbu_atxmega64a1     102
#define vbu_atxmega64a1u    102
#define vbu_atxmega64b1       8
#define vbu_atxmega64a3      75
#define vbu_atxmega64a3u     75
#define vbu_atxmega64b3       8
#define vbu_atxmega64c3       6
#define vbu_atxmega64d3       6
#define vbu_atxmega64a4u     36
#define vbu_atxmega64d4       6
#define vbu_atxmega128a1    102
#define vbu_atxmega128a1revd 102
#define vbu_atxmega128a1u   102
#define vbu_atxmega128b1      8
#define vbu_atxmega128a3     75
#define vbu_atxmega128a3u    75
#define vbu_atxmega128b3      8
#define vbu_atxmega128c3      6
#define vbu_atxmega128d3      6
#define vbu_atxmega128a4u    36
#define vbu_atxmega128d4      6
#define vbu_atxmega192a3     75
#define vbu_atxmega192a3u    75
#define vbu_atxmega192c3      6
#define vbu_atxmega192d3      6
#define vbu_atxmega256a3     75
#define vbu_atxmega256a3b    57
#define vbu_atxmega256a3bu   57
#define vbu_atxmega256a3u    75
#define vbu_atxmega256c3      6
#define vbu_atxmega256d3      6
#define vbu_atxmega384c3      8
#define vbu_atxmega384d3      6
#define vbu_attiny202         4
#define vbu_attiny204         5
#define vbu_attiny212         4
#define vbu_attiny214         5
#define vbu_attiny402         4
#define vbu_attiny404         5
#define vbu_attiny406        14
#define vbu_attiny412         4
#define vbu_attiny414         5
#define vbu_attiny416        26
#define vbu_attiny416auto    26
#define vbu_attiny417        26
#define vbu_attiny424        30
#define vbu_attiny426        30
#define vbu_attiny427        30
#define vbu_attiny804        14
#define vbu_attiny806        14
#define vbu_attiny807        14
#define vbu_attiny814         5
#define vbu_attiny816        26
#define vbu_attiny817        26
#define vbu_attiny824        30
#define vbu_attiny826        30
#define vbu_attiny827        30
#define vbu_attiny1604       14
#define vbu_attiny1606       14
#define vbu_attiny1607       14
#define vbu_attiny1614        5
#define vbu_attiny1616       31
#define vbu_attiny1617       31
#define vbu_attiny1624       30
#define vbu_attiny1626       30
#define vbu_attiny1627       30
#define vbu_attiny3214       31
#define vbu_attiny3216       31
#define vbu_attiny3217       31
#define vbu_attiny3224       30
#define vbu_attiny3226       30
#define vbu_attiny3227       30
#define vbu_atmega808        36
#define vbu_atmega809        40
#define vbu_atmega1608       36
#define vbu_atmega1609       40
#define vbu_atmega3208       36
#define vbu_atmega3209       40
#define vbu_atmega4808       36
#define vbu_atmega4809       40
#define vbu_avr16dd14        36
#define vbu_avr16dd20        36
#define vbu_avr16dd28        36
#define vbu_avr16ea28        37
#define vbu_avr16dd32        36
#define vbu_avr16ea32        37
#define vbu_avr16ea48        45
#define vbu_avr32dd14        36
#define vbu_avr32dd20        36
#define vbu_avr32da28        41
#define vbu_avr32db28        42
#define vbu_avr32dd28        36
#define vbu_avr32ea28        37
#define vbu_avr32da32        41
#define vbu_avr32db32        44
#define vbu_avr32dd32        36
#define vbu_avr32ea32        37
#define vbu_avr32da48        58
#define vbu_avr32db48        59
#define vbu_avr32ea48        45
#define vbu_avr64dd14        36
#define vbu_avr64dd20        36
#define vbu_avr64da28        41
#define vbu_avr64db28        42
#define vbu_avr64dd28        36
#define vbu_avr64ea28        37
#define vbu_avr64da32        41
#define vbu_avr64db32        44
#define vbu_avr64dd32        36
#define vbu_avr64ea32        37
#define vbu_avr64da48        58
#define vbu_avr64db48        59
#define vbu_avr64ea48        45
#define vbu_avr64da64        64
#define vbu_avr64db64        65
#define vbu_avr128da28       41
#define vbu_avr128db28       42
#define vbu_avr128da32       41
#define vbu_avr128db32       44
#define vbu_avr128da48       58
#define vbu_avr128db48       59
#define vbu_avr128da64       64
#define vbu_avr128db64       65


// Interrupt vector table interrupt names

extern const char * const    vtab_attiny9[10];
#define vtab_attiny4         vtab_attiny9

extern const char * const    vtab_attiny10[11];
#define vtab_attiny5         vtab_attiny10

extern const char * const    vtab_attiny20[17];

extern const char * const    vtab_attiny40[18];

extern const char * const    vtab_attiny104[16];
#define vtab_attiny102       vtab_attiny104

extern const char * const    vtab_attiny11[5];

extern const char * const    vtab_attiny12[6];

extern const char * const    vtab_attiny13a[10];
#define vtab_attiny13        vtab_attiny13a

extern const char * const    vtab_attiny15[9];

extern const char * const    vtab_attiny22[3];
#define vtab_at90s2343       vtab_attiny22
#define vtab_at90s2323       vtab_attiny22

extern const char * const    vtab_attiny26[12];

extern const char * const    vtab_attiny28[6];

extern const char * const    vtab_attiny43u[16];

extern const char * const    vtab_attiny84a[17];
#define vtab_attiny84        vtab_attiny84a
#define vtab_attiny44a       vtab_attiny84a
#define vtab_attiny44        vtab_attiny84a
#define vtab_attiny24a       vtab_attiny84a
#define vtab_attiny24        vtab_attiny84a

extern const char * const    vtab_attiny85[15];
#define vtab_attiny45        vtab_attiny85
#define vtab_attiny25        vtab_attiny85

extern const char * const    vtab_attiny88[20];
#define vtab_attiny48        vtab_attiny88

extern const char * const    vtab_attiny167[20];
#define vtab_attiny87        vtab_attiny167
#define vtab_ata664251       vtab_attiny167
#define vtab_ata6617c        vtab_attiny167
#define vtab_ata6616c        vtab_attiny167
#define vtab_ata5505         vtab_attiny167

extern const char * const    vtab_attiny828r[26];
#define vtab_attiny828       vtab_attiny828r

extern const char * const    vtab_attiny841[30];
#define vtab_attiny441       vtab_attiny841

extern const char * const    vtab_attiny861a[19];
#define vtab_attiny861       vtab_attiny861a
#define vtab_attiny461a      vtab_attiny861a
#define vtab_attiny461       vtab_attiny861a
#define vtab_attiny261a      vtab_attiny861a
#define vtab_attiny261       vtab_attiny861a

extern const char * const    vtab_attiny1634r[28];
#define vtab_attiny1634      vtab_attiny1634r

extern const char * const    vtab_attiny2313[19];

extern const char * const    vtab_attiny4313[21];
#define vtab_attiny2313a     vtab_attiny4313

extern const char * const    vtab_atmega8a[19];
#define vtab_atmega8         vtab_atmega8a

extern const char * const    vtab_atmega16a[21];
#define vtab_atmega16        vtab_atmega16a

extern const char * const    vtab_atmega16hva[21];
#define vtab_atmega8hva      vtab_atmega16hva

extern const char * const    vtab_atmega16hva2[22];

extern const char * const    vtab_atmega32hvbrevb[29];
#define vtab_atmega32hvb     vtab_atmega32hvbrevb
#define vtab_atmega16hvbrevb vtab_atmega32hvbrevb
#define vtab_atmega16hvb     vtab_atmega32hvbrevb

extern const char * const    vtab_atmega32u2[29];
#define vtab_atmega16u2      vtab_atmega32u2
#define vtab_atmega8u2       vtab_atmega32u2
#define vtab_at90usb162      vtab_atmega32u2
#define vtab_at90usb82       vtab_atmega32u2

extern const char * const    vtab_atmega32u4[43];
#define vtab_atmega16u4      vtab_atmega32u4

extern const char * const    vtab_atmega32u6[38];
#define vtab_at90usb1287     vtab_atmega32u6
#define vtab_at90usb1286     vtab_atmega32u6
#define vtab_at90usb647      vtab_atmega32u6
#define vtab_at90usb646      vtab_atmega32u6

extern const char * const    vtab_atmega64m1[31];
#define vtab_atmega64c1      vtab_atmega64m1
#define vtab_atmega32m1      vtab_atmega64m1
#define vtab_atmega32c1      vtab_atmega64m1
#define vtab_atmega16m1      vtab_atmega64m1

extern const char * const    vtab_atmega64hve2[25];
#define vtab_atmega64hve     vtab_atmega64hve2
#define vtab_atmega32hve2    vtab_atmega64hve2

extern const char * const    vtab_atmega103[24];

extern const char * const    vtab_atmega128a[35];
#define vtab_atmega128       vtab_atmega128a
#define vtab_atmega64a       vtab_atmega128a
#define vtab_atmega64        vtab_atmega128a

extern const char * const    vtab_atmega128rfa1[72];

extern const char * const    vtab_atmega161[21];

extern const char * const    vtab_atmega162[28];

extern const char * const    vtab_atmega163[18];

extern const char * const    vtab_atmega168pb[27];
#define vtab_atmega88pb      vtab_atmega168pb
#define vtab_atmega48pb      vtab_atmega168pb

extern const char * const    vtab_atmega323[21];
#define vtab_atmega32a       vtab_atmega323
#define vtab_atmega32        vtab_atmega323

extern const char * const    vtab_atmega324pb[51];

extern const char * const    vtab_atmega328[26];
#define vtab_atmega168       vtab_atmega328

extern const char * const    vtab_atmega328p[26];
#define vtab_atmega168pa     vtab_atmega328p
#define vtab_atmega168p      vtab_atmega328p
#define vtab_atmega168a      vtab_atmega328p
#define vtab_atmega88pa      vtab_atmega328p
#define vtab_atmega88p       vtab_atmega328p
#define vtab_atmega88a       vtab_atmega328p
#define vtab_atmega88        vtab_atmega328p
#define vtab_atmega48pa      vtab_atmega328p
#define vtab_atmega48p       vtab_atmega328p
#define vtab_atmega48a       vtab_atmega328p
#define vtab_atmega48        vtab_atmega328p
#define vtab_ata6614q        vtab_atmega328p
#define vtab_ata6613c        vtab_atmega328p
#define vtab_ata6612c        vtab_atmega328p
#define vtab_lgt8f328p       vtab_atmega328p
#define vtab_lgt8f168p       vtab_atmega328p
#define vtab_lgt8f88p        vtab_atmega328p

extern const char * const    vtab_atmega328pb[45];

extern const char * const    vtab_atmega406[23];

extern const char * const    vtab_atmega644[28];

extern const char * const    vtab_atmega644pa[31];
#define vtab_atmega644p      vtab_atmega644pa
#define vtab_atmega644a      vtab_atmega644pa
#define vtab_atmega324pa     vtab_atmega644pa
#define vtab_atmega324p      vtab_atmega644pa
#define vtab_atmega324a      vtab_atmega644pa
#define vtab_atmega164pa     vtab_atmega644pa
#define vtab_atmega164p      vtab_atmega644pa
#define vtab_atmega164a      vtab_atmega644pa

extern const char * const    vtab_atmega645p[22];
#define vtab_atmega645a      vtab_atmega645p
#define vtab_atmega645       vtab_atmega645p
#define vtab_atmega325pa     vtab_atmega645p
#define vtab_atmega325p      vtab_atmega645p
#define vtab_atmega325a      vtab_atmega645p
#define vtab_atmega325       vtab_atmega645p
#define vtab_atmega165pa     vtab_atmega645p
#define vtab_atmega165p      vtab_atmega645p
#define vtab_atmega165a      vtab_atmega645p
#define vtab_atmega165       vtab_atmega645p

extern const char * const    vtab_atmega649p[23];
#define vtab_atmega649a      vtab_atmega649p
#define vtab_atmega649       vtab_atmega649p
#define vtab_atmega329pa     vtab_atmega649p
#define vtab_atmega329p      vtab_atmega649p
#define vtab_atmega329a      vtab_atmega649p
#define vtab_atmega329       vtab_atmega649p
#define vtab_atmega169pa     vtab_atmega649p
#define vtab_atmega169p      vtab_atmega649p
#define vtab_atmega169a      vtab_atmega649p
#define vtab_atmega169       vtab_atmega649p

extern const char * const    vtab_atmega1284p[35];
#define vtab_atmega1284      vtab_atmega1284p

extern const char * const    vtab_atmega2560[57];
#define vtab_atmega1280      vtab_atmega2560
#define vtab_atmega640       vtab_atmega2560

extern const char * const    vtab_atmega2561[57];
#define vtab_atmega1281      vtab_atmega2561

extern const char * const    vtab_atmega2564rfr2[77];
#define vtab_atmega1284rfr2  vtab_atmega2564rfr2
#define vtab_atmega644rfr2   vtab_atmega2564rfr2
#define vtab_atmega256rfr2   vtab_atmega2564rfr2
#define vtab_atmega128rfr2   vtab_atmega2564rfr2
#define vtab_atmega64rfr2    vtab_atmega2564rfr2

extern const char * const    vtab_atmega6450p[25];
#define vtab_atmega6450a     vtab_atmega6450p
#define vtab_atmega6450      vtab_atmega6450p
#define vtab_atmega3250pa    vtab_atmega6450p
#define vtab_atmega3250p     vtab_atmega6450p
#define vtab_atmega3250a     vtab_atmega6450p
#define vtab_atmega3250      vtab_atmega6450p

extern const char * const    vtab_atmega6490p[25];
#define vtab_atmega6490a     vtab_atmega6490p
#define vtab_atmega6490      vtab_atmega6490p
#define vtab_atmega3290pa    vtab_atmega6490p
#define vtab_atmega3290p     vtab_atmega6490p
#define vtab_atmega3290a     vtab_atmega6490p
#define vtab_atmega3290      vtab_atmega6490p

extern const char * const    vtab_atmega8515[17];

extern const char * const    vtab_atmega8535[21];

extern const char * const    vtab_at86rf401[3];

extern const char * const    vtab_at90pwm1[32];

extern const char * const    vtab_at90pwm2[32];

extern const char * const    vtab_at90pwm3b[32];
#define vtab_at90pwm3        vtab_at90pwm3b
#define vtab_at90pwm2b       vtab_at90pwm3b

extern const char * const    vtab_at90scr100h[38];
#define vtab_at90scr100      vtab_at90scr100h

extern const char * const    vtab_at90can128[37];
#define vtab_at90can64       vtab_at90can128
#define vtab_at90can32       vtab_at90can128

extern const char * const    vtab_at90pwm161[20];
#define vtab_at90pwm81       vtab_at90pwm161

extern const char * const    vtab_at90pwm316[32];
#define vtab_at90pwm216      vtab_at90pwm316

extern const char * const    vtab_at90s1200[4];

extern const char * const    vtab_at90s2313[11];

extern const char * const    vtab_at90s4433[14];
#define vtab_at90s2333       vtab_at90s4433

extern const char * const    vtab_at90s8515[13];
#define vtab_at90s4414       vtab_at90s8515

extern const char * const    vtab_at90s8535[17];
#define vtab_at90s4434       vtab_at90s8535

extern const char * const    vtab_ata5272[37];

extern const char * const    vtab_ata5702m322[51];
#define vtab_ata5700m322     vtab_ata5702m322

extern const char * const    vtab_ata5790[30];

extern const char * const    vtab_ata5791[31];
#define vtab_ata5790n        vtab_ata5791

extern const char * const    vtab_ata5795[23];

extern const char * const    vtab_ata5835[44];
#define vtab_ata5787         vtab_ata5835

extern const char * const    vtab_ata6289[27];
#define vtab_ata6286         vtab_ata6289
#define vtab_ata6285         vtab_ata6289

extern const char * const    vtab_ata8515[42];
#define vtab_ata8510         vtab_ata8515
#define vtab_ata8215         vtab_ata8515
#define vtab_ata8210         vtab_ata8515
#define vtab_ata5833         vtab_ata8515
#define vtab_ata5832         vtab_ata8515
#define vtab_ata5831         vtab_ata8515
#define vtab_ata5783         vtab_ata8515
#define vtab_ata5782         vtab_ata8515
#define vtab_ata5781         vtab_ata8515

extern const char * const    vtab_atxmega32a4[94];
#define vtab_atxmega16a4     vtab_atxmega32a4

extern const char * const    vtab_atxmega32c4[127];
#define vtab_atxmega16c4     vtab_atxmega32c4

extern const char * const    vtab_atxmega32d4[91];
#define vtab_atxmega16d4     vtab_atxmega32d4

extern const char * const    vtab_atxmega32e5[43];
#define vtab_atxmega16e5     vtab_atxmega32e5
#define vtab_atxmega8e5      vtab_atxmega32e5

extern const char * const    vtab_atxmega128a1revd[125];
#define vtab_atxmega128a1    vtab_atxmega128a1revd
#define vtab_atxmega64a1     vtab_atxmega128a1revd

extern const char * const    vtab_atxmega128a1u[127];
#define vtab_atxmega64a1u    vtab_atxmega128a1u

extern const char * const    vtab_atxmega128b1[81];
#define vtab_atxmega64b1     vtab_atxmega128b1

extern const char * const    vtab_atxmega128b3[54];
#define vtab_atxmega64b3     vtab_atxmega128b3

extern const char * const    vtab_atxmega128a4u[127];
#define vtab_atxmega64a4u    vtab_atxmega128a4u
#define vtab_atxmega32a4u    vtab_atxmega128a4u
#define vtab_atxmega16a4u    vtab_atxmega128a4u

extern const char * const    vtab_atxmega128d4[91];
#define vtab_atxmega64d4     vtab_atxmega128d4

extern const char * const    vtab_atxmega256a3[122];
#define vtab_atxmega192a3    vtab_atxmega256a3
#define vtab_atxmega128a3    vtab_atxmega256a3
#define vtab_atxmega64a3     vtab_atxmega256a3

extern const char * const    vtab_atxmega256a3b[122];

extern const char * const    vtab_atxmega256a3bu[127];

extern const char * const    vtab_atxmega256a3u[127];
#define vtab_atxmega192a3u   vtab_atxmega256a3u
#define vtab_atxmega128a3u   vtab_atxmega256a3u
#define vtab_atxmega64a3u    vtab_atxmega256a3u

extern const char * const    vtab_atxmega256c3[127];
#define vtab_atxmega192c3    vtab_atxmega256c3
#define vtab_atxmega128c3    vtab_atxmega256c3
#define vtab_atxmega64c3     vtab_atxmega256c3
#define vtab_atxmega32c3     vtab_atxmega256c3

extern const char * const    vtab_atxmega384c3[127];

extern const char * const    vtab_atxmega384d3[114];
#define vtab_atxmega256d3    vtab_atxmega384d3
#define vtab_atxmega192d3    vtab_atxmega384d3
#define vtab_atxmega128d3    vtab_atxmega384d3
#define vtab_atxmega64d3     vtab_atxmega384d3
#define vtab_atxmega32d3     vtab_atxmega384d3

extern const char * const    vtab_attiny402[26];
#define vtab_attiny202       vtab_attiny402

extern const char * const    vtab_attiny404[26];
#define vtab_attiny204       vtab_attiny404

extern const char * const    vtab_attiny406[26];

extern const char * const    vtab_attiny412[26];
#define vtab_attiny212       vtab_attiny412

extern const char * const    vtab_attiny814[26];
#define vtab_attiny414       vtab_attiny814
#define vtab_attiny214       vtab_attiny814

extern const char * const    vtab_attiny817[26];
#define vtab_attiny816       vtab_attiny817
#define vtab_attiny417       vtab_attiny817
#define vtab_attiny416auto   vtab_attiny817
#define vtab_attiny416       vtab_attiny817

extern const char * const    vtab_attiny1607[31];
#define vtab_attiny1606      vtab_attiny1607
#define vtab_attiny1604      vtab_attiny1607
#define vtab_attiny807       vtab_attiny1607
#define vtab_attiny806       vtab_attiny1607
#define vtab_attiny804       vtab_attiny1607

extern const char * const    vtab_attiny1614[31];

extern const char * const    vtab_attiny3214[31];

extern const char * const    vtab_attiny3217[31];
#define vtab_attiny3216      vtab_attiny3217
#define vtab_attiny1617      vtab_attiny3217
#define vtab_attiny1616      vtab_attiny3217

extern const char * const    vtab_attiny3227[30];
#define vtab_attiny3226      vtab_attiny3227
#define vtab_attiny3224      vtab_attiny3227
#define vtab_attiny1627      vtab_attiny3227
#define vtab_attiny1626      vtab_attiny3227
#define vtab_attiny1624      vtab_attiny3227
#define vtab_attiny827       vtab_attiny3227
#define vtab_attiny826       vtab_attiny3227
#define vtab_attiny824       vtab_attiny3227
#define vtab_attiny427       vtab_attiny3227
#define vtab_attiny426       vtab_attiny3227
#define vtab_attiny424       vtab_attiny3227

extern const char * const    vtab_atmega4808[36];
#define vtab_atmega3208      vtab_atmega4808
#define vtab_atmega1608      vtab_atmega4808
#define vtab_atmega808       vtab_atmega4808

extern const char * const    vtab_atmega4809[40];
#define vtab_atmega3209      vtab_atmega4809
#define vtab_atmega1609      vtab_atmega4809
#define vtab_atmega809       vtab_atmega4809

extern const char * const    vtab_avr64dd32[36];
#define vtab_avr64dd28       vtab_avr64dd32
#define vtab_avr64dd20       vtab_avr64dd32
#define vtab_avr64dd14       vtab_avr64dd32
#define vtab_avr32dd32       vtab_avr64dd32
#define vtab_avr32dd28       vtab_avr64dd32
#define vtab_avr32dd20       vtab_avr64dd32
#define vtab_avr32dd14       vtab_avr64dd32
#define vtab_avr16dd32       vtab_avr64dd32
#define vtab_avr16dd28       vtab_avr64dd32
#define vtab_avr16dd20       vtab_avr64dd32
#define vtab_avr16dd14       vtab_avr64dd32

extern const char * const    vtab_avr64ea32[37];
#define vtab_avr64ea28       vtab_avr64ea32
#define vtab_avr32ea32       vtab_avr64ea32
#define vtab_avr32ea28       vtab_avr64ea32
#define vtab_avr16ea32       vtab_avr64ea32
#define vtab_avr16ea28       vtab_avr64ea32

extern const char * const    vtab_avr64ea48[45];
#define vtab_avr32ea48       vtab_avr64ea48
#define vtab_avr16ea48       vtab_avr64ea48

extern const char * const    vtab_avr128da28[41];
#define vtab_avr64da28       vtab_avr128da28
#define vtab_avr32da28       vtab_avr128da28

extern const char * const    vtab_avr128db28[42];
#define vtab_avr64db28       vtab_avr128db28
#define vtab_avr32db28       vtab_avr128db28

extern const char * const    vtab_avr128da32[44];
#define vtab_avr64da32       vtab_avr128da32
#define vtab_avr32da32       vtab_avr128da32

extern const char * const    vtab_avr128db32[44];
#define vtab_avr64db32       vtab_avr128db32
#define vtab_avr32db32       vtab_avr128db32

extern const char * const    vtab_avr128da48[58];
#define vtab_avr64da48       vtab_avr128da48
#define vtab_avr32da48       vtab_avr128da48

extern const char * const    vtab_avr128db48[61];
#define vtab_avr64db48       vtab_avr128db48
#define vtab_avr32db48       vtab_avr128db48

extern const char * const    vtab_avr128da64[64];
#define vtab_avr64da64       vtab_avr128da64

extern const char * const    vtab_avr128db64[65];
#define vtab_avr64db64       vtab_avr128db64

// Configuration table names

extern const Configitem_t    cfgtab_atmega328[14];
#define cfgtab_atmega328p    cfgtab_atmega328
#define cfgtab_ata6614q      cfgtab_atmega328

extern const Configitem_t    cfgtab_atmega16m1[17];

extern const Configitem_t    cfgtab_atmega16hva2[9];

extern const Configitem_t    cfgtab_atmega32hvbrevb[12];

extern const Configitem_t    cfgtab_atmega64hve[13];

extern const Configitem_t    cfgtab_atmega328pb[15];

extern const Configitem_t    cfgtab_atmega8515[13];

extern const Configitem_t    cfgtab_attiny102[5];
#define cfgtab_attiny104     cfgtab_attiny102

extern const Configitem_t    cfgtab_attiny28[3];

extern const Configitem_t    cfgtab_attiny441[14];
#define cfgtab_attiny841     cfgtab_attiny441

extern const Configitem_t    cfgtab_at90pwm2[18];
#define cfgtab_at90pwm3      cfgtab_at90pwm2

extern const Configitem_t    cfgtab_at90pwm81[19];
#define cfgtab_at90pwm161    cfgtab_at90pwm81

extern const Configitem_t    cfgtab_at90can128[15];

extern const Configitem_t    cfgtab_at90usb162[15];
#define cfgtab_atmega16u2    cfgtab_at90usb162
#define cfgtab_at90usb82     cfgtab_at90usb162

extern const Configitem_t    cfgtab_at90s1200[3];

extern const Configitem_t    cfgtab_at90s2313[3];
#define cfgtab_at90s4414     cfgtab_at90s2313
#define cfgtab_at90s4434     cfgtab_at90s2313
#define cfgtab_at90s8515     cfgtab_at90s2313
#define cfgtab_at90s8535     cfgtab_at90s2313

extern const Configitem_t    cfgtab_ata5700m322[9];
#define cfgtab_ata5702m322   cfgtab_ata5700m322

extern const Configitem_t    cfgtab_ata5781[11];
#define cfgtab_ata5782       cfgtab_ata5781
#define cfgtab_ata5783       cfgtab_ata5781
#define cfgtab_ata5831       cfgtab_ata5781
#define cfgtab_ata5832       cfgtab_ata5781
#define cfgtab_ata5833       cfgtab_ata5781
#define cfgtab_ata8210       cfgtab_ata5781
#define cfgtab_ata8215       cfgtab_ata5781
#define cfgtab_ata8510       cfgtab_ata5781
#define cfgtab_ata8515       cfgtab_ata5781

extern const Configitem_t    cfgtab_ata5790[11];
#define cfgtab_ata5791       cfgtab_ata5790

extern const Configitem_t    cfgtab_ata6285[17];
#define cfgtab_ata6286       cfgtab_ata6285

extern const Configitem_t    cfgtab_atxmega16e5[17];
#define cfgtab_atxmega8e5    cfgtab_atxmega16e5
#define cfgtab_atxmega32e5   cfgtab_atxmega16e5

extern const Configitem_t    cfgtab_atxmega128a3[16];
#define cfgtab_atxmega64a1   cfgtab_atxmega128a3
#define cfgtab_atxmega64a3   cfgtab_atxmega128a3
#define cfgtab_atxmega128a1  cfgtab_atxmega128a3
#define cfgtab_atxmega128a1revd cfgtab_atxmega128a3
#define cfgtab_atxmega192a3  cfgtab_atxmega128a3
#define cfgtab_atxmega256a3  cfgtab_atxmega128a3
#define cfgtab_atxmega256a3b cfgtab_atxmega128a3

extern const Configitem_t    cfgtab_atxmega128a3u[17];
#define cfgtab_atxmega16a4u  cfgtab_atxmega128a3u
#define cfgtab_atxmega32a4u  cfgtab_atxmega128a3u
#define cfgtab_atxmega64a1u  cfgtab_atxmega128a3u
#define cfgtab_atxmega64a3u  cfgtab_atxmega128a3u
#define cfgtab_atxmega64a4u  cfgtab_atxmega128a3u
#define cfgtab_atxmega128a1u cfgtab_atxmega128a3u
#define cfgtab_atxmega128a4u cfgtab_atxmega128a3u
#define cfgtab_atxmega192a3u cfgtab_atxmega128a3u
#define cfgtab_atxmega256a3bu cfgtab_atxmega128a3u
#define cfgtab_atxmega256a3u cfgtab_atxmega128a3u

extern const Configitem_t    cfgtab_attiny204[23];
#define cfgtab_attiny202     cfgtab_attiny204
#define cfgtab_attiny212     cfgtab_attiny204
#define cfgtab_attiny214     cfgtab_attiny204
#define cfgtab_attiny402     cfgtab_attiny204
#define cfgtab_attiny404     cfgtab_attiny204
#define cfgtab_attiny406     cfgtab_attiny204
#define cfgtab_attiny412     cfgtab_attiny204
#define cfgtab_attiny414     cfgtab_attiny204
#define cfgtab_attiny416     cfgtab_attiny204
#define cfgtab_attiny417     cfgtab_attiny204
#define cfgtab_attiny814     cfgtab_attiny204
#define cfgtab_attiny816     cfgtab_attiny204
#define cfgtab_attiny817     cfgtab_attiny204
#define cfgtab_attiny1614    cfgtab_attiny204
#define cfgtab_attiny1616    cfgtab_attiny204
#define cfgtab_attiny1617    cfgtab_attiny204
#define cfgtab_attiny3216    cfgtab_attiny204
#define cfgtab_attiny3217    cfgtab_attiny204

extern const Configitem_t    cfgtab_attiny1624[16];
#define cfgtab_attiny424     cfgtab_attiny1624
#define cfgtab_attiny426     cfgtab_attiny1624
#define cfgtab_attiny427     cfgtab_attiny1624
#define cfgtab_attiny824     cfgtab_attiny1624
#define cfgtab_attiny826     cfgtab_attiny1624
#define cfgtab_attiny827     cfgtab_attiny1624
#define cfgtab_attiny1626    cfgtab_attiny1624
#define cfgtab_attiny1627    cfgtab_attiny1624
#define cfgtab_attiny3224    cfgtab_attiny1624
#define cfgtab_attiny3226    cfgtab_attiny1624
#define cfgtab_attiny3227    cfgtab_attiny1624

extern const Configitem_t    cfgtab_avr32dd14[17];
#define cfgtab_avr16dd14     cfgtab_avr32dd14
#define cfgtab_avr16dd20     cfgtab_avr32dd14
#define cfgtab_avr16dd28     cfgtab_avr32dd14
#define cfgtab_avr16dd32     cfgtab_avr32dd14
#define cfgtab_avr32dd20     cfgtab_avr32dd14
#define cfgtab_avr32dd28     cfgtab_avr32dd14
#define cfgtab_avr32dd32     cfgtab_avr32dd14
#define cfgtab_avr64dd14     cfgtab_avr32dd14
#define cfgtab_avr64dd20     cfgtab_avr32dd14
#define cfgtab_avr64dd28     cfgtab_avr32dd14
#define cfgtab_avr64dd32     cfgtab_avr32dd14

extern const Configitem_t    cfgtab_avr64ea48[16];
#define cfgtab_avr16ea28     cfgtab_avr64ea48
#define cfgtab_avr16ea32     cfgtab_avr64ea48
#define cfgtab_avr16ea48     cfgtab_avr64ea48
#define cfgtab_avr32ea28     cfgtab_avr64ea48
#define cfgtab_avr32ea32     cfgtab_avr64ea48
#define cfgtab_avr32ea48     cfgtab_avr64ea48
#define cfgtab_avr64ea28     cfgtab_avr64ea48
#define cfgtab_avr64ea32     cfgtab_avr64ea48

extern const Configitem_t    cfgtab_atmega103comp[15];

extern const Configitem_t    cfgtab_at90scr100h[13];
#define cfgtab_at90scr100    cfgtab_at90scr100h

extern const Configitem_t    cfgtab_atmega161comp[15];

extern const Configitem_t    cfgtab_at90s8535comp[13];

extern const Configitem_t    cfgtab_attiny4[4];
#define cfgtab_attiny5       cfgtab_attiny4
#define cfgtab_attiny9       cfgtab_attiny4
#define cfgtab_attiny10      cfgtab_attiny4

extern const Configitem_t    cfgtab_attiny20[5];
#define cfgtab_attiny40      cfgtab_attiny20

extern const Configitem_t    cfgtab_attiny11[4];

extern const Configitem_t    cfgtab_attiny12[6];

extern const Configitem_t    cfgtab_attiny13[10];
#define cfgtab_attiny13a     cfgtab_attiny13

extern const Configitem_t    cfgtab_attiny15[6];

extern const Configitem_t    cfgtab_attiny22[3];

extern const Configitem_t    cfgtab_attiny24[11];
#define cfgtab_attiny24a     cfgtab_attiny24
#define cfgtab_attiny44      cfgtab_attiny24
#define cfgtab_attiny44a     cfgtab_attiny24
#define cfgtab_attiny84      cfgtab_attiny24
#define cfgtab_attiny84a     cfgtab_attiny24

extern const Configitem_t    cfgtab_attiny25[11];
#define cfgtab_attiny45      cfgtab_attiny25
#define cfgtab_attiny85      cfgtab_attiny25

extern const Configitem_t    cfgtab_attiny26[8];

extern const Configitem_t    cfgtab_attiny43u[11];
#define cfgtab_attiny261     cfgtab_attiny43u
#define cfgtab_attiny261a    cfgtab_attiny43u
#define cfgtab_attiny461     cfgtab_attiny43u
#define cfgtab_attiny461a    cfgtab_attiny43u
#define cfgtab_attiny861     cfgtab_attiny43u
#define cfgtab_attiny861a    cfgtab_attiny43u

extern const Configitem_t    cfgtab_attiny48[11];
#define cfgtab_attiny88      cfgtab_attiny48

extern const Configitem_t    cfgtab_attiny87[11];
#define cfgtab_attiny167     cfgtab_attiny87
#define cfgtab_ata5272       cfgtab_attiny87
#define cfgtab_ata5505       cfgtab_attiny87
#define cfgtab_ata6616c      cfgtab_attiny87
#define cfgtab_ata6617c      cfgtab_attiny87
#define cfgtab_ata664251     cfgtab_attiny87

extern const Configitem_t    cfgtab_attiny828[16];
#define cfgtab_attiny828r    cfgtab_attiny828

extern const Configitem_t    cfgtab_attiny1634[13];
#define cfgtab_attiny1634r   cfgtab_attiny1634

extern const Configitem_t    cfgtab_attiny2313[11];

extern const Configitem_t    cfgtab_attiny2313a[11];
#define cfgtab_attiny4313    cfgtab_attiny2313a

extern const Configitem_t    cfgtab_atmega8[13];
#define cfgtab_atmega8a      cfgtab_atmega8

extern const Configitem_t    cfgtab_atmega8hva[7];
#define cfgtab_atmega16hva   cfgtab_atmega8hva

extern const Configitem_t    cfgtab_atmega8u2[15];

extern const Configitem_t    cfgtab_atmega16[13];
#define cfgtab_atmega16a     cfgtab_atmega16

extern const Configitem_t    cfgtab_atmega16hvb[12];

extern const Configitem_t    cfgtab_atmega16hvbrevb[12];

extern const Configitem_t    cfgtab_atmega16u4[15];

extern const Configitem_t    cfgtab_atmega32[13];
#define cfgtab_atmega32a     cfgtab_atmega32

extern const Configitem_t    cfgtab_atmega32hvb[12];

extern const Configitem_t    cfgtab_atmega32c1[17];
#define cfgtab_atmega32m1    cfgtab_atmega32c1

extern const Configitem_t    cfgtab_atmega32u2[15];

extern const Configitem_t    cfgtab_atmega32u4[15];

extern const Configitem_t    cfgtab_atmega32u6[15];

extern const Configitem_t    cfgtab_atmega48[11];
#define cfgtab_atmega48a     cfgtab_atmega48
#define cfgtab_atmega48p     cfgtab_atmega48
#define cfgtab_atmega48pa    cfgtab_atmega48

extern const Configitem_t    cfgtab_atmega48pb[11];

extern const Configitem_t    cfgtab_atmega64[15];
#define cfgtab_atmega64a     cfgtab_atmega64

extern const Configitem_t    cfgtab_atmega64c1[17];
#define cfgtab_atmega64m1    cfgtab_atmega64c1

extern const Configitem_t    cfgtab_atmega64hve2[13];
#define cfgtab_atmega32hve2  cfgtab_atmega64hve2

extern const Configitem_t    cfgtab_atmega64rfr2[14];
#define cfgtab_atmega644rfr2 cfgtab_atmega64rfr2

extern const Configitem_t    cfgtab_atmega88[14];
#define cfgtab_atmega88a     cfgtab_atmega88
#define cfgtab_atmega88p     cfgtab_atmega88
#define cfgtab_atmega88pa    cfgtab_atmega88
#define cfgtab_ata6612c      cfgtab_atmega88

extern const Configitem_t    cfgtab_atmega88pb[14];

extern const Configitem_t    cfgtab_atmega103[4];

extern const Configitem_t    cfgtab_atmega128[15];
#define cfgtab_atmega128a    cfgtab_atmega128

extern const Configitem_t    cfgtab_atmega128rfa1[14];

extern const Configitem_t    cfgtab_atmega128rfr2[14];
#define cfgtab_atmega1284rfr2 cfgtab_atmega128rfr2

extern const Configitem_t    cfgtab_atmega161[7];

extern const Configitem_t    cfgtab_atmega162[15];

extern const Configitem_t    cfgtab_atmega163[9];

extern const Configitem_t    cfgtab_atmega164a[14];
#define cfgtab_atmega164p    cfgtab_atmega164a
#define cfgtab_atmega164pa   cfgtab_atmega164a

extern const Configitem_t    cfgtab_atmega165[15];
#define cfgtab_atmega165a    cfgtab_atmega165
#define cfgtab_atmega165p    cfgtab_atmega165
#define cfgtab_atmega165pa   cfgtab_atmega165
#define cfgtab_atmega169     cfgtab_atmega165
#define cfgtab_atmega169a    cfgtab_atmega165
#define cfgtab_atmega169p    cfgtab_atmega165
#define cfgtab_atmega169pa   cfgtab_atmega165

extern const Configitem_t    cfgtab_atmega168[14];
#define cfgtab_atmega168a    cfgtab_atmega168
#define cfgtab_atmega168p    cfgtab_atmega168
#define cfgtab_atmega168pa   cfgtab_atmega168
#define cfgtab_ata6613c      cfgtab_atmega168

extern const Configitem_t    cfgtab_atmega168pb[14];

extern const Configitem_t    cfgtab_atmega256rfr2[14];
#define cfgtab_atmega2564rfr2 cfgtab_atmega256rfr2

extern const Configitem_t    cfgtab_atmega323[12];

extern const Configitem_t    cfgtab_atmega324a[14];
#define cfgtab_atmega324p    cfgtab_atmega324a
#define cfgtab_atmega324pa   cfgtab_atmega324a

extern const Configitem_t    cfgtab_atmega324pb[15];

extern const Configitem_t    cfgtab_atmega325[15];
#define cfgtab_atmega325a    cfgtab_atmega325
#define cfgtab_atmega325p    cfgtab_atmega325
#define cfgtab_atmega325pa   cfgtab_atmega325
#define cfgtab_atmega329     cfgtab_atmega325
#define cfgtab_atmega329a    cfgtab_atmega325
#define cfgtab_atmega329p    cfgtab_atmega325
#define cfgtab_atmega329pa   cfgtab_atmega325
#define cfgtab_atmega3250    cfgtab_atmega325
#define cfgtab_atmega3250a   cfgtab_atmega325
#define cfgtab_atmega3250p   cfgtab_atmega325
#define cfgtab_atmega3250pa  cfgtab_atmega325
#define cfgtab_atmega3290    cfgtab_atmega325
#define cfgtab_atmega3290a   cfgtab_atmega325
#define cfgtab_atmega3290p   cfgtab_atmega325
#define cfgtab_atmega3290pa  cfgtab_atmega325

extern const Configitem_t    cfgtab_atmega406[10];

extern const Configitem_t    cfgtab_atmega640[14];

extern const Configitem_t    cfgtab_atmega644[14];
#define cfgtab_atmega644a    cfgtab_atmega644
#define cfgtab_atmega644p    cfgtab_atmega644
#define cfgtab_atmega644pa   cfgtab_atmega644

extern const Configitem_t    cfgtab_atmega645[15];
#define cfgtab_atmega645a    cfgtab_atmega645
#define cfgtab_atmega645p    cfgtab_atmega645
#define cfgtab_atmega649     cfgtab_atmega645
#define cfgtab_atmega649a    cfgtab_atmega645
#define cfgtab_atmega649p    cfgtab_atmega645
#define cfgtab_atmega6450    cfgtab_atmega645
#define cfgtab_atmega6450a   cfgtab_atmega645
#define cfgtab_atmega6450p   cfgtab_atmega645
#define cfgtab_atmega6490    cfgtab_atmega645
#define cfgtab_atmega6490a   cfgtab_atmega645
#define cfgtab_atmega6490p   cfgtab_atmega645

extern const Configitem_t    cfgtab_atmega1280[14];
#define cfgtab_atmega1281    cfgtab_atmega1280

extern const Configitem_t    cfgtab_atmega1284[14];
#define cfgtab_atmega1284p   cfgtab_atmega1284

extern const Configitem_t    cfgtab_atmega2560[14];
#define cfgtab_atmega2561    cfgtab_atmega2560

extern const Configitem_t    cfgtab_atmega8535[13];

extern const Configitem_t    cfgtab_at90pwm1[17];

extern const Configitem_t    cfgtab_at90pwm2b[18];
#define cfgtab_at90pwm3b     cfgtab_at90pwm2b

extern const Configitem_t    cfgtab_at90can32[15];

extern const Configitem_t    cfgtab_at90can64[15];

extern const Configitem_t    cfgtab_at90pwm216[18];

extern const Configitem_t    cfgtab_at90pwm316[18];

extern const Configitem_t    cfgtab_at90usb646[15];
#define cfgtab_at90usb647    cfgtab_at90usb646

extern const Configitem_t    cfgtab_at90usb1286[15];
#define cfgtab_at90usb1287   cfgtab_at90usb1286

extern const Configitem_t    cfgtab_at90s2323[3];

extern const Configitem_t    cfgtab_at90s2333[5];

extern const Configitem_t    cfgtab_at90s2343[3];

extern const Configitem_t    cfgtab_at90s4433[5];

extern const Configitem_t    cfgtab_at90s8515comp[13];

extern const Configitem_t    cfgtab_ata5787[11];
#define cfgtab_ata5835       cfgtab_ata5787

extern const Configitem_t    cfgtab_ata5790n[10];
#define cfgtab_ata5795       cfgtab_ata5790n

extern const Configitem_t    cfgtab_ata6289[17];

extern const Configitem_t    cfgtab_atxmega16a4[16];
#define cfgtab_atxmega32a4   cfgtab_atxmega16a4

extern const Configitem_t    cfgtab_atxmega16c4[15];
#define cfgtab_atxmega16d4   cfgtab_atxmega16c4
#define cfgtab_atxmega32c3   cfgtab_atxmega16c4
#define cfgtab_atxmega32d3   cfgtab_atxmega16c4
#define cfgtab_atxmega32c4   cfgtab_atxmega16c4
#define cfgtab_atxmega32d4   cfgtab_atxmega16c4
#define cfgtab_atxmega64c3   cfgtab_atxmega16c4
#define cfgtab_atxmega64d3   cfgtab_atxmega16c4
#define cfgtab_atxmega64d4   cfgtab_atxmega16c4
#define cfgtab_atxmega128c3  cfgtab_atxmega16c4
#define cfgtab_atxmega128d3  cfgtab_atxmega16c4
#define cfgtab_atxmega128d4  cfgtab_atxmega16c4
#define cfgtab_atxmega192c3  cfgtab_atxmega16c4
#define cfgtab_atxmega192d3  cfgtab_atxmega16c4
#define cfgtab_atxmega256c3  cfgtab_atxmega16c4
#define cfgtab_atxmega256d3  cfgtab_atxmega16c4
#define cfgtab_atxmega384c3  cfgtab_atxmega16c4
#define cfgtab_atxmega384d3  cfgtab_atxmega16c4

extern const Configitem_t    cfgtab_atxmega64b1[17];
#define cfgtab_atxmega64b3   cfgtab_atxmega64b1
#define cfgtab_atxmega128b1  cfgtab_atxmega64b1
#define cfgtab_atxmega128b3  cfgtab_atxmega64b1

extern const Configitem_t    cfgtab_attiny416auto[23];

extern const Configitem_t    cfgtab_attiny804[15];
#define cfgtab_attiny806     cfgtab_attiny804
#define cfgtab_attiny807     cfgtab_attiny804
#define cfgtab_attiny1604    cfgtab_attiny804
#define cfgtab_attiny1606    cfgtab_attiny804
#define cfgtab_attiny1607    cfgtab_attiny804

extern const Configitem_t    cfgtab_atmega808[15];
#define cfgtab_atmega809     cfgtab_atmega808
#define cfgtab_atmega1608    cfgtab_atmega808
#define cfgtab_atmega1609    cfgtab_atmega808
#define cfgtab_atmega3208    cfgtab_atmega808
#define cfgtab_atmega3209    cfgtab_atmega808
#define cfgtab_atmega4808    cfgtab_atmega808
#define cfgtab_atmega4809    cfgtab_atmega808

extern const Configitem_t    cfgtab_avr32da28[15];
#define cfgtab_avr32da32     cfgtab_avr32da28
#define cfgtab_avr32da48     cfgtab_avr32da28
#define cfgtab_avr64da28     cfgtab_avr32da28
#define cfgtab_avr64da32     cfgtab_avr32da28
#define cfgtab_avr64da48     cfgtab_avr32da28
#define cfgtab_avr64da64     cfgtab_avr32da28
#define cfgtab_avr128da28    cfgtab_avr32da28
#define cfgtab_avr128da32    cfgtab_avr32da28
#define cfgtab_avr128da48    cfgtab_avr32da28
#define cfgtab_avr128da64    cfgtab_avr32da28

extern const Configitem_t    cfgtab_avr32db28[16];
#define cfgtab_avr32db32     cfgtab_avr32db28
#define cfgtab_avr32db48     cfgtab_avr32db28
#define cfgtab_avr64db28     cfgtab_avr32db28
#define cfgtab_avr64db32     cfgtab_avr32db28
#define cfgtab_avr64db48     cfgtab_avr32db28
#define cfgtab_avr64db64     cfgtab_avr32db28
#define cfgtab_avr128db28    cfgtab_avr32db28
#define cfgtab_avr128db32    cfgtab_avr32db28
#define cfgtab_avr128db48    cfgtab_avr32db28
#define cfgtab_avr128db64    cfgtab_avr32db28

int upidxmcuid(int mcuid);
int upidxsig(const uint8_t *sigs);
int upidxname(const char *name);
int upmatchingsig(uint8_t sigs[3], char *p, size_t n);

#endif
