/* automatically generated by rust-bindgen 0.57.0 */

pub type __int32_t = ::libc::c_int;
pub type __uint32_t = ::libc::c_uint;
pub type __uint64_t = ::libc::c_ulong;
pub type va_list = __builtin_va_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct udev {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct udev_device {
    _unused: [u8; 0],
}
#[doc = " @ingroup base"]
#[doc = " @struct libinput"]
#[doc = ""]
#[doc = " A handle for accessing libinput. This struct is refcounted, use"]
#[doc = " libinput_ref() and libinput_unref()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput {
    _unused: [u8; 0],
}
#[doc = " @ingroup device"]
#[doc = " @struct libinput_device"]
#[doc = ""]
#[doc = " A base handle for accessing libinput devices. This struct is"]
#[doc = " refcounted, use libinput_device_ref() and libinput_device_unref()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_device {
    _unused: [u8; 0],
}
#[doc = " @ingroup device"]
#[doc = " @struct libinput_device_group"]
#[doc = ""]
#[doc = " A base handle for accessing libinput device groups. This struct is"]
#[doc = " refcounted, use libinput_device_group_ref() and"]
#[doc = " libinput_device_group_unref()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_device_group {
    _unused: [u8; 0],
}
#[doc = " @ingroup seat"]
#[doc = " @struct libinput_seat"]
#[doc = ""]
#[doc = " The base handle for accessing libinput seats. This struct is"]
#[doc = " refcounted, use libinput_seat_ref() and libinput_seat_unref()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_seat {
    _unused: [u8; 0],
}
#[doc = " @ingroup device"]
#[doc = " @struct libinput_tablet_tool"]
#[doc = ""]
#[doc = " An object representing a tool being used by a device with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_TOOL capability."]
#[doc = ""]
#[doc = " Tablet events generated by such a device are bound to a specific tool"]
#[doc = " rather than coming from the device directly. Depending on the hardware it"]
#[doc = " is possible to track the same physical tool across multiple"]
#[doc = " struct libinput_device devices."]
#[doc = " See libinput_tablet_tool_get_serial() for more details."]
#[doc = ""]
#[doc = " This struct is refcounted, use libinput_tablet_tool_ref() and"]
#[doc = " libinput_tablet_tool_unref()."]
#[doc = ""]
#[doc = " @since 1.2"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_tablet_tool {
    _unused: [u8; 0],
}
#[doc = " @ingroup event"]
#[doc = " @struct libinput_event"]
#[doc = ""]
#[doc = " The base event type. Use libinput_event_get_pointer_event() or similar to"]
#[doc = " get the actual event type."]
#[doc = ""]
#[doc = " @warning Unlike other structs events are considered transient and"]
#[doc = " <b>not</b> refcounted."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event {
    _unused: [u8; 0],
}
#[doc = " @ingroup event"]
#[doc = " @struct libinput_event_device_notify"]
#[doc = ""]
#[doc = " An event notifying the caller of a device being added or removed."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_device_notify {
    _unused: [u8; 0],
}
#[doc = " @ingroup event_keyboard"]
#[doc = " @struct libinput_event_keyboard"]
#[doc = ""]
#[doc = " A keyboard event representing a key press/release."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_keyboard {
    _unused: [u8; 0],
}
#[doc = " @ingroup event_pointer"]
#[doc = " @struct libinput_event_pointer"]
#[doc = ""]
#[doc = " A pointer event representing relative or absolute pointer movement,"]
#[doc = " a button press/release or scroll axis events."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_pointer {
    _unused: [u8; 0],
}
#[doc = " @ingroup event_touch"]
#[doc = " @struct libinput_event_touch"]
#[doc = ""]
#[doc = " Touch event representing a touch down, move or up, as well as a touch"]
#[doc = " cancel and touch frame events. Valid event types for this event are @ref"]
#[doc = " LIBINPUT_EVENT_TOUCH_DOWN, @ref LIBINPUT_EVENT_TOUCH_MOTION, @ref"]
#[doc = " LIBINPUT_EVENT_TOUCH_UP, @ref LIBINPUT_EVENT_TOUCH_CANCEL and @ref"]
#[doc = " LIBINPUT_EVENT_TOUCH_FRAME."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_touch {
    _unused: [u8; 0],
}
#[doc = " @ingroup event_tablet"]
#[doc = " @struct libinput_event_tablet_tool"]
#[doc = ""]
#[doc = " Tablet tool event representing an axis update, button press, or tool"]
#[doc = " update. Valid event types for this event are @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY and @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
#[doc = ""]
#[doc = " @since 1.2"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_tablet_tool {
    _unused: [u8; 0],
}
#[doc = " @ingroup event_tablet_pad"]
#[doc = " @struct libinput_event_tablet_pad"]
#[doc = ""]
#[doc = " Tablet pad event representing a button press, or ring/strip update on"]
#[doc = " the tablet pad itself. Valid event types for this event are @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_PAD_BUTTON, @ref LIBINPUT_EVENT_TABLET_PAD_RING and"]
#[doc = " @ref LIBINPUT_EVENT_TABLET_PAD_STRIP."]
#[doc = ""]
#[doc = " @since 1.3"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_tablet_pad {
    _unused: [u8; 0],
}
pub const libinput_log_priority_LIBINPUT_LOG_PRIORITY_DEBUG: libinput_log_priority = 10;
pub const libinput_log_priority_LIBINPUT_LOG_PRIORITY_INFO: libinput_log_priority = 20;
pub const libinput_log_priority_LIBINPUT_LOG_PRIORITY_ERROR: libinput_log_priority = 30;
#[doc = " @ingroup base"]
#[doc = ""]
#[doc = " Log priority for internal logging messages."]
pub type libinput_log_priority = ::libc::c_uint;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_KEYBOARD: libinput_device_capability = 0;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_POINTER: libinput_device_capability = 1;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_TOUCH: libinput_device_capability = 2;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_TABLET_TOOL: libinput_device_capability =
    3;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_TABLET_PAD: libinput_device_capability = 4;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_GESTURE: libinput_device_capability = 5;
pub const libinput_device_capability_LIBINPUT_DEVICE_CAP_SWITCH: libinput_device_capability = 6;
#[doc = " @ingroup device"]
#[doc = ""]
#[doc = " Capabilities on a device. A device may have one or more capabilities"]
#[doc = " at a time, capabilities remain static for the lifetime of the device."]
pub type libinput_device_capability = ::libc::c_uint;
pub const libinput_key_state_LIBINPUT_KEY_STATE_RELEASED: libinput_key_state = 0;
pub const libinput_key_state_LIBINPUT_KEY_STATE_PRESSED: libinput_key_state = 1;
#[doc = " @ingroup device"]
#[doc = ""]
#[doc = " Logical state of a key. Note that the logical state may not represent"]
#[doc = " the physical state of the key."]
pub type libinput_key_state = ::libc::c_uint;
pub const libinput_led_LIBINPUT_LED_NUM_LOCK: libinput_led = 1;
pub const libinput_led_LIBINPUT_LED_CAPS_LOCK: libinput_led = 2;
pub const libinput_led_LIBINPUT_LED_SCROLL_LOCK: libinput_led = 4;
#[doc = " @ingroup device"]
#[doc = ""]
#[doc = " Mask reflecting LEDs on a device."]
pub type libinput_led = ::libc::c_uint;
pub const libinput_button_state_LIBINPUT_BUTTON_STATE_RELEASED: libinput_button_state = 0;
pub const libinput_button_state_LIBINPUT_BUTTON_STATE_PRESSED: libinput_button_state = 1;
#[doc = " @ingroup device"]
#[doc = ""]
#[doc = " Logical state of a physical button. Note that the logical state may not"]
#[doc = " represent the physical state of the button."]
pub type libinput_button_state = ::libc::c_uint;
pub const libinput_pointer_axis_LIBINPUT_POINTER_AXIS_SCROLL_VERTICAL: libinput_pointer_axis = 0;
pub const libinput_pointer_axis_LIBINPUT_POINTER_AXIS_SCROLL_HORIZONTAL: libinput_pointer_axis = 1;
#[doc = " @ingroup device"]
#[doc = ""]
#[doc = " Axes on a device with the capability @ref LIBINPUT_DEVICE_CAP_POINTER"]
#[doc = " that are not x or y coordinates."]
#[doc = ""]
#[doc = " The two scroll axes @ref LIBINPUT_POINTER_AXIS_SCROLL_VERTICAL and"]
#[doc = " @ref LIBINPUT_POINTER_AXIS_SCROLL_HORIZONTAL are engaged separately,"]
#[doc = " depending on the device. libinput provides some scroll direction locking"]
#[doc = " but it is up to the caller to determine which axis is needed and"]
#[doc = " appropriate in the current interaction"]
pub type libinput_pointer_axis = ::libc::c_uint;
#[doc = " The event is caused by the rotation of a wheel."]
pub const libinput_pointer_axis_source_LIBINPUT_POINTER_AXIS_SOURCE_WHEEL:
    libinput_pointer_axis_source = 1;
#[doc = " The event is caused by the movement of one or more fingers on a"]
#[doc = " device."]
pub const libinput_pointer_axis_source_LIBINPUT_POINTER_AXIS_SOURCE_FINGER:
    libinput_pointer_axis_source = 2;
#[doc = " The event is caused by the motion of some device."]
pub const libinput_pointer_axis_source_LIBINPUT_POINTER_AXIS_SOURCE_CONTINUOUS:
    libinput_pointer_axis_source = 3;
#[doc = " The event is caused by the tilting of a mouse wheel rather than"]
#[doc = " its rotation. This method is commonly used on mice without"]
#[doc = " separate horizontal scroll wheels."]
pub const libinput_pointer_axis_source_LIBINPUT_POINTER_AXIS_SOURCE_WHEEL_TILT:
    libinput_pointer_axis_source = 4;
#[doc = " @ingroup device"]
#[doc = ""]
#[doc = " The source for a libinput_pointer_axis event. See"]
#[doc = " libinput_event_pointer_get_axis_source() for details."]
pub type libinput_pointer_axis_source = ::libc::c_uint;
pub const libinput_tablet_pad_ring_axis_source_LIBINPUT_TABLET_PAD_RING_SOURCE_UNKNOWN:
    libinput_tablet_pad_ring_axis_source = 1;
#[doc = " The event is caused by the movement of one or more fingers on"]
#[doc = " the ring."]
pub const libinput_tablet_pad_ring_axis_source_LIBINPUT_TABLET_PAD_RING_SOURCE_FINGER:
    libinput_tablet_pad_ring_axis_source = 2;
#[doc = " @ingroup event_tablet_pad"]
#[doc = ""]
#[doc = " The source for a @ref LIBINPUT_EVENT_TABLET_PAD_RING event. See"]
#[doc = " libinput_event_tablet_pad_get_ring_source() for details."]
#[doc = ""]
#[doc = " @since 1.3"]
pub type libinput_tablet_pad_ring_axis_source = ::libc::c_uint;
pub const libinput_tablet_pad_strip_axis_source_LIBINPUT_TABLET_PAD_STRIP_SOURCE_UNKNOWN:
    libinput_tablet_pad_strip_axis_source = 1;
#[doc = " The event is caused by the movement of one or more fingers on"]
#[doc = " the strip."]
pub const libinput_tablet_pad_strip_axis_source_LIBINPUT_TABLET_PAD_STRIP_SOURCE_FINGER:
    libinput_tablet_pad_strip_axis_source = 2;
#[doc = " @ingroup event_tablet_pad"]
#[doc = ""]
#[doc = " The source for a @ref LIBINPUT_EVENT_TABLET_PAD_STRIP event. See"]
#[doc = " libinput_event_tablet_pad_get_strip_source() for details."]
#[doc = ""]
#[doc = " @since 1.3"]
pub type libinput_tablet_pad_strip_axis_source = ::libc::c_uint;
#[doc = "< A generic pen"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_PEN: libinput_tablet_tool_type = 1;
#[doc = "< Eraser"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_ERASER: libinput_tablet_tool_type = 2;
#[doc = "< A paintbrush-like tool"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_BRUSH: libinput_tablet_tool_type = 3;
#[doc = "< Physical drawing tool, e.g."]
#[doc = "Wacom Inking Pen"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_PENCIL: libinput_tablet_tool_type = 4;
#[doc = "< An airbrush-like tool"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_AIRBRUSH: libinput_tablet_tool_type =
    5;
#[doc = "< A mouse bound to the tablet"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_MOUSE: libinput_tablet_tool_type = 6;
#[doc = "< A mouse tool with a lens"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_LENS: libinput_tablet_tool_type = 7;
#[doc = "< A rotary device with"]
#[doc = "positional and rotation"]
#[doc = "data"]
pub const libinput_tablet_tool_type_LIBINPUT_TABLET_TOOL_TYPE_TOTEM: libinput_tablet_tool_type = 8;
#[doc = " @ingroup device"]
#[doc = ""]
#[doc = " Available tool types for a device with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_TOOL capability. The tool type defines the default"]
#[doc = " usage of the tool as advertised by the manufacturer. Multiple different"]
#[doc = " physical tools may share the same tool type, e.g. a Wacom Classic Pen,"]
#[doc = " Wacom Pro Pen and a Wacom Grip Pen are all of type @ref"]
#[doc = " LIBINPUT_TABLET_TOOL_TYPE_PEN."]
#[doc = " Use libinput_tablet_tool_get_tool_id() to get a specific model where applicable."]
#[doc = ""]
#[doc = " Note that on some device, the eraser tool is on the tail end of a pen"]
#[doc = " device. On other devices, e.g. MS Surface 3, the eraser is the pen tip"]
#[doc = " while a button is held down."]
#[doc = ""]
#[doc = " @note The @ref libinput_tablet_tool_type can only describe the default physical"]
#[doc = " type of the device. For devices with adjustable physical properties"]
#[doc = " the tool type remains the same, i.e. putting a Wacom stroke nib into a"]
#[doc = " classic pen leaves the tool type as @ref LIBINPUT_TABLET_TOOL_TYPE_PEN."]
#[doc = ""]
#[doc = " @since 1.2"]
pub type libinput_tablet_tool_type = ::libc::c_uint;
pub const libinput_tablet_tool_proximity_state_LIBINPUT_TABLET_TOOL_PROXIMITY_STATE_OUT:
    libinput_tablet_tool_proximity_state = 0;
pub const libinput_tablet_tool_proximity_state_LIBINPUT_TABLET_TOOL_PROXIMITY_STATE_IN:
    libinput_tablet_tool_proximity_state = 1;
#[doc = " @ingroup device"]
#[doc = ""]
#[doc = " The state of proximity for a tool on a device. The device must have the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_TOOL capability."]
#[doc = ""]
#[doc = " The proximity of a tool is a binary state signalling whether the tool is"]
#[doc = " within a detectable distance of the tablet device. A tool that is out of"]
#[doc = " proximity cannot generate events."]
#[doc = ""]
#[doc = " On some hardware a tool goes out of proximity when it ceases to touch the"]
#[doc = " surface. On other hardware, the tool is still detectable within a short"]
#[doc = " distance (a few cm) off the surface."]
#[doc = ""]
#[doc = " @since 1.2"]
pub type libinput_tablet_tool_proximity_state = ::libc::c_uint;
pub const libinput_tablet_tool_tip_state_LIBINPUT_TABLET_TOOL_TIP_UP:
    libinput_tablet_tool_tip_state = 0;
pub const libinput_tablet_tool_tip_state_LIBINPUT_TABLET_TOOL_TIP_DOWN:
    libinput_tablet_tool_tip_state = 1;
#[doc = " @ingroup device"]
#[doc = ""]
#[doc = " The tip contact state for a tool on a device. The device must have"]
#[doc = " the @ref LIBINPUT_DEVICE_CAP_TABLET_TOOL capability."]
#[doc = ""]
#[doc = " The tip contact state of a tool is a binary state signalling whether the tool is"]
#[doc = " touching the surface of the tablet device."]
#[doc = ""]
#[doc = " @since 1.2"]
pub type libinput_tablet_tool_tip_state = ::libc::c_uint;
#[doc = " @ingroup tablet_pad_modes"]
#[doc = " @struct libinput_tablet_pad_mode_group"]
#[doc = ""]
#[doc = " A mode on a tablet pad is a virtual grouping of functionality, usually"]
#[doc = " based on some visual feedback like LEDs on the pad. The set of buttons,"]
#[doc = " rings and strips that share the same mode are a \"mode group\". Whenever"]
#[doc = " the mode changes, all buttons, rings and strips within this mode group"]
#[doc = " are affected."]
#[doc = ""]
#[doc = " Most tablets only have a single mode group, some tablets provide multiple"]
#[doc = " mode groups through independent banks of LEDs (e.g. the Wacom Cintiq"]
#[doc = " 24HD). libinput guarantees that at least one mode group is always"]
#[doc = " available."]
#[doc = ""]
#[doc = " This struct is refcounted, use libinput_tablet_pad_mode_group_ref() and"]
#[doc = " libinput_tablet_pad_mode_group_unref()."]
#[doc = ""]
#[doc = " @since 1.4"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_tablet_pad_mode_group {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " Most devices only provide a single mode group, however devices such as"]
    #[doc = " the Wacom Cintiq 22HD provide two mode groups. If multiple mode groups"]
    #[doc = " are available, a caller should use"]
    #[doc = " libinput_tablet_pad_mode_group_has_button(),"]
    #[doc = " libinput_tablet_pad_mode_group_has_ring() and"]
    #[doc = " libinput_tablet_pad_mode_group_has_strip() to associate each button,"]
    #[doc = " ring and strip with the correct mode group."]
    #[doc = ""]
    #[doc = " @return the number of mode groups available on this device"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_device_tablet_pad_get_num_mode_groups(
        device: *mut libinput_device,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " The returned mode group is not refcounted and may become invalid after"]
    #[doc = " the next call to libinput. Use libinput_tablet_pad_mode_group_ref() and"]
    #[doc = " libinput_tablet_pad_mode_group_unref() to continue using the handle"]
    #[doc = " outside of the immediate scope."]
    #[doc = ""]
    #[doc = " While at least one reference is kept by the caller, the returned mode"]
    #[doc = " group will be identical for each subsequent call of this function with"]
    #[doc = " the same index and that same struct is returned from"]
    #[doc = " libinput_event_tablet_pad_get_mode_group(), provided the event was"]
    #[doc = " generated by this mode group."]
    #[doc = ""]
    #[doc = " @param device A device with the @ref LIBINPUT_DEVICE_CAP_TABLET_PAD"]
    #[doc = " capability"]
    #[doc = " @param index A mode group index"]
    #[doc = " @return the mode group with the given index or NULL if an invalid index"]
    #[doc = " is given."]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_device_tablet_pad_get_mode_group(
        device: *mut libinput_device,
        index: ::libc::c_uint,
    ) -> *mut libinput_tablet_pad_mode_group;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " The returned number is the same index as passed to"]
    #[doc = " libinput_device_tablet_pad_get_mode_group(). For tablets with only one"]
    #[doc = " mode this number is always 0."]
    #[doc = ""]
    #[doc = " @param group A previously obtained mode group"]
    #[doc = " @return the numeric index this mode group represents, starting at 0"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_get_index(
        group: *mut libinput_tablet_pad_mode_group,
    ) -> ::libc::c_uint;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " Query the mode group for the number of available modes. The number of"]
    #[doc = " modes is usually decided by the number of physical LEDs available on the"]
    #[doc = " device. Different mode groups may have a different number of modes. Use"]
    #[doc = " libinput_tablet_pad_mode_group_get_mode() to get the currently active"]
    #[doc = " mode."]
    #[doc = ""]
    #[doc = " libinput guarantees that at least one mode is available. A device without"]
    #[doc = " mode switching capability has a single mode group and a single mode."]
    #[doc = ""]
    #[doc = " @param group A previously obtained mode group"]
    #[doc = " @return the number of modes available in this mode group"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_get_num_modes(
        group: *mut libinput_tablet_pad_mode_group,
    ) -> ::libc::c_uint;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " Return the current mode this mode group is in. Note that the returned"]
    #[doc = " mode is the mode valid as of completing the last libinput_dispatch()."]
    #[doc = " The returned mode may thus be different than the mode returned by"]
    #[doc = " libinput_event_tablet_pad_get_mode()."]
    #[doc = ""]
    #[doc = " For example, if the mode was toggled three times between the call to"]
    #[doc = " libinput_dispatch(), this function returns the third mode but the events"]
    #[doc = " in the event queue will return the modes 1, 2 and 3, respectively."]
    #[doc = ""]
    #[doc = " @param group A previously obtained mode group"]
    #[doc = " @return the numeric index of the current mode in this group, starting at 0"]
    #[doc = ""]
    #[doc = " @see libinput_event_tablet_pad_get_mode"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_get_mode(
        group: *mut libinput_tablet_pad_mode_group,
    ) -> ::libc::c_uint;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " Devices without mode switching capabilities return true for every button."]
    #[doc = ""]
    #[doc = " @param group A previously obtained mode group"]
    #[doc = " @param button A button index, starting at 0"]
    #[doc = " @return true if the given button index is part of this mode group or"]
    #[doc = " false otherwise"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_has_button(
        group: *mut libinput_tablet_pad_mode_group,
        button: ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " Devices without mode switching capabilities return true for every ring."]
    #[doc = ""]
    #[doc = " @param group A previously obtained mode group"]
    #[doc = " @param ring A ring index, starting at 0"]
    #[doc = " @return true if the given ring index is part of this mode group or"]
    #[doc = " false otherwise"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_has_ring(
        group: *mut libinput_tablet_pad_mode_group,
        ring: ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " Devices without mode switching capabilities return true for every strip."]
    #[doc = ""]
    #[doc = " @param group A previously obtained mode group"]
    #[doc = " @param strip A strip index, starting at 0"]
    #[doc = " @return true if the given strip index is part of this mode group or"]
    #[doc = " false otherwise"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_has_strip(
        group: *mut libinput_tablet_pad_mode_group,
        strip: ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " The toggle button in a mode group is the button assigned to cycle to or"]
    #[doc = " directly assign a new mode when pressed. Not all devices have a toggle"]
    #[doc = " button and some devices may have more than one toggle button. For"]
    #[doc = " example, the Wacom Cintiq 24HD has six toggle buttons in two groups, each"]
    #[doc = " directly selecting one of the three modes per group."]
    #[doc = ""]
    #[doc = " Devices without mode switching capabilities return false for every button."]
    #[doc = ""]
    #[doc = " @param group A previously obtained mode group"]
    #[doc = " @param button A button index, starting at 0"]
    #[doc = " @retval non-zero if the button is a mode toggle button for this group, or"]
    #[doc = " zero otherwise"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_button_is_toggle(
        group: *mut libinput_tablet_pad_mode_group,
        button: ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " Increase the refcount of the mode group. A mode group will be"]
    #[doc = " freed whenever the refcount reaches 0."]
    #[doc = ""]
    #[doc = " @param group A previously obtained mode group"]
    #[doc = " @return The passed mode group"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_ref(
        group: *mut libinput_tablet_pad_mode_group,
    ) -> *mut libinput_tablet_pad_mode_group;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " Decrease the refcount of the mode group. A mode group will be"]
    #[doc = " freed whenever the refcount reaches 0."]
    #[doc = ""]
    #[doc = " @param group A previously obtained mode group"]
    #[doc = " @return NULL if the group was destroyed, otherwise the passed mode group"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_unref(
        group: *mut libinput_tablet_pad_mode_group,
    ) -> *mut libinput_tablet_pad_mode_group;
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " Set caller-specific data associated with this mode group. libinput does"]
    #[doc = " not manage, look at, or modify this data. The caller must ensure the"]
    #[doc = " data is valid."]
    #[doc = ""]
    #[doc = " @param group A previously obtained mode group"]
    #[doc = " @param user_data Caller-specific data pointer"]
    #[doc = " @see libinput_tablet_pad_mode_group_get_user_data"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_set_user_data(
        group: *mut libinput_tablet_pad_mode_group,
        user_data: *mut ::libc::c_void,
    );
}
extern "C" {
    #[doc = " @ingroup tablet_pad_modes"]
    #[doc = ""]
    #[doc = " Get the caller-specific data associated with this mode group, if any."]
    #[doc = ""]
    #[doc = " @param group A previously obtained mode group"]
    #[doc = " @return Caller-specific data pointer or NULL if none was set"]
    #[doc = " @see libinput_tablet_pad_mode_group_set_user_data"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_tablet_pad_mode_group_get_user_data(
        group: *mut libinput_tablet_pad_mode_group,
    ) -> *mut ::libc::c_void;
}
pub const libinput_switch_state_LIBINPUT_SWITCH_STATE_OFF: libinput_switch_state = 0;
pub const libinput_switch_state_LIBINPUT_SWITCH_STATE_ON: libinput_switch_state = 1;
#[doc = " @ingroup device"]
#[doc = ""]
#[doc = " The state of a switch. The default state of a switch is @ref"]
#[doc = " LIBINPUT_SWITCH_STATE_OFF and no event is sent to confirm a switch in the"]
#[doc = " off position. If a switch is logically on during initialization, libinput"]
#[doc = " sends an event of type @ref LIBINPUT_EVENT_SWITCH_TOGGLE with a state"]
#[doc = " @ref LIBINPUT_SWITCH_STATE_ON."]
#[doc = ""]
#[doc = " @since 1.7"]
pub type libinput_switch_state = ::libc::c_uint;
#[doc = " The laptop lid was closed when the switch state is @ref"]
#[doc = " LIBINPUT_SWITCH_STATE_ON, or was opened when it is @ref"]
#[doc = " LIBINPUT_SWITCH_STATE_OFF."]
pub const libinput_switch_LIBINPUT_SWITCH_LID: libinput_switch = 1;
#[doc = " This switch indicates whether the device is in normal laptop mode"]
#[doc = " or behaves like a tablet-like device where the primary"]
#[doc = " interaction is usually a touch screen. When in tablet mode, the"]
#[doc = " keyboard and touchpad are usually inaccessible."]
#[doc = ""]
#[doc = " If the switch is in state @ref LIBINPUT_SWITCH_STATE_OFF, the"]
#[doc = " device is in laptop mode. If the switch is in state @ref"]
#[doc = " LIBINPUT_SWITCH_STATE_ON, the device is in tablet mode and the"]
#[doc = " keyboard or touchpad may not be  accessible."]
#[doc = ""]
#[doc = " It is up to the caller to identify which devices are inaccessible"]
#[doc = " in tablet mode."]
pub const libinput_switch_LIBINPUT_SWITCH_TABLET_MODE: libinput_switch = 2;
#[doc = " @ingroup device"]
#[doc = ""]
#[doc = " The type of a switch."]
#[doc = ""]
#[doc = " @since 1.7"]
pub type libinput_switch = ::libc::c_uint;
#[doc = " @ingroup event_switch"]
#[doc = " @struct libinput_event_switch"]
#[doc = ""]
#[doc = " A switch event representing a changed state in a switch."]
#[doc = ""]
#[doc = " @since 1.7"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_switch {
    _unused: [u8; 0],
}
#[doc = " This is not a real event type, and is only used to tell the user that"]
#[doc = " no new event is available in the queue. See"]
#[doc = " libinput_next_event_type()."]
pub const libinput_event_type_LIBINPUT_EVENT_NONE: libinput_event_type = 0;
#[doc = " Signals that a device has been added to the context. The device will"]
#[doc = " not be read until the next time the user calls libinput_dispatch()"]
#[doc = " and data is available."]
#[doc = ""]
#[doc = " This allows setting up initial device configuration before any events"]
#[doc = " are created."]
pub const libinput_event_type_LIBINPUT_EVENT_DEVICE_ADDED: libinput_event_type = 1;
#[doc = " Signals that a device has been removed. No more events from the"]
#[doc = " associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_DEVICE_REMOVED: libinput_event_type = 2;
#[doc = " Signals that a device has been removed. No more events from the"]
#[doc = " associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_KEYBOARD_KEY: libinput_event_type = 300;
#[doc = " Signals that a device has been removed. No more events from the"]
#[doc = " associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_POINTER_MOTION: libinput_event_type = 400;
#[doc = " Signals that a device has been removed. No more events from the"]
#[doc = " associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE: libinput_event_type = 401;
#[doc = " Signals that a device has been removed. No more events from the"]
#[doc = " associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_POINTER_BUTTON: libinput_event_type = 402;
#[doc = " Signals that a device has been removed. No more events from the"]
#[doc = " associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_POINTER_AXIS: libinput_event_type = 403;
#[doc = " Signals that a device has been removed. No more events from the"]
#[doc = " associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_TOUCH_DOWN: libinput_event_type = 500;
#[doc = " Signals that a device has been removed. No more events from the"]
#[doc = " associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_TOUCH_UP: libinput_event_type = 501;
#[doc = " Signals that a device has been removed. No more events from the"]
#[doc = " associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_TOUCH_MOTION: libinput_event_type = 502;
#[doc = " Signals that a device has been removed. No more events from the"]
#[doc = " associated device will be in the queue or be queued after this event."]
pub const libinput_event_type_LIBINPUT_EVENT_TOUCH_CANCEL: libinput_event_type = 503;
#[doc = " Signals the end of a set of touchpoints at one device sample"]
#[doc = " time. This event has no coordinate information attached."]
pub const libinput_event_type_LIBINPUT_EVENT_TOUCH_FRAME: libinput_event_type = 504;
#[doc = " One or more axes have changed state on a device with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_TOOL capability. This event is only sent"]
#[doc = " when the tool is in proximity, see @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY for details."]
#[doc = ""]
#[doc = " The proximity event contains the initial state of the axis as the"]
#[doc = " tool comes into proximity. An event of type @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_TOOL_AXIS is only sent when an axis value"]
#[doc = " changes from this initial state. It is possible for a tool to"]
#[doc = " enter and leave proximity without sending an event of type @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_TOOL_AXIS."]
#[doc = ""]
#[doc = " An event of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS is sent"]
#[doc = " when the tip state does not change. See the documentation for"]
#[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP for more details."]
#[doc = ""]
#[doc = " @since 1.2"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_TOOL_AXIS: libinput_event_type = 600;
#[doc = " Signals that a tool has come in or out of proximity of a device with"]
#[doc = " the @ref LIBINPUT_DEVICE_CAP_TABLET_TOOL capability."]
#[doc = ""]
#[doc = " Proximity events contain each of the current values for each axis,"]
#[doc = " and these values may be extracted from them in the same way they are"]
#[doc = " with @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS events."]
#[doc = ""]
#[doc = " Some tools may always be in proximity. For these tools, events of"]
#[doc = " type @ref LIBINPUT_TABLET_TOOL_PROXIMITY_STATE_IN are sent only once after @ref"]
#[doc = " LIBINPUT_EVENT_DEVICE_ADDED, and events of type @ref"]
#[doc = " LIBINPUT_TABLET_TOOL_PROXIMITY_STATE_OUT are sent only once before @ref"]
#[doc = " LIBINPUT_EVENT_DEVICE_REMOVED."]
#[doc = ""]
#[doc = " If the tool that comes into proximity supports x/y coordinates,"]
#[doc = " libinput guarantees that both x and y are set in the proximity"]
#[doc = " event."]
#[doc = ""]
#[doc = " When a tool goes out of proximity, the value of every axis should be"]
#[doc = " assumed to have an undefined state and any buttons that are currently held"]
#[doc = " down on the stylus are marked as released. Button release events for"]
#[doc = " each button that was held down on the stylus are sent before the"]
#[doc = " proximity out event."]
#[doc = ""]
#[doc = " @since 1.2"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY: libinput_event_type = 601;
#[doc = " Signals that a tool has come in contact with the surface of a"]
#[doc = " device with the @ref LIBINPUT_DEVICE_CAP_TABLET_TOOL capability."]
#[doc = ""]
#[doc = " On devices without distance proximity detection, the @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP is sent immediately after @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY for the tip down event, and"]
#[doc = " immediately before for the tip up event."]
#[doc = ""]
#[doc = " The decision when a tip touches the surface is device-dependent"]
#[doc = " and may be derived from pressure data or other means. If the tip"]
#[doc = " state is changed by axes changing state, the"]
#[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP event includes the changed"]
#[doc = " axes and no additional axis event is sent for this state change."]
#[doc = " In other words, a caller must look at both @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_TOOL_AXIS and @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP events to know the current state"]
#[doc = " of the axes."]
#[doc = ""]
#[doc = " If a button state change occurs at the same time as a tip state"]
#[doc = " change, the order of events is device-dependent."]
#[doc = ""]
#[doc = " @since 1.2"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_TOOL_TIP: libinput_event_type = 602;
#[doc = " Signals that a tool has changed a logical button state on a"]
#[doc = " device with the @ref LIBINPUT_DEVICE_CAP_TABLET_TOOL capability."]
#[doc = ""]
#[doc = " Button state changes occur on their own and do not include axis"]
#[doc = " state changes. If button and axis state changes occur within the"]
#[doc = " same logical hardware event, the order of the @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON and @ref"]
#[doc = " LIBINPUT_EVENT_TABLET_TOOL_AXIS event is device-specific."]
#[doc = ""]
#[doc = " This event is not to be confused with the button events emitted"]
#[doc = " by the tablet pad. See @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON."]
#[doc = ""]
#[doc = " @see LIBINPUT_EVENT_TABLET_PAD_BUTTON"]
#[doc = ""]
#[doc = " @since 1.2"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_TOOL_BUTTON: libinput_event_type = 603;
#[doc = " A button pressed on a device with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_PAD capability."]
#[doc = ""]
#[doc = " A button differs from @ref LIBINPUT_EVENT_TABLET_PAD_KEY in that"]
#[doc = " buttons are sequentially indexed from 0 and do not carry any"]
#[doc = " other information.  Keys have a specific functionality assigned"]
#[doc = " to them. The key code thus carries a semantic meaning, a button"]
#[doc = " number does not."]
#[doc = ""]
#[doc = " This event is not to be confused with the button events emitted"]
#[doc = " by tools on a tablet (@ref LIBINPUT_EVENT_TABLET_TOOL_BUTTON)."]
#[doc = ""]
#[doc = " @since 1.3"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_PAD_BUTTON: libinput_event_type = 700;
#[doc = " A status change on a tablet ring with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_PAD capability."]
#[doc = ""]
#[doc = " @since 1.3"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_PAD_RING: libinput_event_type = 701;
#[doc = " A status change on a strip on a device with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_PAD capability."]
#[doc = ""]
#[doc = " @since 1.3"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_PAD_STRIP: libinput_event_type = 702;
#[doc = " A key pressed on a device with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_PAD capability."]
#[doc = ""]
#[doc = " A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that"]
#[doc = " keys have a specific functionality assigned to them (buttons are"]
#[doc = " sequentially ordered). The key code thus carries a semantic"]
#[doc = " meaning, a button number does not."]
#[doc = ""]
#[doc = " @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_TABLET_PAD_KEY: libinput_event_type = 703;
#[doc = " A key pressed on a device with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_PAD capability."]
#[doc = ""]
#[doc = " A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that"]
#[doc = " keys have a specific functionality assigned to them (buttons are"]
#[doc = " sequentially ordered). The key code thus carries a semantic"]
#[doc = " meaning, a button number does not."]
#[doc = ""]
#[doc = " @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_SWIPE_BEGIN: libinput_event_type = 800;
#[doc = " A key pressed on a device with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_PAD capability."]
#[doc = ""]
#[doc = " A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that"]
#[doc = " keys have a specific functionality assigned to them (buttons are"]
#[doc = " sequentially ordered). The key code thus carries a semantic"]
#[doc = " meaning, a button number does not."]
#[doc = ""]
#[doc = " @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_SWIPE_UPDATE: libinput_event_type = 801;
#[doc = " A key pressed on a device with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_PAD capability."]
#[doc = ""]
#[doc = " A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that"]
#[doc = " keys have a specific functionality assigned to them (buttons are"]
#[doc = " sequentially ordered). The key code thus carries a semantic"]
#[doc = " meaning, a button number does not."]
#[doc = ""]
#[doc = " @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_SWIPE_END: libinput_event_type = 802;
#[doc = " A key pressed on a device with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_PAD capability."]
#[doc = ""]
#[doc = " A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that"]
#[doc = " keys have a specific functionality assigned to them (buttons are"]
#[doc = " sequentially ordered). The key code thus carries a semantic"]
#[doc = " meaning, a button number does not."]
#[doc = ""]
#[doc = " @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_PINCH_BEGIN: libinput_event_type = 803;
#[doc = " A key pressed on a device with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_PAD capability."]
#[doc = ""]
#[doc = " A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that"]
#[doc = " keys have a specific functionality assigned to them (buttons are"]
#[doc = " sequentially ordered). The key code thus carries a semantic"]
#[doc = " meaning, a button number does not."]
#[doc = ""]
#[doc = " @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_PINCH_UPDATE: libinput_event_type = 804;
#[doc = " A key pressed on a device with the @ref"]
#[doc = " LIBINPUT_DEVICE_CAP_TABLET_PAD capability."]
#[doc = ""]
#[doc = " A key differs from @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON in that"]
#[doc = " keys have a specific functionality assigned to them (buttons are"]
#[doc = " sequentially ordered). The key code thus carries a semantic"]
#[doc = " meaning, a button number does not."]
#[doc = ""]
#[doc = " @since 1.15"]
pub const libinput_event_type_LIBINPUT_EVENT_GESTURE_PINCH_END: libinput_event_type = 805;
#[doc = " @since 1.7"]
pub const libinput_event_type_LIBINPUT_EVENT_SWITCH_TOGGLE: libinput_event_type = 900;
#[doc = " @ingroup base"]
#[doc = ""]
#[doc = " Event type for events returned by libinput_get_event()."]
pub type libinput_event_type = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " Destroy the event, freeing all associated resources. Resources obtained"]
    #[doc = " from this event must be considered invalid after this call."]
    #[doc = ""]
    #[doc = " @warning Unlike other structs events are considered transient and"]
    #[doc = " <b>not</b> refcounted. Calling libinput_event_destroy() <b>will</b>"]
    #[doc = " destroy the event."]
    #[doc = ""]
    #[doc = " @param event An event retrieved by libinput_get_event()."]
    pub fn libinput_event_destroy(event: *mut libinput_event);
}
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " Get the type of the event."]
    #[doc = ""]
    #[doc = " @param event An event retrieved by libinput_get_event()."]
    pub fn libinput_event_get_type(event: *mut libinput_event) -> libinput_event_type;
}
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " Get the libinput context from the event."]
    #[doc = ""]
    #[doc = " @param event The libinput event"]
    #[doc = " @return The libinput context for this event."]
    pub fn libinput_event_get_context(event: *mut libinput_event) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " Return the device associated with this event. For device added/removed"]
    #[doc = " events this is the device added or removed. For all other device events,"]
    #[doc = " this is the device that generated the event."]
    #[doc = ""]
    #[doc = " This device is not refcounted and its lifetime is that of the event. Use"]
    #[doc = " libinput_device_ref() before using the device outside of this scope."]
    #[doc = ""]
    #[doc = " @return The device associated with this event"]
    pub fn libinput_event_get_device(event: *mut libinput_event) -> *mut libinput_device;
}
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " Return the pointer event that is this input event. If the event type does"]
    #[doc = " not match the pointer event types, this function returns NULL."]
    #[doc = ""]
    #[doc = " The inverse of this function is libinput_event_pointer_get_base_event()."]
    #[doc = ""]
    #[doc = " @return A pointer event, or NULL for other events"]
    pub fn libinput_event_get_pointer_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_pointer;
}
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " Return the keyboard event that is this input event. If the event type does"]
    #[doc = " not match the keyboard event types, this function returns NULL."]
    #[doc = ""]
    #[doc = " The inverse of this function is libinput_event_keyboard_get_base_event()."]
    #[doc = ""]
    #[doc = " @return A keyboard event, or NULL for other events"]
    pub fn libinput_event_get_keyboard_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_keyboard;
}
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " Return the touch event that is this input event. If the event type does"]
    #[doc = " not match the touch event types, this function returns NULL."]
    #[doc = ""]
    #[doc = " The inverse of this function is libinput_event_touch_get_base_event()."]
    #[doc = ""]
    #[doc = " @return A touch event, or NULL for other events"]
    pub fn libinput_event_get_touch_event(event: *mut libinput_event) -> *mut libinput_event_touch;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_event_gesture {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " Return the gesture event that is this input event. If the event type does"]
    #[doc = " not match the gesture event types, this function returns NULL."]
    #[doc = ""]
    #[doc = " A gesture's lifetime has three distinct stages: begin, update and end, each"]
    #[doc = " with their own event types. Begin is sent when the fingers are first set"]
    #[doc = " down or libinput decides that the gesture begins. For @ref"]
    #[doc = " LIBINPUT_EVENT_GESTURE_PINCH_BEGIN this sets the initial scale. Any"]
    #[doc = " events changing properties of the gesture are sent as update events. On"]
    #[doc = " termination of the gesture, an end event is sent."]
    #[doc = ""]
    #[doc = " The inverse of this function is libinput_event_gesture_get_base_event()."]
    #[doc = ""]
    #[doc = " @return A gesture event, or NULL for other events"]
    pub fn libinput_event_get_gesture_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_gesture;
}
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " Return the tablet tool event that is this input event. If the event type"]
    #[doc = " does not match the tablet tool event types, this function returns NULL."]
    #[doc = ""]
    #[doc = " The inverse of this function is libinput_event_tablet_tool_get_base_event()."]
    #[doc = ""]
    #[doc = " @return A tablet tool event, or NULL for other events"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_get_tablet_tool_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_tablet_tool;
}
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " Return the tablet pad event that is this input event. If the event type does not"]
    #[doc = " match the tablet pad event types, this function returns NULL."]
    #[doc = ""]
    #[doc = " The inverse of this function is libinput_event_tablet_pad_get_base_event()."]
    #[doc = ""]
    #[doc = " @return A tablet pad event, or NULL for other events"]
    pub fn libinput_event_get_tablet_pad_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_tablet_pad;
}
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " Return the switch event that is this input event. If the event type does"]
    #[doc = " not match the switch event types, this function returns NULL."]
    #[doc = ""]
    #[doc = " The inverse of this function is libinput_event_switch_get_base_event()."]
    #[doc = ""]
    #[doc = " @return A switch event, or NULL for other events"]
    #[doc = ""]
    #[doc = " @since 1.7"]
    pub fn libinput_event_get_switch_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_switch;
}
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " Return the device event that is this input event. If the event type does"]
    #[doc = " not match the device event types, this function returns NULL."]
    #[doc = ""]
    #[doc = " The inverse of this function is"]
    #[doc = " libinput_event_device_notify_get_base_event()."]
    #[doc = ""]
    #[doc = " @return A device event, or NULL for other events"]
    pub fn libinput_event_get_device_notify_event(
        event: *mut libinput_event,
    ) -> *mut libinput_event_device_notify;
}
extern "C" {
    #[doc = " @ingroup event"]
    #[doc = ""]
    #[doc = " @return The generic libinput_event of this event"]
    pub fn libinput_event_device_notify_get_base_event(
        event: *mut libinput_event_device_notify,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_keyboard"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @return The event time for this event"]
    pub fn libinput_event_keyboard_get_time(event: *mut libinput_event_keyboard) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_keyboard"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @return The event time for this event in microseconds"]
    pub fn libinput_event_keyboard_get_time_usec(event: *mut libinput_event_keyboard) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_keyboard"]
    #[doc = ""]
    #[doc = " @return The keycode that triggered this key event"]
    pub fn libinput_event_keyboard_get_key(event: *mut libinput_event_keyboard) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_keyboard"]
    #[doc = ""]
    #[doc = " @return The state change of the key"]
    pub fn libinput_event_keyboard_get_key_state(
        event: *mut libinput_event_keyboard,
    ) -> libinput_key_state;
}
extern "C" {
    #[doc = " @ingroup event_keyboard"]
    #[doc = ""]
    #[doc = " @return The generic libinput_event of this event"]
    pub fn libinput_event_keyboard_get_base_event(
        event: *mut libinput_event_keyboard,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_keyboard"]
    #[doc = ""]
    #[doc = " For the key of a @ref LIBINPUT_EVENT_KEYBOARD_KEY event, return the total number"]
    #[doc = " of keys pressed on all devices on the associated seat after the event was"]
    #[doc = " triggered."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_KEYBOARD_KEY. For other events, this function returns 0."]
    #[doc = ""]
    #[doc = " @return The seat wide pressed key count for the key of this event"]
    pub fn libinput_event_keyboard_get_seat_key_count(event: *mut libinput_event_keyboard) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @return The event time for this event"]
    pub fn libinput_event_pointer_get_time(event: *mut libinput_event_pointer) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @return The event time for this event in microseconds"]
    pub fn libinput_event_pointer_get_time_usec(event: *mut libinput_event_pointer) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the delta between the last event and the current event. For pointer"]
    #[doc = " events that are not of type @ref LIBINPUT_EVENT_POINTER_MOTION, this"]
    #[doc = " function returns 0."]
    #[doc = ""]
    #[doc = " If a device employs pointer acceleration, the delta returned by this"]
    #[doc = " function is the accelerated delta."]
    #[doc = ""]
    #[doc = " Relative motion deltas are to be interpreted as pixel movement of a"]
    #[doc = " standardized mouse. See the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_MOTION."]
    #[doc = ""]
    #[doc = " @return The relative x movement since the last event"]
    pub fn libinput_event_pointer_get_dx(event: *mut libinput_event_pointer) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the delta between the last event and the current event. For pointer"]
    #[doc = " events that are not of type @ref LIBINPUT_EVENT_POINTER_MOTION, this"]
    #[doc = " function returns 0."]
    #[doc = ""]
    #[doc = " If a device employs pointer acceleration, the delta returned by this"]
    #[doc = " function is the accelerated delta."]
    #[doc = ""]
    #[doc = " Relative motion deltas are to be interpreted as pixel movement of a"]
    #[doc = " standardized mouse. See the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_MOTION."]
    #[doc = ""]
    #[doc = " @return The relative y movement since the last event"]
    pub fn libinput_event_pointer_get_dy(event: *mut libinput_event_pointer) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the relative delta of the unaccelerated motion vector of the"]
    #[doc = " current event. For pointer events that are not of type @ref"]
    #[doc = " LIBINPUT_EVENT_POINTER_MOTION, this function returns 0."]
    #[doc = ""]
    #[doc = " Relative unaccelerated motion deltas are raw device coordinates."]
    #[doc = " Note that these coordinates are subject to the device's native"]
    #[doc = " resolution. Touchpad coordinates represent raw device coordinates in the"]
    #[doc = " X resolution of the touchpad. See the libinput documentation for more"]
    #[doc = " details."]
    #[doc = ""]
    #[doc = " Any rotation applied to the device also applies to unaccelerated motion"]
    #[doc = " (see libinput_device_config_rotation_set_angle())."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_MOTION."]
    #[doc = ""]
    #[doc = " @return The unaccelerated relative x movement since the last event"]
    pub fn libinput_event_pointer_get_dx_unaccelerated(event: *mut libinput_event_pointer) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the relative delta of the unaccelerated motion vector of the"]
    #[doc = " current event. For pointer events that are not of type @ref"]
    #[doc = " LIBINPUT_EVENT_POINTER_MOTION, this function returns 0."]
    #[doc = ""]
    #[doc = " Relative unaccelerated motion deltas are raw device coordinates."]
    #[doc = " Note that these coordinates are subject to the device's native"]
    #[doc = " resolution. Touchpad coordinates represent raw device coordinates in the"]
    #[doc = " X resolution of the touchpad. See the libinput documentation for more"]
    #[doc = " details."]
    #[doc = ""]
    #[doc = " Any rotation applied to the device also applies to unaccelerated motion"]
    #[doc = " (see libinput_device_config_rotation_set_angle())."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_MOTION."]
    #[doc = ""]
    #[doc = " @return The unaccelerated relative y movement since the last event"]
    pub fn libinput_event_pointer_get_dy_unaccelerated(event: *mut libinput_event_pointer) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the current absolute x coordinate of the pointer event, in mm from"]
    #[doc = " the top left corner of the device. To get the corresponding output screen"]
    #[doc = " coordinate, use libinput_event_pointer_get_absolute_x_transformed()."]
    #[doc = ""]
    #[doc = " For pointer events that are not of type"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE."]
    #[doc = ""]
    #[doc = " @return The current absolute x coordinate"]
    pub fn libinput_event_pointer_get_absolute_x(event: *mut libinput_event_pointer) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the current absolute y coordinate of the pointer event, in mm from"]
    #[doc = " the top left corner of the device. To get the corresponding output screen"]
    #[doc = " coordinate, use libinput_event_pointer_get_absolute_y_transformed()."]
    #[doc = ""]
    #[doc = " For pointer events that are not of type"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE."]
    #[doc = ""]
    #[doc = " @return The current absolute y coordinate"]
    pub fn libinput_event_pointer_get_absolute_y(event: *mut libinput_event_pointer) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the current absolute x coordinate of the pointer event, transformed to"]
    #[doc = " screen coordinates."]
    #[doc = ""]
    #[doc = " For pointer events that are not of type"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE, the return value of this"]
    #[doc = " function is undefined."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE."]
    #[doc = ""]
    #[doc = " @param event The libinput pointer event"]
    #[doc = " @param width The current output screen width"]
    #[doc = " @return The current absolute x coordinate transformed to a screen coordinate"]
    pub fn libinput_event_pointer_get_absolute_x_transformed(
        event: *mut libinput_event_pointer,
        width: u32,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the current absolute y coordinate of the pointer event, transformed to"]
    #[doc = " screen coordinates."]
    #[doc = ""]
    #[doc = " For pointer events that are not of type"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE, the return value of this function is"]
    #[doc = " undefined."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_MOTION_ABSOLUTE."]
    #[doc = ""]
    #[doc = " @param event The libinput pointer event"]
    #[doc = " @param height The current output screen height"]
    #[doc = " @return The current absolute y coordinate transformed to a screen coordinate"]
    pub fn libinput_event_pointer_get_absolute_y_transformed(
        event: *mut libinput_event_pointer,
        height: u32,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the button that triggered this event."]
    #[doc = " For pointer events that are not of type @ref"]
    #[doc = " LIBINPUT_EVENT_POINTER_BUTTON, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_BUTTON."]
    #[doc = ""]
    #[doc = " @return The button triggering this event"]
    pub fn libinput_event_pointer_get_button(event: *mut libinput_event_pointer) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the button state that triggered this event."]
    #[doc = " For pointer events that are not of type @ref"]
    #[doc = " LIBINPUT_EVENT_POINTER_BUTTON, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_BUTTON."]
    #[doc = ""]
    #[doc = " @return The button state triggering this event"]
    pub fn libinput_event_pointer_get_button_state(
        event: *mut libinput_event_pointer,
    ) -> libinput_button_state;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " For the button of a @ref LIBINPUT_EVENT_POINTER_BUTTON event, return the"]
    #[doc = " total number of buttons pressed on all devices on the associated seat"]
    #[doc = " after the event was triggered."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_BUTTON. For other events, this function"]
    #[doc = " returns 0."]
    #[doc = ""]
    #[doc = " @return The seat wide pressed button count for the key of this event"]
    pub fn libinput_event_pointer_get_seat_button_count(event: *mut libinput_event_pointer) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Check if the event has a valid value for the given axis."]
    #[doc = ""]
    #[doc = " If this function returns non-zero for an axis and"]
    #[doc = " libinput_event_pointer_get_axis_value() returns a value of 0, the event"]
    #[doc = " is a scroll stop event."]
    #[doc = ""]
    #[doc = " For pointer events that are not of type @ref LIBINPUT_EVENT_POINTER_AXIS,"]
    #[doc = " this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_AXIS."]
    #[doc = ""]
    #[doc = " @return Non-zero if this event contains a value for this axis"]
    pub fn libinput_event_pointer_has_axis(
        event: *mut libinput_event_pointer,
        axis: libinput_pointer_axis,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the axis value of the given axis. The interpretation of the value"]
    #[doc = " depends on the axis. For the two scrolling axes"]
    #[doc = " @ref LIBINPUT_POINTER_AXIS_SCROLL_VERTICAL and"]
    #[doc = " @ref LIBINPUT_POINTER_AXIS_SCROLL_HORIZONTAL, the value of the event is in"]
    #[doc = " relative scroll units, with the positive direction being down or right,"]
    #[doc = " respectively. For the interpretation of the value, see"]
    #[doc = " libinput_event_pointer_get_axis_source()."]
    #[doc = ""]
    #[doc = " If libinput_event_pointer_has_axis() returns 0 for an axis, this function"]
    #[doc = " returns 0 for that axis."]
    #[doc = ""]
    #[doc = " For pointer events that are not of type @ref LIBINPUT_EVENT_POINTER_AXIS,"]
    #[doc = " this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_AXIS."]
    #[doc = ""]
    #[doc = " @return The axis value of this event"]
    #[doc = ""]
    #[doc = " @see libinput_event_pointer_get_axis_value_discrete"]
    pub fn libinput_event_pointer_get_axis_value(
        event: *mut libinput_event_pointer,
        axis: libinput_pointer_axis,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the source for a given axis event. Axis events (scroll events) can"]
    #[doc = " be caused by a hardware item such as a scroll wheel or emulated from"]
    #[doc = " other input sources, such as two-finger or edge scrolling on a"]
    #[doc = " touchpad."]
    #[doc = ""]
    #[doc = " If the source is @ref LIBINPUT_POINTER_AXIS_SOURCE_FINGER, libinput"]
    #[doc = " guarantees that a scroll sequence is terminated with a scroll value of 0."]
    #[doc = " A caller may use this information to decide on whether kinetic scrolling"]
    #[doc = " should be triggered on this scroll sequence."]
    #[doc = " The coordinate system is identical to the cursor movement, i.e. a"]
    #[doc = " scroll value of 1 represents the equivalent relative motion of 1."]
    #[doc = ""]
    #[doc = " If the source is @ref LIBINPUT_POINTER_AXIS_SOURCE_WHEEL, no terminating"]
    #[doc = " event is guaranteed (though it may happen)."]
    #[doc = " Scrolling is in discrete steps, the value is the angle the wheel moved"]
    #[doc = " in degrees. The default is 15 degrees per wheel click, but some mice may"]
    #[doc = " have differently grained wheels. It is up to the caller how to interpret"]
    #[doc = " such different step sizes."]
    #[doc = ""]
    #[doc = " If the source is @ref LIBINPUT_POINTER_AXIS_SOURCE_CONTINUOUS, no"]
    #[doc = " terminating event is guaranteed (though it may happen)."]
    #[doc = " The coordinate system is identical to the cursor movement, i.e. a"]
    #[doc = " scroll value of 1 represents the equivalent relative motion of 1."]
    #[doc = ""]
    #[doc = " If the source is @ref LIBINPUT_POINTER_AXIS_SOURCE_WHEEL_TILT, no"]
    #[doc = " terminating event is guaranteed (though it may happen)."]
    #[doc = " Scrolling is in discrete steps and there is no physical equivalent for"]
    #[doc = " the value returned here. For backwards compatibility, the value returned"]
    #[doc = " by this function is identical to a single mouse wheel rotation by this"]
    #[doc = " device (see the documentation for @ref LIBINPUT_POINTER_AXIS_SOURCE_WHEEL"]
    #[doc = " above). Callers should not use this value but instead exclusively refer"]
    #[doc = " to the value returned by libinput_event_pointer_get_axis_value_discrete()."]
    #[doc = ""]
    #[doc = " For pointer events that are not of type @ref LIBINPUT_EVENT_POINTER_AXIS,"]
    #[doc = " this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_POINTER_AXIS."]
    #[doc = ""]
    #[doc = " @return The source for this axis event"]
    pub fn libinput_event_pointer_get_axis_source(
        event: *mut libinput_event_pointer,
    ) -> libinput_pointer_axis_source;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " Return the axis value in discrete steps for a given axis event. How a"]
    #[doc = " value translates into a discrete step depends on the source."]
    #[doc = ""]
    #[doc = " If the source is @ref LIBINPUT_POINTER_AXIS_SOURCE_WHEEL, the discrete"]
    #[doc = " value correspond to the number of physical mouse wheel clicks."]
    #[doc = ""]
    #[doc = " If the source is @ref LIBINPUT_POINTER_AXIS_SOURCE_CONTINUOUS or @ref"]
    #[doc = " LIBINPUT_POINTER_AXIS_SOURCE_FINGER, the discrete value is always 0."]
    #[doc = ""]
    #[doc = " @return The discrete value for the given event."]
    #[doc = ""]
    #[doc = " @see libinput_event_pointer_get_axis_value"]
    pub fn libinput_event_pointer_get_axis_value_discrete(
        event: *mut libinput_event_pointer,
        axis: libinput_pointer_axis,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_pointer"]
    #[doc = ""]
    #[doc = " @return The generic libinput_event of this event"]
    pub fn libinput_event_pointer_get_base_event(
        event: *mut libinput_event_pointer,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_touch"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @return The event time for this event"]
    pub fn libinput_event_touch_get_time(event: *mut libinput_event_touch) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_touch"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @return The event time for this event in microseconds"]
    pub fn libinput_event_touch_get_time_usec(event: *mut libinput_event_touch) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_touch"]
    #[doc = ""]
    #[doc = " Get the slot of this touch event. See the kernel's multitouch"]
    #[doc = " protocol B documentation for more information."]
    #[doc = ""]
    #[doc = " If the touch event has no assigned slot, for example if it is from a"]
    #[doc = " single touch device, this function returns -1."]
    #[doc = ""]
    #[doc = " For events not of type @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref"]
    #[doc = " LIBINPUT_EVENT_TOUCH_UP, @ref LIBINPUT_EVENT_TOUCH_MOTION or @ref"]
    #[doc = " LIBINPUT_EVENT_TOUCH_CANCEL, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events of type"]
    #[doc = " other than @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref LIBINPUT_EVENT_TOUCH_UP,"]
    #[doc = " @ref LIBINPUT_EVENT_TOUCH_MOTION or @ref LIBINPUT_EVENT_TOUCH_CANCEL."]
    #[doc = ""]
    #[doc = " @return The slot of this touch event"]
    pub fn libinput_event_touch_get_slot(event: *mut libinput_event_touch) -> i32;
}
extern "C" {
    #[doc = " @ingroup event_touch"]
    #[doc = ""]
    #[doc = " Get the seat slot of the touch event. A seat slot is a non-negative seat"]
    #[doc = " wide unique identifier of an active touch point."]
    #[doc = ""]
    #[doc = " Events from single touch devices will be represented as one individual"]
    #[doc = " touch point per device."]
    #[doc = ""]
    #[doc = " For events not of type @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref"]
    #[doc = " LIBINPUT_EVENT_TOUCH_UP, @ref LIBINPUT_EVENT_TOUCH_MOTION or @ref"]
    #[doc = " LIBINPUT_EVENT_TOUCH_CANCEL, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events of type"]
    #[doc = " other than @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref LIBINPUT_EVENT_TOUCH_UP,"]
    #[doc = " @ref LIBINPUT_EVENT_TOUCH_MOTION or @ref LIBINPUT_EVENT_TOUCH_CANCEL."]
    #[doc = ""]
    #[doc = " @return The seat slot of the touch event"]
    pub fn libinput_event_touch_get_seat_slot(event: *mut libinput_event_touch) -> i32;
}
extern "C" {
    #[doc = " @ingroup event_touch"]
    #[doc = ""]
    #[doc = " Return the current absolute x coordinate of the touch event, in mm from"]
    #[doc = " the top left corner of the device. To get the corresponding output screen"]
    #[doc = " coordinate, use libinput_event_touch_get_x_transformed()."]
    #[doc = ""]
    #[doc = " For events not of type @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref"]
    #[doc = " LIBINPUT_EVENT_TOUCH_MOTION, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events of type"]
    #[doc = " other than @ref LIBINPUT_EVENT_TOUCH_DOWN or @ref"]
    #[doc = " LIBINPUT_EVENT_TOUCH_MOTION."]
    #[doc = ""]
    #[doc = " @param event The libinput touch event"]
    #[doc = " @return The current absolute x coordinate"]
    pub fn libinput_event_touch_get_x(event: *mut libinput_event_touch) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_touch"]
    #[doc = ""]
    #[doc = " Return the current absolute y coordinate of the touch event, in mm from"]
    #[doc = " the top left corner of the device. To get the corresponding output screen"]
    #[doc = " coordinate, use libinput_event_touch_get_y_transformed()."]
    #[doc = ""]
    #[doc = " For events not of type @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref"]
    #[doc = " LIBINPUT_EVENT_TOUCH_MOTION, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events of type"]
    #[doc = " other than @ref LIBINPUT_EVENT_TOUCH_DOWN or @ref"]
    #[doc = " LIBINPUT_EVENT_TOUCH_MOTION."]
    #[doc = ""]
    #[doc = " @param event The libinput touch event"]
    #[doc = " @return The current absolute y coordinate"]
    pub fn libinput_event_touch_get_y(event: *mut libinput_event_touch) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_touch"]
    #[doc = ""]
    #[doc = " Return the current absolute x coordinate of the touch event, transformed to"]
    #[doc = " screen coordinates."]
    #[doc = ""]
    #[doc = " For events not of type @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref"]
    #[doc = " LIBINPUT_EVENT_TOUCH_MOTION, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events of type"]
    #[doc = " other than @ref LIBINPUT_EVENT_TOUCH_DOWN or @ref"]
    #[doc = " LIBINPUT_EVENT_TOUCH_MOTION."]
    #[doc = ""]
    #[doc = " @param event The libinput touch event"]
    #[doc = " @param width The current output screen width"]
    #[doc = " @return The current absolute x coordinate transformed to a screen coordinate"]
    pub fn libinput_event_touch_get_x_transformed(
        event: *mut libinput_event_touch,
        width: u32,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_touch"]
    #[doc = ""]
    #[doc = " Return the current absolute y coordinate of the touch event, transformed to"]
    #[doc = " screen coordinates."]
    #[doc = ""]
    #[doc = " For events not of type @ref LIBINPUT_EVENT_TOUCH_DOWN, @ref"]
    #[doc = " LIBINPUT_EVENT_TOUCH_MOTION, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events of type"]
    #[doc = " other than @ref LIBINPUT_EVENT_TOUCH_DOWN or @ref"]
    #[doc = " LIBINPUT_EVENT_TOUCH_MOTION."]
    #[doc = ""]
    #[doc = " @param event The libinput touch event"]
    #[doc = " @param height The current output screen height"]
    #[doc = " @return The current absolute y coordinate transformed to a screen coordinate"]
    pub fn libinput_event_touch_get_y_transformed(
        event: *mut libinput_event_touch,
        height: u32,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_touch"]
    #[doc = ""]
    #[doc = " @return The generic libinput_event of this event"]
    pub fn libinput_event_touch_get_base_event(
        event: *mut libinput_event_touch,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_gesture"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @return The event time for this event"]
    pub fn libinput_event_gesture_get_time(event: *mut libinput_event_gesture) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_gesture"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @return The event time for this event in microseconds"]
    pub fn libinput_event_gesture_get_time_usec(event: *mut libinput_event_gesture) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_gesture"]
    #[doc = ""]
    #[doc = " @return The generic libinput_event of this event"]
    pub fn libinput_event_gesture_get_base_event(
        event: *mut libinput_event_gesture,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_gesture"]
    #[doc = ""]
    #[doc = " Return the number of fingers used for a gesture. This can be used e.g."]
    #[doc = " to differentiate between 3 or 4 finger swipes."]
    #[doc = ""]
    #[doc = " This function can be called on all gesture events and the returned finger"]
    #[doc = " count value remains the same for the lifetime of a gesture. Thus, if a"]
    #[doc = " user puts down a fourth finger during a three-finger swipe gesture,"]
    #[doc = " libinput will end the three-finger gesture and, if applicable, start a"]
    #[doc = " four-finger swipe gesture. A caller may decide that those gestures are"]
    #[doc = " semantically identical and continue the two gestures as one single gesture."]
    #[doc = ""]
    #[doc = " @return the number of fingers used for a gesture"]
    pub fn libinput_event_gesture_get_finger_count(
        event: *mut libinput_event_gesture,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_gesture"]
    #[doc = ""]
    #[doc = " Return if the gesture ended normally, or if it was cancelled."]
    #[doc = " For gesture events that are not of type"]
    #[doc = " @ref LIBINPUT_EVENT_GESTURE_SWIPE_END or"]
    #[doc = " @ref LIBINPUT_EVENT_GESTURE_PINCH_END, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_GESTURE_SWIPE_END or"]
    #[doc = " @ref LIBINPUT_EVENT_GESTURE_PINCH_END."]
    #[doc = ""]
    #[doc = " @return 0 or 1, with 1 indicating that the gesture was cancelled."]
    pub fn libinput_event_gesture_get_cancelled(
        event: *mut libinput_event_gesture,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_gesture"]
    #[doc = ""]
    #[doc = " Return the delta between the last event and the current event. For gesture"]
    #[doc = " events that are not of type @ref LIBINPUT_EVENT_GESTURE_SWIPE_UPDATE or"]
    #[doc = " @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE, this function returns 0."]
    #[doc = ""]
    #[doc = " If a device employs pointer acceleration, the delta returned by this"]
    #[doc = " function is the accelerated delta."]
    #[doc = ""]
    #[doc = " Relative motion deltas are normalized to represent those of a device with"]
    #[doc = " 1000dpi resolution. See the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @return the relative x movement since the last event"]
    pub fn libinput_event_gesture_get_dx(event: *mut libinput_event_gesture) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_gesture"]
    #[doc = ""]
    #[doc = " Return the delta between the last event and the current event. For gesture"]
    #[doc = " events that are not of type @ref LIBINPUT_EVENT_GESTURE_SWIPE_UPDATE or"]
    #[doc = " @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE, this function returns 0."]
    #[doc = ""]
    #[doc = " If a device employs pointer acceleration, the delta returned by this"]
    #[doc = " function is the accelerated delta."]
    #[doc = ""]
    #[doc = " Relative motion deltas are normalized to represent those of a device with"]
    #[doc = " 1000dpi resolution. See the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @return the relative y movement since the last event"]
    pub fn libinput_event_gesture_get_dy(event: *mut libinput_event_gesture) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_gesture"]
    #[doc = ""]
    #[doc = " Return the relative delta of the unaccelerated motion vector of the"]
    #[doc = " current event. For gesture events that are not of type"]
    #[doc = " @ref LIBINPUT_EVENT_GESTURE_SWIPE_UPDATE or"]
    #[doc = " @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE, this function returns 0."]
    #[doc = ""]
    #[doc = " Relative unaccelerated motion deltas are normalized to represent those of a"]
    #[doc = " device with 1000dpi resolution. See the libinput documentation for more"]
    #[doc = " details. Note that unaccelerated events are not equivalent to 'raw' events"]
    #[doc = " as read from the device."]
    #[doc = ""]
    #[doc = " Any rotation applied to the device also applies to gesture motion"]
    #[doc = " (see libinput_device_config_rotation_set_angle())."]
    #[doc = ""]
    #[doc = " @return the unaccelerated relative x movement since the last event"]
    pub fn libinput_event_gesture_get_dx_unaccelerated(event: *mut libinput_event_gesture) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_gesture"]
    #[doc = ""]
    #[doc = " Return the relative delta of the unaccelerated motion vector of the"]
    #[doc = " current event. For gesture events that are not of type"]
    #[doc = " @ref LIBINPUT_EVENT_GESTURE_SWIPE_UPDATE or"]
    #[doc = " @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE, this function returns 0."]
    #[doc = ""]
    #[doc = " Relative unaccelerated motion deltas are normalized to represent those of a"]
    #[doc = " device with 1000dpi resolution. See the libinput documentation for more"]
    #[doc = " details. Note that unaccelerated events are not equivalent to 'raw' events"]
    #[doc = " as read from the device."]
    #[doc = ""]
    #[doc = " Any rotation applied to the device also applies to gesture motion"]
    #[doc = " (see libinput_device_config_rotation_set_angle())."]
    #[doc = ""]
    #[doc = " @return the unaccelerated relative y movement since the last event"]
    pub fn libinput_event_gesture_get_dy_unaccelerated(event: *mut libinput_event_gesture) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_gesture"]
    #[doc = ""]
    #[doc = " Return the absolute scale of a pinch gesture, the scale is the division"]
    #[doc = " of the current distance between the fingers and the distance at the start"]
    #[doc = " of the gesture. The scale begins at 1.0, and if e.g. the fingers moved"]
    #[doc = " together by 50% then the scale will become 0.5, if they move twice as far"]
    #[doc = " apart as initially the scale becomes 2.0, etc."]
    #[doc = ""]
    #[doc = " For gesture events that are of type @ref"]
    #[doc = " LIBINPUT_EVENT_GESTURE_PINCH_BEGIN, this function returns 1.0."]
    #[doc = ""]
    #[doc = " For gesture events that are of type @ref"]
    #[doc = " LIBINPUT_EVENT_GESTURE_PINCH_END, this function returns the scale value"]
    #[doc = " of the most recent @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE event (if"]
    #[doc = " any) or 1.0 otherwise."]
    #[doc = ""]
    #[doc = " For all other events this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_GESTURE_PINCH_BEGIN, @ref"]
    #[doc = " LIBINPUT_EVENT_GESTURE_PINCH_END or"]
    #[doc = " @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE."]
    #[doc = ""]
    #[doc = " @return the absolute scale of a pinch gesture"]
    pub fn libinput_event_gesture_get_scale(event: *mut libinput_event_gesture) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_gesture"]
    #[doc = ""]
    #[doc = " Return the angle delta in degrees between the last and the current @ref"]
    #[doc = " LIBINPUT_EVENT_GESTURE_PINCH_UPDATE event. For gesture events that"]
    #[doc = " are not of type @ref LIBINPUT_EVENT_GESTURE_PINCH_UPDATE, this"]
    #[doc = " function returns 0."]
    #[doc = ""]
    #[doc = " The angle delta is defined as the change in angle of the line formed by"]
    #[doc = " the 2 fingers of a pinch gesture. Clockwise rotation is represented"]
    #[doc = " by a positive delta, counter-clockwise by a negative delta. If e.g. the"]
    #[doc = " fingers are on the 12 and 6 location of a clock face plate and they move"]
    #[doc = " to the 1 resp. 7 location in a single event then the angle delta is"]
    #[doc = " 30 degrees."]
    #[doc = ""]
    #[doc = " If more than two fingers are present, the angle represents the rotation"]
    #[doc = " around the center of gravity. The calculation of the center of gravity is"]
    #[doc = " implementation-dependent."]
    #[doc = ""]
    #[doc = " @return the angle delta since the last event"]
    pub fn libinput_event_gesture_get_angle_delta(event: *mut libinput_event_gesture) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " @return The generic libinput_event of this event"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_base_event(
        event: *mut libinput_event_tablet_tool,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Check if the x axis was updated in this event."]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other"]
    #[doc = " than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return 1 if the axis was updated or 0 otherwise"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_x_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Check if the y axis was updated in this event."]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other"]
    #[doc = " than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return 1 if the axis was updated or 0 otherwise"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_y_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Check if the pressure axis was updated in this event."]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other"]
    #[doc = " than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return 1 if the axis was updated or 0 otherwise"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_pressure_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Check if the distance axis was updated in this event."]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0."]
    #[doc = " For tablet tool events of type @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY,"]
    #[doc = " this function always returns 1."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other"]
    #[doc = " than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return 1 if the axis was updated or 0 otherwise"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_distance_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Check if the tilt x axis was updated in this event."]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other"]
    #[doc = " than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return 1 if the axis was updated or 0 otherwise"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_tilt_x_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Check if the tilt y axis was updated in this event."]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other"]
    #[doc = " than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return 1 if the axis was updated or 0 otherwise"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_tilt_y_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Check if the z-rotation axis was updated in this event."]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other"]
    #[doc = " than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return 1 if the axis was updated or 0 otherwise"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_rotation_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Check if the slider axis was updated in this event."]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other"]
    #[doc = " than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return 1 if the axis was updated or 0 otherwise"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_slider_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Check if the size major axis was updated in this event."]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other"]
    #[doc = " than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return 1 if the axis was updated or 0 otherwise"]
    pub fn libinput_event_tablet_tool_size_major_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Check if the size minor axis was updated in this event."]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other"]
    #[doc = " than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return 1 if the axis was updated or 0 otherwise"]
    pub fn libinput_event_tablet_tool_size_minor_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Check if the wheel axis was updated in this event."]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS,"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_TIP, or"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other"]
    #[doc = " than @ref LIBINPUT_EVENT_TABLET_TOOL_AXIS, @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_TIP, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY, or @ref"]
    #[doc = " LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return 1 if the axis was updated or 0 otherwise"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_wheel_has_changed(
        event: *mut libinput_event_tablet_tool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the X coordinate of the tablet tool, in mm from the top left"]
    #[doc = " corner of the tablet in its current logical orientation. Use"]
    #[doc = " libinput_event_tablet_tool_get_x_transformed() for transforming the axis"]
    #[doc = " value into a different coordinate space."]
    #[doc = ""]
    #[doc = " @note On some devices, returned value may be negative or larger than the"]
    #[doc = " width of the device. See the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The current value of the the axis"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_x(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the Y coordinate of the tablet tool, in mm from the top left"]
    #[doc = " corner of the tablet in its current logical orientation. Use"]
    #[doc = " libinput_event_tablet_tool_get_y_transformed() for transforming the axis"]
    #[doc = " value into a different coordinate space."]
    #[doc = ""]
    #[doc = " @note On some devices, returned value may be negative or larger than the"]
    #[doc = " width of the device. See the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The current value of the the axis"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_y(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return the delta between the last event and the current event."]
    #[doc = " If the tool employs pointer acceleration, the delta returned by this"]
    #[doc = " function is the accelerated delta."]
    #[doc = ""]
    #[doc = " This value is in screen coordinate space, the delta is to be interpreted"]
    #[doc = " like the return value of libinput_event_pointer_get_dx()."]
    #[doc = " See the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet event"]
    #[doc = " @return The relative x movement since the last event"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_dx(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return the delta between the last event and the current event."]
    #[doc = " If the tool employs pointer acceleration, the delta returned by this"]
    #[doc = " function is the accelerated delta."]
    #[doc = ""]
    #[doc = " This value is in screen coordinate space, the delta is to be interpreted"]
    #[doc = " like the return value of libinput_event_pointer_get_dx()."]
    #[doc = " See the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet event"]
    #[doc = " @return The relative y movement since the last event"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_dy(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the current pressure being applied on the tool in use, normalized"]
    #[doc = " to the range [0, 1]."]
    #[doc = ""]
    #[doc = " If this axis does not exist on the current tool, this function returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The current value of the the axis"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_pressure(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the current distance from the tablet's sensor, normalized to the"]
    #[doc = " range [0, 1]."]
    #[doc = ""]
    #[doc = " If this axis does not exist on the current tool, this function returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The current value of the the axis"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_distance(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the current tilt along the X axis of the tablet's current logical"]
    #[doc = " orientation, in degrees off the tablet's z axis. That is, if the tool is"]
    #[doc = " perfectly orthogonal to the tablet, the tilt angle is 0. When the top"]
    #[doc = " tilts towards the logical top/left of the tablet, the x/y tilt angles are"]
    #[doc = " negative, if the top tilts towards the logical bottom/right of the"]
    #[doc = " tablet, the x/y tilt angles are positive."]
    #[doc = ""]
    #[doc = " If this axis does not exist on the current tool, this function returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The current value of the axis in degrees"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_tilt_x(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the current tilt along the Y axis of the tablet's current logical"]
    #[doc = " orientation, in degrees off the tablet's z axis. That is, if the tool is"]
    #[doc = " perfectly orthogonal to the tablet, the tilt angle is 0. When the top"]
    #[doc = " tilts towards the logical top/left of the tablet, the x/y tilt angles are"]
    #[doc = " negative, if the top tilts towards the logical bottom/right of the"]
    #[doc = " tablet, the x/y tilt angles are positive."]
    #[doc = ""]
    #[doc = " If this axis does not exist on the current tool, this function returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The current value of the the axis in degrees"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_tilt_y(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the current z rotation of the tool in degrees, clockwise from the"]
    #[doc = " tool's logical neutral position."]
    #[doc = ""]
    #[doc = " For tools of type @ref LIBINPUT_TABLET_TOOL_TYPE_MOUSE and @ref"]
    #[doc = " LIBINPUT_TABLET_TOOL_TYPE_LENS the logical neutral position is"]
    #[doc = " pointing to the current logical north of the tablet. For tools of type @ref"]
    #[doc = " LIBINPUT_TABLET_TOOL_TYPE_BRUSH, the logical neutral position is with the"]
    #[doc = " buttons pointing up."]
    #[doc = ""]
    #[doc = " If this axis does not exist on the current tool, this function returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The current value of the the axis"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_rotation(event: *mut libinput_event_tablet_tool) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the current position of the slider on the tool, normalized to the"]
    #[doc = " range [-1, 1]. The logical zero is the neutral position of the slider, or"]
    #[doc = " the logical center of the axis. This axis is available on e.g. the Wacom"]
    #[doc = " Airbrush."]
    #[doc = ""]
    #[doc = " If this axis does not exist on the current tool, this function returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The current value of the the axis"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_slider_position(
        event: *mut libinput_event_tablet_tool,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the current size in mm along the major axis of the touching"]
    #[doc = " ellipse. This axis is not necessarily aligned with either x or y, the"]
    #[doc = " rotation must be taken into account."]
    #[doc = ""]
    #[doc = " Where no rotation is available on a tool, or where rotation is zero, the"]
    #[doc = " major axis aligns with the y axis and the minor axis with the x axis."]
    #[doc = ""]
    #[doc = " If this axis does not exist on the current tool, this function returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The current value of the axis major in mm"]
    pub fn libinput_event_tablet_tool_get_size_major(event: *mut libinput_event_tablet_tool)
        -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the current size in mm along the minor axis of the touching"]
    #[doc = " ellipse. This axis is not necessarily aligned with either x or y, the"]
    #[doc = " rotation must be taken into account."]
    #[doc = ""]
    #[doc = " Where no rotation is available on a tool, or where rotation is zero, the"]
    #[doc = " minor axis aligns with the y axis and the minor axis with the x axis."]
    #[doc = ""]
    #[doc = " If this axis does not exist on the current tool, this function returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The current value of the axis minor in mm"]
    pub fn libinput_event_tablet_tool_get_size_minor(event: *mut libinput_event_tablet_tool)
        -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return the delta for the wheel in degrees."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The delta of the wheel, in degrees, compared to the last event"]
    #[doc = ""]
    #[doc = " @see libinput_event_tablet_tool_get_wheel_delta_discrete"]
    pub fn libinput_event_tablet_tool_get_wheel_delta(
        event: *mut libinput_event_tablet_tool,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return the delta for the wheel in discrete steps (e.g. wheel clicks)."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The delta of the wheel, in discrete steps, compared to the last event"]
    #[doc = ""]
    #[doc = " @see libinput_event_tablet_tool_get_wheel_delta_discrete"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_wheel_delta_discrete(
        event: *mut libinput_event_tablet_tool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return the current absolute x coordinate of the tablet tool event,"]
    #[doc = " transformed to screen coordinates."]
    #[doc = ""]
    #[doc = " @note This function may be called for a specific axis even if"]
    #[doc = " libinput_event_tablet_tool_*_has_changed() returns 0 for that axis."]
    #[doc = " libinput always includes all device axes in the event."]
    #[doc = ""]
    #[doc = " @note On some devices, returned value may be negative or larger than the"]
    #[doc = " width of the device. See the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @param width The current output screen width"]
    #[doc = " @return the current absolute x coordinate transformed to a screen coordinate"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_x_transformed(
        event: *mut libinput_event_tablet_tool,
        width: u32,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return the current absolute y coordinate of the tablet tool event,"]
    #[doc = " transformed to screen coordinates."]
    #[doc = ""]
    #[doc = " @note This function may be called for a specific axis even if"]
    #[doc = " libinput_event_tablet_tool_*_has_changed() returns 0 for that axis."]
    #[doc = " libinput always includes all device axes in the event."]
    #[doc = ""]
    #[doc = " @note On some devices, returned value may be negative or larger than the"]
    #[doc = " width of the device. See the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @param height The current output screen height"]
    #[doc = " @return the current absolute y coordinate transformed to a screen coordinate"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_y_transformed(
        event: *mut libinput_event_tablet_tool,
        height: u32,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the tool that was in use during this event."]
    #[doc = ""]
    #[doc = " The returned tablet tool is not refcounted and may become invalid after"]
    #[doc = " the next call to libinput. Use libinput_tablet_tool_ref() and"]
    #[doc = " libinput_tablet_tool_unref() to continue using the handle outside of the"]
    #[doc = " immediate scope."]
    #[doc = ""]
    #[doc = " If the caller holds at least one reference, this struct is used"]
    #[doc = " whenever the tools enters proximity again."]
    #[doc = ""]
    #[doc = " @note Physical tool tracking requires hardware support. If unavailable,"]
    #[doc = " libinput creates one tool per type per tablet. See"]
    #[doc = " libinput_tablet_tool_get_serial() for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The new tool triggering this event"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_tool(
        event: *mut libinput_event_tablet_tool,
    ) -> *mut libinput_tablet_tool;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the new proximity state of a tool from a proximity event."]
    #[doc = " Used to check whether or not a tool came in or out of proximity during an"]
    #[doc = " event of type @ref LIBINPUT_EVENT_TABLET_TOOL_PROXIMITY."]
    #[doc = ""]
    #[doc = " The proximity state represents the logical proximity state which does not"]
    #[doc = " necessarily match when a tool comes into sensor range or leaves the"]
    #[doc = " sensor range. On some tools this range does not represent the physical"]
    #[doc = " range but a reduced tool-specific logical range. If the range is reduced,"]
    #[doc = " this is done transparent to the caller."]
    #[doc = ""]
    #[doc = " For example, the Wacom mouse and lens cursor tools are usually"]
    #[doc = " used in relative mode, lying flat on the tablet. Movement typically follows"]
    #[doc = " the interaction normal mouse movements have, i.e. slightly lift the tool and"]
    #[doc = " place it in a separate location. The proximity detection on Wacom"]
    #[doc = " tablets however extends further than the user may lift the mouse, i.e. the"]
    #[doc = " tool may not be lifted out of physical proximity. For such tools, libinput"]
    #[doc = " provides software-emulated proximity."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The new proximity state of the tool from the event."]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_proximity_state(
        event: *mut libinput_event_tablet_tool,
    ) -> libinput_tablet_tool_proximity_state;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Returns the new tip state of a tool from a tip event."]
    #[doc = " Used to check whether or not a tool came in contact with the tablet"]
    #[doc = " surface or left contact with the tablet surface during an"]
    #[doc = " event of type @ref LIBINPUT_EVENT_TABLET_TOOL_TIP."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The new tip state of the tool from the event."]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_tip_state(
        event: *mut libinput_event_tablet_tool,
    ) -> libinput_tablet_tool_tip_state;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return the button that triggered this event.  For events that are not of"]
    #[doc = " type @ref LIBINPUT_EVENT_TABLET_TOOL_BUTTON, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return the button triggering this event"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_button(event: *mut libinput_event_tablet_tool) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return the button state of the event."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_BUTTON."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return the button state triggering this event"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_button_state(
        event: *mut libinput_event_tablet_tool,
    ) -> libinput_button_state;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " For the button of a @ref LIBINPUT_EVENT_TABLET_TOOL_BUTTON event, return the total"]
    #[doc = " number of buttons pressed on all devices on the associated seat after the"]
    #[doc = " the event was triggered."]
    #[doc = ""]
    #[doc = "\" @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_TOOL_BUTTON. For other events, this function returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return the seat wide pressed button count for the key of this event"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_seat_button_count(
        event: *mut libinput_event_tablet_tool,
    ) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The event time for this event"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_time(event: *mut libinput_event_tablet_tool) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet tool event"]
    #[doc = " @return The event time for this event in microseconds"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_event_tablet_tool_get_time_usec(event: *mut libinput_event_tablet_tool) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return the high-level tool type for a tool object."]
    #[doc = ""]
    #[doc = " The high level tool describes general interaction expected with the tool."]
    #[doc = " For example, a user would expect a tool of type @ref"]
    #[doc = " LIBINPUT_TABLET_TOOL_TYPE_PEN to interact with a graphics application"]
    #[doc = " taking pressure and tilt into account. The default virtual tool assigned"]
    #[doc = " should be a drawing tool, e.g. a virtual pen or brush."]
    #[doc = " A tool of type @ref LIBINPUT_TABLET_TOOL_TYPE_ERASER would normally be"]
    #[doc = " mapped to an eraser-like virtual tool."]
    #[doc = ""]
    #[doc = " If supported by the hardware, a more specific tool id is always"]
    #[doc = " available, see libinput_tablet_tool_get_tool_id()."]
    #[doc = ""]
    #[doc = " @param tool The libinput tool"]
    #[doc = " @return The tool type for this tool object"]
    #[doc = ""]
    #[doc = " @see libinput_tablet_tool_get_tool_id"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_get_type(
        tool: *mut libinput_tablet_tool,
    ) -> libinput_tablet_tool_type;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return the tool ID for a tool object. If nonzero, this number identifies"]
    #[doc = " the specific type of the tool with more precision than the type returned in"]
    #[doc = " libinput_tablet_tool_get_type(). Not all tablets support a tool ID."]
    #[doc = ""]
    #[doc = " Tablets known to support tool IDs include the Wacom Intuos 3, 4, 5, Wacom"]
    #[doc = " Cintiq and Wacom Intuos Pro series. The tool ID can be used to"]
    #[doc = " distinguish between e.g. a Wacom Classic Pen or a Wacom Pro Pen.  It is"]
    #[doc = " the caller's responsibility to interpret the tool ID."]
    #[doc = ""]
    #[doc = " @param tool The libinput tool"]
    #[doc = " @return The tool ID for this tool object or 0 if none is provided"]
    #[doc = ""]
    #[doc = " @see libinput_tablet_tool_get_type"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_get_tool_id(tool: *mut libinput_tablet_tool) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Increment the reference count of the tool by one. A tool is destroyed"]
    #[doc = " whenever the reference count reaches 0. See libinput_tablet_tool_unref()."]
    #[doc = ""]
    #[doc = " @param tool The tool to increment the ref count of"]
    #[doc = " @return The passed tool"]
    #[doc = ""]
    #[doc = " @see libinput_tablet_tool_unref"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_ref(tool: *mut libinput_tablet_tool) -> *mut libinput_tablet_tool;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Decrement the reference count of the tool by one. When the reference"]
    #[doc = " count of the tool reaches 0, the memory allocated for the tool will be"]
    #[doc = " freed."]
    #[doc = ""]
    #[doc = " @param tool The tool to decrement the ref count of"]
    #[doc = " @return NULL if the tool was destroyed otherwise the passed tool"]
    #[doc = ""]
    #[doc = " @see libinput_tablet_tool_ref"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_unref(tool: *mut libinput_tablet_tool)
        -> *mut libinput_tablet_tool;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return whether the tablet tool supports pressure."]
    #[doc = ""]
    #[doc = " @param tool The tool to check the axis capabilities of"]
    #[doc = " @return Nonzero if the axis is available, zero otherwise."]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_has_pressure(tool: *mut libinput_tablet_tool) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return whether the tablet tool supports distance."]
    #[doc = ""]
    #[doc = " @param tool The tool to check the axis capabilities of"]
    #[doc = " @return Nonzero if the axis is available, zero otherwise."]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_has_distance(tool: *mut libinput_tablet_tool) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return whether the tablet tool supports tilt."]
    #[doc = ""]
    #[doc = " @param tool The tool to check the axis capabilities of"]
    #[doc = " @return Nonzero if the axis is available, zero otherwise."]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_has_tilt(tool: *mut libinput_tablet_tool) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return whether the tablet tool supports z-rotation."]
    #[doc = ""]
    #[doc = " @param tool The tool to check the axis capabilities of"]
    #[doc = " @return Nonzero if the axis is available, zero otherwise."]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_has_rotation(tool: *mut libinput_tablet_tool) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return whether the tablet tool has a slider axis."]
    #[doc = ""]
    #[doc = " @param tool The tool to check the axis capabilities of"]
    #[doc = " @return Nonzero if the axis is available, zero otherwise."]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_has_slider(tool: *mut libinput_tablet_tool) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return whether the tablet tool has a ellipsis major and minor."]
    #[doc = " Where the underlying hardware only supports one of either major or minor,"]
    #[doc = " libinput emulates the other axis as a circular contact, i.e. major =="]
    #[doc = " minor for all values of major."]
    #[doc = ""]
    #[doc = " @param tool The tool to check the axis capabilities of"]
    #[doc = " @return Nonzero if the axis is available, zero otherwise."]
    pub fn libinput_tablet_tool_has_size(tool: *mut libinput_tablet_tool) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return whether the tablet tool has a relative wheel."]
    #[doc = ""]
    #[doc = " @param tool The tool to check the axis capabilities of"]
    #[doc = " @return Nonzero if the axis is available, zero otherwise."]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_has_wheel(tool: *mut libinput_tablet_tool) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Check if a tablet tool has a button with the"]
    #[doc = " passed-in code (see linux/input.h)."]
    #[doc = ""]
    #[doc = " @param tool A tablet tool"]
    #[doc = " @param code button code to check for"]
    #[doc = ""]
    #[doc = " @return 1 if the tool supports this button code, 0 if it does not"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_has_button(
        tool: *mut libinput_tablet_tool,
        code: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return nonzero if the physical tool can be uniquely identified by"]
    #[doc = " libinput, or nonzero otherwise. If a tool can be uniquely identified,"]
    #[doc = " keeping a reference to the tool allows tracking the tool across"]
    #[doc = " proximity out sequences and across compatible tablets."]
    #[doc = " See libinput_tablet_tool_get_serial() for more details."]
    #[doc = ""]
    #[doc = " @param tool A tablet tool"]
    #[doc = " @return 1 if the tool can be uniquely identified, 0 otherwise."]
    #[doc = ""]
    #[doc = " @see libinput_tablet_tool_get_serial"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_is_unique(tool: *mut libinput_tablet_tool) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return the serial number of a tool. If the tool does not report a serial"]
    #[doc = " number, this function returns zero."]
    #[doc = ""]
    #[doc = " Some tools provide hardware information that enables libinput to uniquely"]
    #[doc = " identify the physical device. For example, tools compatible with the"]
    #[doc = " Wacom Intuos 4, Intuos 5, Intuos Pro and Cintiq series are uniquely"]
    #[doc = " identifiable through a serial number. libinput does not specify how a"]
    #[doc = " tool can be identified uniquely, a caller should use"]
    #[doc = " libinput_tablet_tool_is_unique() to check if the tool is unique."]
    #[doc = ""]
    #[doc = " libinput creates a struct @ref libinput_tablet_tool on the first"]
    #[doc = " proximity in of this tool. By default, this struct is destroyed on"]
    #[doc = " proximity out and re-initialized on the next proximity in. If a caller"]
    #[doc = " keeps a reference to the tool by using libinput_tablet_tool_ref()"]
    #[doc = " libinput re-uses this struct whenever that same physical tool comes into"]
    #[doc = " proximity on any tablet"]
    #[doc = " recognized by libinput. It is possible to attach tool-specific virtual"]
    #[doc = " state to the tool. For example, a graphics program such as the GIMP may"]
    #[doc = " assign a specific color to each tool, allowing the artist to use the"]
    #[doc = " tools like physical pens of different color. In multi-tablet setups it is"]
    #[doc = " also possible to track the tool across devices."]
    #[doc = ""]
    #[doc = " If the tool does not have a unique identifier, libinput creates a single"]
    #[doc = " struct @ref libinput_tablet_tool per tool type on each tablet the tool is"]
    #[doc = " used on."]
    #[doc = ""]
    #[doc = " @param tool The libinput tool"]
    #[doc = " @return The tool serial number"]
    #[doc = ""]
    #[doc = " @see libinput_tablet_tool_is_unique"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_get_serial(tool: *mut libinput_tablet_tool) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Return the user data associated with a tool object. libinput does"]
    #[doc = " not manage, look at, or modify this data. The caller must ensure the"]
    #[doc = " data is valid."]
    #[doc = ""]
    #[doc = " @param tool The libinput tool"]
    #[doc = " @return The user data associated with the tool object"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_get_user_data(
        tool: *mut libinput_tablet_tool,
    ) -> *mut ::libc::c_void;
}
extern "C" {
    #[doc = " @ingroup event_tablet"]
    #[doc = ""]
    #[doc = " Set the user data associated with a tool object, if any."]
    #[doc = ""]
    #[doc = " @param tool The libinput tool"]
    #[doc = " @param user_data The user data to associate with the tool object"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_tablet_tool_set_user_data(
        tool: *mut libinput_tablet_tool,
        user_data: *mut ::libc::c_void,
    );
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " @return The generic libinput_event of this event"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_event_tablet_pad_get_base_event(
        event: *mut libinput_event_tablet_pad,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " Returns the current position of the ring, in degrees counterclockwise"]
    #[doc = " from the northern-most point of the ring in the tablet's current logical"]
    #[doc = " orientation."]
    #[doc = ""]
    #[doc = " If the source is @ref LIBINPUT_TABLET_PAD_RING_SOURCE_FINGER,"]
    #[doc = " libinput sends a terminating event with a ring value of -1 when the"]
    #[doc = " finger is lifted from the ring. A caller may use this information to e.g."]
    #[doc = " determine if kinetic scrolling should be triggered."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_PAD_RING.  For other events, this function"]
    #[doc = " returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return The current value of the the axis"]
    #[doc = " @retval -1 The finger was lifted"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_event_tablet_pad_get_ring_position(
        event: *mut libinput_event_tablet_pad,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " Returns the number of the ring that has changed state, with 0 being the"]
    #[doc = " first ring. On tablets with only one ring, this function always returns"]
    #[doc = " 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_PAD_RING.  For other events, this function"]
    #[doc = " returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return The index of the ring that changed state"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_event_tablet_pad_get_ring_number(
        event: *mut libinput_event_tablet_pad,
    ) -> ::libc::c_uint;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " Returns the source of the interaction with the ring. If the source is"]
    #[doc = " @ref LIBINPUT_TABLET_PAD_RING_SOURCE_FINGER, libinput sends a ring"]
    #[doc = " position value of -1 to terminate the current interaction."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_PAD_RING.  For other events, this function"]
    #[doc = " returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return The source of the ring interaction"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_event_tablet_pad_get_ring_source(
        event: *mut libinput_event_tablet_pad,
    ) -> libinput_tablet_pad_ring_axis_source;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " Returns the current position of the strip, normalized to the range"]
    #[doc = " [0, 1], with 0 being the top/left-most point in the tablet's current"]
    #[doc = " logical orientation."]
    #[doc = ""]
    #[doc = " If the source is @ref LIBINPUT_TABLET_PAD_STRIP_SOURCE_FINGER,"]
    #[doc = " libinput sends a terminating event with a ring value of -1 when the"]
    #[doc = " finger is lifted from the ring. A caller may use this information to e.g."]
    #[doc = " determine if kinetic scrolling should be triggered."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_PAD_STRIP.  For other events, this function"]
    #[doc = " returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return The current value of the the axis"]
    #[doc = " @retval -1 The finger was lifted"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_event_tablet_pad_get_strip_position(
        event: *mut libinput_event_tablet_pad,
    ) -> f64;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " Returns the number of the strip that has changed state, with 0 being the"]
    #[doc = " first strip. On tablets with only one strip, this function always returns"]
    #[doc = " 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_PAD_STRIP.  For other events, this function"]
    #[doc = " returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return The index of the strip that changed state"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_event_tablet_pad_get_strip_number(
        event: *mut libinput_event_tablet_pad,
    ) -> ::libc::c_uint;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " Returns the source of the interaction with the strip. If the source is"]
    #[doc = " @ref LIBINPUT_TABLET_PAD_STRIP_SOURCE_FINGER, libinput sends a strip"]
    #[doc = " position value of -1 to terminate the current interaction."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_PAD_STRIP.  For other events, this function"]
    #[doc = " returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return The source of the strip interaction"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_event_tablet_pad_get_strip_source(
        event: *mut libinput_event_tablet_pad,
    ) -> libinput_tablet_pad_strip_axis_source;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " Return the button number that triggered this event, starting at 0."]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON,"]
    #[doc = " this function returns 0."]
    #[doc = ""]
    #[doc = " Note that the number returned is a generic sequential button number and"]
    #[doc = " not a semantic button code as defined in linux/input.h."]
    #[doc = " See the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON. For other events, this function"]
    #[doc = " returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return the button triggering this event"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_event_tablet_pad_get_button_number(
        event: *mut libinput_event_tablet_pad,
    ) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " Return the button state of the event."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_PAD_BUTTON. For other events, this function"]
    #[doc = " returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return the button state triggering this event"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_event_tablet_pad_get_button_state(
        event: *mut libinput_event_tablet_pad,
    ) -> libinput_button_state;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " Return the key code that triggered this event, e.g. KEY_CONTROLPANEL. The"]
    #[doc = " list of key codes is defined in linux/input-event-codes.h."]
    #[doc = ""]
    #[doc = " For events that are not of type @ref LIBINPUT_EVENT_TABLET_PAD_KEY,"]
    #[doc = " this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_PAD_KEY. For other events, this function"]
    #[doc = " returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return the key code triggering this event"]
    #[doc = ""]
    #[doc = " @since 1.15"]
    pub fn libinput_event_tablet_pad_get_key(event: *mut libinput_event_tablet_pad) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " Return the key state of the event."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_TABLET_PAD_KEY. For other events, this function"]
    #[doc = " returns 0."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return the key state triggering this event"]
    #[doc = ""]
    #[doc = " @since 1.15"]
    pub fn libinput_event_tablet_pad_get_key_state(
        event: *mut libinput_event_tablet_pad,
    ) -> libinput_key_state;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " Returns the mode the button, ring, or strip that triggered this event is"]
    #[doc = " in, at the time of the event."]
    #[doc = ""]
    #[doc = " The mode is a virtual grouping of functionality, usually based on some"]
    #[doc = " visual feedback like LEDs on the pad. Mode indices start at 0, a device"]
    #[doc = " that does not support modes always returns 0."]
    #[doc = ""]
    #[doc = " @note Pad keys are not part of a mode group. It is an application bug to"]
    #[doc = " call this function for @ref LIBINPUT_EVENT_TABLET_PAD_KEY."]
    #[doc = ""]
    #[doc = " Mode switching is controlled by libinput and more than one mode may exist"]
    #[doc = " on the tablet. This function returns the mode that this event's button,"]
    #[doc = " ring or strip is logically in. If the button is a mode toggle button"]
    #[doc = " and the button event caused a new mode to be toggled, the mode returned"]
    #[doc = " is the new mode the button is in."]
    #[doc = ""]
    #[doc = " Note that the returned mode is the mode valid as of the time of the"]
    #[doc = " event. The returned mode may thus be different to the mode returned by"]
    #[doc = " libinput_tablet_pad_mode_group_get_mode(). See"]
    #[doc = " libinput_tablet_pad_mode_group_get_mode() for details."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return the 0-indexed mode of this button, ring or strip at the time of"]
    #[doc = " the event"]
    #[doc = ""]
    #[doc = " @see libinput_tablet_pad_mode_group_get_mode"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_event_tablet_pad_get_mode(
        event: *mut libinput_event_tablet_pad,
    ) -> ::libc::c_uint;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " Returns the mode group that the button, ring, or strip that triggered"]
    #[doc = " this event is considered in. The mode is a virtual grouping of"]
    #[doc = " functionality, usually based on some visual feedback like LEDs on the"]
    #[doc = " pad."]
    #[doc = ""]
    #[doc = " @note Pad keys are not part of a mode group. It is an application bug to"]
    #[doc = " call this function for @ref LIBINPUT_EVENT_TABLET_PAD_KEY."]
    #[doc = ""]
    #[doc = " The returned mode group is not refcounted and may become invalid after"]
    #[doc = " the next call to libinput. Use libinput_tablet_pad_mode_group_ref() and"]
    #[doc = " libinput_tablet_pad_mode_group_unref() to continue using the handle"]
    #[doc = " outside of the immediate scope."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return the mode group of the button, ring or strip that caused this event"]
    #[doc = ""]
    #[doc = " @see libinput_device_tablet_pad_get_mode_group"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_event_tablet_pad_get_mode_group(
        event: *mut libinput_event_tablet_pad,
    ) -> *mut libinput_tablet_pad_mode_group;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return The event time for this event"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_event_tablet_pad_get_time(event: *mut libinput_event_tablet_pad) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_tablet_pad"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput tablet pad event"]
    #[doc = " @return The event time for this event in microseconds"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_event_tablet_pad_get_time_usec(event: *mut libinput_event_tablet_pad) -> u64;
}
extern "C" {
    #[doc = " @ingroup event_switch"]
    #[doc = ""]
    #[doc = " Return the switch that triggered this event."]
    #[doc = " For pointer events that are not of type @ref"]
    #[doc = " LIBINPUT_EVENT_SWITCH_TOGGLE, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_SWITCH_TOGGLE."]
    #[doc = ""]
    #[doc = " @param event The libinput switch event"]
    #[doc = " @return The switch triggering this event"]
    #[doc = ""]
    #[doc = " @since 1.7"]
    pub fn libinput_event_switch_get_switch(event: *mut libinput_event_switch) -> libinput_switch;
}
extern "C" {
    #[doc = " @ingroup event_switch"]
    #[doc = ""]
    #[doc = " Return the switch state that triggered this event."]
    #[doc = " For switch events that are not of type @ref"]
    #[doc = " LIBINPUT_EVENT_SWITCH_TOGGLE, this function returns 0."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for events other than"]
    #[doc = " @ref LIBINPUT_EVENT_SWITCH_TOGGLE."]
    #[doc = ""]
    #[doc = " @param event The libinput switch event"]
    #[doc = " @return The switch state triggering this event"]
    #[doc = ""]
    #[doc = " @since 1.7"]
    pub fn libinput_event_switch_get_switch_state(
        event: *mut libinput_event_switch,
    ) -> libinput_switch_state;
}
extern "C" {
    #[doc = " @ingroup event_switch"]
    #[doc = ""]
    #[doc = " @return The generic libinput_event of this event"]
    #[doc = ""]
    #[doc = " @since 1.7"]
    pub fn libinput_event_switch_get_base_event(
        event: *mut libinput_event_switch,
    ) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup event_switch"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput switch event"]
    #[doc = " @return The event time for this event"]
    #[doc = ""]
    #[doc = " @since 1.7"]
    pub fn libinput_event_switch_get_time(event: *mut libinput_event_switch) -> u32;
}
extern "C" {
    #[doc = " @ingroup event_switch"]
    #[doc = ""]
    #[doc = " @note Timestamps may not always increase. See the libinput documentation"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " @param event The libinput switch event"]
    #[doc = " @return The event time for this event in microseconds"]
    #[doc = ""]
    #[doc = " @since 1.7"]
    pub fn libinput_event_switch_get_time_usec(event: *mut libinput_event_switch) -> u64;
}
#[doc = " @ingroup base"]
#[doc = " @struct libinput_interface"]
#[doc = ""]
#[doc = " libinput does not open file descriptors to devices directly, instead"]
#[doc = " open_restricted() and close_restricted() are called for each path that"]
#[doc = " must be opened."]
#[doc = ""]
#[doc = " @see libinput_udev_create_context"]
#[doc = " @see libinput_path_create_context"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct libinput_interface {
    #[doc = " Open the device at the given path with the flags provided and"]
    #[doc = " return the fd."]
    #[doc = ""]
    #[doc = " @param path The device path to open"]
    #[doc = " @param flags Flags as defined by open(2)"]
    #[doc = " @param user_data The user_data provided in"]
    #[doc = " libinput_udev_create_context()"]
    #[doc = ""]
    #[doc = " @return The file descriptor, or a negative errno on failure."]
    pub open_restricted: ::std::option::Option<
        unsafe extern "C" fn(
            path: *const ::libc::c_char,
            flags: ::libc::c_int,
            user_data: *mut ::libc::c_void,
        ) -> ::libc::c_int,
    >,
    #[doc = " Close the file descriptor."]
    #[doc = ""]
    #[doc = " @param fd The file descriptor to close"]
    #[doc = " @param user_data The user_data provided in"]
    #[doc = " libinput_udev_create_context()"]
    pub close_restricted: ::std::option::Option<
        unsafe extern "C" fn(fd: ::libc::c_int, user_data: *mut ::libc::c_void),
    >,
}
#[test]
fn bindgen_test_layout_libinput_interface() {
    assert_eq!(
        ::std::mem::size_of::<libinput_interface>(),
        16usize,
        concat!("Size of: ", stringify!(libinput_interface))
    );
    assert_eq!(
        ::std::mem::align_of::<libinput_interface>(),
        8usize,
        concat!("Alignment of ", stringify!(libinput_interface))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<libinput_interface>())).open_restricted as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(libinput_interface),
            "::",
            stringify!(open_restricted)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<libinput_interface>())).close_restricted as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(libinput_interface),
            "::",
            stringify!(close_restricted)
        )
    );
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Create a new libinput context from udev. This context is inactive until"]
    #[doc = " assigned a seat ID with libinput_udev_assign_seat()."]
    #[doc = ""]
    #[doc = " @param interface The callback interface"]
    #[doc = " @param user_data Caller-specific data passed to the various callback"]
    #[doc = " interfaces."]
    #[doc = " @param udev An already initialized udev context"]
    #[doc = ""]
    #[doc = " @return An initialized, but inactive libinput context or NULL on error"]
    pub fn libinput_udev_create_context(
        interface: *const libinput_interface,
        user_data: *mut ::libc::c_void,
        udev: *mut udev,
    ) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Assign a seat to this libinput context. New devices or the removal of"]
    #[doc = " existing devices will appear as events during libinput_dispatch()."]
    #[doc = ""]
    #[doc = " libinput_udev_assign_seat() succeeds even if no input devices are currently"]
    #[doc = " available on this seat, or if devices are available but fail to open in"]
    #[doc = " @ref libinput_interface::open_restricted. Devices that do not have the"]
    #[doc = " minimum capabilities to be recognized as pointer, keyboard or touch"]
    #[doc = " device are ignored. Such devices and those that failed to open"]
    #[doc = " ignored until the next call to libinput_resume()."]
    #[doc = ""]
    #[doc = " This function may only be called once per context."]
    #[doc = ""]
    #[doc = " @param libinput A libinput context initialized with"]
    #[doc = " libinput_udev_create_context()"]
    #[doc = " @param seat_id A seat identifier. This string must not be NULL."]
    #[doc = ""]
    #[doc = " @return 0 on success or -1 on failure."]
    pub fn libinput_udev_assign_seat(
        libinput: *mut libinput,
        seat_id: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Create a new libinput context that requires the caller to manually add or"]
    #[doc = " remove devices with libinput_path_add_device() and"]
    #[doc = " libinput_path_remove_device()."]
    #[doc = ""]
    #[doc = " The context is fully initialized but will not generate events until at"]
    #[doc = " least one device has been added."]
    #[doc = ""]
    #[doc = " The reference count of the context is initialized to 1. See @ref"]
    #[doc = " libinput_unref."]
    #[doc = ""]
    #[doc = " @param interface The callback interface"]
    #[doc = " @param user_data Caller-specific data passed to the various callback"]
    #[doc = " interfaces."]
    #[doc = ""]
    #[doc = " @return An initialized, empty libinput context."]
    pub fn libinput_path_create_context(
        interface: *const libinput_interface,
        user_data: *mut ::libc::c_void,
    ) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Add a device to a libinput context initialized with"]
    #[doc = " libinput_path_create_context(). If successful, the device will be"]
    #[doc = " added to the internal list and re-opened on libinput_resume(). The device"]
    #[doc = " can be removed with libinput_path_remove_device()."]
    #[doc = ""]
    #[doc = " If the device was successfully initialized, it is returned in the device"]
    #[doc = " argument. The lifetime of the returned device pointer is limited until"]
    #[doc = " the next libinput_dispatch(), use libinput_device_ref() to keep a permanent"]
    #[doc = " reference."]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized libinput context"]
    #[doc = " @param path Path to an input device"]
    #[doc = " @return The newly initiated device on success, or NULL on failure."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function on a libinput"]
    #[doc = " context initialized with libinput_udev_create_context()."]
    pub fn libinput_path_add_device(
        libinput: *mut libinput,
        path: *const ::libc::c_char,
    ) -> *mut libinput_device;
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Remove a device from a libinput context initialized with"]
    #[doc = " libinput_path_create_context() or added to such a context with"]
    #[doc = " libinput_path_add_device()."]
    #[doc = ""]
    #[doc = " Events already processed from this input device are kept in the queue,"]
    #[doc = " the @ref LIBINPUT_EVENT_DEVICE_REMOVED event marks the end of events for"]
    #[doc = " this device."]
    #[doc = ""]
    #[doc = " If no matching device exists, this function does nothing."]
    #[doc = ""]
    #[doc = " @param device A libinput device"]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function on a libinput"]
    #[doc = " context initialized with libinput_udev_create_context()."]
    pub fn libinput_path_remove_device(device: *mut libinput_device);
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " libinput keeps a single file descriptor for all events. Call into"]
    #[doc = " libinput_dispatch() if any events become available on this fd."]
    #[doc = ""]
    #[doc = " @return The file descriptor used to notify of pending events."]
    pub fn libinput_get_fd(libinput: *mut libinput) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Main event dispatchment function. Reads events of the file descriptors"]
    #[doc = " and processes them internally. Use libinput_get_event() to retrieve the"]
    #[doc = " events."]
    #[doc = ""]
    #[doc = " Dispatching does not necessarily queue libinput events. This function"]
    #[doc = " should be called immediately once data is available on the file"]
    #[doc = " descriptor returned by libinput_get_fd(). libinput has a number of"]
    #[doc = " timing-sensitive features (e.g. tap-to-click), any delay in calling"]
    #[doc = " libinput_dispatch() may prevent these features from working correctly."]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized libinput context"]
    #[doc = ""]
    #[doc = " @return 0 on success, or a negative errno on failure"]
    pub fn libinput_dispatch(libinput: *mut libinput) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Retrieve the next event from libinput's internal event queue."]
    #[doc = ""]
    #[doc = " After handling the retrieved event, the caller must destroy it using"]
    #[doc = " libinput_event_destroy()."]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized libinput context"]
    #[doc = " @return The next available event, or NULL if no event is available."]
    pub fn libinput_get_event(libinput: *mut libinput) -> *mut libinput_event;
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Return the type of the next event in the internal queue. This function"]
    #[doc = " does not pop the event off the queue and the next call to"]
    #[doc = " libinput_get_event() returns that event."]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized libinput context"]
    #[doc = " @return The event type of the next available event or @ref"]
    #[doc = " LIBINPUT_EVENT_NONE if no event is available."]
    pub fn libinput_next_event_type(libinput: *mut libinput) -> libinput_event_type;
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Set caller-specific data associated with this context. libinput does"]
    #[doc = " not manage, look at, or modify this data. The caller must ensure the"]
    #[doc = " data is valid."]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized libinput context"]
    #[doc = " @param user_data Caller-specific data passed to the various callback"]
    #[doc = " interfaces."]
    pub fn libinput_set_user_data(libinput: *mut libinput, user_data: *mut ::libc::c_void);
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Get the caller-specific data associated with this context, if any."]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized libinput context"]
    #[doc = " @return The caller-specific data previously assigned in"]
    #[doc = " libinput_set_user_data(), libinput_path_create_context() or"]
    #[doc = " libinput_udev_create_context()."]
    pub fn libinput_get_user_data(libinput: *mut libinput) -> *mut ::libc::c_void;
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Resume a suspended libinput context. This re-enables device"]
    #[doc = " monitoring and adds existing devices."]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized libinput context"]
    #[doc = " @see libinput_suspend"]
    #[doc = ""]
    #[doc = " @return 0 on success or -1 on failure"]
    pub fn libinput_resume(libinput: *mut libinput) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Suspend monitoring for new devices and close existing devices."]
    #[doc = " This all but terminates libinput but does keep the context"]
    #[doc = " valid to be resumed with libinput_resume()."]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized libinput context"]
    pub fn libinput_suspend(libinput: *mut libinput);
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Add a reference to the context. A context is destroyed whenever the"]
    #[doc = " reference count reaches 0. See @ref libinput_unref."]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized valid libinput context"]
    #[doc = " @return The passed libinput context"]
    pub fn libinput_ref(libinput: *mut libinput) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Dereference the libinput context. After this, the context may have been"]
    #[doc = " destroyed, if the last reference was dereferenced. If so, the context is"]
    #[doc = " invalid and may not be interacted with."]
    #[doc = ""]
    #[doc = " @bug When the refcount reaches zero, libinput_unref() releases resources"]
    #[doc = " even if a caller still holds refcounted references to related resources"]
    #[doc = " (e.g. a libinput_device). When libinput_unref() returns"]
    #[doc = " NULL, the caller must consider any resources related to that context"]
    #[doc = " invalid. See https://bugs.freedesktop.org/show_bug.cgi?id=91872."]
    #[doc = ""]
    #[doc = " Example code:"]
    #[doc = " @code"]
    #[doc = " li = libinput_path_create_context(&interface, NULL);"]
    #[doc = " device = libinput_path_add_device(li, \"/dev/input/event0\");"]
    #[doc = " // get extra reference to device"]
    #[doc = " libinput_device_ref(device);"]
    #[doc = ""]
    #[doc = " // refcount reaches 0, so *all* resources are cleaned up,"]
    #[doc = " // including device"]
    #[doc = " libinput_unref(li);"]
    #[doc = ""]
    #[doc = " // INCORRECT: device has been cleaned up and must not be used"]
    #[doc = " // li = libinput_device_get_context(device);"]
    #[doc = " @endcode"]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized libinput context"]
    #[doc = " @return NULL if context was destroyed otherwise the passed context"]
    pub fn libinput_unref(libinput: *mut libinput) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Set the log priority for the libinput context. Messages with priorities"]
    #[doc = " equal to or higher than the argument will be printed to the context's"]
    #[doc = " log handler."]
    #[doc = ""]
    #[doc = " The default log priority is @ref LIBINPUT_LOG_PRIORITY_ERROR."]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized libinput context"]
    #[doc = " @param priority The minimum priority of log messages to print."]
    #[doc = ""]
    #[doc = " @see libinput_log_set_handler"]
    #[doc = " @see libinput_log_get_priority"]
    pub fn libinput_log_set_priority(libinput: *mut libinput, priority: libinput_log_priority);
}
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Get the context's log priority. Messages with priorities equal to or"]
    #[doc = " higher than the argument will be printed to the current log handler."]
    #[doc = ""]
    #[doc = " The default log priority is @ref LIBINPUT_LOG_PRIORITY_ERROR."]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized libinput context"]
    #[doc = " @return The minimum priority of log messages to print."]
    #[doc = ""]
    #[doc = " @see libinput_log_set_handler"]
    #[doc = " @see libinput_log_set_priority"]
    pub fn libinput_log_get_priority(libinput: *const libinput) -> libinput_log_priority;
}
#[doc = " @ingroup base"]
#[doc = ""]
#[doc = " Log handler type for custom logging."]
#[doc = ""]
#[doc = " @param libinput The libinput context"]
#[doc = " @param priority The priority of the current message"]
#[doc = " @param format Message format in printf-style"]
#[doc = " @param args Message arguments"]
#[doc = ""]
#[doc = " @see libinput_log_set_priority"]
#[doc = " @see libinput_log_get_priority"]
#[doc = " @see libinput_log_set_handler"]
pub type libinput_log_handler = ::std::option::Option<
    unsafe extern "C" fn(
        libinput: *mut libinput,
        priority: libinput_log_priority,
        format: *const ::libc::c_char,
        args: va_list,
    ),
>;
extern "C" {
    #[doc = " @ingroup base"]
    #[doc = ""]
    #[doc = " Set the context's log handler. Messages with priorities equal to or"]
    #[doc = " higher than the context's log priority will be passed to the given"]
    #[doc = " log handler."]
    #[doc = ""]
    #[doc = " The default log handler prints to stderr."]
    #[doc = ""]
    #[doc = " @param libinput A previously initialized libinput context"]
    #[doc = " @param log_handler The log handler for library messages."]
    #[doc = ""]
    #[doc = " @see libinput_log_set_priority"]
    #[doc = " @see libinput_log_get_priority"]
    pub fn libinput_log_set_handler(libinput: *mut libinput, log_handler: libinput_log_handler);
}
extern "C" {
    #[doc = " @ingroup seat"]
    #[doc = ""]
    #[doc = " Increase the refcount of the seat. A seat will be freed whenever the"]
    #[doc = " refcount reaches 0. This may happen during libinput_dispatch() if the"]
    #[doc = " seat was removed from the system. A caller must ensure to reference"]
    #[doc = " the seat correctly to avoid dangling pointers."]
    #[doc = ""]
    #[doc = " @param seat A previously obtained seat"]
    #[doc = " @return The passed seat"]
    pub fn libinput_seat_ref(seat: *mut libinput_seat) -> *mut libinput_seat;
}
extern "C" {
    #[doc = " @ingroup seat"]
    #[doc = ""]
    #[doc = " Decrease the refcount of the seat. A seat will be freed whenever the"]
    #[doc = " refcount reaches 0. This may happen during libinput_dispatch() if the"]
    #[doc = " seat was removed from the system. A caller must ensure to reference"]
    #[doc = " the seat correctly to avoid dangling pointers."]
    #[doc = ""]
    #[doc = " @param seat A previously obtained seat"]
    #[doc = " @return NULL if seat was destroyed, otherwise the passed seat"]
    pub fn libinput_seat_unref(seat: *mut libinput_seat) -> *mut libinput_seat;
}
extern "C" {
    #[doc = " @ingroup seat"]
    #[doc = ""]
    #[doc = " Set caller-specific data associated with this seat. libinput does"]
    #[doc = " not manage, look at, or modify this data. The caller must ensure the"]
    #[doc = " data is valid."]
    #[doc = ""]
    #[doc = " @param seat A previously obtained seat"]
    #[doc = " @param user_data Caller-specific data pointer"]
    #[doc = " @see libinput_seat_get_user_data"]
    pub fn libinput_seat_set_user_data(seat: *mut libinput_seat, user_data: *mut ::libc::c_void);
}
extern "C" {
    #[doc = " @ingroup seat"]
    #[doc = ""]
    #[doc = " Get the caller-specific data associated with this seat, if any."]
    #[doc = ""]
    #[doc = " @param seat A previously obtained seat"]
    #[doc = " @return Caller-specific data pointer or NULL if none was set"]
    #[doc = " @see libinput_seat_set_user_data"]
    pub fn libinput_seat_get_user_data(seat: *mut libinput_seat) -> *mut ::libc::c_void;
}
extern "C" {
    #[doc = " @ingroup seat"]
    #[doc = ""]
    #[doc = " Get the libinput context from the seat."]
    #[doc = ""]
    #[doc = " @param seat A previously obtained seat"]
    #[doc = " @return The libinput context for this seat."]
    pub fn libinput_seat_get_context(seat: *mut libinput_seat) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup seat"]
    #[doc = ""]
    #[doc = " Return the physical name of the seat. For libinput contexts created from"]
    #[doc = " udev, this is always the same value as passed into"]
    #[doc = " libinput_udev_assign_seat() and all seats from that context will have"]
    #[doc = " the same physical name."]
    #[doc = ""]
    #[doc = " The physical name of the seat is one that is usually set by the system or"]
    #[doc = " lower levels of the stack. In most cases, this is the base filter for"]
    #[doc = " devices - devices assigned to seats outside the current seat will not"]
    #[doc = " be available to the caller."]
    #[doc = ""]
    #[doc = " @param seat A previously obtained seat"]
    #[doc = " @return The physical name of this seat"]
    pub fn libinput_seat_get_physical_name(seat: *mut libinput_seat) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " @ingroup seat"]
    #[doc = ""]
    #[doc = " Return the logical name of the seat. This is an identifier to group sets"]
    #[doc = " of devices within the compositor."]
    #[doc = ""]
    #[doc = " @param seat A previously obtained seat"]
    #[doc = " @return The logical name of this seat"]
    pub fn libinput_seat_get_logical_name(seat: *mut libinput_seat) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Increase the refcount of the input device. An input device will be freed"]
    #[doc = " whenever the refcount reaches 0. This may happen during"]
    #[doc = " libinput_dispatch() if the device was removed from the system. A caller"]
    #[doc = " must ensure to reference the device correctly to avoid dangling pointers."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @return The passed device"]
    pub fn libinput_device_ref(device: *mut libinput_device) -> *mut libinput_device;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Decrease the refcount of the input device. An input device will be freed"]
    #[doc = " whenever the refcount reaches 0. This may happen during libinput_dispatch"]
    #[doc = " if the device was removed from the system. A caller must ensure to"]
    #[doc = " reference the device correctly to avoid dangling pointers."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @return NULL if the device was destroyed, otherwise the passed device"]
    pub fn libinput_device_unref(device: *mut libinput_device) -> *mut libinput_device;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Set caller-specific data associated with this input device. libinput does"]
    #[doc = " not manage, look at, or modify this data. The caller must ensure the"]
    #[doc = " data is valid."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @param user_data Caller-specific data pointer"]
    #[doc = " @see libinput_device_get_user_data"]
    pub fn libinput_device_set_user_data(
        device: *mut libinput_device,
        user_data: *mut ::libc::c_void,
    );
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Get the caller-specific data associated with this input device, if any."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @return Caller-specific data pointer or NULL if none was set"]
    #[doc = " @see libinput_device_set_user_data"]
    pub fn libinput_device_get_user_data(device: *mut libinput_device) -> *mut ::libc::c_void;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Get the libinput context from the device."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @return The libinput context for this device."]
    pub fn libinput_device_get_context(device: *mut libinput_device) -> *mut libinput;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Get the device group this device is assigned to. Some physical"]
    #[doc = " devices like graphics tablets are represented by multiple kernel"]
    #[doc = " devices and thus by multiple struct @ref libinput_device."]
    #[doc = ""]
    #[doc = " libinput assigns these devices to the same @ref libinput_device_group"]
    #[doc = " allowing the caller to identify such devices and adjust configuration"]
    #[doc = " settings accordingly. For example, setting a tablet to left-handed often"]
    #[doc = " means turning it upside down. A touch device on the same tablet would"]
    #[doc = " need to be turned upside down too to work correctly."]
    #[doc = ""]
    #[doc = " All devices are part of a device group though for most devices the group"]
    #[doc = " will be a singleton. A device is assigned to a device group on @ref"]
    #[doc = " LIBINPUT_EVENT_DEVICE_ADDED and removed from that group on @ref"]
    #[doc = " LIBINPUT_EVENT_DEVICE_REMOVED. It is up to the caller to track how many"]
    #[doc = " devices are in each device group."]
    #[doc = ""]
    #[doc = " @dot"]
    #[doc = " digraph groups_libinput {"]
    #[doc = "   rankdir=\"TB\";"]
    #[doc = "   node ["]
    #[doc = "     shape=\"box\";"]
    #[doc = "   ]"]
    #[doc = ""]
    #[doc = "   mouse [ label=\"mouse\"; URL=\"\\ref libinput_device\"];"]
    #[doc = "   kbd [ label=\"keyboard\"; URL=\"\\ref libinput_device\"];"]
    #[doc = ""]
    #[doc = "   pen [ label=\"tablet pen\"; URL=\"\\ref libinput_device\"];"]
    #[doc = "   touch [ label=\"tablet touch\"; URL=\"\\ref libinput_device\"];"]
    #[doc = "   pad [ label=\"tablet pad\"; URL=\"\\ref libinput_device\"];"]
    #[doc = ""]
    #[doc = "   group1 [ label=\"group 1\"; URL=\"\\ref libinput_device_group\"];"]
    #[doc = "   group2 [ label=\"group 2\"; URL=\"\\ref libinput_device_group\"];"]
    #[doc = "   group3 [ label=\"group 3\"; URL=\"\\ref libinput_device_group\"];"]
    #[doc = ""]
    #[doc = "   mouse -> group1"]
    #[doc = "   kbd -> group2"]
    #[doc = ""]
    #[doc = "   pen -> group3;"]
    #[doc = "   touch -> group3;"]
    #[doc = "   pad -> group3;"]
    #[doc = " }"]
    #[doc = " @enddot"]
    #[doc = ""]
    #[doc = " Device groups do not get re-used once the last device in the group was"]
    #[doc = " removed, i.e. unplugging and re-plugging a physical device with grouped"]
    #[doc = " devices will return a different device group after every unplug."]
    #[doc = ""]
    #[doc = " The returned device group is not refcounted and may become invalid after"]
    #[doc = " the next call to libinput. Use libinput_device_group_ref() and"]
    #[doc = " libinput_device_group_unref() to continue using the handle outside of the"]
    #[doc = " immediate scope."]
    #[doc = ""]
    #[doc = " Device groups are assigned based on the <b>LIBINPUT_DEVICE_GROUP</b> udev"]
    #[doc = " property, see the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @return The device group this device belongs to"]
    pub fn libinput_device_get_device_group(
        device: *mut libinput_device,
    ) -> *mut libinput_device_group;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Get the system name of the device."]
    #[doc = ""]
    #[doc = " To get the descriptive device name, use libinput_device_get_name()."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @return System name of the device"]
    #[doc = ""]
    pub fn libinput_device_get_sysname(device: *mut libinput_device) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " The descriptive device name as advertised by the kernel and/or the"]
    #[doc = " hardware itself. To get the sysname for this device, use"]
    #[doc = " libinput_device_get_sysname()."]
    #[doc = ""]
    #[doc = " The lifetime of the returned string is tied to the struct"]
    #[doc = " libinput_device. The string may be the empty string but is never NULL."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @return The device name"]
    pub fn libinput_device_get_name(device: *mut libinput_device) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Get the product ID for this device."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @return The product ID of this device"]
    pub fn libinput_device_get_id_product(device: *mut libinput_device) -> ::libc::c_uint;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Get the vendor ID for this device."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @return The vendor ID of this device"]
    pub fn libinput_device_get_id_vendor(device: *mut libinput_device) -> ::libc::c_uint;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " A device may be mapped to a single output, or all available outputs. If a"]
    #[doc = " device is mapped to a single output only, a relative device may not move"]
    #[doc = " beyond the boundaries of this output. An absolute device has its input"]
    #[doc = " coordinates mapped to the extents of this output."]
    #[doc = ""]
    #[doc = " @note <b>Use of this function is discouraged.</b> Its return value is not"]
    #[doc = " precisely defined and may not be understood by the caller or may be"]
    #[doc = " insufficient to map the device. Instead, the system configuration could"]
    #[doc = " set a udev property the caller understands and interprets correctly. The"]
    #[doc = " caller could then obtain device with libinput_device_get_udev_device()"]
    #[doc = " and query it for this property. For more complex cases, the caller"]
    #[doc = " must implement monitor-to-device association heuristics."]
    #[doc = ""]
    #[doc = " @return The name of the output this device is mapped to, or NULL if no"]
    #[doc = " output is set"]
    pub fn libinput_device_get_output_name(device: *mut libinput_device) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Get the seat associated with this input device."]
    #[doc = ""]
    #[doc = " A seat can be uniquely identified by the physical and logical seat name."]
    #[doc = " There will ever be only one seat instance with a given physical and logical"]
    #[doc = " seat name pair at any given time, but if no external reference is kept, it"]
    #[doc = " may be destroyed if no device belonging to it is left."]
    #[doc = ""]
    #[doc = " The returned seat is not refcounted and may become invalid after"]
    #[doc = " the next call to libinput. Use libinput_seat_ref() and"]
    #[doc = " libinput_seat_unref() to continue using the handle outside of the"]
    #[doc = " immediate scope."]
    #[doc = ""]
    #[doc = " See the libinput documentation for more information on seats."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @return The seat this input device belongs to"]
    pub fn libinput_device_get_seat(device: *mut libinput_device) -> *mut libinput_seat;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Change the logical seat associated with this device by removing the"]
    #[doc = " device and adding it to the new seat."]
    #[doc = ""]
    #[doc = " This command is identical to physically unplugging the device, then"]
    #[doc = " re-plugging it as a member of the new seat. libinput will generate a"]
    #[doc = " @ref LIBINPUT_EVENT_DEVICE_REMOVED event and this @ref libinput_device is"]
    #[doc = " considered removed from the context; it will not generate further events"]
    #[doc = " and will be freed when the refcount reaches zero."]
    #[doc = " A @ref LIBINPUT_EVENT_DEVICE_ADDED event is generated with a new @ref"]
    #[doc = " libinput_device handle. It is the caller's responsibility to update"]
    #[doc = " references to the new device accordingly."]
    #[doc = ""]
    #[doc = " If the logical seat name already exists in the device's physical seat,"]
    #[doc = " the device is added to this seat. Otherwise, a new seat is created."]
    #[doc = ""]
    #[doc = " @note This change applies to this device until removal or @ref"]
    #[doc = " libinput_suspend(), whichever happens earlier."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @param name The new logical seat name"]
    #[doc = " @return 0 on success, non-zero on error"]
    pub fn libinput_device_set_seat_logical_name(
        device: *mut libinput_device,
        name: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Return a udev handle to the device that is this libinput device, if any."]
    #[doc = " The returned handle has a refcount of at least 1, the caller must call"]
    #[doc = " <i>udev_device_unref()</i> once to release the associated resources."]
    #[doc = " See the [libudev documentation]"]
    #[doc = " (http://www.freedesktop.org/software/systemd/libudev/) for details."]
    #[doc = ""]
    #[doc = " Some devices may not have a udev device, or the udev device may be"]
    #[doc = " unobtainable. This function returns NULL if no udev device was available."]
    #[doc = ""]
    #[doc = " Calling this function multiple times for the same device may not"]
    #[doc = " return the same udev handle each time."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @return A udev handle to the device with a refcount of >= 1 or NULL."]
    #[doc = " @retval NULL This device is not represented by a udev device"]
    pub fn libinput_device_get_udev_device(device: *mut libinput_device) -> *mut udev_device;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Update the LEDs on the device, if any. If the device does not have"]
    #[doc = " LEDs, or does not have one or more of the LEDs given in the mask, this"]
    #[doc = " function does nothing."]
    #[doc = ""]
    #[doc = " @param device A previously obtained device"]
    #[doc = " @param leds A mask of the LEDs to set, or unset."]
    pub fn libinput_device_led_update(device: *mut libinput_device, leds: libinput_led);
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Check if the given device has the specified capability"]
    #[doc = ""]
    #[doc = " @return Non-zero if the given device has the capability or zero otherwise"]
    pub fn libinput_device_has_capability(
        device: *mut libinput_device,
        capability: libinput_device_capability,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Get the physical size of a device in mm, where meaningful. This function"]
    #[doc = " only succeeds on devices with the required data, i.e. tablets, touchpads"]
    #[doc = " and touchscreens."]
    #[doc = ""]
    #[doc = " If this function returns nonzero, width and height are unmodified."]
    #[doc = ""]
    #[doc = " @param device The device"]
    #[doc = " @param width Set to the width of the device"]
    #[doc = " @param height Set to the height of the device"]
    #[doc = " @return 0 on success, or nonzero otherwise"]
    pub fn libinput_device_get_size(
        device: *mut libinput_device,
        width: *mut f64,
        height: *mut f64,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Check if a @ref LIBINPUT_DEVICE_CAP_POINTER device has a button with the"]
    #[doc = " given code (see linux/input-event-codes.h)."]
    #[doc = ""]
    #[doc = " @param device A current input device"]
    #[doc = " @param code Button code to check for, e.g. <i>BTN_LEFT</i>"]
    #[doc = ""]
    #[doc = " @return 1 if the device supports this button code, 0 if it does not, -1"]
    #[doc = " on error."]
    pub fn libinput_device_pointer_has_button(
        device: *mut libinput_device,
        code: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Check if a @ref LIBINPUT_DEVICE_CAP_KEYBOARD device has a key with the"]
    #[doc = " given code (see linux/input-event-codes.h)."]
    #[doc = ""]
    #[doc = " @param device A current input device"]
    #[doc = " @param code Key code to check for, e.g. <i>KEY_ESC</i>"]
    #[doc = ""]
    #[doc = " @return 1 if the device supports this key code, 0 if it does not, -1"]
    #[doc = " on error."]
    pub fn libinput_device_keyboard_has_key(
        device: *mut libinput_device,
        code: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Check how many touches a @ref LIBINPUT_DEVICE_CAP_TOUCH device supports"]
    #[doc = " simultaneously."]
    #[doc = ""]
    #[doc = " @param device A current input device"]
    #[doc = ""]
    #[doc = " @return The number of simultaneous touches or 0 if unknown, -1"]
    #[doc = " on error."]
    #[doc = ""]
    #[doc = " @since 1.11"]
    pub fn libinput_device_touch_get_touch_count(device: *mut libinput_device) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Check if a @ref LIBINPUT_DEVICE_CAP_SWITCH device has a switch of the"]
    #[doc = " given type."]
    #[doc = ""]
    #[doc = " @param device A current input device"]
    #[doc = " @param sw Switch to check for"]
    #[doc = ""]
    #[doc = " @return 1 if the device supports this switch, 0 if it does not, -1"]
    #[doc = " on error."]
    #[doc = ""]
    #[doc = " @since 1.9"]
    pub fn libinput_device_switch_has_switch(
        device: *mut libinput_device,
        sw: libinput_switch,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Return the number of buttons on a device with the"]
    #[doc = " @ref LIBINPUT_DEVICE_CAP_TABLET_PAD capability."]
    #[doc = " Buttons on a pad device are numbered sequentially, see the"]
    #[doc = " libinput documentation for details."]
    #[doc = ""]
    #[doc = " @param device A current input device"]
    #[doc = ""]
    #[doc = " @return The number of buttons supported by the device."]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_device_tablet_pad_get_num_buttons(
        device: *mut libinput_device,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Return the number of rings a device with the @ref"]
    #[doc = " LIBINPUT_DEVICE_CAP_TABLET_PAD capability provides."]
    #[doc = ""]
    #[doc = " @param device A current input device"]
    #[doc = ""]
    #[doc = " @return The number of rings or 0 if the device has no rings."]
    #[doc = ""]
    #[doc = " @see libinput_event_tablet_pad_get_ring_number"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_device_tablet_pad_get_num_rings(device: *mut libinput_device) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Return the number of strips a device with the @ref"]
    #[doc = " LIBINPUT_DEVICE_CAP_TABLET_PAD capability provides."]
    #[doc = ""]
    #[doc = " @param device A current input device"]
    #[doc = ""]
    #[doc = " @return The number of strips or 0 if the device has no strips."]
    #[doc = ""]
    #[doc = " @see libinput_event_tablet_pad_get_strip_number"]
    #[doc = ""]
    #[doc = " @since 1.3"]
    pub fn libinput_device_tablet_pad_get_num_strips(device: *mut libinput_device)
        -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Check if a @ref LIBINPUT_DEVICE_CAP_TABLET_PAD device has a key with the"]
    #[doc = " given code (see linux/input-event-codes.h)."]
    #[doc = ""]
    #[doc = " @param device A current input device"]
    #[doc = " @param code Key code to check for, e.g. <i>KEY_ESC</i>"]
    #[doc = ""]
    #[doc = " @return 1 if the device supports this key code, 0 if it does not, -1"]
    #[doc = " on error."]
    #[doc = ""]
    #[doc = " @since 1.15"]
    pub fn libinput_device_tablet_pad_has_key(
        device: *mut libinput_device,
        code: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Increase the refcount of the device group. A device group will be freed"]
    #[doc = " whenever the refcount reaches 0. This may happen during"]
    #[doc = " libinput_dispatch() if all devices of this group were removed from the"]
    #[doc = " system. A caller must ensure to reference the device group correctly to"]
    #[doc = " avoid dangling pointers."]
    #[doc = ""]
    #[doc = " @param group A previously obtained device group"]
    #[doc = " @return The passed device group"]
    pub fn libinput_device_group_ref(
        group: *mut libinput_device_group,
    ) -> *mut libinput_device_group;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Decrease the refcount of the device group. A device group will be freed"]
    #[doc = " whenever the refcount reaches 0. This may happen during"]
    #[doc = " libinput_dispatch() if all devices of this group were removed from the"]
    #[doc = " system. A caller must ensure to reference the device group correctly to"]
    #[doc = " avoid dangling pointers."]
    #[doc = ""]
    #[doc = " @param group A previously obtained device group"]
    #[doc = " @return NULL if the device group was destroyed, otherwise the passed"]
    #[doc = " device group"]
    pub fn libinput_device_group_unref(
        group: *mut libinput_device_group,
    ) -> *mut libinput_device_group;
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Set caller-specific data associated with this device group. libinput does"]
    #[doc = " not manage, look at, or modify this data. The caller must ensure the"]
    #[doc = " data is valid."]
    #[doc = ""]
    #[doc = " @param group A previously obtained device group"]
    #[doc = " @param user_data Caller-specific data pointer"]
    #[doc = " @see libinput_device_group_get_user_data"]
    pub fn libinput_device_group_set_user_data(
        group: *mut libinput_device_group,
        user_data: *mut ::libc::c_void,
    );
}
extern "C" {
    #[doc = " @ingroup device"]
    #[doc = ""]
    #[doc = " Get the caller-specific data associated with this input device group, if"]
    #[doc = " any."]
    #[doc = ""]
    #[doc = " @param group A previously obtained group"]
    #[doc = " @return Caller-specific data pointer or NULL if none was set"]
    #[doc = " @see libinput_device_group_set_user_data"]
    pub fn libinput_device_group_get_user_data(
        group: *mut libinput_device_group,
    ) -> *mut ::libc::c_void;
}
#[doc = "< Config applied successfully"]
pub const libinput_config_status_LIBINPUT_CONFIG_STATUS_SUCCESS: libinput_config_status = 0;
#[doc = "< Configuration not available on"]
#[doc = "this device"]
pub const libinput_config_status_LIBINPUT_CONFIG_STATUS_UNSUPPORTED: libinput_config_status = 1;
#[doc = "< Invalid parameter range"]
pub const libinput_config_status_LIBINPUT_CONFIG_STATUS_INVALID: libinput_config_status = 2;
#[doc = " @ingroup config"]
#[doc = ""]
#[doc = " Status codes returned when applying configuration settings."]
pub type libinput_config_status = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Return a string describing the error."]
    #[doc = ""]
    #[doc = " @param status The status to translate to a string"]
    #[doc = " @return A human-readable string representing the error or NULL for an"]
    #[doc = " invalid status."]
    pub fn libinput_config_status_to_str(status: libinput_config_status) -> *const ::libc::c_char;
}
#[doc = "< Tapping is to be disabled, or is"]
#[doc = "currently disabled"]
pub const libinput_config_tap_state_LIBINPUT_CONFIG_TAP_DISABLED: libinput_config_tap_state = 0;
#[doc = "< Tapping is to be enabled, or is"]
#[doc = "currently enabled"]
pub const libinput_config_tap_state_LIBINPUT_CONFIG_TAP_ENABLED: libinput_config_tap_state = 1;
#[doc = " @ingroup config"]
pub type libinput_config_tap_state = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if the device supports tap-to-click and how many fingers can be"]
    #[doc = " used for tapping. See"]
    #[doc = " libinput_device_config_tap_set_enabled() for more information."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The number of fingers that can generate a tap event, or 0 if the"]
    #[doc = " device does not support tapping."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_set_enabled"]
    #[doc = " @see libinput_device_config_tap_get_enabled"]
    #[doc = " @see libinput_device_config_tap_get_default_enabled"]
    pub fn libinput_device_config_tap_get_finger_count(
        device: *mut libinput_device,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Enable or disable tap-to-click on this device, with a default mapping of"]
    #[doc = " 1, 2, 3 finger tap mapping to left, right, middle click, respectively."]
    #[doc = " Tapping is limited by the number of simultaneous touches"]
    #[doc = " supported by the device, see"]
    #[doc = " libinput_device_config_tap_get_finger_count()."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param enable @ref LIBINPUT_CONFIG_TAP_ENABLED to enable tapping or @ref"]
    #[doc = " LIBINPUT_CONFIG_TAP_DISABLED to disable tapping"]
    #[doc = ""]
    #[doc = " @return A config status code. Disabling tapping on a device that does not"]
    #[doc = " support tapping always succeeds."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_get_finger_count"]
    #[doc = " @see libinput_device_config_tap_get_enabled"]
    #[doc = " @see libinput_device_config_tap_get_default_enabled"]
    pub fn libinput_device_config_tap_set_enabled(
        device: *mut libinput_device,
        enable: libinput_config_tap_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if tap-to-click is enabled on this device. If the device does not"]
    #[doc = " support tapping, this function always returns @ref"]
    #[doc = " LIBINPUT_CONFIG_TAP_DISABLED."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @retval LIBINPUT_CONFIG_TAP_ENABLED If tapping is currently enabled"]
    #[doc = " @retval LIBINPUT_CONFIG_TAP_DISABLED If tapping is currently disabled"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_get_finger_count"]
    #[doc = " @see libinput_device_config_tap_set_enabled"]
    #[doc = " @see libinput_device_config_tap_get_default_enabled"]
    pub fn libinput_device_config_tap_get_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_tap_state;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Return the default setting for whether tap-to-click is enabled on this"]
    #[doc = " device."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @retval LIBINPUT_CONFIG_TAP_ENABLED If tapping is enabled by default"]
    #[doc = " @retval LIBINPUT_CONFIG_TAP_DISABLED If tapping Is disabled by default"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_get_finger_count"]
    #[doc = " @see libinput_device_config_tap_set_enabled"]
    #[doc = " @see libinput_device_config_tap_get_enabled"]
    pub fn libinput_device_config_tap_get_default_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_tap_state;
}
#[doc = " 1/2/3 finger tap maps to left/right/middle"]
pub const libinput_config_tap_button_map_LIBINPUT_CONFIG_TAP_MAP_LRM:
    libinput_config_tap_button_map = 0;
#[doc = " 1/2/3 finger tap maps to left/middle/right"]
pub const libinput_config_tap_button_map_LIBINPUT_CONFIG_TAP_MAP_LMR:
    libinput_config_tap_button_map = 1;
#[doc = " @ingroup config"]
#[doc = ""]
#[doc = " @since 1.5"]
pub type libinput_config_tap_button_map = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Set the finger number to button number mapping for tap-to-click. The"]
    #[doc = " default mapping on most devices is to have a 1, 2 and 3 finger tap to map"]
    #[doc = " to the left, right and middle button, respectively."]
    #[doc = " A device may permit changing the button mapping but disallow specific"]
    #[doc = " maps. In this case @ref LIBINPUT_CONFIG_STATUS_UNSUPPORTED is returned,"]
    #[doc = " the caller is expected to handle this case correctly."]
    #[doc = ""]
    #[doc = " Changing the button mapping may not take effect immediately,"]
    #[doc = " the device may wait until it is in a neutral state before applying any"]
    #[doc = " changes."]
    #[doc = ""]
    #[doc = " The mapping may be changed when tap-to-click is disabled. The new mapping"]
    #[doc = " takes effect when tap-to-click is enabled in the future."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for devices where"]
    #[doc = " libinput_device_config_tap_get_finger_count() returns 0."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param map The new finger-to-button number mapping"]
    #[doc = " @return A config status code. Changing the order on a device that does not"]
    #[doc = " support tapping always fails with @ref LIBINPUT_CONFIG_STATUS_UNSUPPORTED."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_get_button_map"]
    #[doc = " @see libinput_device_config_tap_get_default_button_map"]
    #[doc = ""]
    #[doc = " @since 1.5"]
    pub fn libinput_device_config_tap_set_button_map(
        device: *mut libinput_device,
        map: libinput_config_tap_button_map,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the finger number to button number mapping for tap-to-click."]
    #[doc = ""]
    #[doc = " The return value for a device that does not support tapping is always"]
    #[doc = " @ref LIBINPUT_CONFIG_TAP_MAP_LRM."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for devices where"]
    #[doc = " libinput_device_config_tap_get_finger_count() returns 0."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The current finger-to-button number mapping"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_set_button_map"]
    #[doc = " @see libinput_device_config_tap_get_default_button_map"]
    #[doc = ""]
    #[doc = " @since 1.5"]
    pub fn libinput_device_config_tap_get_button_map(
        device: *mut libinput_device,
    ) -> libinput_config_tap_button_map;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the default finger number to button number mapping for tap-to-click."]
    #[doc = ""]
    #[doc = " The return value for a device that does not support tapping is always"]
    #[doc = " @ref LIBINPUT_CONFIG_TAP_MAP_LRM."]
    #[doc = ""]
    #[doc = " @note It is an application bug to call this function for devices where"]
    #[doc = " libinput_device_config_tap_get_finger_count() returns 0."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The current finger-to-button number mapping"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_set_button_map"]
    #[doc = " @see libinput_device_config_tap_get_default_button_map"]
    #[doc = ""]
    #[doc = " @since 1.5"]
    pub fn libinput_device_config_tap_get_default_button_map(
        device: *mut libinput_device,
    ) -> libinput_config_tap_button_map;
}
#[doc = " Drag is to be disabled, or is"]
#[doc = " currently disabled."]
pub const libinput_config_drag_state_LIBINPUT_CONFIG_DRAG_DISABLED: libinput_config_drag_state = 0;
#[doc = " Drag is to be enabled, or is"]
#[doc = " currently enabled"]
pub const libinput_config_drag_state_LIBINPUT_CONFIG_DRAG_ENABLED: libinput_config_drag_state = 1;
#[doc = " @ingroup config"]
#[doc = ""]
#[doc = " A config status to distinguish or set dragging on a device. Currently"]
#[doc = " implemented for tap-and-drag only, see"]
#[doc = " libinput_device_config_tap_set_drag_enabled()"]
#[doc = ""]
#[doc = " @since 1.2"]
pub type libinput_config_drag_state = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Enable or disable tap-and-drag on this device. When enabled, a"]
    #[doc = " single-finger tap immediately followed by a finger down results in a"]
    #[doc = " button down event, subsequent finger motion thus triggers a drag. The"]
    #[doc = " button is released on finger up. See the libinput documentation for more"]
    #[doc = " details."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param enable @ref LIBINPUT_CONFIG_DRAG_ENABLED to enable, @ref"]
    #[doc = " LIBINPUT_CONFIG_DRAG_DISABLED to disable tap-and-drag"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_drag_get_enabled"]
    #[doc = " @see libinput_device_config_tap_drag_get_default_enabled"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_device_config_tap_set_drag_enabled(
        device: *mut libinput_device,
        enable: libinput_config_drag_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Return whether tap-and-drag is enabled or disabled on this device."]
    #[doc = ""]
    #[doc = " @param device The device to check"]
    #[doc = " @retval LIBINPUT_CONFIG_DRAG_ENABLED if tap-and-drag is enabled"]
    #[doc = " @retval LIBINPUT_CONFIG_DRAG_DISABLED if tap-and-drag is"]
    #[doc = " disabled"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_drag_set_enabled"]
    #[doc = " @see libinput_device_config_tap_drag_get_default_enabled"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_device_config_tap_get_drag_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_drag_state;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Return whether tap-and-drag is enabled or disabled by default on this"]
    #[doc = " device."]
    #[doc = ""]
    #[doc = " @param device The device to check"]
    #[doc = " @retval LIBINPUT_CONFIG_DRAG_ENABLED if tap-and-drag is enabled by"]
    #[doc = " default"]
    #[doc = " @retval LIBINPUT_CONFIG_DRAG_DISABLED if tap-and-drag is"]
    #[doc = " disabled by default"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_drag_set_enabled"]
    #[doc = " @see libinput_device_config_tap_drag_get_enabled"]
    #[doc = ""]
    #[doc = " @since 1.2"]
    pub fn libinput_device_config_tap_get_default_drag_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_drag_state;
}
#[doc = " Drag lock is to be disabled, or is currently disabled"]
pub const libinput_config_drag_lock_state_LIBINPUT_CONFIG_DRAG_LOCK_DISABLED:
    libinput_config_drag_lock_state = 0;
#[doc = " Drag lock is to be enabled, or is currently disabled"]
pub const libinput_config_drag_lock_state_LIBINPUT_CONFIG_DRAG_LOCK_ENABLED:
    libinput_config_drag_lock_state = 1;
#[doc = " @ingroup config"]
pub type libinput_config_drag_lock_state = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Enable or disable drag-lock during tapping on this device. When enabled,"]
    #[doc = " a finger may be lifted and put back on the touchpad within a timeout and"]
    #[doc = " the drag process continues. When disabled, lifting the finger during a"]
    #[doc = " tap-and-drag will immediately stop the drag. See the libinput"]
    #[doc = " documentation for more details."]
    #[doc = ""]
    #[doc = " Enabling drag lock on a device that has tapping disabled is permitted,"]
    #[doc = " but has no effect until tapping is enabled."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param enable @ref LIBINPUT_CONFIG_DRAG_LOCK_ENABLED to enable drag lock"]
    #[doc = " or @ref LIBINPUT_CONFIG_DRAG_LOCK_DISABLED to disable drag lock"]
    #[doc = ""]
    #[doc = " @return A config status code. Disabling drag lock on a device that does not"]
    #[doc = " support tapping always succeeds."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_get_drag_lock_enabled"]
    #[doc = " @see libinput_device_config_tap_get_default_drag_lock_enabled"]
    pub fn libinput_device_config_tap_set_drag_lock_enabled(
        device: *mut libinput_device,
        enable: libinput_config_drag_lock_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if drag-lock during tapping is enabled on this device. If the"]
    #[doc = " device does not support tapping, this function always returns"]
    #[doc = " @ref LIBINPUT_CONFIG_DRAG_LOCK_DISABLED."]
    #[doc = ""]
    #[doc = " Drag lock may be enabled even when tapping is disabled."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @retval LIBINPUT_CONFIG_DRAG_LOCK_ENABLED If drag lock is currently enabled"]
    #[doc = " @retval LIBINPUT_CONFIG_DRAG_LOCK_DISABLED If drag lock is currently disabled"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_set_drag_lock_enabled"]
    #[doc = " @see libinput_device_config_tap_get_default_drag_lock_enabled"]
    pub fn libinput_device_config_tap_get_drag_lock_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_drag_lock_state;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if drag-lock during tapping is enabled by default on this device."]
    #[doc = " If the device does not support tapping, this function always returns"]
    #[doc = " @ref LIBINPUT_CONFIG_DRAG_LOCK_DISABLED."]
    #[doc = ""]
    #[doc = " Drag lock may be enabled by default even when tapping is disabled by"]
    #[doc = " default."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @retval LIBINPUT_CONFIG_DRAG_LOCK_ENABLED If drag lock is enabled by"]
    #[doc = " default"]
    #[doc = " @retval LIBINPUT_CONFIG_DRAG_LOCK_DISABLED If drag lock is disabled by"]
    #[doc = " default"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_tap_set_drag_lock_enabled"]
    #[doc = " @see libinput_device_config_tap_get_drag_lock_enabled"]
    pub fn libinput_device_config_tap_get_default_drag_lock_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_drag_lock_state;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if the device can be calibrated via a calibration matrix."]
    #[doc = ""]
    #[doc = " @param device The device to check"]
    #[doc = " @return Non-zero if the device can be calibrated, zero otherwise."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_calibration_set_matrix"]
    #[doc = " @see libinput_device_config_calibration_get_matrix"]
    #[doc = " @see libinput_device_config_calibration_get_default_matrix"]
    pub fn libinput_device_config_calibration_has_matrix(
        device: *mut libinput_device,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Apply the 3x3 transformation matrix to absolute device coordinates. This"]
    #[doc = " matrix has no effect on relative events."]
    #[doc = ""]
    #[doc = " Given a 6-element array [a, b, c, d, e, f], the matrix is applied as"]
    #[doc = " @code"]
    #[doc = " [ a  b  c ]   [ x ]"]
    #[doc = " [ d  e  f ] * [ y ]"]
    #[doc = " [ 0  0  1 ]   [ 1 ]"]
    #[doc = " @endcode"]
    #[doc = ""]
    #[doc = " The translation component (c, f) is expected to be normalized to the"]
    #[doc = " device coordinate range. For example, the matrix"]
    #[doc = " @code"]
    #[doc = " [ 1 0  1 ]"]
    #[doc = " [ 0 1 -1 ]"]
    #[doc = " [ 0 0  1 ]"]
    #[doc = " @endcode"]
    #[doc = " moves all coordinates by 1 device-width to the right and 1 device-height"]
    #[doc = " up."]
    #[doc = ""]
    #[doc = " The rotation matrix for rotation around the origin is defined as"]
    #[doc = " @code"]
    #[doc = " [ cos(a) -sin(a) 0 ]"]
    #[doc = " [ sin(a)  cos(a) 0 ]"]
    #[doc = " [   0      0     1 ]"]
    #[doc = " @endcode"]
    #[doc = " Note that any rotation requires an additional translation component to"]
    #[doc = " translate the rotated coordinates back into the original device space."]
    #[doc = " The rotation matrixes for 90, 180 and 270 degrees clockwise are:"]
    #[doc = " @code"]
    #[doc = " 90 deg cw:\t\t180 deg cw:\t\t270 deg cw:"]
    #[doc = " [ 0 -1 1]\t\t[ -1  0 1]\t\t[  0 1 0 ]"]
    #[doc = " [ 1  0 0]\t\t[  0 -1 1]\t\t[ -1 0 1 ]"]
    #[doc = " [ 0  0 1]\t\t[  0  0 1]\t\t[  0 0 1 ]"]
    #[doc = " @endcode"]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param matrix An array representing the first two rows of a 3x3 matrix as"]
    #[doc = " described above."]
    #[doc = ""]
    #[doc = " @return A config status code."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_calibration_has_matrix"]
    #[doc = " @see libinput_device_config_calibration_get_matrix"]
    #[doc = " @see libinput_device_config_calibration_get_default_matrix"]
    pub fn libinput_device_config_calibration_set_matrix(
        device: *mut libinput_device,
        matrix: *const f32,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Return the current calibration matrix for this device."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param matrix Set to the array representing the first two rows of a 3x3 matrix as"]
    #[doc = " described in libinput_device_config_calibration_set_matrix()."]
    #[doc = ""]
    #[doc = " @return 0 if no calibration is set and the returned matrix is the"]
    #[doc = " identity matrix, 1 otherwise"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_calibration_has_matrix"]
    #[doc = " @see libinput_device_config_calibration_set_matrix"]
    #[doc = " @see libinput_device_config_calibration_get_default_matrix"]
    pub fn libinput_device_config_calibration_get_matrix(
        device: *mut libinput_device,
        matrix: *mut f32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Return the default calibration matrix for this device. On most devices,"]
    #[doc = " this is the identity matrix. If the udev property"]
    #[doc = " <b>LIBINPUT_CALIBRATION_MATRIX</b> is set on the respective udev device,"]
    #[doc = " that property's value becomes the default matrix, see the libinput"]
    #[doc = " documentation for more details."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param matrix Set to the array representing the first two rows of a 3x3 matrix as"]
    #[doc = " described in libinput_device_config_calibration_set_matrix()."]
    #[doc = ""]
    #[doc = " @return 0 if no calibration is set and the returned matrix is the"]
    #[doc = " identity matrix, 1 otherwise"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_calibration_has_matrix"]
    #[doc = " @see libinput_device_config_calibration_set_matrix"]
    #[doc = " @see libinput_device_config_calibration_get_matrix"]
    pub fn libinput_device_config_calibration_get_default_matrix(
        device: *mut libinput_device,
        matrix: *mut f32,
    ) -> ::libc::c_int;
}
#[doc = " Send events from this device normally. This is a placeholder"]
#[doc = " mode only, any device detected by libinput can be enabled. Do not"]
#[doc = " test for this value as bitmask."]
pub const libinput_config_send_events_mode_LIBINPUT_CONFIG_SEND_EVENTS_ENABLED:
    libinput_config_send_events_mode = 0;
#[doc = " Do not send events through this device. Depending on the device,"]
#[doc = " this may close all file descriptors on the device or it may leave"]
#[doc = " the file descriptors open and route events through a different"]
#[doc = " device."]
#[doc = ""]
#[doc = " If this bit field is set, other disable modes may be"]
#[doc = " ignored. For example, if both @ref"]
#[doc = " LIBINPUT_CONFIG_SEND_EVENTS_DISABLED and @ref"]
#[doc = " LIBINPUT_CONFIG_SEND_EVENTS_DISABLED_ON_EXTERNAL_MOUSE are set,"]
#[doc = " the device remains disabled when all external pointer devices are"]
#[doc = " unplugged."]
pub const libinput_config_send_events_mode_LIBINPUT_CONFIG_SEND_EVENTS_DISABLED:
    libinput_config_send_events_mode = 1;
#[doc = " If an external pointer device is plugged in, do not send events"]
#[doc = " from this device. This option may be available on built-in"]
#[doc = " touchpads."]
pub const libinput_config_send_events_mode_LIBINPUT_CONFIG_SEND_EVENTS_DISABLED_ON_EXTERNAL_MOUSE : libinput_config_send_events_mode = 2 ;
#[doc = " @ingroup config"]
#[doc = ""]
#[doc = " The send-event mode of a device defines when a device may generate events"]
#[doc = " and pass those events to the caller."]
pub type libinput_config_send_events_mode = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Return the possible send-event modes for this device. These modes define"]
    #[doc = " when a device may process and send events."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return A bitmask of possible modes."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_send_events_set_mode"]
    #[doc = " @see libinput_device_config_send_events_get_mode"]
    #[doc = " @see libinput_device_config_send_events_get_default_mode"]
    pub fn libinput_device_config_send_events_get_modes(device: *mut libinput_device) -> u32;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Set the send-event mode for this device. The mode defines when the device"]
    #[doc = " processes and sends events to the caller."]
    #[doc = ""]
    #[doc = " The selected mode may not take effect immediately. Events already"]
    #[doc = " received and processed from this device are unaffected and will be passed"]
    #[doc = " to the caller on the next call to libinput_get_event()."]
    #[doc = ""]
    #[doc = " If the mode is a bitmask of @ref libinput_config_send_events_mode,"]
    #[doc = " the device may wait for or generate events until it is in a neutral"]
    #[doc = " state. For example, this may include waiting for or generating button"]
    #[doc = " release events."]
    #[doc = ""]
    #[doc = " If the device is already suspended, this function does nothing and"]
    #[doc = " returns success. Changing the send-event mode on a device that has been"]
    #[doc = " removed is permitted."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param mode A bitmask of send-events modes"]
    #[doc = ""]
    #[doc = " @return A config status code."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_send_events_get_modes"]
    #[doc = " @see libinput_device_config_send_events_get_mode"]
    #[doc = " @see libinput_device_config_send_events_get_default_mode"]
    pub fn libinput_device_config_send_events_set_mode(
        device: *mut libinput_device,
        mode: u32,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the send-event mode for this device. The mode defines when the device"]
    #[doc = " processes and sends events to the caller."]
    #[doc = ""]
    #[doc = " If a caller enables the bits for multiple modes, some of which are"]
    #[doc = " subsets of another mode libinput may drop the bits that are subsets. In"]
    #[doc = " other words, don't expect libinput_device_config_send_events_get_mode()"]
    #[doc = " to always return exactly the same bitmask as passed into"]
    #[doc = " libinput_device_config_send_events_set_mode()."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The current bitmask of the send-event mode for this device."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_send_events_get_modes"]
    #[doc = " @see libinput_device_config_send_events_set_mode"]
    #[doc = " @see libinput_device_config_send_events_get_default_mode"]
    pub fn libinput_device_config_send_events_get_mode(device: *mut libinput_device) -> u32;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the default send-event mode for this device. The mode defines when"]
    #[doc = " the device processes and sends events to the caller."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The bitmask of the send-event mode for this device."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_send_events_get_modes"]
    #[doc = " @see libinput_device_config_send_events_set_mode"]
    #[doc = " @see libinput_device_config_send_events_get_mode"]
    pub fn libinput_device_config_send_events_get_default_mode(device: *mut libinput_device)
        -> u32;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if a device uses libinput-internal pointer-acceleration."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return 0 if the device is not accelerated, nonzero if it is accelerated"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_accel_set_speed"]
    #[doc = " @see libinput_device_config_accel_get_speed"]
    #[doc = " @see libinput_device_config_accel_get_default_speed"]
    pub fn libinput_device_config_accel_is_available(device: *mut libinput_device)
        -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Set the pointer acceleration speed of this pointer device within a range"]
    #[doc = " of [-1, 1], where 0 is the default acceleration for this device, -1 is"]
    #[doc = " the slowest acceleration and 1 is the maximum acceleration available on"]
    #[doc = " this device. The actual pointer acceleration mechanism is"]
    #[doc = " implementation-dependent, as is the number of steps available within the"]
    #[doc = " range. libinput picks the semantically closest acceleration step if the"]
    #[doc = " requested value does not match a discrete setting."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param speed The normalized speed, in a range of [-1, 1]"]
    #[doc = ""]
    #[doc = " @return A config status code"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_accel_is_available"]
    #[doc = " @see libinput_device_config_accel_get_speed"]
    #[doc = " @see libinput_device_config_accel_get_default_speed"]
    pub fn libinput_device_config_accel_set_speed(
        device: *mut libinput_device,
        speed: f64,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the current pointer acceleration setting for this pointer device. The"]
    #[doc = " returned value is normalized to a range of [-1, 1]."]
    #[doc = " See libinput_device_config_accel_set_speed() for details."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return The current speed, range -1 to 1"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_accel_is_available"]
    #[doc = " @see libinput_device_config_accel_set_speed"]
    #[doc = " @see libinput_device_config_accel_get_default_speed"]
    pub fn libinput_device_config_accel_get_speed(device: *mut libinput_device) -> f64;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Return the default speed setting for this device, normalized to a range"]
    #[doc = " of [-1, 1]."]
    #[doc = " See libinput_device_config_accel_set_speed() for details."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The default speed setting for this device."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_accel_is_available"]
    #[doc = " @see libinput_device_config_accel_set_speed"]
    #[doc = " @see libinput_device_config_accel_get_speed"]
    pub fn libinput_device_config_accel_get_default_speed(device: *mut libinput_device) -> f64;
}
#[doc = " Placeholder for devices that don't have a configurable pointer"]
#[doc = " acceleration profile."]
pub const libinput_config_accel_profile_LIBINPUT_CONFIG_ACCEL_PROFILE_NONE:
    libinput_config_accel_profile = 0;
#[doc = " A flat acceleration profile. Pointer motion is accelerated by a"]
#[doc = " constant (device-specific) factor, depending on the current"]
#[doc = " speed."]
#[doc = ""]
#[doc = " @see libinput_device_config_accel_set_speed"]
pub const libinput_config_accel_profile_LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT:
    libinput_config_accel_profile = 1;
#[doc = " An adaptive acceleration profile. Pointer acceleration depends"]
#[doc = " on the input speed. This is the default profile for most devices."]
pub const libinput_config_accel_profile_LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE:
    libinput_config_accel_profile = 2;
#[doc = " @ingroup config"]
#[doc = ""]
#[doc = " @since 1.1"]
pub type libinput_config_accel_profile = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Returns a bitmask of the configurable acceleration modes available on"]
    #[doc = " this device."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return A bitmask of all configurable modes available on this device."]
    #[doc = ""]
    #[doc = " @since 1.1"]
    pub fn libinput_device_config_accel_get_profiles(device: *mut libinput_device) -> u32;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Set the pointer acceleration profile of this pointer device to the given"]
    #[doc = " mode."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param mode The mode to set the device to."]
    #[doc = ""]
    #[doc = " @return A config status code"]
    #[doc = ""]
    #[doc = " @since 1.1"]
    pub fn libinput_device_config_accel_set_profile(
        device: *mut libinput_device,
        mode: libinput_config_accel_profile,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the current pointer acceleration profile for this pointer device."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return The currently configured pointer acceleration profile."]
    #[doc = ""]
    #[doc = " @since 1.1"]
    pub fn libinput_device_config_accel_get_profile(
        device: *mut libinput_device,
    ) -> libinput_config_accel_profile;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Return the default pointer acceleration profile for this pointer device."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return The default acceleration profile for this device."]
    #[doc = ""]
    #[doc = " @since 1.1"]
    pub fn libinput_device_config_accel_get_default_profile(
        device: *mut libinput_device,
    ) -> libinput_config_accel_profile;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Return non-zero if the device supports \"natural scrolling\"."]
    #[doc = ""]
    #[doc = " In traditional scroll mode, the movement of fingers on a touchpad when"]
    #[doc = " scrolling matches the movement of the scroll bars. When the fingers move"]
    #[doc = " down, the scroll bar moves down, a line of text on the screen moves"]
    #[doc = " towards the upper end of the screen. This also matches scroll wheels on"]
    #[doc = " mice (wheel down, content moves up)."]
    #[doc = ""]
    #[doc = " Natural scrolling is the term coined by Apple for inverted scrolling."]
    #[doc = " In this mode, the effect of scrolling movement of fingers on a touchpad"]
    #[doc = " resemble physical manipulation of paper. When the fingers move down, a"]
    #[doc = " line of text on the screen moves down (scrollbars move up). This is the"]
    #[doc = " opposite of scroll wheels on mice."]
    #[doc = ""]
    #[doc = " A device supporting natural scrolling can be switched between traditional"]
    #[doc = " scroll mode and natural scroll mode."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return Zero if natural scrolling is not supported, non-zero if natural"]
    #[doc = " scrolling is supported by this device"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_set_natural_scroll_enabled"]
    #[doc = " @see libinput_device_config_scroll_get_natural_scroll_enabled"]
    #[doc = " @see libinput_device_config_scroll_get_default_natural_scroll_enabled"]
    pub fn libinput_device_config_scroll_has_natural_scroll(
        device: *mut libinput_device,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Enable or disable natural scrolling on the device."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param enable non-zero to enable, zero to disable natural scrolling"]
    #[doc = ""]
    #[doc = " @return A config status code"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_has_natural_scroll"]
    #[doc = " @see libinput_device_config_scroll_get_natural_scroll_enabled"]
    #[doc = " @see libinput_device_config_scroll_get_default_natural_scroll_enabled"]
    pub fn libinput_device_config_scroll_set_natural_scroll_enabled(
        device: *mut libinput_device,
        enable: ::libc::c_int,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the current mode for scrolling on this device"]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return Zero if natural scrolling is disabled, non-zero if enabled"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_has_natural_scroll"]
    #[doc = " @see libinput_device_config_scroll_set_natural_scroll_enabled"]
    #[doc = " @see libinput_device_config_scroll_get_default_natural_scroll_enabled"]
    pub fn libinput_device_config_scroll_get_natural_scroll_enabled(
        device: *mut libinput_device,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the default mode for scrolling on this device"]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return Zero if natural scrolling is disabled by default, non-zero if enabled"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_has_natural_scroll"]
    #[doc = " @see libinput_device_config_scroll_set_natural_scroll_enabled"]
    #[doc = " @see libinput_device_config_scroll_get_natural_scroll_enabled"]
    pub fn libinput_device_config_scroll_get_default_natural_scroll_enabled(
        device: *mut libinput_device,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if a device has a configuration that supports left-handed usage."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return Non-zero if the device can be set to left-handed, or zero"]
    #[doc = " otherwise"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_left_handed_set"]
    #[doc = " @see libinput_device_config_left_handed_get"]
    #[doc = " @see libinput_device_config_left_handed_get_default"]
    pub fn libinput_device_config_left_handed_is_available(
        device: *mut libinput_device,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Set the left-handed configuration of the device."]
    #[doc = ""]
    #[doc = " The exact behavior is device-dependent. On a mouse and most pointing"]
    #[doc = " devices, left and right buttons are swapped but the middle button is"]
    #[doc = " unmodified. On a touchpad, physical buttons (if present) are swapped. On a"]
    #[doc = " clickpad, the top and bottom software-emulated buttons are swapped where"]
    #[doc = " present, the main area of the touchpad remains a left button. Tapping and"]
    #[doc = " clickfinger behavior is not affected by this setting."]
    #[doc = ""]
    #[doc = " Changing the left-handed configuration of a device may not take effect"]
    #[doc = " until all buttons have been logically released."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param left_handed Zero to disable, non-zero to enable left-handed mode"]
    #[doc = " @return A configuration status code"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_left_handed_is_available"]
    #[doc = " @see libinput_device_config_left_handed_get"]
    #[doc = " @see libinput_device_config_left_handed_get_default"]
    pub fn libinput_device_config_left_handed_set(
        device: *mut libinput_device,
        left_handed: ::libc::c_int,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the current left-handed configuration of the device."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return Zero if the device is in right-handed mode, non-zero if the"]
    #[doc = " device is in left-handed mode"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_left_handed_is_available"]
    #[doc = " @see libinput_device_config_left_handed_set"]
    #[doc = " @see libinput_device_config_left_handed_get_default"]
    pub fn libinput_device_config_left_handed_get(device: *mut libinput_device) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the default left-handed configuration of the device."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return Zero if the device is in right-handed mode by default, or non-zero"]
    #[doc = " if the device is in left-handed mode by default"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_left_handed_is_available"]
    #[doc = " @see libinput_device_config_left_handed_set"]
    #[doc = " @see libinput_device_config_left_handed_get"]
    pub fn libinput_device_config_left_handed_get_default(
        device: *mut libinput_device,
    ) -> ::libc::c_int;
}
#[doc = " Do not send software-emulated button events. This has no effect"]
#[doc = " on events generated by physical buttons."]
pub const libinput_config_click_method_LIBINPUT_CONFIG_CLICK_METHOD_NONE:
    libinput_config_click_method = 0;
#[doc = " Use software-button areas to generate button events."]
pub const libinput_config_click_method_LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS:
    libinput_config_click_method = 1;
#[doc = " The number of fingers decides which button press to generate."]
pub const libinput_config_click_method_LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER:
    libinput_config_click_method = 2;
#[doc = " @ingroup config"]
#[doc = ""]
#[doc = " The click method defines when to generate software-emulated"]
#[doc = " buttons, usually on a device that does not have a specific physical"]
#[doc = " button available."]
pub type libinput_config_click_method = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check which button click methods a device supports. The button click"]
    #[doc = " method defines when to generate software-emulated buttons, usually on a"]
    #[doc = " device that does not have a specific physical button available."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return A bitmask of possible methods."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_click_get_methods"]
    #[doc = " @see libinput_device_config_click_set_method"]
    #[doc = " @see libinput_device_config_click_get_method"]
    pub fn libinput_device_config_click_get_methods(device: *mut libinput_device) -> u32;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Set the button click method for this device. The button click"]
    #[doc = " method defines when to generate software-emulated buttons, usually on a"]
    #[doc = " device that does not have a specific physical button available."]
    #[doc = ""]
    #[doc = " @note The selected click method may not take effect immediately. The"]
    #[doc = " device may require changing to a neutral state first before activating"]
    #[doc = " the new method."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param method The button click method"]
    #[doc = ""]
    #[doc = " @return A config status code"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_click_get_methods"]
    #[doc = " @see libinput_device_config_click_get_method"]
    #[doc = " @see libinput_device_config_click_get_default_method"]
    pub fn libinput_device_config_click_set_method(
        device: *mut libinput_device,
        method: libinput_config_click_method,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the button click method for this device. The button click"]
    #[doc = " method defines when to generate software-emulated buttons, usually on a"]
    #[doc = " device that does not have a specific physical button available."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return The current button click method for this device"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_click_get_methods"]
    #[doc = " @see libinput_device_config_click_set_method"]
    #[doc = " @see libinput_device_config_click_get_default_method"]
    pub fn libinput_device_config_click_get_method(
        device: *mut libinput_device,
    ) -> libinput_config_click_method;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the default button click method for this device. The button click"]
    #[doc = " method defines when to generate software-emulated buttons, usually on a"]
    #[doc = " device that does not have a specific physical button available."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return The default button click method for this device"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_click_get_methods"]
    #[doc = " @see libinput_device_config_click_set_method"]
    #[doc = " @see libinput_device_config_click_get_method"]
    pub fn libinput_device_config_click_get_default_method(
        device: *mut libinput_device,
    ) -> libinput_config_click_method;
}
#[doc = " Middle mouse button emulation is to be disabled, or"]
#[doc = " is currently disabled."]
pub const libinput_config_middle_emulation_state_LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED:
    libinput_config_middle_emulation_state = 0;
#[doc = " Middle mouse button emulation is to be enabled, or"]
#[doc = " is currently enabled."]
pub const libinput_config_middle_emulation_state_LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED:
    libinput_config_middle_emulation_state = 1;
#[doc = " @ingroup config"]
pub type libinput_config_middle_emulation_state = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if middle mouse button emulation configuration is available on this"]
    #[doc = " device. See libinput_device_config_middle_emulation_set_enabled() for"]
    #[doc = " more details."]
    #[doc = ""]
    #[doc = " @note Some devices provide middle mouse button emulation but do not allow"]
    #[doc = " enabling/disabling that emulation. These devices return zero in"]
    #[doc = " libinput_device_config_middle_emulation_is_available()."]
    #[doc = ""]
    #[doc = " @param device The device to query"]
    #[doc = ""]
    #[doc = " @return Non-zero if middle mouse button emulation is available and can be"]
    #[doc = " configured, zero otherwise."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_middle_emulation_set_enabled"]
    #[doc = " @see libinput_device_config_middle_emulation_get_enabled"]
    #[doc = " @see libinput_device_config_middle_emulation_get_default_enabled"]
    pub fn libinput_device_config_middle_emulation_is_available(
        device: *mut libinput_device,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Enable or disable middle button emulation on this device. When enabled, a"]
    #[doc = " simultaneous press of the left and right button generates a middle mouse"]
    #[doc = " button event. Releasing the buttons generates a middle mouse button"]
    #[doc = " release, the left and right button events are discarded otherwise."]
    #[doc = ""]
    #[doc = " See the libinput documentation for more details."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param enable @ref LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED to"]
    #[doc = " disable, @ref LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED To enable"]
    #[doc = " middle button emulation."]
    #[doc = ""]
    #[doc = " @return A config status code. Disabling middle button emulation on a"]
    #[doc = " device that does not support middle button emulation always succeeds."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_middle_emulation_is_available"]
    #[doc = " @see libinput_device_config_middle_emulation_get_enabled"]
    #[doc = " @see libinput_device_config_middle_emulation_get_default_enabled"]
    pub fn libinput_device_config_middle_emulation_set_enabled(
        device: *mut libinput_device,
        enable: libinput_config_middle_emulation_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if configurable middle button emulation is enabled on this device."]
    #[doc = " See libinput_device_config_middle_emulation_set_enabled() for more"]
    #[doc = " details."]
    #[doc = ""]
    #[doc = " If the device does not have configurable middle button emulation, this"]
    #[doc = " function returns @ref LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED."]
    #[doc = ""]
    #[doc = " @note Some devices provide middle mouse button emulation but do not allow"]
    #[doc = " enabling/disabling that emulation. These devices always return @ref"]
    #[doc = " LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return @ref LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED if disabled"]
    #[doc = " or not available/configurable, @ref"]
    #[doc = " LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED If enabled."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_middle_emulation_is_available"]
    #[doc = " @see libinput_device_config_middle_emulation_set_enabled"]
    #[doc = " @see libinput_device_config_middle_emulation_get_default_enabled"]
    pub fn libinput_device_config_middle_emulation_get_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_middle_emulation_state;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if configurable middle button emulation is enabled by default on"]
    #[doc = " this device. See libinput_device_config_middle_emulation_set_enabled()"]
    #[doc = " for more details."]
    #[doc = ""]
    #[doc = " If the device does not have configurable middle button"]
    #[doc = " emulation, this function returns @ref"]
    #[doc = " LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED."]
    #[doc = ""]
    #[doc = " @note Some devices provide middle mouse button emulation but do not allow"]
    #[doc = " enabling/disabling that emulation. These devices always return @ref"]
    #[doc = " LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return @ref LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED If disabled"]
    #[doc = " or not available, @ref LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED if"]
    #[doc = " enabled."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_middle_emulation_is_available"]
    #[doc = " @see libinput_device_config_middle_emulation_set_enabled"]
    #[doc = " @see libinput_device_config_middle_emulation_get_enabled"]
    pub fn libinput_device_config_middle_emulation_get_default_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_middle_emulation_state;
}
#[doc = " Never send scroll events instead of pointer motion events."]
#[doc = " This has no effect on events generated by scroll wheels."]
pub const libinput_config_scroll_method_LIBINPUT_CONFIG_SCROLL_NO_SCROLL:
    libinput_config_scroll_method = 0;
#[doc = " Send scroll events when two fingers are logically down on the"]
#[doc = " device."]
pub const libinput_config_scroll_method_LIBINPUT_CONFIG_SCROLL_2FG: libinput_config_scroll_method =
    1;
#[doc = " Send scroll events when a finger moves along the bottom or"]
#[doc = " right edge of a device."]
pub const libinput_config_scroll_method_LIBINPUT_CONFIG_SCROLL_EDGE: libinput_config_scroll_method =
    2;
#[doc = " Send scroll events when a button is down and the device moves"]
#[doc = " along a scroll-capable axis."]
pub const libinput_config_scroll_method_LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN:
    libinput_config_scroll_method = 4;
#[doc = " @ingroup config"]
#[doc = ""]
#[doc = " The scroll method of a device selects when to generate scroll axis events"]
#[doc = " instead of pointer motion events."]
pub type libinput_config_scroll_method = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check which scroll methods a device supports. The method defines when to"]
    #[doc = " generate scroll axis events instead of pointer motion events."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = ""]
    #[doc = " @return A bitmask of possible methods."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_set_method"]
    #[doc = " @see libinput_device_config_scroll_get_method"]
    #[doc = " @see libinput_device_config_scroll_get_default_method"]
    #[doc = " @see libinput_device_config_scroll_set_button"]
    #[doc = " @see libinput_device_config_scroll_get_button"]
    #[doc = " @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_get_methods(device: *mut libinput_device) -> u32;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Set the scroll method for this device. The method defines when to"]
    #[doc = " generate scroll axis events instead of pointer motion events."]
    #[doc = ""]
    #[doc = " @note Setting @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN enables"]
    #[doc = " the scroll method, but scrolling is only activated when the configured"]
    #[doc = " button is held down. If no button is set, i.e."]
    #[doc = " libinput_device_config_scroll_get_button() returns 0, scrolling"]
    #[doc = " cannot activate."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param method The scroll method for this device."]
    #[doc = ""]
    #[doc = " @return A config status code."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_get_methods"]
    #[doc = " @see libinput_device_config_scroll_get_method"]
    #[doc = " @see libinput_device_config_scroll_get_default_method"]
    #[doc = " @see libinput_device_config_scroll_set_button"]
    #[doc = " @see libinput_device_config_scroll_get_button"]
    #[doc = " @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_set_method(
        device: *mut libinput_device,
        method: libinput_config_scroll_method,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the scroll method for this device. The method defines when to"]
    #[doc = " generate scroll axis events instead of pointer motion events."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The current scroll method for this device."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_get_methods"]
    #[doc = " @see libinput_device_config_scroll_set_method"]
    #[doc = " @see libinput_device_config_scroll_get_default_method"]
    #[doc = " @see libinput_device_config_scroll_set_button"]
    #[doc = " @see libinput_device_config_scroll_get_button"]
    #[doc = " @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_get_method(
        device: *mut libinput_device,
    ) -> libinput_config_scroll_method;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the default scroll method for this device. The method defines when to"]
    #[doc = " generate scroll axis events instead of pointer motion events."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The default scroll method for this device."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_get_methods"]
    #[doc = " @see libinput_device_config_scroll_set_method"]
    #[doc = " @see libinput_device_config_scroll_get_method"]
    #[doc = " @see libinput_device_config_scroll_set_button"]
    #[doc = " @see libinput_device_config_scroll_get_button"]
    #[doc = " @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_get_default_method(
        device: *mut libinput_device,
    ) -> libinput_config_scroll_method;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Set the button for the @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN method"]
    #[doc = " for this device."]
    #[doc = ""]
    #[doc = " When the current scroll method is set to @ref"]
    #[doc = " LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN, no button press/release events"]
    #[doc = " will be send for the configured button."]
    #[doc = ""]
    #[doc = " When the configured button is pressed, any motion events along a"]
    #[doc = " scroll-capable axis are turned into scroll axis events."]
    #[doc = ""]
    #[doc = " @note Setting the button does not change the scroll method. To change the"]
    #[doc = " scroll method call libinput_device_config_scroll_set_method()."]
    #[doc = ""]
    #[doc = " If the button is 0, button scrolling is effectively disabled."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param button The button which when pressed switches to sending scroll events"]
    #[doc = ""]
    #[doc = " @return A config status code"]
    #[doc = " @retval LIBINPUT_CONFIG_STATUS_SUCCESS On success"]
    #[doc = " @retval LIBINPUT_CONFIG_STATUS_UNSUPPORTED If @ref"]
    #[doc = " LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN is not supported"]
    #[doc = " @retval LIBINPUT_CONFIG_STATUS_INVALID The given button does not"]
    #[doc = " exist on this device"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_get_methods"]
    #[doc = " @see libinput_device_config_scroll_set_method"]
    #[doc = " @see libinput_device_config_scroll_get_method"]
    #[doc = " @see libinput_device_config_scroll_get_default_method"]
    #[doc = " @see libinput_device_config_scroll_get_button"]
    #[doc = " @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_set_button(
        device: *mut libinput_device,
        button: u32,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the button for the @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN method"]
    #[doc = " for this device."]
    #[doc = ""]
    #[doc = " If @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN scroll method is not"]
    #[doc = " supported, or no button is set, this function returns 0."]
    #[doc = ""]
    #[doc = " @note The return value is independent of the currently selected"]
    #[doc = " scroll-method. For button scrolling to activate, a device must have the"]
    #[doc = " @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN method enabled, and a non-zero"]
    #[doc = " button set as scroll button."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The button which when pressed switches to sending scroll events"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_get_methods"]
    #[doc = " @see libinput_device_config_scroll_set_method"]
    #[doc = " @see libinput_device_config_scroll_get_method"]
    #[doc = " @see libinput_device_config_scroll_get_default_method"]
    #[doc = " @see libinput_device_config_scroll_set_button"]
    #[doc = " @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_get_button(device: *mut libinput_device) -> u32;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the default button for the @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN"]
    #[doc = " method for this device."]
    #[doc = ""]
    #[doc = " If @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN scroll method is not supported,"]
    #[doc = " or no default button is set, this function returns 0."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The default button for the @ref"]
    #[doc = " LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN method"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_get_methods"]
    #[doc = " @see libinput_device_config_scroll_set_method"]
    #[doc = " @see libinput_device_config_scroll_get_method"]
    #[doc = " @see libinput_device_config_scroll_get_default_method"]
    #[doc = " @see libinput_device_config_scroll_set_button"]
    #[doc = " @see libinput_device_config_scroll_get_button"]
    pub fn libinput_device_config_scroll_get_default_button(device: *mut libinput_device) -> u32;
}
pub const libinput_config_scroll_button_lock_state_LIBINPUT_CONFIG_SCROLL_BUTTON_LOCK_DISABLED:
    libinput_config_scroll_button_lock_state = 0;
pub const libinput_config_scroll_button_lock_state_LIBINPUT_CONFIG_SCROLL_BUTTON_LOCK_ENABLED:
    libinput_config_scroll_button_lock_state = 1;
pub type libinput_config_scroll_button_lock_state = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Set the scroll button lock. If the state is"]
    #[doc = " @ref LIBINPUT_CONFIG_SCROLL_BUTTON_LOCK_DISABLED, the button must"]
    #[doc = " physically be held down for button scrolling to work."]
    #[doc = " If the state is"]
    #[doc = " @ref LIBINPUT_CONFIG_SCROLL_BUTTON_LOCK_ENABLED, the button is considered"]
    #[doc = " logically down after the first press and release sequence, and logically"]
    #[doc = " up after the second press and release sequence."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param state The state to set the scroll button lock to"]
    #[doc = ""]
    #[doc = " @return A config status code. Disabling the scroll button lock on"]
    #[doc = " device that does not support button scrolling always succeeds."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_set_button"]
    #[doc = " @see libinput_device_config_scroll_get_button"]
    #[doc = " @see libinput_device_config_scroll_get_default_button"]
    pub fn libinput_device_config_scroll_set_button_lock(
        device: *mut libinput_device,
        state: libinput_config_scroll_button_lock_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the current scroll button lock state."]
    #[doc = ""]
    #[doc = " If @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN scroll method is not"]
    #[doc = " supported, or no button is set, this function returns @ref"]
    #[doc = " LIBINPUT_CONFIG_SCROLL_BUTTON_LOCK_DISABLED."]
    #[doc = ""]
    #[doc = " @note The return value is independent of the currently selected"]
    #[doc = " scroll-method. For the scroll button lock to activate, a device must have"]
    #[doc = " the @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN method enabled, and a"]
    #[doc = " non-zero button set as scroll button."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The scroll button lock state"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_set_button"]
    #[doc = " @see libinput_device_config_scroll_set_button_lock"]
    #[doc = " @see libinput_device_config_scroll_get_button_lock"]
    #[doc = " @see libinput_device_config_scroll_get_default_button_lock"]
    pub fn libinput_device_config_scroll_get_button_lock(
        device: *mut libinput_device,
    ) -> libinput_config_scroll_button_lock_state;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the default scroll button lock state."]
    #[doc = ""]
    #[doc = " If @ref LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN scroll method is not"]
    #[doc = " supported, or no button is set, this function returns @ref"]
    #[doc = " LIBINPUT_CONFIG_SCROLL_BUTTON_LOCK_DISABLED."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The default scroll button lock state"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_scroll_set_button"]
    #[doc = " @see libinput_device_config_scroll_set_button_lock"]
    #[doc = " @see libinput_device_config_scroll_get_button_lock"]
    #[doc = " @see libinput_device_config_scroll_get_default_button_lock"]
    pub fn libinput_device_config_scroll_get_default_button_lock(
        device: *mut libinput_device,
    ) -> libinput_config_scroll_button_lock_state;
}
pub const libinput_config_dwt_state_LIBINPUT_CONFIG_DWT_DISABLED: libinput_config_dwt_state = 0;
pub const libinput_config_dwt_state_LIBINPUT_CONFIG_DWT_ENABLED: libinput_config_dwt_state = 1;
#[doc = " @ingroup config"]
#[doc = ""]
#[doc = " Possible states for the disable-while-typing feature."]
pub type libinput_config_dwt_state = ::libc::c_uint;
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if this device supports configurable disable-while-typing feature."]
    #[doc = " This feature is usually available on built-in touchpads and disables the"]
    #[doc = " touchpad while typing. See the libinput documentation for details."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return 0 if this device does not support disable-while-typing, or 1"]
    #[doc = " otherwise."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_dwt_set_enabled"]
    #[doc = " @see libinput_device_config_dwt_get_enabled"]
    #[doc = " @see libinput_device_config_dwt_get_default_enabled"]
    pub fn libinput_device_config_dwt_is_available(device: *mut libinput_device) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Enable or disable the disable-while-typing feature. When enabled, the"]
    #[doc = " device will be disabled while typing and for a short period after. See"]
    #[doc = " the libinput documentation for details."]
    #[doc = ""]
    #[doc = " @note Enabling or disabling disable-while-typing may not take effect"]
    #[doc = " immediately."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param enable @ref LIBINPUT_CONFIG_DWT_DISABLED to disable"]
    #[doc = " disable-while-typing, @ref LIBINPUT_CONFIG_DWT_ENABLED to enable"]
    #[doc = ""]
    #[doc = " @return A config status code. Disabling disable-while-typing on a"]
    #[doc = " device that does not support the feature always succeeds."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_dwt_is_available"]
    #[doc = " @see libinput_device_config_dwt_get_enabled"]
    #[doc = " @see libinput_device_config_dwt_get_default_enabled"]
    pub fn libinput_device_config_dwt_set_enabled(
        device: *mut libinput_device,
        enable: libinput_config_dwt_state,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if the disable-while typing feature is currently enabled on this"]
    #[doc = " device. If the device does not support disable-while-typing, this"]
    #[doc = " function returns @ref LIBINPUT_CONFIG_DWT_DISABLED."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return @ref LIBINPUT_CONFIG_DWT_DISABLED if disabled, @ref"]
    #[doc = " LIBINPUT_CONFIG_DWT_ENABLED if enabled."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_dwt_is_available"]
    #[doc = " @see libinput_device_config_dwt_set_enabled"]
    #[doc = " @see libinput_device_config_dwt_get_default_enabled"]
    pub fn libinput_device_config_dwt_get_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_dwt_state;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check if the disable-while typing feature is enabled on this device by"]
    #[doc = " default. If the device does not support disable-while-typing, this"]
    #[doc = " function returns @ref LIBINPUT_CONFIG_DWT_DISABLED."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return @ref LIBINPUT_CONFIG_DWT_DISABLED if disabled, @ref"]
    #[doc = " LIBINPUT_CONFIG_DWT_ENABLED if enabled."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_dwt_is_available"]
    #[doc = " @see libinput_device_config_dwt_set_enabled"]
    #[doc = " @see libinput_device_config_dwt_get_enabled"]
    pub fn libinput_device_config_dwt_get_default_enabled(
        device: *mut libinput_device,
    ) -> libinput_config_dwt_state;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Check whether a device can have a custom rotation applied."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return Non-zero if a device can be rotated, zero otherwise."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_rotation_set_angle"]
    #[doc = " @see libinput_device_config_rotation_get_angle"]
    #[doc = " @see libinput_device_config_rotation_get_default_angle"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_device_config_rotation_is_available(
        device: *mut libinput_device,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Set the rotation of a device in degrees clockwise off the logical neutral"]
    #[doc = " position. Any subsequent motion events are adjusted according to the"]
    #[doc = " given angle."]
    #[doc = ""]
    #[doc = " The angle has to be in the range of [0, 360[ degrees, otherwise this"]
    #[doc = " function returns LIBINPUT_CONFIG_STATUS_INVALID. If the angle is a"]
    #[doc = " multiple of 360 or negative, the caller must ensure the correct ranging"]
    #[doc = " before calling this function."]
    #[doc = ""]
    #[doc = " libinput guarantees that this function accepts multiples of 90 degrees."]
    #[doc = " If a value is within the [0, 360[ range but not a multiple of 90 degrees,"]
    #[doc = " this function may return LIBINPUT_CONFIG_STATUS_INVALID if the underlying"]
    #[doc = " device or implementation does not support finer-grained rotation angles."]
    #[doc = ""]
    #[doc = " The rotation angle is applied to all motion events emitted by the device."]
    #[doc = " Thus, rotating the device also changes the angle required or presented by"]
    #[doc = " scrolling, gestures, etc."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @param degrees_cw The angle in degrees clockwise"]
    #[doc = " @return A config status code. Setting a rotation of 0 degrees on a"]
    #[doc = " device that does not support rotation always succeeds."]
    #[doc = ""]
    #[doc = " @see libinput_device_config_rotation_is_available"]
    #[doc = " @see libinput_device_config_rotation_get_angle"]
    #[doc = " @see libinput_device_config_rotation_get_default_angle"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_device_config_rotation_set_angle(
        device: *mut libinput_device,
        degrees_cw: ::libc::c_uint,
    ) -> libinput_config_status;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the current rotation of a device in degrees clockwise off the logical"]
    #[doc = " neutral position. If this device does not support rotation, the return"]
    #[doc = " value is always 0."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The angle in degrees clockwise"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_rotation_is_available"]
    #[doc = " @see libinput_device_config_rotation_set_angle"]
    #[doc = " @see libinput_device_config_rotation_get_default_angle"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_device_config_rotation_get_angle(
        device: *mut libinput_device,
    ) -> ::libc::c_uint;
}
extern "C" {
    #[doc = " @ingroup config"]
    #[doc = ""]
    #[doc = " Get the default rotation of a device in degrees clockwise off the logical"]
    #[doc = " neutral position. If this device does not support rotation, the return"]
    #[doc = " value is always 0."]
    #[doc = ""]
    #[doc = " @param device The device to configure"]
    #[doc = " @return The default angle in degrees clockwise"]
    #[doc = ""]
    #[doc = " @see libinput_device_config_rotation_is_available"]
    #[doc = " @see libinput_device_config_rotation_set_angle"]
    #[doc = " @see libinput_device_config_rotation_get_angle"]
    #[doc = ""]
    #[doc = " @since 1.4"]
    pub fn libinput_device_config_rotation_get_default_angle(
        device: *mut libinput_device,
    ) -> ::libc::c_uint;
}
pub type __builtin_va_list = __va_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list {
    pub __stack: *mut ::libc::c_void,
    pub __gr_top: *mut ::libc::c_void,
    pub __vr_top: *mut ::libc::c_void,
    pub __gr_offs: ::libc::c_int,
    pub __vr_offs: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___va_list() {
    assert_eq!(
        ::std::mem::size_of::<__va_list>(),
        32usize,
        concat!("Size of: ", stringify!(__va_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list>())).__stack as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list),
            "::",
            stringify!(__stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list>())).__gr_top as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list),
            "::",
            stringify!(__gr_top)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list>())).__vr_top as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list),
            "::",
            stringify!(__vr_top)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list>())).__gr_offs as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list),
            "::",
            stringify!(__gr_offs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list>())).__vr_offs as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list),
            "::",
            stringify!(__vr_offs)
        )
    );
}
