/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.quicksearch;

import com.jgoodies.common.bean.Bean;
import com.jgoodies.quicksearch.Activatable;
import com.jgoodies.quicksearch.QuickSearchProcessEvent;
import com.jgoodies.quicksearch.QuickSearchProcessListener;
import com.jgoodies.quicksearch.QuickSearchProcessor;
import com.jgoodies.quicksearch.QuickSearchPublisher;
import com.jgoodies.quicksearch.QuickSearchState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingWorker;

public final class QuickSearchManager
extends Bean {
    public static final String PROPERTY_SEARCH_TEXT = "searchText";
    private final QuickSearchProcessor searchProcessor;
    private String searchText;
    private final List<QuickSearchProcessListener> listeners;
    private Action openDetailsAction;
    private Action openPreferencesAction;
    private final List<Activatable> activatables;
    private QuickSearchProcessorWorker worker;
    private QuickSearchProcessEvent.State state;

    public QuickSearchManager(QuickSearchProcessor searchProcessor) {
        this.searchProcessor = searchProcessor;
        this.searchText = "";
        this.listeners = new CopyOnWriteArrayList<QuickSearchProcessListener>();
        this.activatables = new ArrayList<Activatable>();
    }

    public QuickSearchProcessor getProcessor() {
        return this.searchProcessor;
    }

    public Action getOpenDetailsAction() {
        return this.openDetailsAction;
    }

    public void setOpenDetailsAction(Action action) {
        this.openDetailsAction = action;
    }

    public Action getOpenPreferencesAction() {
        return this.openPreferencesAction;
    }

    public void setOpenPreferencesAction(Action action) {
        this.openPreferencesAction = action;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String text) {
        String oldText = this.getSearchText();
        this.searchText = text;
        this.firePropertyChange(PROPERTY_SEARCH_TEXT, oldText, text);
        this.onTextChange(text);
    }

    public List<Activatable> getActivatables() {
        return this.activatables == null ? null : Collections.unmodifiableList(this.activatables);
    }

    public void addQuickSearchProcessListener(QuickSearchProcessListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeQuickSearchProcessListener(QuickSearchProcessListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public QuickSearchProcessEvent.State getState() {
        return this.state;
    }

    private void fireSearchProcessStarted() {
        this.state = QuickSearchProcessEvent.State.PROCESS_STARTED;
        this.fireSearchProcessEvent(new QuickSearchProcessEvent(this, QuickSearchProcessEvent.State.PROCESS_STARTED));
    }

    private void fireSearchProcessCanceled() {
        this.state = QuickSearchProcessEvent.State.PROCESS_CANCELLED;
        this.fireSearchProcessEvent(new QuickSearchProcessEvent(this, QuickSearchProcessEvent.State.PROCESS_CANCELLED));
    }

    private void fireSearchResultChanged() {
        this.fireSearchProcessEvent(new QuickSearchProcessEvent(this, QuickSearchProcessEvent.State.RESULT_CHANGED));
    }

    private void fireSearchProcessSucceeded() {
        this.state = QuickSearchProcessEvent.State.PROCESS_SUCCEEDED;
        this.fireSearchProcessEvent(new QuickSearchProcessEvent(this, QuickSearchProcessEvent.State.PROCESS_SUCCEEDED));
    }

    private void fireSearchProcessEvent(QuickSearchProcessEvent event) {
        for (QuickSearchProcessListener listener : this.listeners) {
            listener.searchProcessed(event);
        }
    }

    private void onTextChange(String content) {
        if (this.worker != null) {
            this.worker.cancel(true);
            this.worker = null;
        }
        this.worker = new QuickSearchProcessorWorker(this, content);
        this.worker.execute();
    }

    private void addActivatables(List<Activatable> moreActivatables) {
        this.activatables.addAll(moreActivatables);
        this.fireSearchResultChanged();
    }

    private void clearActivatables() {
        this.activatables.clear();
    }

    static final class Publisher
    implements QuickSearchPublisher {
        private final QuickSearchProcessorWorker worker;

        Publisher(QuickSearchProcessorWorker worker) {
            this.worker = worker;
        }

        @Override
        public void publish(Activatable ... chunks) {
            this.worker.publishActivatables(chunks);
        }

        @Override
        public void publish(List<Activatable> activatables) {
            this.publish(activatables.toArray(new Activatable[activatables.size()]));
        }
    }

    static final class QuickSearchProcessorWorker
    extends SwingWorker<Boolean, Activatable>
    implements QuickSearchState {
        private final QuickSearchManager manager;
        private final String content;
        private final QuickSearchPublisher publisher;

        QuickSearchProcessorWorker(QuickSearchManager manager, String content) {
            this.manager = manager;
            this.content = content;
            this.publisher = new Publisher(this);
            manager.clearActivatables();
            manager.fireSearchProcessStarted();
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            return this.manager.getProcessor().search(this.content, this.publisher, this);
        }

        void publishActivatables(Activatable ... chunks) {
            if (!this.isCancelled()) {
                this.publish(chunks);
            }
        }

        @Override
        protected void process(List<Activatable> chunks) {
            this.manager.addActivatables(chunks);
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        this.manager.fireSearchProcessSucceeded();
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    this.failed(e.getCause());
                }
            }
            this.manager.fireSearchProcessCanceled();
        }

        private void failed(Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Failed to search activatables in the background", throwable);
        }
    }
}

