/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Graphics;

public final class PlasticModernUtils {
    static final Color GRAY1 = new Color(240, 240, 240);
    static final Color GRAY2 = new Color(191, 191, 191);
    static final Color GRAY3 = new Color(173, 173, 173);
    static final Color LIGHT_BLUE = new Color(0, 120, 215);
    static final Color DARK_BLUE = new Color(0, 84, 153);

    private PlasticModernUtils() {
    }

    static void drawPlainButtonBorder(Graphics g, int x, int y, int w, int h) {
        PlasticModernUtils.drawButtonBorder(g, x, y, w, h, GRAY1, PlasticLookAndFeel.getControlDarkShadow());
    }

    static void drawRolloverButtonBorder(Graphics g, int x, int y, int w, int h) {
        PlasticModernUtils.drawButtonBorder(g, x, y, w, h, GRAY1, LIGHT_BLUE);
    }

    static void drawPressedButtonBorder(Graphics g, int x, int y, int w, int h) {
        PlasticModernUtils.drawButtonBorder(g, x, y, w, h, GRAY1, DARK_BLUE);
    }

    static void drawDefaultButtonBorder(Graphics g, int x, int y, int w, int h) {
        PlasticModernUtils.drawRolloverButtonBorder(g, x, y, w, h);
        g.setColor(LIGHT_BLUE);
        PlasticUtils.drawRect(g, x + 2, y + 2, w - 5, h - 5);
    }

    static void drawSelectedButtonBorder(Graphics g, int x, int y, int w, int h) {
        PlasticModernUtils.drawButtonBorder(g, x, y, w, h, GRAY1, DARK_BLUE);
    }

    static void drawDisabledButtonBorder(Graphics g, int x, int y, int w, int h) {
        PlasticModernUtils.drawButtonBorder(g, x, y, w, h, GRAY1, GRAY2);
    }

    private static void drawButtonBorder(Graphics g, int x, int y, int w, int h, Color outerColor, Color innerColor) {
        g.setColor(outerColor);
        PlasticUtils.drawRect(g, x, y, w - 1, h - 1);
        g.setColor(innerColor);
        PlasticUtils.drawRect(g, x + 1, y + 1, w - 3, h - 3);
    }
}

