/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.Fonts;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import java.awt.Font;
import javax.swing.UIDefaults;

public final class FontPolicies {
    private FontPolicies() {
    }

    public static FontPolicy createFixedPolicy(FontSet fontSet) {
        return new FixedPolicy(fontSet);
    }

    public static FontPolicy customSettingsPolicy(FontPolicy defaultPolicy) {
        return new CustomSettingsPolicy(defaultPolicy);
    }

    public static FontPolicy getDefaultPlasticPolicy() {
        return SystemUtils.IS_OS_WINDOWS ? FontPolicies.getDefaultWindowsPolicy() : FontPolicies.getLogicalFontsPolicy();
    }

    public static FontPolicy getDefaultWindowsPolicy() {
        return new DefaultWindowsPolicy();
    }

    public static FontPolicy getLogicalFontsPolicy() {
        return FontPolicies.createFixedPolicy(FontSets.getLogicalFontSet());
    }

    private static FontSet getCustomFontSet(String lafName) {
        String controlFontKey = lafName + ".controlFont";
        String menuFontKey = lafName + ".menuFont";
        String decodedControlFont = LookUtils.getSystemProperty(controlFontKey);
        if (decodedControlFont == null) {
            return null;
        }
        Font controlFont = Fonts.asCompositeFontUIResource(Font.decode(decodedControlFont));
        String decodedMenuFont = LookUtils.getSystemProperty(menuFontKey);
        Font menuFont = decodedMenuFont != null ? Fonts.asCompositeFontUIResource(Font.decode(decodedMenuFont)) : null;
        return FontSets.createDefaultFontSet(controlFont, menuFont);
    }

    private static final class CustomSettingsPolicy
    implements FontPolicy {
        private final FontPolicy wrappedPolicy;

        CustomSettingsPolicy(FontPolicy wrappedPolicy) {
            this.wrappedPolicy = wrappedPolicy;
        }

        @Override
        public FontSet getFontSet(String lafName, UIDefaults table) {
            FontSet customFontSet = FontPolicies.getCustomFontSet(lafName);
            if (customFontSet != null) {
                return customFontSet;
            }
            return this.wrappedPolicy.getFontSet(lafName, table);
        }
    }

    private static final class DefaultWindowsPolicy
    implements FontPolicy {
        private DefaultWindowsPolicy() {
        }

        @Override
        public FontSet getFontSet(String lafName, UIDefaults table) {
            Font controlFont;
            Font plainControlFont = Fonts.getWindowsControlFont();
            if (Options.isLargerBodyTextEnabled()) {
                plainControlFont = plainControlFont.deriveFont(plainControlFont.getSize2D() * 14.0f / 12.0f);
            }
            Font menuFont = controlFont = Fonts.asCompositeFontUIResource(plainControlFont);
            Font titleFont = controlFont;
            Font messageFont = controlFont;
            Font windowTitleFont = controlFont;
            Font smallFont = lafName.equals("Plastic") ? controlFont.deriveFont(controlFont.getSize2D() - ScreenScaling.toPhysical(2.0f)) : plainControlFont;
            return FontSets.createDefaultFontSet(controlFont, menuFont, titleFont, messageFont, smallFont, windowTitleFont);
        }
    }

    private static final class FixedPolicy
    implements FontPolicy {
        private final FontSet fontSet;

        FixedPolicy(FontSet fontSet) {
            this.fontSet = fontSet;
        }

        @Override
        public FontSet getFontSet(String lafName, UIDefaults table) {
            return this.fontSet;
        }
    }
}

