/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.util;

import com.jgoodies.common.swing.ScreenScaling;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.prefs.Preferences;

public final class ScreenUtils {
    private ScreenUtils() {
    }

    public static void locateAt(Component component, ScreenLocation location) {
        int y;
        int x;
        Dimension paneSize = component.getSize();
        Rectangle screenBounds = ScreenUtils.screenBounds(component);
        switch (location) {
            case NORTH_WEST: 
            case WEST: 
            case SOUTH_WEST: {
                x = screenBounds.x;
                break;
            }
            default: {
                x = screenBounds.x + (screenBounds.width - paneSize.width) / 2;
                break;
            }
            case NORTH_EAST: 
            case EAST: 
            case SOUTH_EAST: {
                x = screenBounds.x + screenBounds.width - paneSize.width;
            }
        }
        switch (location) {
            case NORTH_WEST: 
            case NORTH: 
            case NORTH_EAST: {
                y = screenBounds.y;
                break;
            }
            case WEST: 
            case CENTER: 
            case EAST: {
                y = screenBounds.y + (screenBounds.height - paneSize.height) / 2;
                break;
            }
            default: {
                y = screenBounds.y + (int)((double)(screenBounds.height - paneSize.height) * 0.45);
                break;
            }
            case SOUTH_WEST: 
            case SOUTH: 
            case SOUTH_EAST: {
                y = screenBounds.y + screenBounds.height - paneSize.height;
            }
        }
        component.setLocation(x, y);
    }

    public static Dimension getEffectiveScreenSize() {
        return ScreenScaling.toEffective(Toolkit.getDefaultToolkit().getScreenSize());
    }

    public static String encodedScreenConfiguration() {
        StringBuilder builder = new StringBuilder();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            builder.append(ScreenUtils.encodeRectangle(gc.getBounds()));
        }
        return builder.toString();
    }

    public static Preferences screenConfigurationNode(Preferences prefs) {
        Preferences node = prefs;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            node = node.node(ScreenUtils.encodeRectangle(gc.getBounds()));
        }
        return node;
    }

    private static String encodeRectangle(Rectangle r) {
        return String.format("[%1$s,%2$s,%3$s,%4$s]", r.x, r.y, r.width, r.height);
    }

    private static Rectangle screenBounds(Component c) {
        Dimension screenSize = c.getToolkit().getScreenSize();
        Insets screenInsets = c.getToolkit().getScreenInsets(c.getGraphicsConfiguration());
        return new Rectangle(screenInsets.left, screenInsets.top, screenSize.width - (screenInsets.left + screenInsets.right), screenSize.height - (screenInsets.top + screenInsets.bottom));
    }

    public static enum ScreenLocation {
        WEST,
        NORTH_WEST,
        NORTH,
        NORTH_EAST,
        EAST,
        SOUTH_EAST,
        SOUTH,
        SOUTH_WEST,
        CENTER,
        OPTICAL_CENTER;

    }
}

